/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.RawByteCodes;
import icecaptools.stackanalyser.ArrayRefType;
import icecaptools.stackanalyser.NonRefType;
import icecaptools.stackanalyser.RefType;
import icecaptools.stackanalyser.UnexpectedTypeException;
import icecaptools.stackanalyser.UnknownType;
import java.util.Iterator;
import java.util.Stack;

public class AbstractStack {
    private Stack<StackCell> stack = new Stack();

    public AbstractStack copy() {
        AbstractStack copy = new AbstractStack();
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            copy.stack.push(((StackCell)iterator.next()).copy());
        }
        return copy;
    }

    public void pushUnknown() {
        StackCell cell = new StackCell();
        this.push(cell);
    }

    public void pushRef() {
        StackCell cell = new StackCell();
        cell.content = new RefType();
        this.push(cell);
    }

    public void pushArrayRef(RawByteCodes.RawBytecode pusher) {
        StackCell cell = new StackCell();
        cell.content = new ArrayRefType(pusher);
        this.push(cell);
    }

    public void pushNonRef() {
        StackCell cell = new StackCell();
        cell.content = new NonRefType();
        this.push(cell);
    }

    public void popNonRef() throws UnexpectedTypeException {
        StackCell top = this.stack.pop();
        if (top.content instanceof RefType) {
            throw new UnexpectedTypeException();
        }
    }

    public StackCell popRef() throws UnexpectedTypeException {
        StackCell top = this.stack.pop();
        if (top.content instanceof NonRefType) {
            throw new UnexpectedTypeException();
        }
        return top;
    }

    public StackCell popAny() {
        return this.stack.pop();
    }

    public void push(StackCell top) {
        this.stack.push(top);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractStack) {
            AbstractStack other = (AbstractStack)obj;
            if (other.stack.size() == this.stack.size()) {
                int i = 0;
                while (i < this.stack.size()) {
                    UnknownType otherElement = ((StackCell)other.stack.get((int)i)).content;
                    UnknownType thisElement = ((StackCell)this.stack.get((int)i)).content;
                    if (!otherElement.equals(thisElement)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.stack.size() == 0) {
            buffer.append("--");
        } else {
            int i = 0;
            while (i < this.stack.size()) {
                buffer.append("[" + i + "]: ");
                buffer.append(((StackCell)this.stack.get(i)).toString());
                buffer.append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    public int getSize() {
        return this.stack.size();
    }

    public byte[] getStackInfo() {
        int stackSize = this.stack.size();
        if (stackSize > 0) {
            int bytesRequired = stackSize - 1 >> 3;
            byte[] stackInfo = new byte[++bytesRequired];
            this.populateStackInfo(stackInfo);
            return stackInfo;
        }
        return new byte[0];
    }

    private void populateStackInfo(byte[] stackInfo) {
        int i = 0;
        while (i < this.stack.size()) {
            if (((StackCell)this.stack.get((int)i)).content instanceof RefType) {
                int byteNo = i / 8;
                int bitNo = i % 8;
                int n = byteNo;
                stackInfo[n] = (byte)(stackInfo[n] | 1 << bitNo);
            }
            ++i;
        }
    }

    public StackCell getAt(int index) {
        return (StackCell)this.stack.get(index);
    }

    public StackCell peek() {
        return this.stack.peek();
    }

    public void setAt(int i, StackCell element) {
        this.stack.set(i, element);
    }

    public void merge(AbstractStack other) throws Exception {
        if (this.stack.size() == other.stack.size()) {
            int i = 0;
            while (i < this.stack.size()) {
                StackCell thisCell = (StackCell)this.stack.get(i);
                StackCell otherCell = (StackCell)other.stack.get(i);
                thisCell.merge(otherCell);
                ++i;
            }
        } else {
            throw new Exception("Unmergable merge attempted");
        }
    }

    public void clear(int index) {
        int i = 0;
        while (i < this.stack.size()) {
            StackCell current = (StackCell)this.stack.elementAt(i);
            if (current.content instanceof RefType) {
                RefType refType = (RefType)current.content;
                if (refType.identicleWith == index) {
                    refType.identicleWith = -1;
                }
            }
            ++i;
        }
    }

    public Object[] getArray() {
        return this.stack.toArray();
    }

    public static class StackCell {
        public UnknownType content;

        public StackCell() {
            this.content = new UnknownType();
        }

        private StackCell(boolean noInit) {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(this.content.toString());
            buffer.append("]");
            return buffer.toString();
        }

        public StackCell copy() {
            StackCell cell = new StackCell(true);
            cell.content = this.content.copy();
            return cell;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void merge(StackCell other) throws Exception {
            UnknownType left = this.content;
            UnknownType right = other.content;
            if (left.getClass() == UnknownType.class) {
                this.content = right.copy();
                return;
            } else {
                if (left.getClass() == NonRefType.class) {
                    if (right.getClass() == UnknownType.class || right.getClass() == NonRefType.class) return;
                    if (right.getClass() == RefType.class) {
                        throw new Exception("Unmergeable merge");
                    }
                    if (right.getClass() != ArrayRefType.class) throw new Exception("Unmergeable merge");
                    throw new Exception("Unmergeable merge");
                }
                if (left.getClass() == RefType.class) {
                    if (right.getClass() == UnknownType.class) return;
                    if (right.getClass() == NonRefType.class) {
                        throw new Exception("Unmergeable merge");
                    }
                    if (right.getClass() == RefType.class) {
                        ((RefType)left).merge((RefType)right);
                        return;
                    } else {
                        if (right.getClass() != ArrayRefType.class) throw new Exception("Unmergeable merge");
                        this.content = right.copy();
                        ((RefType)this.content).merge((RefType)left);
                    }
                    return;
                } else {
                    if (left.getClass() != ArrayRefType.class) throw new Exception("Unmergeable merge");
                    if (right.getClass() == UnknownType.class) return;
                    if (right.getClass() == NonRefType.class) {
                        throw new Exception("Unmergeable merge");
                    }
                    if (right.getClass() == RefType.class) {
                        ((RefType)left).merge((RefType)right);
                        return;
                    } else {
                        if (right.getClass() != ArrayRefType.class) throw new Exception("Unmergeable merge");
                        ((RefType)left).merge((RefType)right);
                    }
                }
            }
        }
    }
}

