/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.ev3;

import icecaptools.launching.TargetSpecificLauncherTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EV3LauncherTab
extends TargetSpecificLauncherTab {
    public static final String DEVICE_IPADDRESS = "DEVICE_IPADDRESS";
    protected String defaultDeviceAddress;
    private String deviceName;
    Text ipText;

    protected EV3LauncherTab(String defaultDeviceAddress, String deviceName) {
        this.defaultDeviceAddress = defaultDeviceAddress;
        this.deviceName = deviceName;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Group ipGroup = new Group(this.root, 4);
        FormLayout layout = new FormLayout();
        ipGroup.setLayout((Layout)layout);
        ipGroup.setText(String.valueOf(this.deviceName) + " IP address");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.optimizationLevelGroup, 5);
        formData.right = new FormAttachment(100, -5);
        ipGroup.setLayoutData((Object)formData);
        Label ipLabel = new Label((Composite)ipGroup, 16384);
        ipLabel.setText(String.valueOf(this.deviceName) + " IP Address:");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 9);
        ipLabel.setLayoutData((Object)formData);
        this.ipText = new Text((Composite)ipGroup, 2052);
        formData = new FormData();
        formData.left = new FormAttachment((Control)ipLabel, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.ipText.setLayoutData((Object)formData);
        this.ipText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EV3LauncherTab.this.lcd.updateButtons();
            }
        });
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(DEVICE_IPADDRESS, this.defaultDeviceAddress);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String targetIPAddress = configuration.getAttribute(DEVICE_IPADDRESS, "");
            if (targetIPAddress != null) {
                this.ipText.setText(targetIPAddress);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean ipAddressValid = false;
        if (this.ipText.getText() != null && this.ipText.getText().trim().length() > 0) {
            ipAddressValid = true;
        }
        return super.isValid(launchConfig) && ipAddressValid;
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String targetIPAddress = this.ipText.getText();
        if (targetIPAddress != null) {
            configuration.setAttribute(DEVICE_IPADDRESS, targetIPAddress);
        } else {
            configuration.setAttribute(DEVICE_IPADDRESS, this.defaultDeviceAddress);
        }
    }

    @Override
    protected String getHeapSizeUnit() {
        return "kB";
    }

    @Override
    protected int getHeapSizeMaximum() {
        return 2048;
    }

    @Override
    protected int getDefaultHeapSize() {
        return 64;
    }
}

