/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import icecaptools.launching.CommonLauncherTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public abstract class TargetSpecificLauncherTab
extends CommonLauncherTab {
    public static final String HEAPSIZE = "HEAPSIZE";
    public static final String IMPLEMENTATION_FILE = "IMPLEMENTATION_FILE";
    public static final String ENABLE_NATIVE_IMPLEMENTATION = "ENABLE_NATIVE_IMPLEMENTATION";
    public static final String GCC_OPTIMIZATION_LEVEL = "GCC_OPTIMIZATION_LEVEL";
    private Spinner heapSizeText;
    private Button nativesCheckbox;
    private Text nativesText;
    private NativesCheckboxListener nativesListener;
    protected Group optimizationLevelGroup;
    private Button level0button;
    private Button level1button;
    private Button level2button;
    private Button level3button;
    private Button levelsbutton;

    @Override
    protected String getSourceGroupHeader() {
        return "Source";
    }

    @Override
    protected String getSourceLabelText() {
        return "Source folder:";
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Group heapSizeGroup = new Group(this.root, 4);
        heapSizeGroup.setText("Heap size");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.sourceGroup, 10);
        formData.right = new FormAttachment(100, -5);
        heapSizeGroup.setLayoutData((Object)formData);
        FormLayout layout = new FormLayout();
        heapSizeGroup.setLayout((Layout)layout);
        Label heapSize = new Label((Composite)heapSizeGroup, 16384);
        heapSize.setText("Heap size (" + this.getHeapSizeUnit() + "):");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        heapSize.setLayoutData((Object)formData);
        this.heapSizeText = new Spinner((Composite)heapSizeGroup, 2048);
        this.heapSizeText.setMaximum(this.getHeapSizeMaximum());
        formData = new FormData();
        formData.left = new FormAttachment((Control)heapSize, 5);
        formData.top = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, -5);
        this.heapSizeText.setLayoutData((Object)formData);
        this.heapSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
        Group nativesGroup = new Group(this.root, 4);
        layout = new FormLayout();
        nativesGroup.setLayout((Layout)layout);
        nativesGroup.setText("User defined natives");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)heapSizeGroup, 10);
        formData.right = new FormAttachment(100, -5);
        nativesGroup.setLayoutData((Object)formData);
        this.nativesCheckbox = new Button((Composite)nativesGroup, 32);
        this.nativesCheckbox.setText("Enable user defined natives");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        this.nativesCheckbox.setLayoutData((Object)formData);
        Label nativesFile = new Label((Composite)nativesGroup, 16384);
        nativesFile.setText("Implementation file:");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.nativesCheckbox, 10);
        nativesFile.setLayoutData((Object)formData);
        Button selectNatives = new Button((Composite)nativesGroup, 8);
        selectNatives.setText("...");
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.nativesCheckbox, 10);
        formData.right = new FormAttachment(100, -5);
        selectNatives.setLayoutData((Object)formData);
        this.nativesText = new Text((Composite)nativesGroup, 2052);
        formData = new FormData();
        formData.left = new FormAttachment((Control)nativesFile, 5);
        formData.top = new FormAttachment((Control)this.nativesCheckbox, 10);
        formData.right = new FormAttachment((Control)selectNatives, -5);
        this.nativesText.setLayoutData((Object)formData);
        selectNatives.addMouseListener((MouseListener)new SelectImplementationFileListener(selectNatives, this.nativesText));
        this.nativesListener = new NativesCheckboxListener(this.nativesCheckbox, nativesFile, selectNatives, this.nativesText);
        this.nativesCheckbox.addMouseListener((MouseListener)this.nativesListener);
        this.optimizationLevelGroup = new Group(this.root, 4);
        layout = new FormLayout();
        this.optimizationLevelGroup.setLayout((Layout)layout);
        this.optimizationLevelGroup.setText("Compiler optimization level");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)nativesGroup, 5);
        formData.right = new FormAttachment(100, -5);
        this.optimizationLevelGroup.setLayoutData((Object)formData);
        this.level0button = new Button((Composite)this.optimizationLevelGroup, 16);
        this.level0button.setText("-O0");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        this.level0button.setLayoutData((Object)formData);
        this.level0button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
        this.level1button = new Button((Composite)this.optimizationLevelGroup, 16);
        this.level1button.setText("-O1");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.level0button, 5);
        this.level1button.setLayoutData((Object)formData);
        this.level1button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
        this.level2button = new Button((Composite)this.optimizationLevelGroup, 16);
        this.level2button.setText("-O2");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.level1button, 5);
        this.level2button.setLayoutData((Object)formData);
        this.level2button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
        this.level3button = new Button((Composite)this.optimizationLevelGroup, 16);
        this.level3button.setText("-O3");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.level2button, 5);
        this.level3button.setLayoutData((Object)formData);
        this.level3button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
        this.levelsbutton = new Button((Composite)this.optimizationLevelGroup, 16);
        this.levelsbutton.setText("-Os");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.level3button, 5);
        this.levelsbutton.setLayoutData((Object)formData);
        this.levelsbutton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        });
    }

    protected abstract int getHeapSizeMaximum();

    protected abstract String getHeapSizeUnit();

    public Control getControl() {
        return this.root;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        configuration.setAttribute(HEAPSIZE, this.getDefaultHeapSize());
        configuration.setAttribute(ENABLE_NATIVE_IMPLEMENTATION, false);
        configuration.setAttribute(IMPLEMENTATION_FILE, "");
        configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 0);
    }

    protected abstract int getDefaultHeapSize();

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            super.initializeFrom(configuration);
            int heapSize = configuration.getAttribute(HEAPSIZE, this.getDefaultHeapSize());
            this.heapSizeText.setSelection(heapSize);
            int optimLevel = configuration.getAttribute(GCC_OPTIMIZATION_LEVEL, 0);
            switch (optimLevel) {
                case 1: {
                    this.level1button.setSelection(true);
                    break;
                }
                case 2: {
                    this.level2button.setSelection(true);
                    break;
                }
                case 3: {
                    this.level3button.setSelection(true);
                    break;
                }
                case 4: {
                    this.levelsbutton.setSelection(true);
                    break;
                }
                default: {
                    this.level0button.setSelection(true);
                }
            }
            boolean natives = configuration.getAttribute(ENABLE_NATIVE_IMPLEMENTATION, false);
            this.nativesCheckbox.setSelection(natives);
            String implementationFile = configuration.getAttribute(IMPLEMENTATION_FILE, "");
            if (implementationFile.trim().length() > 0) {
                this.nativesText.setText(implementationFile);
            }
            if (natives) {
                this.nativesListener.enableNativesSelection(false);
            } else {
                this.nativesListener.disableNativesSelection(false);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute(HEAPSIZE, this.heapSizeText.getSelection());
        configuration.setAttribute(ENABLE_NATIVE_IMPLEMENTATION, this.nativesCheckbox.getSelection());
        configuration.setAttribute(IMPLEMENTATION_FILE, this.nativesText.getText());
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        if (this.level0button.getSelection()) {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 0);
        } else if (this.level1button.getSelection()) {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 1);
        } else if (this.level2button.getSelection()) {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 2);
        } else if (this.level3button.getSelection()) {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 3);
        } else if (this.levelsbutton.getSelection()) {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 4);
        } else {
            configuration.setAttribute(GCC_OPTIMIZATION_LEVEL, 0);
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (super.isValid(launchConfig)) {
            boolean enableNatives = this.nativesCheckbox.getSelection();
            if (enableNatives) {
                String natives = this.nativesText.getText();
                if (natives != null && natives.trim().length() > 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    private class NativesCheckboxListener
    implements MouseListener {
        private Button checkbox;
        private Label nativesFile;
        private Button selectNatives;
        private Text nativesText;

        NativesCheckboxListener(Button checkbox, Label nativesFile, Button selectNatives, Text nativesText) {
            this.checkbox = checkbox;
            this.nativesFile = nativesFile;
            this.selectNatives = selectNatives;
            this.nativesText = nativesText;
            this.disableNativesSelection(false);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (this.checkbox.getSelection()) {
                this.enableNativesSelection(true);
            } else {
                this.disableNativesSelection(true);
            }
        }

        private void disableNativesSelection(boolean update) {
            this.nativesFile.setEnabled(false);
            this.selectNatives.setEnabled(false);
            this.nativesText.setEnabled(false);
            if (update) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        }

        private void enableNativesSelection(boolean update) {
            this.nativesFile.setEnabled(true);
            this.selectNatives.setEnabled(true);
            this.nativesText.setEnabled(true);
            if (update) {
                TargetSpecificLauncherTab.this.lcd.updateButtons();
            }
        }
    }

    private class SelectImplementationFileListener
    extends CommonLauncherTab.SelectSourceFolderOrFileListener {
        SelectImplementationFileListener(Button select, Text text) {
            super(select, text);
        }

        public void mouseUp(MouseEvent e) {
            FileDialog dialog = new FileDialog(this.select.getShell(), 4096);
            dialog.setText("Locate implementation file");
            String filter = this.text.getText();
            if (filter != null && filter.trim().length() == 0) {
                filter = null;
            }
            dialog.setFilterPath(filter);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            this.text.setText(path);
            TargetSpecificLauncherTab.this.lcd.updateButtons();
        }
    }
}

