/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import icecaptools.launching.TargetSpecificLauncherTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class POSIXLauncherTab
extends TargetSpecificLauncherTab {
    private Button arch64Button;
    private Button arch32Button;
    private Button cygwinButton;
    public static final String TARGET_ARCHITECTURE = "TARGET_ARCHITECTURE";
    public static final String CYGWIN_USED = "CYGWIN_USED";

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Group architecureGroup = new Group(this.root, 4);
        FormLayout layout = new FormLayout();
        architecureGroup.setLayout((Layout)layout);
        architecureGroup.setText("Target architecture");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.optimizationLevelGroup, 5);
        formData.right = new FormAttachment(100, -5);
        architecureGroup.setLayoutData((Object)formData);
        this.arch64Button = new Button((Composite)architecureGroup, 16);
        this.arch64Button.setText("64 bit");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        this.arch64Button.setLayoutData((Object)formData);
        this.arch64Button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                POSIXLauncherTab.this.lcd.updateButtons();
            }
        });
        this.arch32Button = new Button((Composite)architecureGroup, 16);
        this.arch32Button.setText("32 bit");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.arch64Button, 5);
        this.arch32Button.setLayoutData((Object)formData);
        this.arch32Button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                POSIXLauncherTab.this.lcd.updateButtons();
            }
        });
        this.cygwinButton = new Button((Composite)architecureGroup, 32);
        this.cygwinButton.setText("Cygwin?");
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.arch32Button, 5);
        this.cygwinButton.setLayoutData((Object)formData);
        this.cygwinButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                POSIXLauncherTab.this.lcd.updateButtons();
            }
        });
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(TARGET_ARCHITECTURE, "64bit");
        configuration.setAttribute(CYGWIN_USED, "false");
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String targetArchitecture = configuration.getAttribute(TARGET_ARCHITECTURE, "");
            if ("64bit".equals(targetArchitecture)) {
                this.arch64Button.setSelection(true);
            } else {
                this.arch32Button.setSelection(true);
            }
            String cygwinUsed = configuration.getAttribute(CYGWIN_USED, "false");
            if (cygwinUsed.equalsIgnoreCase("true")) {
                this.cygwinButton.setSelection(true);
            } else {
                this.cygwinButton.setSelection(false);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (this.arch64Button.getSelection()) {
            configuration.setAttribute(TARGET_ARCHITECTURE, "64bit");
        } else {
            configuration.setAttribute(TARGET_ARCHITECTURE, "32bit");
        }
        if (this.cygwinButton.getSelection()) {
            configuration.setAttribute(CYGWIN_USED, "true");
        } else {
            configuration.setAttribute(CYGWIN_USED, "false");
        }
    }

    @Override
    protected String getHeapSizeUnit() {
        return "MB";
    }

    @Override
    protected int getHeapSizeMaximum() {
        return 16;
    }

    @Override
    protected int getDefaultHeapSize() {
        return 1;
    }
}

