/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging.variables;

import icecaptools.debugging.HVMPOSIXDebugTarget;
import icecaptools.debugging.variables.HVMVariable;
import java.io.IOException;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;

public abstract class HVMNumberVariable
extends HVMVariable {
    private IValue iValue;

    public HVMNumberVariable(IDebugTarget iDebugTarget, LocalVariable localVariable, Method method) {
        super(iDebugTarget, localVariable, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue getValue() throws DebugException {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        synchronized (iDebugTarget) {
            if (this.iValue == null) {
                byte[] val = this.getValueBuffer();
                try {
                    short index = (short)this.localVariable.getIndex();
                    ((HVMPOSIXDebugTarget)this.target).getValueFromStack(index, val);
                    long ival = 0L;
                    int i = val.length - 1;
                    while (i >= 0) {
                        ival <<= 8;
                        ival |= (long)(val[i] & 0xFF);
                        --i;
                    }
                    this.iValue = this.getNumberValue(this.target, ival);
                    return this.iValue;
                }
                catch (IOException iOException) {
                    throw new DebugException(new IStatus(){
                        private static final String message = "Could not get number value";

                        public IStatus[] getChildren() {
                            return null;
                        }

                        public int getCode() {
                            return 4;
                        }

                        public Throwable getException() {
                            return new Exception(message);
                        }

                        public String getMessage() {
                            return message;
                        }

                        public String getPlugin() {
                            return DebugPlugin.getUniqueIdentifier();
                        }

                        public int getSeverity() {
                            return 4;
                        }

                        public boolean isMultiStatus() {
                            return false;
                        }

                        public boolean isOK() {
                            return false;
                        }

                        public boolean matches(int severityMask) {
                            return false;
                        }
                    });
                }
            }
            return this.iValue;
        }
    }

    protected abstract IValue getNumberValue(IDebugTarget var1, long var2);

    protected abstract byte[] getValueBuffer();
}

