/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging;

import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.CompilationSequence;
import icecaptools.ConverterJob;
import icecaptools.MethodAndClass;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodLocation;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.debugging.DebugChannel;
import icecaptools.debugging.EventDispatchJob;
import icecaptools.debugging.HVMDebugElement;
import icecaptools.debugging.HVMStackFrame;
import icecaptools.debugging.HVMThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class HVMPOSIXDebugTarget
extends HVMDebugElement
implements IDebugTarget {
    private static final int RESUME_EVENT = 11;
    private static final int TERMINATE_EVENT = 13;
    private static final int BREAKPOINT_ADD_EVENT = 14;
    private static final int BREAKPOINT_REMOVE_EVENT = 16;
    private static final int GET_STACKFRAMES_EVENT = 17;
    private static final int STACKFRAMES_START_EVENT = 18;
    private static final int STACKFRAMES_END_EVENT = 19;
    private static final int GET_STACKVALUE_EVENT = 20;
    private static final int STEPOVER = 3;
    private static final int STEPINTO = 1;
    private static final int STEP_EVENT = 21;
    private static final int STEPCONTINUE = 4;
    private ILaunch launch;
    private IProcess targetProcess;
    private HVMThread[] threads;
    private EventDispatchJob eventDispatcher;
    private ILineBreakpoint activeBreakPoint;
    private HashMap<MethodLocation, ILineBreakpoint> breakPoints;
    private MethodLocation suspendedAt;
    private MethodEntryPoints suspendedAtEP;
    private MethodAndClass suspendedAtMethod;
    private DebugChannel tc;

    public HVMPOSIXDebugTarget(ILaunch launch, IProcess p, DebugChannel tc, IProgressMonitor monitor) throws Exception {
        super(null);
        this.launch = launch;
        this.targetProcess = p;
        this.target = this;
        this.threads = new HVMThread[1];
        this.threads[0] = new HVMThread(this);
        try {
            tc.connectToTarget(monitor);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("Unable to connect to debug target");
        }
        catch (IOException iOException) {
            throw new Exception("Unable to connect to debug target");
        }
        this.clearSuspendedAt();
        this.breakPoints = new HashMap();
        this.eventDispatcher = new EventDispatchJob(tc.getEventChannel(), this);
        this.eventDispatcher.schedule();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.tc = tc;
    }

    private void clearSuspendedAt() {
        this.suspendedAt = null;
        this.suspendedAtEP = null;
        this.suspendedAtMethod = null;
    }

    private void sendRequest(byte event) throws IOException {
        OutputStream outputStream = this.tc.getRequestOutputStream();
        outputStream.write(event);
        outputStream.flush();
    }

    private void sendRequest(short data) throws IOException {
        OutputStream outputStream = this.tc.getRequestOutputStream();
        outputStream.write(data & 0xFF);
        outputStream.write(data >> 8 & 0xFF);
        outputStream.flush();
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public void started() {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        try {
            this.resume();
        }
        catch (DebugException debugException) {}
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    public void terminate() throws DebugException {
        try {
            this.sendRequest((byte)13);
            this.terminated();
        }
        catch (IOException iOException) {
            throw new DebugException(new IStatus(){
                private static final String message = "Sending TERMINATE request failed";

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(message);
                }

                public String getMessage() {
                    return message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            });
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspendedAt != null;
    }

    public void terminated() throws IOException {
        this.clearSuspendedAt();
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fireTerminateEvent();
        this.tc.disconnectFromTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        try {
            if (this.isStepping()) {
                HVMPOSIXDebugTarget hVMPOSIXDebugTarget = this;
                synchronized (hVMPOSIXDebugTarget) {
                    this.sendRequest((byte)21);
                    this.sendRequest((byte)4);
                }
            } else {
                this.sendRequest((byte)11);
            }
            this.resumed(32);
            this.clearSuspendedAt();
        }
        catch (IOException iOException) {
            throw new DebugException(new IStatus(){
                private static final String message = "Sending RESUME request failed";

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(message);
                }

                public String getMessage() {
                    return message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            });
        }
    }

    private void resumed(int detail) {
        this.fireResumeEvent(detail);
        this.threads[0].clearStackFrames();
    }

    public void suspend() throws DebugException {
        System.out.println("suspend");
    }

    public String getClassNameFromBreakpoint(IBreakpoint breakpoint) throws CoreException {
        ILineBreakpoint lineBreakpoint;
        IMarker marker;
        Map attributes;
        Object typeName;
        CompilationSequence compilationSequence = ConverterJob.mostRecentSequence;
        if (compilationSequence != null && breakpoint instanceof ILineBreakpoint && (typeName = (attributes = (marker = (lineBreakpoint = (ILineBreakpoint)breakpoint).getMarker()).getAttributes()).get("org.eclipse.jdt.debug.core.typeName")) != null && typeName instanceof String) {
            String tName = (String)typeName;
            return tName;
        }
        return null;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            int lineNumber;
            MethodLocation ml;
            String className = this.getClassNameFromBreakpoint(breakpoint);
            if (className != null && (ml = ClassfileUtils.getMethodLocation(className, lineNumber = ((ILineBreakpoint)breakpoint).getLineNumber(), ConverterJob.mostRecentSequence)) != null) {
                this.breakPoints.put(ml, (ILineBreakpoint)breakpoint);
                this.setBreakpointOnTarget(ml);
            }
        }
        catch (CoreException coreException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBreakpointOnTarget(MethodLocation ml) throws IOException {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        synchronized (iDebugTarget) {
            this.sendRequest((byte)14);
            this.sendRequest(ml.getMethodNumber());
            this.sendRequest(ml.getAddress());
        }
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.jdt.debug");
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        for (Map.Entry<MethodLocation, ILineBreakpoint> entry : this.breakPoints.entrySet()) {
            if (entry.getValue() != breakpoint) continue;
            MethodLocation ml = entry.getKey();
            try {
                IDebugTarget iDebugTarget = this.getDebugTarget();
                synchronized (iDebugTarget) {
                    this.sendRequest((byte)16);
                    this.sendRequest(ml.getMethodNumber());
                    this.sendRequest(ml.getAddress());
                }
                this.breakPoints.remove(ml);
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        System.out.println("breakpointChanged");
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        System.out.println("supportsStorageRetrieval");
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        System.out.println("getMemoryBlock");
        return null;
    }

    public IProcess getProcess() {
        return this.targetProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() throws DebugException {
        try {
            String fName = this.getLaunch().getLaunchConfiguration().getAttribute("SOURCE_FOLDER", "");
            return fName;
        }
        catch (CoreException coreException) {
            throw new DebugException(new IStatus(){
                private static final String message = "Could not get name of launch configuration";

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(message);
                }

                public String getMessage() {
                    return message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            });
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    private void suspended(int detail, MethodLocation ml) {
        this.suspendedAt = ml;
        this.fireSuspendEvent(detail);
    }

    public void breakPointHit(int methodNumber, int pc) throws CoreException, IOException {
        if (this.suspendedAt != null) {
            if (methodNumber == this.suspendedAt.getMethodNumber()) {
                BNode bnode = this.suspendedAtEP.getBNodeFromHVMAddress(pc);
                int originalPC = bnode.getOriginalAddress();
                int lineNumber = ClassfileUtils.getLineNumber(this.suspendedAtMethod.getMethod(), originalPC);
                if (lineNumber != this.suspendedAt.getLineNumber()) {
                    this.suspendedAt = new MethodLocation(methodNumber, pc, lineNumber);
                    this.suspended(2, this.suspendedAt);
                } else {
                    this.sendRequest((byte)11);
                }
            } else {
                this.resume();
            }
        } else {
            MethodLocation ml = new MethodLocation(methodNumber, pc, -1);
            ILineBreakpoint breakPoint = this.breakPoints.get(ml);
            if (breakPoint != null) {
                this.activeBreakPoint = breakPoint;
                ml.setLineNumber(this.activeBreakPoint.getLineNumber());
                this.suspended(16, ml);
            } else {
                this.suspended(1, ml);
            }
        }
    }

    public IBreakpoint getActiveBreakPoint() {
        return this.activeBreakPoint;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        LinkedList<HVMStackFrame> frames = new LinkedList<HVMStackFrame>();
        try {
            this.sendRequest((byte)17);
            InputStream requestInputStream = this.tc.getRequestInputStream();
            int tag = requestInputStream.read();
            while (tag == 18) {
                int methodNumber = requestInputStream.read();
                int pc = requestInputStream.read();
                HVMStackFrame frame = new HVMStackFrame(this.threads[0], methodNumber |= requestInputStream.read() << 8, pc |= requestInputStream.read() << 8);
                frames.add(frame);
                tag = requestInputStream.read();
            }
        }
        catch (IOException iOException) {
            throw new DebugException(new IStatus(){
                private static final String message = "Could not get stack frames";

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(message);
                }

                public String getMessage() {
                    return message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            });
        }
        IStackFrame[] framesArray = new IStackFrame[frames.size()];
        int i = 0;
        while (i < frames.size()) {
            framesArray[i] = (IStackFrame)frames.get(i);
            ++i;
        }
        return framesArray;
    }

    public void getValueFromStack(short index, byte[] val) throws IOException {
        this.sendRequest((byte)20);
        this.sendRequest((byte)(index >> 8));
        this.sendRequest((byte)(index & 0xFF));
        this.sendRequest((byte)val.length);
        InputStream requestInputStream = this.tc.getRequestInputStream();
        int i = 0;
        while (i < val.length) {
            val[i] = (byte)requestInputStream.read();
            ++i;
        }
    }

    public void stepOver() throws DebugException {
        this.stepIntoOrOver((byte)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepIntoOrOver(byte StepType) throws DebugException {
        if (this.isSuspended()) {
            CompilationSequence compilationSequence = ConverterJob.mostRecentSequence;
            if (compilationSequence != null) {
                ByteCodePatcher patcher = compilationSequence.getPatcher();
                MethodOrFieldDesc m = patcher.getMethodDescriptor(this.suspendedAt.getMethodNumber());
                try {
                    this.suspendedAtMethod = ClassfileUtils.findMethod(m.getClassName(), m.getName(), m.getSignature());
                }
                catch (Exception exception) {}
                if (this.suspendedAtMethod != null) {
                    this.suspendedAtEP = compilationSequence.getDependencyExtent().getMethod(m.getClassName(), m.getName(), m.getSignature());
                    if (this.suspendedAtEP != null) {
                        try {
                            this.threads[0].clearStackFrames();
                            HVMPOSIXDebugTarget hVMPOSIXDebugTarget = this;
                            synchronized (hVMPOSIXDebugTarget) {
                                this.sendRequest((byte)21);
                                this.sendRequest(StepType);
                                this.sendRequest(this.suspendedAt.getMethodNumber());
                                this.sendRequest(this.suspendedAt.getAddress());
                                return;
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.resume();
        }
    }

    public boolean isStepping() {
        return this.suspendedAtEP != null;
    }

    public void stepInto() throws DebugException {
        this.stepIntoOrOver((byte)1);
        this.clearSuspendedAt();
    }
}

