/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.debugging;

import icecaptools.debugging.HVMPOSIXDebugTarget;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class EventDispatchJob
extends Job {
    private static final int START_EVENT = 10;
    private static final int TERMINATED_EVENT = 12;
    private static final int BREAKPOINT_HIT_EVENT = 15;
    private InputStream eventInputStream;
    private HVMPOSIXDebugTarget target;

    public EventDispatchJob(InputStream inputStream, HVMPOSIXDebugTarget target) {
        super("HVM Debug Event Dispatch");
        this.setSystem(true);
        this.eventInputStream = inputStream;
        this.target = target;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            while (true) {
                int tag = this.eventInputStream.read();
                switch (tag) {
                    case 10: {
                        this.target.started();
                        break;
                    }
                    case 12: {
                        this.target.terminated();
                        return Status.OK_STATUS;
                    }
                    case 15: {
                        int methodNumber = this.eventInputStream.read();
                        methodNumber |= this.eventInputStream.read() << 8;
                        int pc = this.eventInputStream.read();
                        pc |= this.eventInputStream.read() << 8;
                        try {
                            this.target.breakPointHit(methodNumber, pc);
                            break;
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        }
        catch (IOException iOException) {
            return Status.OK_STATUS;
        }
    }
}

