/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.conversion;

import icecaptools.AnalysisObserver;
import icecaptools.AnnotationsAttributeReader;
import icecaptools.BNode;
import icecaptools.BasicBNode;
import icecaptools.BranchBNode;
import icecaptools.ByteCodeStream;
import icecaptools.CFuncInfo;
import icecaptools.CheckcastBNode;
import icecaptools.ClassManager;
import icecaptools.ClassfileUtils;
import icecaptools.DefaultObserver;
import icecaptools.DependencyLeakException;
import icecaptools.DependencyWalker;
import icecaptools.DynamicMethodCallVirtualMethodBNode;
import icecaptools.GotoBNode;
import icecaptools.IcecapClassPath;
import icecaptools.IcecapIterator;
import icecaptools.IcecapRepository;
import icecaptools.InterfaceMethodCallBNode;
import icecaptools.JavaArrayClass;
import icecaptools.LDCBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NewArrayBNode;
import icecaptools.NewArrayMultiBNode;
import icecaptools.NewBNode;
import icecaptools.NewList;
import icecaptools.ObjectFieldAccessBNode;
import icecaptools.RawByteCodes;
import icecaptools.RestartableMethodObserver;
import icecaptools.ReturnBNode;
import icecaptools.SpecialMethodCallBNode;
import icecaptools.StaticFieldAccessBNode;
import icecaptools.StaticMethodCallBNode;
import icecaptools.SwitchBNode;
import icecaptools.VirtualMethodCallBNode;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.LDCConstant;
import icecaptools.compiler.utils.CallGraph;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.DependencyExtent;
import icecaptools.conversion.DependencyRestrictor;
import icecaptools.conversion.TargetAddressMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.AttributeReader;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;

public class Converter
implements ClassManager {
    private DependencyExtent dependencyExtent;
    private AnalysisObserver observer;
    private RestartableMethodObserver methodObserver;
    private PrintStream out;
    DependencyRestrictor dependencyRestrictor;
    private boolean initialized;
    private CallGraph cg;
    private boolean supportLoading;

    public Converter(PrintStream out, RestartableMethodObserver methodObserver, ICompilationRegistry cregistry, boolean supportLoading) throws ClassNotFoundException {
        this.out = out;
        this.dependencyExtent = new DependencyExtent();
        this.dependencyRestrictor = new DependencyRestrictor(cregistry);
        this.methodObserver = methodObserver;
        this.initialized = false;
        this.supportLoading = supportLoading;
        this.cg = new CallGraph();
    }

    /*
     * Loose catch block
     */
    public NewList startConversion(ConversionConfiguration config) {
        NewList newList;
        block22: {
            newList = new NewList();
            try {
                try {
                    MethodEntryPoints entryPoint;
                    this.methodObserver.restart();
                    if (!this.initialized) {
                        Attribute.addAttributeReader((String)"RuntimeInvisibleAnnotations", (AttributeReader)new AnnotationsAttributeReader());
                        this.initialized = true;
                    }
                    IcecapClassPath classPath = new IcecapClassPath(config.getInputFolder());
                    IcecapRepository repository = new IcecapRepository(SyntheticRepository.getInstance((ClassPath)classPath));
                    Repository.setRepository((org.apache.bcel.util.Repository)repository);
                    Repository.clearCache();
                    if (this.observer == null) {
                        this.observer = new DefaultObserver();
                    }
                    DependencyWalker dependencyWalker = new DependencyWalker(this, this.observer, this.out, config);
                    JavaClass clazz = dependencyWalker.lookupClass(String.valueOf(config.getInputPackage()) + "." + config.getInputClass());
                    config.setEntryPointClassName(clazz.getClassName());
                    if (ClassfileUtils.hasClassInitializer(clazz)) {
                        entryPoint = this.convertByteCode(null, clazz, "<clinit>", "()V", true);
                        newList = dependencyWalker.analyseMethod(entryPoint, new NewList());
                    }
                    if (this.supportLoading) {
                        JavaClass systemClass = dependencyWalker.lookupClass("devices.System");
                        entryPoint = this.convertByteCode(null, systemClass, "includeHWObjectSupport", "()V", true);
                        newList = dependencyWalker.analyseMethod(entryPoint, newList);
                    }
                    if (config.getEntryPointMethodName() == null) {
                        config.setEntryPointMethodName("main");
                    }
                    if (config.getEntryPointMethodSignature() == null) {
                        config.setEntryPointMethodSignature("([Ljava/lang/String;)V");
                    }
                    if ((entryPoint = this.convertByteCode(null, clazz, config.getEntryPointMethodName(), config.getEntryPointMethodSignature(), config.isEntryPointModyfierIsStatic())) != null) {
                        newList = dependencyWalker.analyseMethod(entryPoint, newList);
                    }
                    IcecapIterator<CFuncInfo> cfunctions = this.observer.getCFunctions();
                    while (cfunctions.hasNext()) {
                        CFuncInfo next = cfunctions.next();
                        MethodOrFieldDesc methodDesc = next.getMethodOrFieldDesc();
                        clazz = dependencyWalker.lookupClass(methodDesc.getClassName());
                        entryPoint = this.convertByteCode(null, clazz, methodDesc.getName(), methodDesc.getSignature(), true);
                        if (entryPoint == null) continue;
                        newList = dependencyWalker.analyseMethod(entryPoint, newList);
                    }
                    IcecapIterator<String> leafMethods = dependencyWalker.getLeafs();
                    boolean first = true;
                    while (leafMethods.hasNext()) {
                        if (first) {
                            this.out.println("Empty leaf methods:");
                            first = false;
                        }
                        this.out.println(leafMethods.next());
                    }
                    String[] elements = newList.getElementsAsArray();
                    if (elements.length > 0) {
                        this.out.println("Inferred creation of the following instance types:");
                        int i = 0;
                        while (i < elements.length) {
                            this.out.println("  " + elements[i]);
                            ++i;
                        }
                    } else {
                        this.out.println("No instance types created.");
                    }
                }
                catch (ClassNotFoundException e) {
                    this.out.println(e.getMessage());
                    e.printStackTrace(this.out);
                    newList = new NewList("Error");
                    this.methodObserver.refresh();
                }
                catch (DependencyLeakException dependencyLeakException) {
                    this.out.println("Dependency leak, failed to compile " + config.getInputClass());
                    this.out.flush();
                    this.methodObserver.refresh();
                    return null;
                }
                catch (Throwable e) {
                    this.out.println(e.getMessage());
                    e.printStackTrace(this.out);
                    newList = new NewList("Error");
                    this.methodObserver.refresh();
                    break block22;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.methodObserver.refresh();
            }
        }
        return newList;
    }

    @Override
    public boolean skipMethodHack(String clazz, String targetMethodName, String targetMethodSignature) {
        return !clazz.contains("InvocationTargetException") && this.dependencyRestrictor.skipMethod(clazz, targetMethodName, targetMethodSignature);
    }

    public MethodEntryPoints convertByteCode(BNode cause, JavaClass targetClass, String targetMethodName, String targetMethodSignature, boolean isStatic) throws Exception {
        return this.convertByteCode(cause, targetClass, targetMethodName, targetMethodSignature, isStatic, false);
    }

    public MethodEntryPoints convertByteCode(BNode cause, JavaClass targetClass, String targetMethodName, String targetMethodSignature, boolean isStatic, boolean forceInclusion) throws Exception {
        MethodEntryPoints result = this.dependencyExtent.getMethod(targetClass.getClassName(), targetMethodName, targetMethodSignature);
        if (cause != null) {
            cause.registerInCallGraph(this.cg, targetClass.getClassName(), targetMethodName, targetMethodSignature);
        }
        if (result == null) {
            if (!forceInclusion && this.skipMethodHack(targetClass.getClassName(), targetMethodName, targetMethodSignature)) {
                this.observer.methodCodeUsed(targetClass.getClassName(), targetMethodName, targetMethodSignature, false);
                return null;
            }
            this.observer.methodCodeUsed(targetClass.getClassName(), targetMethodName, targetMethodSignature, true);
            result = this.convert(targetClass, targetMethodName, targetMethodSignature, isStatic);
            if (result != null) {
                this.dependencyExtent.insertMethod(result, targetClass.getClassName(), targetMethodName, targetMethodSignature);
            }
        }
        return result;
    }

    private MethodEntryPoints convert(JavaClass clazz, String targetMethodName, String targetMethodSignature, boolean isStatic) throws Exception {
        Method method = ClassfileUtils.findMethodInClass(clazz, targetMethodName, targetMethodSignature);
        if (method != null) {
            Code code = method.getCode();
            if (code != null) {
                ArrayList<BNode> bnodes = new ArrayList<BNode>();
                ByteCodeStream stream = new ByteCodeStream();
                stream.init(code.getCode());
                while (stream.hasMore()) {
                    String signature;
                    String fieldName;
                    ConstantUtf8 className;
                    ConstantClass classIndex;
                    ConstantNameAndType nameAndType;
                    ConstantUtf8 methodSig;
                    ConstantUtf8 methodName;
                    ConstantUtf8 className2;
                    ConstantNameAndType nameAndType2;
                    ConstantClass classRef;
                    int currentCode = stream.get();
                    RawByteCodes.RawBytecode current = null;
                    BNode currentBNode = null;
                    switch ((byte)currentCode) {
                        case 0: {
                            current = new RawByteCodes.Raw_nop();
                            break;
                        }
                        case 1: {
                            current = new RawByteCodes.Raw_aconst_null();
                            break;
                        }
                        case 2: {
                            current = new RawByteCodes.Raw_iconst_m1();
                            break;
                        }
                        case 3: {
                            current = new RawByteCodes.Raw_iconst_0();
                            break;
                        }
                        case 4: {
                            current = new RawByteCodes.Raw_iconst_1();
                            break;
                        }
                        case 5: {
                            current = new RawByteCodes.Raw_iconst_2();
                            break;
                        }
                        case 6: {
                            current = new RawByteCodes.Raw_iconst_3();
                            break;
                        }
                        case 7: {
                            current = new RawByteCodes.Raw_iconst_4();
                            break;
                        }
                        case 8: {
                            current = new RawByteCodes.Raw_iconst_5();
                            break;
                        }
                        case 9: {
                            current = new RawByteCodes.Raw_lconst_0();
                            break;
                        }
                        case 10: {
                            current = new RawByteCodes.Raw_lconst_1();
                            break;
                        }
                        case 11: {
                            current = new RawByteCodes.Raw_fconst_0();
                            break;
                        }
                        case 12: {
                            current = new RawByteCodes.Raw_fconst_1();
                            break;
                        }
                        case 13: {
                            current = new RawByteCodes.Raw_fconst_2();
                            break;
                        }
                        case 14: {
                            current = new RawByteCodes.Raw_dconst_0();
                            break;
                        }
                        case 15: {
                            current = new RawByteCodes.Raw_dconst_1();
                            break;
                        }
                        case 16: {
                            current = new RawByteCodes.Raw_bipush();
                            break;
                        }
                        case 17: {
                            current = new RawByteCodes.Raw_sipush();
                            break;
                        }
                        case 18: {
                            current = new RawByteCodes.Raw_ldc();
                            break;
                        }
                        case 19: {
                            current = new RawByteCodes.Raw_ldc_w();
                            break;
                        }
                        case 20: {
                            current = new RawByteCodes.Raw_ldc2_w();
                            break;
                        }
                        case 21: {
                            current = new RawByteCodes.Raw_iload();
                            break;
                        }
                        case 22: {
                            current = new RawByteCodes.Raw_lload();
                            break;
                        }
                        case 23: {
                            current = new RawByteCodes.Raw_fload();
                            break;
                        }
                        case 24: {
                            current = new RawByteCodes.Raw_dload();
                            break;
                        }
                        case 25: {
                            current = new RawByteCodes.Raw_aload();
                            break;
                        }
                        case 26: {
                            current = new RawByteCodes.Raw_iload_0();
                            break;
                        }
                        case 27: {
                            current = new RawByteCodes.Raw_iload_1();
                            break;
                        }
                        case 28: {
                            current = new RawByteCodes.Raw_iload_2();
                            break;
                        }
                        case 29: {
                            current = new RawByteCodes.Raw_iload_3();
                            break;
                        }
                        case 30: {
                            current = new RawByteCodes.Raw_lload_0();
                            break;
                        }
                        case 31: {
                            current = new RawByteCodes.Raw_lload_1();
                            break;
                        }
                        case 32: {
                            current = new RawByteCodes.Raw_lload_2();
                            break;
                        }
                        case 33: {
                            current = new RawByteCodes.Raw_lload_3();
                            break;
                        }
                        case 34: {
                            current = new RawByteCodes.Raw_fload_0();
                            break;
                        }
                        case 35: {
                            current = new RawByteCodes.Raw_fload_1();
                            break;
                        }
                        case 36: {
                            current = new RawByteCodes.Raw_fload_2();
                            break;
                        }
                        case 37: {
                            current = new RawByteCodes.Raw_fload_3();
                            break;
                        }
                        case 38: {
                            current = new RawByteCodes.Raw_dload_0();
                            break;
                        }
                        case 39: {
                            current = new RawByteCodes.Raw_dload_1();
                            break;
                        }
                        case 40: {
                            current = new RawByteCodes.Raw_dload_2();
                            break;
                        }
                        case 41: {
                            current = new RawByteCodes.Raw_dload_3();
                            break;
                        }
                        case 42: {
                            current = new RawByteCodes.Raw_aload_0();
                            break;
                        }
                        case 43: {
                            current = new RawByteCodes.Raw_aload_1();
                            break;
                        }
                        case 44: {
                            current = new RawByteCodes.Raw_aload_2();
                            break;
                        }
                        case 45: {
                            current = new RawByteCodes.Raw_aload_3();
                            break;
                        }
                        case 46: {
                            current = new RawByteCodes.Raw_iaload();
                            break;
                        }
                        case 47: {
                            current = new RawByteCodes.Raw_laload();
                            break;
                        }
                        case 48: {
                            current = new RawByteCodes.Raw_faload();
                            break;
                        }
                        case 49: {
                            current = new RawByteCodes.Raw_daload();
                            break;
                        }
                        case 50: {
                            current = new RawByteCodes.Raw_aaload();
                            break;
                        }
                        case 51: {
                            current = new RawByteCodes.Raw_baload();
                            break;
                        }
                        case 52: {
                            current = new RawByteCodes.Raw_caload();
                            break;
                        }
                        case 53: {
                            current = new RawByteCodes.Raw_saload();
                            break;
                        }
                        case 54: {
                            current = new RawByteCodes.Raw_istore();
                            break;
                        }
                        case 55: {
                            current = new RawByteCodes.Raw_lstore();
                            break;
                        }
                        case 56: {
                            current = new RawByteCodes.Raw_fstore();
                            break;
                        }
                        case 57: {
                            current = new RawByteCodes.Raw_dstore();
                            break;
                        }
                        case 58: {
                            current = new RawByteCodes.Raw_astore();
                            break;
                        }
                        case 59: {
                            current = new RawByteCodes.Raw_istore_0();
                            break;
                        }
                        case 60: {
                            current = new RawByteCodes.Raw_istore_1();
                            break;
                        }
                        case 61: {
                            current = new RawByteCodes.Raw_istore_2();
                            break;
                        }
                        case 62: {
                            current = new RawByteCodes.Raw_istore_3();
                            break;
                        }
                        case 63: {
                            current = new RawByteCodes.Raw_lstore_0();
                            break;
                        }
                        case 64: {
                            current = new RawByteCodes.Raw_lstore_1();
                            break;
                        }
                        case 65: {
                            current = new RawByteCodes.Raw_lstore_2();
                            break;
                        }
                        case 66: {
                            current = new RawByteCodes.Raw_lstore_3();
                            break;
                        }
                        case 67: {
                            current = new RawByteCodes.Raw_fstore_0();
                            break;
                        }
                        case 68: {
                            current = new RawByteCodes.Raw_fstore_1();
                            break;
                        }
                        case 69: {
                            current = new RawByteCodes.Raw_fstore_2();
                            break;
                        }
                        case 70: {
                            current = new RawByteCodes.Raw_fstore_3();
                            break;
                        }
                        case 71: {
                            current = new RawByteCodes.Raw_dstore_0();
                            break;
                        }
                        case 72: {
                            current = new RawByteCodes.Raw_dstore_1();
                            break;
                        }
                        case 73: {
                            current = new RawByteCodes.Raw_dstore_2();
                            break;
                        }
                        case 74: {
                            current = new RawByteCodes.Raw_dstore_3();
                            break;
                        }
                        case 75: {
                            current = new RawByteCodes.Raw_astore_0();
                            break;
                        }
                        case 76: {
                            current = new RawByteCodes.Raw_astore_1();
                            break;
                        }
                        case 77: {
                            current = new RawByteCodes.Raw_astore_2();
                            break;
                        }
                        case 78: {
                            current = new RawByteCodes.Raw_astore_3();
                            break;
                        }
                        case 79: {
                            current = new RawByteCodes.Raw_iastore();
                            break;
                        }
                        case 80: {
                            current = new RawByteCodes.Raw_lastore();
                            break;
                        }
                        case 81: {
                            current = new RawByteCodes.Raw_fastore();
                            break;
                        }
                        case 82: {
                            current = new RawByteCodes.Raw_dastore();
                            break;
                        }
                        case 83: {
                            current = new RawByteCodes.Raw_aastore();
                            break;
                        }
                        case 84: {
                            current = new RawByteCodes.Raw_bastore();
                            break;
                        }
                        case 85: {
                            current = new RawByteCodes.Raw_castore();
                            break;
                        }
                        case 86: {
                            current = new RawByteCodes.Raw_sastore();
                            break;
                        }
                        case 87: {
                            current = new RawByteCodes.Raw_pop();
                            break;
                        }
                        case 88: {
                            current = new RawByteCodes.Raw_pop2();
                            break;
                        }
                        case 89: {
                            current = new RawByteCodes.Raw_dup();
                            break;
                        }
                        case 90: {
                            current = new RawByteCodes.Raw_dup_x1();
                            break;
                        }
                        case 91: {
                            current = new RawByteCodes.Raw_dup_x2();
                            break;
                        }
                        case 92: {
                            current = new RawByteCodes.Raw_dup2();
                            break;
                        }
                        case 93: {
                            current = new RawByteCodes.Raw_dup2_x1();
                            break;
                        }
                        case 94: {
                            current = new RawByteCodes.Raw_dup2_x2();
                            break;
                        }
                        case 95: {
                            current = new RawByteCodes.Raw_swap();
                            break;
                        }
                        case 96: {
                            current = new RawByteCodes.Raw_iadd();
                            break;
                        }
                        case 97: {
                            current = new RawByteCodes.Raw_ladd();
                            break;
                        }
                        case 98: {
                            current = new RawByteCodes.Raw_fadd();
                            break;
                        }
                        case 99: {
                            current = new RawByteCodes.Raw_dadd();
                            break;
                        }
                        case 100: {
                            current = new RawByteCodes.Raw_isub();
                            break;
                        }
                        case 101: {
                            current = new RawByteCodes.Raw_lsub();
                            break;
                        }
                        case 102: {
                            current = new RawByteCodes.Raw_fsub();
                            break;
                        }
                        case 103: {
                            current = new RawByteCodes.Raw_dsub();
                            break;
                        }
                        case 104: {
                            current = new RawByteCodes.Raw_imul();
                            break;
                        }
                        case 105: {
                            current = new RawByteCodes.Raw_lmul();
                            break;
                        }
                        case 106: {
                            current = new RawByteCodes.Raw_fmul();
                            break;
                        }
                        case 107: {
                            current = new RawByteCodes.Raw_dmul();
                            break;
                        }
                        case 108: {
                            current = new RawByteCodes.Raw_idiv();
                            break;
                        }
                        case 109: {
                            current = new RawByteCodes.Raw_ldiv();
                            break;
                        }
                        case 110: {
                            current = new RawByteCodes.Raw_fdiv();
                            break;
                        }
                        case 111: {
                            current = new RawByteCodes.Raw_ddiv();
                            break;
                        }
                        case 112: {
                            current = new RawByteCodes.Raw_irem();
                            break;
                        }
                        case 113: {
                            current = new RawByteCodes.Raw_lrem();
                            break;
                        }
                        case 114: {
                            current = new RawByteCodes.Raw_frem();
                            break;
                        }
                        case 115: {
                            current = new RawByteCodes.Raw_drem();
                            break;
                        }
                        case 116: {
                            current = new RawByteCodes.Raw_ineg();
                            break;
                        }
                        case 117: {
                            current = new RawByteCodes.Raw_lneg();
                            break;
                        }
                        case 118: {
                            current = new RawByteCodes.Raw_fneg();
                            break;
                        }
                        case 119: {
                            current = new RawByteCodes.Raw_dneg();
                            break;
                        }
                        case 120: {
                            current = new RawByteCodes.Raw_ishl();
                            break;
                        }
                        case 121: {
                            current = new RawByteCodes.Raw_lshl();
                            break;
                        }
                        case 122: {
                            current = new RawByteCodes.Raw_ishr();
                            break;
                        }
                        case 123: {
                            current = new RawByteCodes.Raw_lshr();
                            break;
                        }
                        case 124: {
                            current = new RawByteCodes.Raw_iushr();
                            break;
                        }
                        case 125: {
                            current = new RawByteCodes.Raw_lushr();
                            break;
                        }
                        case 126: {
                            current = new RawByteCodes.Raw_iand();
                            break;
                        }
                        case 127: {
                            current = new RawByteCodes.Raw_land();
                            break;
                        }
                        case -128: {
                            current = new RawByteCodes.Raw_ior();
                            break;
                        }
                        case -126: {
                            current = new RawByteCodes.Raw_ixor();
                            break;
                        }
                        case -127: {
                            current = new RawByteCodes.Raw_lor();
                            break;
                        }
                        case -125: {
                            current = new RawByteCodes.Raw_lxor();
                            break;
                        }
                        case -124: {
                            current = new RawByteCodes.Raw_iinc();
                            break;
                        }
                        case -123: {
                            current = new RawByteCodes.Raw_i2l();
                            break;
                        }
                        case -122: {
                            current = new RawByteCodes.Raw_i2f();
                            break;
                        }
                        case -121: {
                            current = new RawByteCodes.Raw_i2d();
                            break;
                        }
                        case -120: {
                            current = new RawByteCodes.Raw_l2i();
                            break;
                        }
                        case -119: {
                            current = new RawByteCodes.Raw_l2f();
                            break;
                        }
                        case -118: {
                            current = new RawByteCodes.Raw_l2d();
                            break;
                        }
                        case -117: {
                            current = new RawByteCodes.Raw_f2i();
                            break;
                        }
                        case -116: {
                            current = new RawByteCodes.Raw_f2l();
                            break;
                        }
                        case -115: {
                            current = new RawByteCodes.Raw_f2d();
                            break;
                        }
                        case -114: {
                            current = new RawByteCodes.Raw_d2i();
                            break;
                        }
                        case -113: {
                            current = new RawByteCodes.Raw_d2l();
                            break;
                        }
                        case -112: {
                            current = new RawByteCodes.Raw_d2f();
                            break;
                        }
                        case -111: {
                            current = new RawByteCodes.Raw_i2b();
                            break;
                        }
                        case -110: {
                            current = new RawByteCodes.Raw_i2c();
                            break;
                        }
                        case -109: {
                            current = new RawByteCodes.Raw_i2s();
                            break;
                        }
                        case -108: {
                            current = new RawByteCodes.Raw_lcmp();
                            break;
                        }
                        case -107: {
                            current = new RawByteCodes.Raw_fcmpl();
                            break;
                        }
                        case -106: {
                            current = new RawByteCodes.Raw_fcmpg();
                            break;
                        }
                        case -105: {
                            current = new RawByteCodes.Raw_dcmpl();
                            break;
                        }
                        case -104: {
                            current = new RawByteCodes.Raw_dcmpg();
                            break;
                        }
                        case -103: {
                            current = new RawByteCodes.Raw_ifeq();
                            break;
                        }
                        case -102: {
                            current = new RawByteCodes.Raw_ifne();
                            break;
                        }
                        case -101: {
                            current = new RawByteCodes.Raw_iflt();
                            break;
                        }
                        case -100: {
                            current = new RawByteCodes.Raw_ifge();
                            break;
                        }
                        case -99: {
                            current = new RawByteCodes.Raw_ifgt();
                            break;
                        }
                        case -98: {
                            current = new RawByteCodes.Raw_ifle();
                            break;
                        }
                        case -97: {
                            current = new RawByteCodes.Raw_if_icmpeq();
                            break;
                        }
                        case -96: {
                            current = new RawByteCodes.Raw_if_icmpne();
                            break;
                        }
                        case -95: {
                            current = new RawByteCodes.Raw_if_icmplt();
                            break;
                        }
                        case -94: {
                            current = new RawByteCodes.Raw_if_icmpge();
                            break;
                        }
                        case -93: {
                            current = new RawByteCodes.Raw_if_icmpgt();
                            break;
                        }
                        case -92: {
                            current = new RawByteCodes.Raw_if_icmple();
                            break;
                        }
                        case -91: {
                            current = new RawByteCodes.Raw_if_acmpeq();
                            break;
                        }
                        case -90: {
                            current = new RawByteCodes.Raw_if_acmpne();
                            break;
                        }
                        case -89: {
                            current = new RawByteCodes.Raw_goto();
                            break;
                        }
                        case -88: {
                            current = new RawByteCodes.Raw_jsr();
                            break;
                        }
                        case -87: {
                            current = new RawByteCodes.Raw_ret();
                            break;
                        }
                        case -86: {
                            current = new RawByteCodes.Raw_tableswitch();
                            break;
                        }
                        case -85: {
                            current = new RawByteCodes.Raw_lookupswitch();
                            break;
                        }
                        case -84: {
                            current = new RawByteCodes.Raw_ireturn();
                            break;
                        }
                        case -83: {
                            current = new RawByteCodes.Raw_lreturn();
                            break;
                        }
                        case -82: {
                            current = new RawByteCodes.Raw_freturn();
                            break;
                        }
                        case -81: {
                            current = new RawByteCodes.Raw_dreturn();
                            break;
                        }
                        case -80: {
                            current = new RawByteCodes.Raw_areturn();
                            break;
                        }
                        case -79: {
                            current = new RawByteCodes.Raw_return();
                            break;
                        }
                        case -78: {
                            current = new RawByteCodes.Raw_getstatic();
                            break;
                        }
                        case -77: {
                            current = new RawByteCodes.Raw_putstatic();
                            break;
                        }
                        case -76: {
                            current = new RawByteCodes.Raw_getfield();
                            break;
                        }
                        case -75: {
                            current = new RawByteCodes.Raw_putfield();
                            break;
                        }
                        case -74: {
                            current = new RawByteCodes.Raw_invokevirtual();
                            break;
                        }
                        case -70: {
                            current = new RawByteCodes.Raw_invokedynamic();
                            break;
                        }
                        case -73: {
                            current = new RawByteCodes.Raw_invokespecial();
                            break;
                        }
                        case -72: {
                            current = new RawByteCodes.Raw_invokestatic();
                            break;
                        }
                        case -71: {
                            current = new RawByteCodes.Raw_invokeinterface();
                            break;
                        }
                        case -69: {
                            current = new RawByteCodes.Raw_new();
                            break;
                        }
                        case -67: {
                            current = new RawByteCodes.Raw_anewarray();
                            break;
                        }
                        case -68: {
                            current = new RawByteCodes.Raw_newArray();
                            break;
                        }
                        case -66: {
                            current = new RawByteCodes.Raw_arraylength();
                            break;
                        }
                        case -65: {
                            current = new RawByteCodes.Raw_athrow();
                            break;
                        }
                        case -64: {
                            current = new RawByteCodes.Raw_checkcast();
                            break;
                        }
                        case -63: {
                            current = new RawByteCodes.Raw_instanceof();
                            break;
                        }
                        case -62: {
                            current = new RawByteCodes.Raw_monitorenter();
                            break;
                        }
                        case -61: {
                            current = new RawByteCodes.Raw_monitorexit();
                            break;
                        }
                        case -60: {
                            current = new RawByteCodes.Raw_wide();
                            break;
                        }
                        case -59: {
                            current = new RawByteCodes.Raw_multianewarray();
                            break;
                        }
                        case -58: {
                            current = new RawByteCodes.Raw_ifnull();
                            break;
                        }
                        case -57: {
                            current = new RawByteCodes.Raw_ifnonnull();
                            break;
                        }
                        case -56: {
                            current = new RawByteCodes.Raw_goto_w();
                            break;
                        }
                        case -55: {
                            current = new RawByteCodes.Raw_jsr_w();
                            break;
                        }
                        default: {
                            throw new Exception("Unknown byte code [" + currentCode + "]");
                        }
                    }
                    current.read(currentCode, stream);
                    if (current instanceof RawByteCodes.Raw_goto) {
                        RawByteCodes.Raw_goto rawGoto = (RawByteCodes.Raw_goto)current;
                        currentBNode = new GotoBNode(rawGoto.getAddress(), (int)rawGoto.branchoffset, clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.RawShortBranchOperation) {
                        RawByteCodes.RawShortBranchOperation shortBranchOperation = (RawByteCodes.RawShortBranchOperation)current;
                        currentBNode = new BranchBNode(shortBranchOperation.getAddress(), (int)shortBranchOperation.branchoffset, clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_new) {
                        RawByteCodes.Raw_new rawNew = (RawByteCodes.Raw_new)current;
                        JavaClass newType = ClassfileUtils.getType(clazz, rawNew.cpIndex);
                        currentBNode = new NewBNode(rawNew.getAddress(), newType, clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_checkcast) {
                        JavaClass type = ClassfileUtils.getType(clazz, ((RawByteCodes.Raw_checkcast)current).cpIndex);
                        currentBNode = type != null ? new CheckcastBNode(current.getAddress(), type, clazz.getClassName(), targetMethodName, targetMethodSignature) : new BasicBNode(current.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_instanceof) {
                        JavaClass type = ClassfileUtils.getType(clazz, ((RawByteCodes.Raw_instanceof)current).cpIndex);
                        currentBNode = type != null ? new CheckcastBNode(current.getAddress(), type, clazz.getClassName(), targetMethodName, targetMethodSignature) : new BasicBNode(current.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_invokevirtual) {
                        RawByteCodes.Raw_invokevirtual rawInvokeVirtual = (RawByteCodes.Raw_invokevirtual)current;
                        int index = rawInvokeVirtual.cpIndex;
                        ConstantMethodref methodRef = (ConstantMethodref)clazz.getConstantPool().getConstant(index);
                        classRef = (ConstantClass)clazz.getConstantPool().getConstant(methodRef.getClassIndex());
                        nameAndType2 = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodRef.getNameAndTypeIndex());
                        className2 = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef.getNameIndex());
                        methodName = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getNameIndex());
                        methodSig = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getSignatureIndex());
                        currentBNode = new VirtualMethodCallBNode(rawInvokeVirtual.getAddress(), className2.getBytes(), methodName.getBytes(), methodSig.getBytes(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_invokedynamic) {
                        Attribute[] attributes;
                        RawByteCodes.Raw_invokedynamic rawInvokeDynamic = (RawByteCodes.Raw_invokedynamic)current;
                        int index = rawInvokeDynamic.cpIndex;
                        ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)clazz.getConstantPool().getConstant(index);
                        int bootstrapIndex = constantInvokeDynamic.getBootstrapMethodAttrIndex();
                        int nameAndTypeIndex = constantInvokeDynamic.getNameAndTypeIndex();
                        nameAndType = (ConstantNameAndType)clazz.getConstantPool().getConstant(nameAndTypeIndex);
                        methodName = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType.getNameIndex());
                        methodSig = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType.getSignatureIndex());
                        Attribute[] attributeArray = attributes = clazz.getAttributes();
                        int n = attributes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            BootstrapMethods bmethods;
                            BootstrapMethod[] bmethodsAsArray;
                            Attribute attribute = attributeArray[n2];
                            if (attribute instanceof BootstrapMethods && (bmethodsAsArray = (bmethods = (BootstrapMethods)attribute).getBootstrapMethods()) != null && bootstrapIndex < bmethodsAsArray.length) {
                                int[] args;
                                BootstrapMethod bm = bmethodsAsArray[bootstrapIndex];
                                int methodRefIndex = bm.getBootstrapMethodRef();
                                ConstantMethodHandle methodRef = (ConstantMethodHandle)clazz.getConstantPool().getConstant(methodRefIndex);
                                switch (methodRef.getReferenceKind()) {
                                    case 1: {
                                        System.out.println("REF_getField");
                                        break;
                                    }
                                    case 2: {
                                        System.out.println("REF_getStatic");
                                        break;
                                    }
                                    case 3: {
                                        System.out.println("REF_putField");
                                        break;
                                    }
                                    case 4: {
                                        System.out.println("REF_putStatic");
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        ConstantMethodref methodInfo = (ConstantMethodref)clazz.getConstantPool().getConstant(methodRef.getReferenceIndex());
                                        ConstantClass classRef2 = (ConstantClass)clazz.getConstantPool().getConstant(methodInfo.getClassIndex());
                                        ConstantNameAndType nameAndTypeHandle = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodInfo.getNameAndTypeIndex());
                                        ConstantUtf8 classNameHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef2.getNameIndex());
                                        ConstantUtf8 methodNameHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndTypeHandle.getNameIndex());
                                        ConstantUtf8 methodSigHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndTypeHandle.getSignatureIndex());
                                        currentBNode = new DynamicMethodCallVirtualMethodBNode(rawInvokeDynamic.getAddress(), bootstrapIndex, methodName.getBytes(), methodSig.getBytes(), classNameHandle.getBytes(), methodNameHandle.getBytes(), methodSigHandle.getBytes(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                                        break;
                                    }
                                    case 9: {
                                        System.out.println("REF_invokeInterface");
                                        break;
                                    }
                                    default: {
                                        System.out.println("default");
                                    }
                                }
                                int[] nArray = args = bm.getBootstrapArguments();
                                int n3 = args.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    int i = nArray[n4];
                                    Constant c = clazz.getConstantPool().getConstant(i);
                                    if (!(c instanceof ConstantMethodType) && c instanceof ConstantMethodHandle) {
                                        methodRef = (ConstantMethodHandle)c;
                                        switch (methodRef.getReferenceKind()) {
                                            case 1: {
                                                System.out.println("REF_getField");
                                                break;
                                            }
                                            case 2: {
                                                System.out.println("REF_getStatic");
                                                break;
                                            }
                                            case 3: {
                                                System.out.println("REF_putField");
                                                break;
                                            }
                                            case 4: {
                                                System.out.println("REF_putStatic");
                                                break;
                                            }
                                            case 5: 
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                ConstantMethodref methodInfo = (ConstantMethodref)clazz.getConstantPool().getConstant(methodRef.getReferenceIndex());
                                                ConstantClass classRef3 = (ConstantClass)clazz.getConstantPool().getConstant(methodInfo.getClassIndex());
                                                ConstantNameAndType nameAndTypeHandle = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodInfo.getNameAndTypeIndex());
                                                ConstantUtf8 classNameHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef3.getNameIndex());
                                                ConstantUtf8 methodNameHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndTypeHandle.getNameIndex());
                                                ConstantUtf8 methodSigHandle = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndTypeHandle.getSignatureIndex());
                                                if (!(currentBNode instanceof DynamicMethodCallVirtualMethodBNode)) break;
                                                ((DynamicMethodCallVirtualMethodBNode)currentBNode).setLambdaMethod(classNameHandle.getBytes(), methodNameHandle.getBytes(), methodSigHandle.getBytes());
                                                break;
                                            }
                                            case 9: {
                                                System.out.println("REF_invokeInterface");
                                                break;
                                            }
                                            default: {
                                                System.out.println("default");
                                            }
                                        }
                                    }
                                    c = null;
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    } else if (current instanceof RawByteCodes.Raw_invokespecial) {
                        RawByteCodes.Raw_invokespecial rawInvokeSpecial = (RawByteCodes.Raw_invokespecial)current;
                        int index = rawInvokeSpecial.cpIndex;
                        ConstantMethodref methodRef = (ConstantMethodref)clazz.getConstantPool().getConstant(index);
                        classRef = (ConstantClass)clazz.getConstantPool().getConstant(methodRef.getClassIndex());
                        nameAndType2 = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodRef.getNameAndTypeIndex());
                        className2 = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef.getNameIndex());
                        methodName = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getNameIndex());
                        methodSig = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getSignatureIndex());
                        currentBNode = new SpecialMethodCallBNode(rawInvokeSpecial.getAddress(), className2.getBytes(), methodName.getBytes(), methodSig.getBytes(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_invokestatic) {
                        RawByteCodes.Raw_invokestatic rawInvokeStatic = (RawByteCodes.Raw_invokestatic)current;
                        int index = rawInvokeStatic.cpIndex;
                        ConstantMethodref methodRef = (ConstantMethodref)clazz.getConstantPool().getConstant(index);
                        classRef = (ConstantClass)clazz.getConstantPool().getConstant(methodRef.getClassIndex());
                        nameAndType2 = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodRef.getNameAndTypeIndex());
                        className2 = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef.getNameIndex());
                        methodName = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getNameIndex());
                        methodSig = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getSignatureIndex());
                        currentBNode = new StaticMethodCallBNode(rawInvokeStatic.getAddress(), className2.getBytes(), methodName.getBytes(), methodSig.getBytes(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_invokeinterface) {
                        RawByteCodes.Raw_invokeinterface rawInvokeInterface = (RawByteCodes.Raw_invokeinterface)current;
                        int index = rawInvokeInterface.cpIndex;
                        ConstantInterfaceMethodref methodRef = (ConstantInterfaceMethodref)clazz.getConstantPool().getConstant(index);
                        classRef = (ConstantClass)clazz.getConstantPool().getConstant(methodRef.getClassIndex());
                        nameAndType2 = (ConstantNameAndType)clazz.getConstantPool().getConstant(methodRef.getNameAndTypeIndex());
                        className2 = (ConstantUtf8)clazz.getConstantPool().getConstant(classRef.getNameIndex());
                        methodName = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getNameIndex());
                        methodSig = (ConstantUtf8)clazz.getConstantPool().getConstant(nameAndType2.getSignatureIndex());
                        currentBNode = new InterfaceMethodCallBNode(rawInvokeInterface.getAddress(), className2.getBytes(), methodName.getBytes(), methodSig.getBytes(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.RawReturnOperation || current instanceof RawByteCodes.Raw_ret || current instanceof RawByteCodes.Raw_athrow) {
                        currentBNode = new ReturnBNode(current.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_putstatic || current instanceof RawByteCodes.Raw_getstatic) {
                        RawByteCodes.RawCpIndexOperation putgetstatic = (RawByteCodes.RawCpIndexOperation)current;
                        int index = putgetstatic.cpIndex;
                        ConstantFieldref fieldRef = (ConstantFieldref)clazz.getConstantPool().getConstant(index);
                        classIndex = (ConstantClass)clazz.getConstantPool().getConstant(fieldRef.getClassIndex());
                        className = (ConstantUtf8)clazz.getConstantPool().getConstant(classIndex.getNameIndex());
                        nameAndType = (ConstantNameAndType)clazz.getConstantPool().getConstant(fieldRef.getNameAndTypeIndex());
                        fieldName = nameAndType.getName(clazz.getConstantPool());
                        signature = nameAndType.getSignature(clazz.getConstantPool());
                        currentBNode = new StaticFieldAccessBNode(putgetstatic.getAddress(), className.getBytes().replace('/', '.'), fieldName, signature, current instanceof RawByteCodes.Raw_getstatic, clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_tableswitch) {
                        RawByteCodes.Raw_tableswitch tableSwitch = (RawByteCodes.Raw_tableswitch)current;
                        currentBNode = new SwitchBNode(tableSwitch, tableSwitch.getAddress(), tableSwitch.defaultVal, clazz.getClassName(), targetMethodName, targetMethodSignature);
                        long[] targets = tableSwitch.offsets;
                        int count = 0;
                        while (count < targets.length) {
                            ((SwitchBNode)currentBNode).addTargetAddress(targets[count]);
                            ++count;
                        }
                    } else if (current instanceof RawByteCodes.Raw_lookupswitch) {
                        RawByteCodes.Raw_lookupswitch lookupSwitch = (RawByteCodes.Raw_lookupswitch)current;
                        currentBNode = new SwitchBNode(lookupSwitch, lookupSwitch.getAddress(), lookupSwitch.defaultVal, clazz.getClassName(), targetMethodName, targetMethodSignature);
                        RawByteCodes.Raw_lookupswitch.Pair[] pairs = lookupSwitch.pairs;
                        int count = 0;
                        while (count < pairs.length) {
                            ((SwitchBNode)currentBNode).addTargetAddress(pairs[count].offset);
                            ++count;
                        }
                    } else if (current instanceof RawByteCodes.Raw_putfield || current instanceof RawByteCodes.Raw_getfield) {
                        RawByteCodes.RawCpIndexOperation putgetfield = (RawByteCodes.RawCpIndexOperation)current;
                        int index = putgetfield.cpIndex;
                        ConstantFieldref fieldRef = (ConstantFieldref)clazz.getConstantPool().getConstant(index);
                        classIndex = (ConstantClass)clazz.getConstantPool().getConstant(fieldRef.getClassIndex());
                        className = (ConstantUtf8)clazz.getConstantPool().getConstant(classIndex.getNameIndex());
                        nameAndType = (ConstantNameAndType)clazz.getConstantPool().getConstant(fieldRef.getNameAndTypeIndex());
                        fieldName = nameAndType.getName(clazz.getConstantPool());
                        signature = nameAndType.getSignature(clazz.getConstantPool());
                        currentBNode = new ObjectFieldAccessBNode(current.getAddress(), className.getBytes(), fieldName, signature, current instanceof RawByteCodes.Raw_getfield, clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_ldc || current instanceof RawByteCodes.Raw_ldc_w || current instanceof RawByteCodes.Raw_ldc2_w) {
                        int cpIndex = current instanceof RawByteCodes.Raw_ldc ? ((RawByteCodes.Raw_ldc)current).cpIndex : (current instanceof RawByteCodes.Raw_ldc2_w ? ((RawByteCodes.Raw_ldc2_w)current).cpIndex : ((RawByteCodes.Raw_ldc_w)current).cpIndex);
                        LDCConstant constant = ClassfileUtils.getLDCConstant(clazz.getClassName(), cpIndex);
                        currentBNode = new LDCBNode(constant, current.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_anewarray) {
                        RawByteCodes.Raw_anewarray newArray = (RawByteCodes.Raw_anewarray)current;
                        JavaClass newType = ClassfileUtils.getType(clazz, newArray.cpIndex);
                        currentBNode = new NewArrayBNode(newType, newArray.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_newArray) {
                        RawByteCodes.Raw_newArray newArray = (RawByteCodes.Raw_newArray)current;
                        currentBNode = new NewArrayBNode(newArray.type, newArray.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    } else if (current instanceof RawByteCodes.Raw_multianewarray) {
                        RawByteCodes.Raw_multianewarray newArray = (RawByteCodes.Raw_multianewarray)current;
                        JavaArrayClass newType = (JavaArrayClass)ClassfileUtils.getType(clazz, newArray.cpIndex);
                        if (newType.isBasicType()) {
                            int type = newType.getBasicType();
                            currentBNode = new NewArrayMultiBNode(type, newArray.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature, newType.getDimension());
                        } else {
                            currentBNode = new NewArrayMultiBNode(newType, newArray.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature, newType.getDimension());
                        }
                    } else {
                        currentBNode = new BasicBNode(current.getAddress(), clazz.getClassName(), targetMethodName, targetMethodSignature);
                    }
                    currentBNode.setExceptionsThrown(current.exceptionsThrown());
                    currentBNode.setRawBytes(current.getRawBytes());
                    currentBNode.setRawBytecode(current);
                    bnodes.add(currentBNode);
                }
                TargetAddressMap tmap = new TargetAddressMap();
                Converter.linkBNodes(bnodes, tmap);
                return new MethodEntryPoints(bnodes, method, tmap, clazz);
            }
            return null;
        }
        return null;
    }

    public static void extendBNodes(ArrayList<BNode> bnodes, CodeException[] codeExceptions) throws Exception {
        int i = 0;
        while (i < bnodes.size()) {
            BNode current = bnodes.get(i);
            if (current.requiresExtension()) {
                int extension = current.extend();
                int address = current.getAddress();
                Converter.relocateExceptions(address, extension, codeExceptions);
                Converter.relocateForward(bnodes, i + 1, extension, address);
                Converter.relocateBackward(bnodes, i, extension, address);
            }
            ++i;
        }
    }

    private static void relocateExceptions(int address, int extension, CodeException[] codeExceptions) {
        if (codeExceptions != null && codeExceptions.length > 0) {
            int i = 0;
            while (i < codeExceptions.length) {
                CodeException exceptionHandler = codeExceptions[i];
                int startPC = exceptionHandler.getStartPC();
                int endPC = exceptionHandler.getEndPC();
                int handlerPC = exceptionHandler.getHandlerPC();
                if (startPC > address) {
                    startPC += extension;
                }
                if (endPC > address) {
                    endPC += extension;
                }
                if (handlerPC > address) {
                    handlerPC += extension;
                }
                exceptionHandler.setStartPC(startPC);
                exceptionHandler.setEndPC(endPC);
                exceptionHandler.setHandlerPC(handlerPC);
                ++i;
            }
        }
    }

    private static void relocateBackward(ArrayList<BNode> bnodes, int end, int extension, int address) {
        int i = 0;
        while (i <= end) {
            BNode current = bnodes.get(i);
            current.relocateBackward(address, extension);
            ++i;
        }
    }

    private static void relocateForward(ArrayList<BNode> bnodes, int start, int extension, int address) {
        int i = start;
        while (i < bnodes.size()) {
            BNode current = bnodes.get(i);
            current.relocateForward(address, extension);
            current.setAddress(current.getAddress() + extension);
            ++i;
        }
    }

    private static void linkBNodes(ArrayList<BNode> bnodes, TargetAddressMap tmap) throws Exception {
        BNode[] nodes = new BNode[bnodes.size()];
        Iterator<BNode> iterator = bnodes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            nodes[i] = iterator.next();
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            BNode bNode = nodes[i];
            bNode.link(nodes, tmap);
            ++i;
        }
    }

    public void setObserver(AnalysisObserver analysisObserver) {
        this.observer = analysisObserver;
    }

    public AnalysisObserver getObserver() {
        return this.observer;
    }

    public DependencyExtent getDependencyExtent() {
        return this.dependencyExtent;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }
}

