/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.utils;

import icecaptools.IcecapIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MethodMap<T> {
    private HashMap<String, Object> classes = new HashMap();
    private ArrayList<T> values = new ArrayList();
    private ArrayList<String> classesList = null;

    public boolean contains(String className) {
        return this.classes.containsKey(className);
    }

    public void put(String className) {
        HashMap methods = (HashMap)this.classes.get(className);
        if (methods == null) {
            methods = new HashMap();
            this.classes.put(className, methods);
            this.classesList = null;
        }
    }

    public boolean put(String className, String targetMethodName, String targetMethodSignature, T value) {
        if (this.classes.containsKey(className)) {
            HashMap methods = (HashMap)this.classes.get(className);
            if (methods.containsKey(targetMethodName)) {
                HashMap signatures = (HashMap)methods.get(targetMethodName);
                if (signatures.containsKey(targetMethodSignature)) {
                    return false;
                }
                signatures.put(targetMethodSignature, value);
                this.values.add(value);
                return true;
            }
            HashMap signatures = new HashMap();
            methods.put(targetMethodName, signatures);
            return this.put(className, targetMethodName, targetMethodSignature, value);
        }
        HashMap methods = new HashMap();
        this.classes.put(className, methods);
        this.classesList = null;
        return this.put(className, targetMethodName, targetMethodSignature, value);
    }

    public Iterator<String> getClasses() {
        if (this.classesList == null) {
            Set<String> keys = this.classes.keySet();
            this.classesList = new ArrayList<String>(keys);
            Collections.sort(this.classesList);
        }
        return this.classesList.iterator();
    }

    public boolean contains(String className, String methodName, String methodSignature) {
        return this.get(className, methodName, methodSignature) != null;
    }

    public T get(String className, String methodName, String methodSignature) {
        HashMap signatures;
        HashMap methods = (HashMap)this.classes.get(className);
        if (methods != null && (signatures = (HashMap)methods.get(methodName)) != null) {
            Object value = signatures.get(methodSignature);
            return (T)value;
        }
        return null;
    }

    public Iterator<T> getValues() {
        return this.values.iterator();
    }

    public IcecapIterator<T> getMethods(String nextClass) {
        return this.get(nextClass);
    }

    private IcecapIterator<T> get(String nextClass) {
        return new ValueIterator(nextClass);
    }

    private class ValueIterator
    implements IcecapIterator<T> {
        private Iterator<String> methods;
        private Iterator<String> signatures;
        private String className;
        private HashMap<String, Object> ms;
        private HashMap<String, T> ss;

        ValueIterator(String className) {
            this.className = className;
            this.methods = null;
            this.signatures = null;
        }

        @Override
        public boolean hasNext() {
            if (this.methods == null) {
                if (MethodMap.this.classes.containsKey(this.className)) {
                    this.ms = (HashMap)MethodMap.this.classes.get(this.className);
                    this.methods = this.ms.keySet().iterator();
                    return this.hasNext();
                }
            } else if (this.signatures == null) {
                if (this.methods.hasNext()) {
                    String nextMethod = this.methods.next();
                    this.ss = (HashMap)this.ms.get(nextMethod);
                    this.signatures = this.ss.keySet().iterator();
                    return this.hasNext();
                }
            } else {
                return this.signatures.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            Object n = this.ss.get(this.signatures.next());
            if (!this.signatures.hasNext()) {
                this.signatures = null;
            }
            return n;
        }
    }
}

