/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.utils;

public class ClassInheritanceMatrix {
    private int dimension = 1;
    private byte[] bits;
    private int tupac = 0;

    public ClassInheritanceMatrix(int d) {
        while (this.dimension < d) {
            this.dimension += this.dimension;
            ++this.tupac;
        }
        int bitsRequired = this.dimension * this.dimension;
        int bytesRequired = bitsRequired / 8;
        if (bitsRequired % 8 > 0) {
            ++bytesRequired;
        }
        this.bits = new byte[bytesRequired];
    }

    public void setInherits(int subClass, int superClass) {
        int bitIndex = (subClass << this.tupac) + superClass;
        int byteIndex = bitIndex >> 3;
        byte b = this.bits[byteIndex];
        this.bits[byteIndex] = b = (byte)(b | 1 << (bitIndex & 7));
    }

    public boolean getInherits(int subClass, int superClass) {
        int bitIndex = (subClass << this.tupac) + superClass;
        int byteIndex = bitIndex >> 3;
        byte b = this.bits[byteIndex];
        return (b = (byte)(b & 1 << (bitIndex & 7))) != 0;
    }

    public StringBuffer getMatrix() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RANGE const uint8 tupac = " + this.tupac + ";\n");
        buffer.append("RANGE static const unsigned char _inheritanceMatrix[" + this.bits.length + "] PROGMEM = { ");
        int i = 0;
        while (i < this.bits.length) {
            byte b = this.bits[i];
            buffer.append("0x").append("0123456789ABCDEF".charAt((b & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(b & 0xF));
            if (i < this.bits.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append(" };\n");
        return buffer;
    }

    public int getMatrixSize() {
        return this.bits.length;
    }
}

