/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.utils;

import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.HackInterfaceMethodCallBNode;
import icecaptools.IcecapIterator;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodIdentifier;
import icecaptools.MethodOrFieldDesc;
import icecaptools.VirtualOrInterfaceMethodCallBNode;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.utils.MethodMap;
import icecaptools.compiler.utils.SubClassChecker;
import icecaptools.conversion.DependencyExtent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class CallGraph {
    private MethodMap<MethodMap<CGInfo>> cg = new MethodMap();
    private MethodMap<LinkedList<BNode>> allCallSites = new MethodMap();
    private boolean newInstanceInvoked = false;
    private JavaClass runtimException;
    private JavaClass error;
    private SubClassChecker subClassChecker = new SubClassChecker();

    public MethodMap<CGInfo> register(BNode cause, String locationClass, String locationMethod, String locationMethodSignature, String targetClassName, String targetMethodName, String targetMethodSignature) {
        CGInfo cgInfo;
        MethodMap<CGInfo> callees = this.cg.get(locationClass, locationMethod, locationMethodSignature);
        if (callees == null) {
            callees = new MethodMap();
            this.cg.put(locationClass, locationMethod, locationMethodSignature, callees);
        }
        if ((cgInfo = callees.get(targetClassName, targetMethodName, targetMethodSignature)) == null) {
            cgInfo = new CGInfo(locationClass, locationMethod, locationMethodSignature, targetClassName, targetMethodName, targetMethodSignature);
            callees.put(targetClassName, targetMethodName, targetMethodSignature, cgInfo);
        }
        cgInfo.addCause(cause);
        if (targetMethodName.equals("newInstance")) {
            this.newInstanceInvoked = true;
        }
        return callees;
    }

    public void analyse(DependencyExtent extent, ICompilationRegistry cregistry) throws ClassNotFoundException {
        this.runtimException = Repository.lookupClass((String)"java.lang.RuntimeException");
        this.error = Repository.lookupClass((String)"java.lang.Error");
        Iterator<MethodEntryPoints> methods = extent.getMethods();
        while (methods.hasNext()) {
            MethodEntryPoints nextMethod = methods.next();
            this.analyseMethod(nextMethod, cregistry);
            this.buildCallSites(nextMethod);
        }
        boolean carryOn = true;
        while (carryOn) {
            carryOn = false;
            Iterator<MethodEntryPoints> methodsIterator = extent.getMethods();
            while (methodsIterator.hasNext()) {
                LinkedList<BNode> callSites;
                MethodEntryPoints nextMethod = methodsIterator.next();
                if (!nextMethod.canCallWithArgs() || (callSites = this.allCallSites.get(nextMethod.getClazz().getClassName(), nextMethod.getMethod().getName(), nextMethod.getMethod().getSignature())) == null) continue;
                Iterator callSitesIterator = callSites.iterator();
                while (callSitesIterator.hasNext() && !carryOn) {
                    VirtualOrInterfaceMethodCallBNode callsite = (VirtualOrInterfaceMethodCallBNode)callSitesIterator.next();
                    Iterator<JavaClass> targetClasses = callsite.getTargetClasses();
                    while (targetClasses.hasNext() && !carryOn) {
                        String nextClass = targetClasses.next().getClassName();
                        MethodEntryPoints targetMethod = extent.getMethod(nextClass, nextMethod.getMethod().getName(), nextMethod.getMethod().getSignature());
                        if (targetMethod != null) {
                            if (targetMethod.canCallWithArgs()) continue;
                            nextMethod.setCallWithArgs(false);
                            carryOn = true;
                            continue;
                        }
                        nextMethod.setCallWithArgs(false);
                        carryOn = true;
                    }
                }
            }
        }
    }

    private void buildCallSites(MethodEntryPoints method) {
        Iterator<MethodMap<CGInfo>> callers = this.cg.getValues();
        LinkedList<BNode> callSites = new LinkedList<BNode>();
        while (callers.hasNext()) {
            MethodMap<CGInfo> callees = callers.next();
            Iterator<CGInfo> entries = callees.getValues();
            while (entries.hasNext()) {
                CGInfo cgInfo = entries.next();
                if (!method.isEqualTo(cgInfo.targetClassName, cgInfo.targetMethodName, cgInfo.targetMethodSignature)) continue;
                Collection<? extends BNode> causes = cgInfo.getCauses();
                for (BNode bNode : causes) {
                    if (!(bNode instanceof VirtualOrInterfaceMethodCallBNode) || bNode instanceof HackInterfaceMethodCallBNode) continue;
                    callSites.add(bNode);
                }
            }
        }
        if (callSites.size() > 0) {
            this.allCallSites.put(method.getClazz().getClassName(), method.getMethod().getName(), method.getMethod().getSignature(), callSites);
        }
    }

    private void analyseMethod(MethodEntryPoints method, ICompilationRegistry cregistry) throws ClassNotFoundException {
        Iterator<MethodMap<CGInfo>> callers = this.cg.getValues();
        LinkedList<? extends BNode> callSites = new LinkedList<BNode>();
        while (callers.hasNext()) {
            MethodMap<CGInfo> callees = callers.next();
            Iterator<CGInfo> entries = callees.getValues();
            while (entries.hasNext()) {
                CGInfo cgInfo = entries.next();
                if (!method.isEqualTo(cgInfo.targetClassName, cgInfo.targetMethodName, cgInfo.targetMethodSignature)) continue;
                try {
                    Method caller = ClassfileUtils.findMethod(cgInfo.locationClass, cgInfo.locationMethod, cgInfo.locationMethodSignature).getMethod();
                    MethodOrFieldDesc desc = new MethodOrFieldDesc(cgInfo.locationClass, cgInfo.locationMethod, cgInfo.locationMethodSignature);
                    if (!Compiler.compileMethod(cregistry, caller, desc)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    return;
                }
                callSites.addAll(cgInfo.getCauses());
            }
        }
        Method m = method.getMethod();
        MethodOrFieldDesc desc = new MethodOrFieldDesc(method.getClazz().getClassName(), m.getName(), m.getSignature());
        if (desc.getClassName().equals("java.lang.String") && desc.getName().equals("<init>") && desc.getSignature().equals("([C)V")) {
            return;
        }
        if (Compiler.isStaticInitializer(desc)) {
            return;
        }
        if (!Compiler.compileMethod(cregistry, m, desc)) {
            return;
        }
        if (m.isSynthetic()) {
            return;
        }
        if (this.newInstanceInvoked && m.getName().equals("<init>") && m.getSignature().equals("()V")) {
            return;
        }
        if (m.getName().contains("dispatchRunnable")) {
            return;
        }
        if (m.getName().contains("lock")) {
            return;
        }
        if (m.getName().contains("unlock")) {
            return;
        }
        if (m.getName().contains("setNormalized")) {
            return;
        }
        String clazz = method.getClazz().getClassName();
        JavaClass currentClass = Repository.lookupClass((String)clazz);
        if ((this.subClassChecker.isSubclassOf(currentClass, this.runtimException) || this.subClassChecker.isSubclassOf(currentClass, this.error)) && m.getName().equals("<init>") && m.getSignature().equals("()V")) {
            return;
        }
        method.setCallWithArgs(true);
    }

    public IcecapIterator<MethodIdentifier> getCallees(String className, String methodName, String methodSignature) {
        MethodMap<CGInfo> calledMethods = this.cg.get(className, methodName, methodSignature);
        if (calledMethods == null) {
            return new EmptyMethodIdentifierIterator();
        }
        return new MethodIdentifierIterator(calledMethods.getValues());
    }

    public static class CGInfo
    implements MethodIdentifier {
        String locationClass;
        String locationMethod;
        String locationMethodSignature;
        String targetClassName;
        String targetMethodName;
        String targetMethodSignature;
        LinkedList<BNode> causes = new LinkedList();
        private int gValue;

        public CGInfo(String locationClass, String locationMethod, String locationMethodSignature, String targetClassName, String targetMethodName, String targetMethodSignature) {
            this.locationClass = locationClass;
            this.locationMethod = locationMethod;
            this.locationMethodSignature = locationMethodSignature;
            this.targetClassName = targetClassName;
            this.targetMethodName = targetMethodName;
            this.targetMethodSignature = targetMethodSignature;
        }

        public void addCause(BNode cause) {
            if (!this.causes.contains(cause)) {
                this.causes.add(cause);
            }
        }

        public Collection<? extends BNode> getCauses() {
            return this.causes;
        }

        @Override
        public String getClassName() {
            return this.targetClassName;
        }

        @Override
        public String getName() {
            return this.targetMethodName;
        }

        public String toString() {
            return String.valueOf(this.targetClassName) + "." + this.targetMethodName + "(" + this.targetMethodSignature + ")";
        }

        @Override
        public String getSignature() {
            return this.targetMethodSignature;
        }

        @Override
        public int getGenericValue() {
            return this.gValue;
        }

        @Override
        public void setGenericValue(int m) {
            this.gValue = m;
        }

        public boolean isRecursive() {
            return this.locationClass.equals(this.targetClassName) && this.locationMethod.equals(this.targetMethodName) && this.locationMethodSignature.equals(this.targetMethodSignature);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CGInfo) {
                CGInfo other = (CGInfo)obj;
                if (other.targetClassName.equals(this.targetClassName) && other.targetMethodName.equals(this.targetMethodName) && other.targetMethodSignature.equals(this.targetMethodSignature)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class EmptyMethodIdentifierIterator
    implements IcecapIterator<MethodIdentifier> {
        private EmptyMethodIdentifierIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public MethodIdentifier next() {
            return null;
        }
    }

    private static class MethodIdentifierIterator
    implements IcecapIterator<MethodIdentifier> {
        private Iterator<CGInfo> values;

        public MethodIdentifierIterator(Iterator<CGInfo> values) {
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.values.hasNext();
        }

        @Override
        public MethodIdentifier next() {
            return this.values.next();
        }
    }
}

