/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.StackCellInfo;
import icecaptools.compiler.aot.StackManager;

public class LevelNRegisterAllocator
extends StackManager {
    private StackCell[] stackCache;

    public LevelNRegisterAllocator(StringBuffer output, NoDuplicatesMemorySegment localVariables, int level, int maxLocals, boolean isSynthetic, SPManipulator spManipulator) {
        super(output, localVariables, maxLocals, isSynthetic, spManipulator);
        this.stackCache = new StackCell[level];
        int i = 0;
        while (i < level) {
            StackCell next = new StackCell();
            next.inUse = false;
            next.size = -1;
            next.postfix = (byte)i;
            next.v_name = "";
            this.stackCache[i] = next;
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = this.stackCache.length - 1;
        while (i >= 0) {
            StackCell next = this.stackCache[i];
            if (next.inUse) {
                switch (next.size) {
                    case 1: {
                        buffer.append("byte ");
                        break;
                    }
                    case 2: {
                        buffer.append("short ");
                        break;
                    }
                    case 3: {
                        buffer.append("int ");
                        break;
                    }
                    default: {
                        buffer.append("??? ");
                    }
                }
                buffer.append(next.v_name);
            } else {
                buffer.append("---");
            }
            buffer.append("\n");
            --i;
        }
        return buffer.toString();
    }

    public LevelNRegisterAllocator(NoDuplicatesMemorySegment localVariables, int level, int maxLocals, boolean isSynthetic, SPManipulator spManipulator) {
        this(null, localVariables, level, maxLocals, isSynthetic, spManipulator);
    }

    @Override
    public void push(int dstSize, String value) {
        StackCell top = null;
        int index = this.stackCache.length - 1;
        while (index >= 0) {
            if (!this.stackCache[index].inUse) {
                top = this.stackCache[index];
                break;
            }
            --index;
        }
        if (top != null) {
            if (top.size != dstSize) {
                top.size = dstSize;
                switch (top.size) {
                    case 1: {
                        top.v_name = "b_val" + top.postfix;
                        break;
                    }
                    case 2: {
                        top.v_name = "s_val" + top.postfix;
                        break;
                    }
                    case 4: {
                        top.v_name = "f_val" + top.postfix;
                        break;
                    }
                    default: {
                        top.v_name = "i_val" + top.postfix;
                    }
                }
            }
            this.output.append("   " + top.v_name + " = " + value + ";\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(dstSize) + " " + top.v_name + ";\n");
            top.inUse = true;
        } else {
            top = this.stackCache[this.stackCache.length - 1];
            this.pushIt(top.size, top.v_name);
            top.inUse = false;
            index = this.stackCache.length - 1;
            while (index > 0) {
                this.stackCache[index] = this.stackCache[index - 1];
                --index;
            }
            this.stackCache[0] = top;
            this.push(dstSize, value);
        }
    }

    @Override
    public void pop(String dst, int srcSize) {
        StackCell top = this.findTop();
        if (top != null) {
            if (dst != null) {
                this.output.append(String.valueOf(dst) + " = " + top.v_name + ";\n");
            }
            top.inUse = false;
        } else {
            super.pop(dst, srcSize);
        }
    }

    protected StackCell findTop() {
        StackCell top = null;
        int index = 0;
        while (index < this.stackCache.length) {
            if (this.stackCache[index].inUse) {
                top = this.stackCache[index];
                break;
            }
            ++index;
        }
        return top;
    }

    @Override
    public void popRef(String dst) {
        StackCell top = this.findTop();
        if (top != null) {
            this.output.append(String.valueOf(dst) + " = (unsigned char *) (pointer)" + top.v_name + ";\n");
            top.inUse = false;
        } else {
            super.popRef(dst);
        }
    }

    @Override
    public int flush(boolean doit) {
        int count = 0;
        int index = this.stackCache.length - 1;
        while (index >= 0) {
            StackCell top = this.stackCache[index];
            if (top.inUse) {
                super.push(top.size, top.v_name);
                if (doit) {
                    top.inUse = false;
                }
                ++count;
            }
            --index;
        }
        return count;
    }

    @Override
    public void flushTop(boolean doit) {
        int index = 0;
        while (index < this.stackCache.length) {
            StackCell top = this.stackCache[index];
            if (top.inUse) {
                super.push(top.size, top.v_name);
                if (!doit) break;
                top.inUse = false;
                break;
            }
            ++index;
        }
    }

    @Override
    public String peekTop(int index, int srcSize) {
        StackCell top = null;
        int i = 0;
        while (i < this.stackCache.length) {
            if (this.stackCache[i].inUse) {
                if (index > 1) {
                    --index;
                } else {
                    top = this.stackCache[i];
                    break;
                }
            }
            ++i;
        }
        if (top != null) {
            return top.v_name;
        }
        return super.peekTop(index, srcSize);
    }

    @Override
    public StackManager copy() {
        LevelNRegisterAllocator clone = new LevelNRegisterAllocator(this.output, this.localVariables, this.stackCache.length, this.localVariableManager.getMaxLocals(), this.isSynthetic, this.spManipulator);
        int i = 0;
        while (i < this.stackCache.length) {
            StackCell next = clone.stackCache[i];
            next.inUse = this.stackCache[i].inUse;
            next.size = this.stackCache[i].size;
            next.postfix = this.stackCache[i].postfix;
            next.v_name = this.stackCache[i].v_name;
            ++i;
        }
        clone.localVariableManager.copyLocals(this.localVariableManager);
        return clone;
    }

    @Override
    public boolean equals(Object other) {
        if (other.getClass() == LevelNRegisterAllocator.class) {
            LevelNRegisterAllocator otherStack = (LevelNRegisterAllocator)other;
            if (otherStack.stackCache.length == this.stackCache.length) {
                int i = 0;
                while (i < this.stackCache.length) {
                    StackCell thisCell = this.stackCache[i];
                    StackCell otherCell = otherStack.stackCache[i];
                    if (thisCell.inUse != otherCell.inUse) {
                        return false;
                    }
                    if (thisCell.inUse) {
                        if (thisCell.postfix != otherCell.postfix) {
                            return false;
                        }
                        if (thisCell.size != otherCell.size) {
                            return false;
                        }
                        if (!thisCell.v_name.equals(otherCell.v_name)) {
                            return false;
                        }
                    }
                    ++i;
                }
                return this.localVariableManager.equals(otherStack.localVariableManager);
            }
        }
        return false;
    }

    @Override
    public void merge(StackManager other) throws Exception {
        super.merge(other);
        LevelNRegisterAllocator targetStack = (LevelNRegisterAllocator)other;
        if (targetStack.stackCache.length == this.stackCache.length) {
            int i = this.stackCache.length - 1;
            while (i >= 0) {
                StackCell left = this.stackCache[i];
                StackCell right = targetStack.stackCache[i];
                if (left.inUse && !right.inUse) {
                    super.push(left.size, left.v_name);
                    left.inUse = false;
                } else if (!left.inUse && right.inUse) {
                    int rightCacheSize = targetStack.getCacheSize();
                    int leftCacheSize = this.getCacheSize();
                    int cacheSize = rightCacheSize - leftCacheSize;
                    this.output.append("   sp -= " + cacheSize + ";\n");
                    this.spManipulator.setSPUsed(true);
                    while (cacheSize > 0) {
                        right = targetStack.stackCache[i];
                        left = this.stackCache[i];
                        String srctype = "";
                        if (right.size != 3) {
                            srctype = AOTCompiler.getPointerCast(right.size);
                        }
                        this.output.append("   " + right.v_name + " = *" + srctype + "sp;\n");
                        this.output.append("   sp++;\n");
                        --cacheSize;
                        --i;
                        left.inUse = right.inUse;
                        left.postfix = right.postfix;
                        left.v_name = right.v_name;
                        left.size = right.size;
                    }
                    while (i >= 0) {
                        right = targetStack.stackCache[i];
                        left = this.stackCache[i];
                        left.inUse = right.inUse;
                        left.postfix = right.postfix;
                        left.v_name = right.v_name;
                        left.size = right.size;
                        --i;
                    }
                } else if (left.inUse && right.inUse && (left.size != right.size || !left.v_name.equals(right.v_name))) {
                    System.out.println("Unsupported merge [" + this.spManipulator.getCurrentMethod() + "]");
                    System.out.println("failure on index: " + i);
                    System.out.println("src: ");
                    System.out.println(this.toString());
                    System.out.println("dst: ");
                    System.out.println(other.toString());
                    throw new Exception("Unsupported merge");
                }
                --i;
            }
        } else {
            throw new Exception("Unmergeable merge");
        }
    }

    private int getCacheSize() {
        int count = 0;
        int i = this.stackCache.length - 1;
        while (i >= 0) {
            if (!this.stackCache[i].inUse) break;
            ++count;
            --i;
        }
        return count;
    }

    @Override
    public boolean isCached(int offset) {
        ++offset;
        int index = 0;
        while (index < this.stackCache.length) {
            if (this.stackCache[index].inUse) break;
            ++index;
        }
        while (index < this.stackCache.length) {
            if (offset <= 0) break;
            ++index;
            --offset;
        }
        return offset == 0;
    }

    @Override
    public int topSize() {
        StackCell top = this.findTop();
        if (top != null) {
            return top.size;
        }
        return 3;
    }

    private static class StackCell
    extends StackCellInfo {
        public boolean inUse;
        public byte postfix;

        private StackCell() {
        }
    }
}

