/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.MethodEntryPoints;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.StackManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;

public class LabelsManager {
    private MethodEntryPoints javaMethod;
    private HashMap<String, StringBuffer> labels;
    private int methodNumber;
    private NoDuplicatesMemorySegment localVariables;
    private NoDuplicatesMemorySegment requiredIncludes;
    private SPManipulator spManipulator;
    public static final String LExceptionSwitch = "LExceptionSwitch";
    public static final String LThrowIt = "throwIt";
    public static final String LThrowNullPointer = "throwNullPointer";
    public static final String LThrowClassCast = "throwClassCastException";
    public static final String LThrowOutOfMemory = "throwOutOfMemory";
    public static final String LThrowArithmeticException = "throwArithmeticException";

    public LabelsManager(MethodEntryPoints javaMethod, int methodNumber, NoDuplicatesMemorySegment localVariables, NoDuplicatesMemorySegment requiredIncludes, SPManipulator spManipulator) {
        this.javaMethod = javaMethod;
        this.labels = new HashMap();
        this.methodNumber = methodNumber;
        this.localVariables = localVariables;
        this.requiredIncludes = requiredIncludes;
        this.spManipulator = spManipulator;
    }

    public void generateExceptionSwitch() throws Exception {
        if (!this.labels.containsKey(LExceptionSwitch)) {
            ArrayList<String> generatedLabels = new ArrayList<String>();
            StringBuffer switchStatement = new StringBuffer();
            switchStatement.append("   switch(handler_pc) {\n");
            Code codeAttr = this.javaMethod.getMethod().getCode();
            if (codeAttr != null) {
                CodeException[] handlers;
                CodeException[] codeExceptionArray = handlers = codeAttr.getExceptionTable();
                int n = handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    CodeException codeException = codeExceptionArray[n2];
                    String label = "L" + codeException.getHandlerPC();
                    if (!generatedLabels.contains(label)) {
                        switchStatement.append("      case " + codeException.getHandlerPC() + ":\n");
                        switchStatement.append("         goto " + label + ";\n");
                        generatedLabels.add(label);
                    }
                    ++n2;
                }
            }
            switchStatement.append("      case (unsigned short)-1: /* Not handled */\n");
            switchStatement.append("      default:\n");
            switchStatement.append("         fp[0] = *(sp - 1);\n");
            if (this.javaMethod.useCombinedReturnType()) {
                switchStatement.append("         return -excep;\n");
            } else {
                switchStatement.append("         return excep;\n");
            }
            switchStatement.append("   }\n");
            this.spManipulator.setSPUsed(true);
            this.localVariables.print("   " + AOTCompiler.getTypeCast(this.javaMethod.getReturnTypeSize()) + " excep;\n");
            this.labels.put(LExceptionSwitch, switchStatement);
        }
    }

    public StringBuffer getLabels() {
        StringBuffer exceptionSwitch = this.labels.get(LExceptionSwitch);
        StringBuffer result = new StringBuffer();
        if (exceptionSwitch != null) {
            this.labels.remove(LExceptionSwitch);
        }
        StringBuffer throwItLabel = this.labels.remove(LThrowIt);
        Iterator<Map.Entry<String, StringBuffer>> iterator = this.labels.entrySet().iterator();
        ArrayList<Label> orderedLabels = new ArrayList<Label>();
        while (iterator.hasNext()) {
            Map.Entry<String, StringBuffer> next = iterator.next();
            Label nextLabel = new Label();
            nextLabel.label = next.getKey();
            nextLabel.code = next.getValue();
            orderedLabels.add(nextLabel);
        }
        if (throwItLabel != null) {
            Label nextLabel = new Label();
            nextLabel.label = LThrowIt;
            nextLabel.code = throwItLabel;
            orderedLabels.add(nextLabel);
        }
        Iterator orderedIterator = orderedLabels.iterator();
        while (orderedIterator.hasNext()) {
            Label next = (Label)orderedIterator.next();
            result.append("   " + next.label + ":\n");
            result.append(next.code.toString());
            if (!orderedIterator.hasNext()) continue;
            result.append("      goto throwIt;\n");
        }
        if (exceptionSwitch != null) {
            result.append(exceptionSwitch.toString());
        }
        return result;
    }

    public void generateThrowIt() throws Exception {
        if (!this.labels.containsKey(LThrowIt)) {
            StringBuffer throwIt = new StringBuffer();
            throwIt.append("      handler_pc = handleAthrow(&methods[" + this.methodNumber + "], excep, pc);\n");
            throwIt.append("      sp++;\n");
            this.spManipulator.setSPUsed(true);
            this.labels.put(LThrowIt, throwIt);
            this.localVariables.print("   unsigned short handler_pc;\n");
            this.requiredIncludes.print("RANGE extern const MethodInfo *methods;\n");
            this.requiredIncludes.print("#include \"methods.h\"\n");
            this.requiredIncludes.print("extern unsigned short handleAthrow(const MethodInfo* method, unsigned short classIndex, unsigned short pc);\n");
            this.generateExceptionSwitch();
        }
    }

    public void generateThrowClassCast() throws Exception {
        if (!this.labels.containsKey(LThrowClassCast)) {
            StringBuffer throwClassCast = new StringBuffer();
            this.spManipulator.setSPUsed(true);
            throwClassCast.append("      excep = initializeException(sp, JAVA_LANG_CLASSCASTEXCEPTION, JAVA_LANG_CLASSCASTEXCEPTION_INIT_);\n");
            this.labels.put(LThrowClassCast, throwClassCast);
            this.requiredIncludes.print("int16 initializeException(int32* sp, int16 exceptionClass, int16 exceptionInitMethod);\n");
            this.requiredIncludes.print("#include \"classes.h\"\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(this.javaMethod.getReturnTypeSize()) + " excep;\n");
            this.generateThrowIt();
            this.generateExceptionSwitch();
        }
    }

    public void generateThrowNullPointer() throws Exception {
        if (!this.labels.containsKey(LThrowNullPointer)) {
            StringBuffer throwNullPointer = new StringBuffer();
            this.spManipulator.setSPUsed(true);
            throwNullPointer.append("      excep = initializeException(sp, JAVA_LANG_NULLPOINTEREXCEPTION, JAVA_LANG_NULLPOINTEREXCEPTION_INIT_);\n");
            this.labels.put(LThrowNullPointer, throwNullPointer);
            this.requiredIncludes.print("int16 initializeException(int32* sp, int16 exceptionClass, int16 exceptionInitMethod);\n");
            this.requiredIncludes.print("#include \"classes.h\"\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(this.javaMethod.getReturnTypeSize()) + " excep;\n");
            this.generateThrowIt();
            this.generateExceptionSwitch();
        }
    }

    public void generateOutOfMemory() throws Exception {
        if (!this.labels.containsKey(LThrowOutOfMemory)) {
            StringBuffer throwOutOfMemory = new StringBuffer();
            this.spManipulator.setSPUsed(true);
            throwOutOfMemory.append("      excep = initializeException(sp, JAVA_LANG_OUTOFMEMORYERROR, JAVA_LANG_OUTOFMEMORYERROR_INIT_);\n");
            this.labels.put(LThrowOutOfMemory, throwOutOfMemory);
            this.requiredIncludes.print("int16 initializeException(int32* sp, int16 exceptionClass, int16 exceptionInitMethod);\n");
            this.requiredIncludes.print("#include \"classes.h\"\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(this.javaMethod.getReturnTypeSize()) + " excep;\n");
            this.generateThrowIt();
            this.generateExceptionSwitch();
        }
    }

    public void generateArithmeticException() throws Exception {
        if (!this.labels.containsKey(LThrowArithmeticException)) {
            StringBuffer throwArithmetic = new StringBuffer();
            this.spManipulator.setSPUsed(true);
            throwArithmetic.append("      excep = initializeException(sp, JAVA_LANG_ARITHMETICEXCEPTION, JAVA_LANG_ARITHMETICEXCEPTION_INIT_);\n");
            this.labels.put(LThrowArithmeticException, throwArithmetic);
            this.requiredIncludes.print("int16 initializeException(int32* sp, int16 exceptionClass, int16 exceptionInitMethod);\n");
            this.requiredIncludes.print("#include \"classes.h\"\n");
            this.localVariables.print("   " + AOTCompiler.getTypeCast(this.javaMethod.getReturnTypeSize()) + " excep;\n");
            this.generateThrowIt();
            this.generateExceptionSwitch();
        }
    }

    public void jumpTo(StackManager sm) throws Exception {
        this.jumpTo(sm, false);
    }

    public void jumpTo(StackManager sm, boolean saveTop) throws Exception {
        if (saveTop) {
            this.spManipulator.setSPUsed(true);
            sm.flushTop(false);
            sm.getOutput().append("   sp--;\n");
        }
        sm.flushLocals();
    }

    private static class Label {
        public String label;
        public StringBuffer code;

        private Label() {
        }
    }
}

