/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.AOTToolBox;
import icecaptools.compiler.aot.InvokeEmitter;
import icecaptools.compiler.aot.LabelsManager;
import icecaptools.compiler.aot.StackManager;
import java.util.Stack;
import org.apache.bcel.classfile.Method;

public abstract class InvokeSpecialEmitter {
    private StackManager sm;
    private StringBuffer output;
    private NoDuplicatesMemorySegment localVariables;
    private int pc;
    private LabelsManager labelsManager;
    private BNode bnode;
    private byte[] currentMethodCode;
    private NoDuplicatesMemorySegment requiredIncludes;
    private MethodOrFieldDesc methodDesc;
    private AOTToolBox toolBox;
    private MethodEntryPoints entrypoints;

    InvokeSpecialEmitter(StackManager sm, StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, BNode bnode, byte[] currentMethodCode, NoDuplicatesMemorySegment requiredIncludes, MethodOrFieldDesc methodDesc, AOTToolBox toolBox, MethodEntryPoints entrypoints) {
        this.sm = sm;
        this.output = output;
        this.localVariables = localVariables;
        this.pc = pc;
        this.labelsManager = labelsManager;
        this.bnode = bnode;
        this.currentMethodCode = currentMethodCode;
        this.requiredIncludes = requiredIncludes;
        this.methodDesc = methodDesc;
        this.toolBox = toolBox;
        this.entrypoints = entrypoints;
    }

    public InvokeEmitter getEmitter() throws Exception {
        MethodEntryPoints calleeEntry = this.toolBox.getDependencyExtent().getMethod(this.methodDesc.getClassName(), this.methodDesc.getName(), this.methodDesc.getSignature());
        Emitter emitter = calleeEntry != null && calleeEntry.canCallWithArgs() ? new WithArgsEmitter(calleeEntry) : new WithStackEmitter(calleeEntry);
        return emitter;
    }

    protected abstract void a_handleExceptionOccurred(StringBuffer var1, NoDuplicatesMemorySegment var2, int var3, LabelsManager var4, String var5, String var6, StackManager var7, MethodOrFieldDesc var8, String var9, MethodEntryPoints var10, String var11, boolean var12) throws Exception;

    protected abstract void a_setSPUsed(boolean var1);

    protected abstract boolean a_mayThrowExceptions(String var1, String var2, String var3);

    protected abstract int a_normalizeProducersSize(BNode var1, int var2) throws Exception;

    protected abstract void a_adjustStackAndCheckObject(StringBuffer var1, NoDuplicatesMemorySegment var2, int var3, LabelsManager var4, int var5, String var6, String var7, StackManager var8) throws Exception;

    private abstract class Emitter
    implements InvokeEmitter {
        protected Method referredMethod;
        protected int numArgs;
        protected MethodEntryPoints calleeEntry;
        protected StackManager smCopy;
        protected String exceptionVariable;
        protected String uniqueMethodIDCallee;

        Emitter(MethodEntryPoints calleeEntry) {
            this.calleeEntry = calleeEntry;
        }

        @Override
        public abstract void handleReturnValue() throws Exception;

        @Override
        public void setup() throws Exception {
            this.referredMethod = ClassfileUtils.findMethod(InvokeSpecialEmitter.this.methodDesc.getClassName(), InvokeSpecialEmitter.this.methodDesc.getName(), InvokeSpecialEmitter.this.methodDesc.getSignature()).getMethod();
            this.numArgs = ClassfileUtils.getNumArgs(this.referredMethod);
            if (InvokeSpecialEmitter.this.currentMethodCode[InvokeSpecialEmitter.this.pc] != -72) {
                ++this.numArgs;
            }
        }

        @Override
        public void callSetupException() throws Exception {
            this.smCopy = InvokeSpecialEmitter.this.sm.copy();
            this.exceptionVariable = "";
            if (InvokeSpecialEmitter.this.a_mayThrowExceptions(InvokeSpecialEmitter.this.methodDesc.getClassName(), InvokeSpecialEmitter.this.methodDesc.getName(), InvokeSpecialEmitter.this.methodDesc.getSignature())) {
                this.exceptionVariable = "rval_m_" + InvokeSpecialEmitter.this.pc;
                int returnTypeSize = 0;
                returnTypeSize = this.calleeEntry != null ? this.calleeEntry.getReturnTypeSize() : 2;
                InvokeSpecialEmitter.this.localVariables.print("   " + AOTCompiler.getTypeCast(returnTypeSize) + " " + this.exceptionVariable + ";\n");
            }
        }

        @Override
        public void performCall() throws Exception {
            if (AOTCompiler.synchronizedSupported(this.referredMethod)) {
                InvokeSpecialEmitter.this.output.append("   handleMonitorEnterExit((Object*)(pointer)" + this.getHandleMonitorArgs());
                InvokeSpecialEmitter.this.requiredIncludes.print("extern unsigned char handleMonitorEnterExit(Object* lockObj, unsigned char isEnter, int32* sp, const char* fromMethod);\n");
            }
            this.uniqueMethodIDCallee = InvokeSpecialEmitter.this.toolBox.getIdGenerator().getUniqueId(InvokeSpecialEmitter.this.methodDesc.getClassName(), InvokeSpecialEmitter.this.methodDesc.getName(), InvokeSpecialEmitter.this.methodDesc.getSignature());
            if (AOTCompiler.interpretMethod(this.referredMethod, InvokeSpecialEmitter.this.methodDesc, InvokeSpecialEmitter.this.toolBox.getCregistry())) {
                InvokeSpecialEmitter.this.output.append("   " + this.exceptionVariable + " = enterMethodInterpreter(" + this.uniqueMethodIDCallee.toUpperCase() + ", sp);\n");
            } else {
                if (this.referredMethod.isNative() || InvokeSpecialEmitter.this.toolBox.getManager().skipMethodHack(InvokeSpecialEmitter.this.methodDesc.getClassName(), InvokeSpecialEmitter.this.methodDesc.getName(), InvokeSpecialEmitter.this.methodDesc.getSignature())) {
                    this.uniqueMethodIDCallee = "n_" + this.uniqueMethodIDCallee;
                }
                InvokeSpecialEmitter.this.output.append("   " + this.exceptionVariable + " = " + this.uniqueMethodIDCallee + "(sp");
                this.addCallParameters();
                InvokeSpecialEmitter.this.output.append(");\n");
            }
            InvokeSpecialEmitter.this.a_setSPUsed(true);
        }

        @Override
        public MethodOrFieldDesc getMethodDesc() {
            return InvokeSpecialEmitter.this.methodDesc;
        }

        @Override
        public void setMethodDesc(MethodOrFieldDesc m) throws Exception {
            InvokeSpecialEmitter.this.methodDesc = m;
            this.setup();
        }

        @Override
        public abstract String callSetup() throws Exception;

        public abstract String getHandleMonitorArgs();

        public abstract void addCallParameters();
    }

    private class WithArgsEmitter
    extends Emitter {
        private int spAdjustment;
        private StringBuffer currentOutput;
        private Stack<String> argNames;

        WithArgsEmitter(MethodEntryPoints calleeEntry) {
            super(calleeEntry);
        }

        @Override
        public String callSetup() throws Exception {
            this.argNames = new Stack();
            StringBuffer types = new StringBuffer();
            this.spAdjustment = 0;
            int n = this.numArgs;
            int offset = 1;
            while (n > 0) {
                String argName;
                int srcSize = InvokeSpecialEmitter.this.a_normalizeProducersSize(InvokeSpecialEmitter.this.bnode, ((InvokeSpecialEmitter)InvokeSpecialEmitter.this).bnode.getAinfo().entryStack.size() - offset);
                ++offset;
                if (InvokeSpecialEmitter.this.sm.isCached(0)) {
                    argName = InvokeSpecialEmitter.this.sm.peekTop(1, srcSize);
                    InvokeSpecialEmitter.this.sm.pop(null, srcSize);
                } else {
                    argName = "hvm_arg_no_" + n + "_" + InvokeSpecialEmitter.this.pc;
                    InvokeSpecialEmitter.this.sm.pop(argName, srcSize);
                    InvokeSpecialEmitter.this.localVariables.print("   " + AOTCompiler.getTypeCast(srcSize) + " " + argName + ";\n");
                }
                this.argNames.push(argName);
                types.append(AOTCompiler.getTypeCast(srcSize));
                if (--n <= 0) continue;
                types.append(", ");
            }
            if (InvokeSpecialEmitter.this.currentMethodCode[InvokeSpecialEmitter.this.pc] != -72 && AOTCompiler.nullPointerCheckRequired(this.numArgs, InvokeSpecialEmitter.this.bnode)) {
                AOTCompiler.checkObject(InvokeSpecialEmitter.this.output, InvokeSpecialEmitter.this.localVariables, InvokeSpecialEmitter.this.pc, InvokeSpecialEmitter.this.labelsManager, null, "", InvokeSpecialEmitter.this.sm, this.argNames.peek());
            }
            this.currentOutput = InvokeSpecialEmitter.this.sm.getOutput();
            StringBuffer discardThis = new StringBuffer();
            InvokeSpecialEmitter.this.sm.setOutput(discardThis);
            this.spAdjustment = InvokeSpecialEmitter.this.sm.flush(false);
            InvokeSpecialEmitter.this.sm.setOutput(this.currentOutput);
            if (this.spAdjustment > 0) {
                InvokeSpecialEmitter.this.output.append("   sp += " + this.spAdjustment + ";\n");
            }
            if (this.argNames.size() > 0) {
                return this.argNames.peek();
            }
            return null;
        }

        @Override
        public String getHandleMonitorArgs() {
            return String.valueOf(this.argNames.peek()) + ", 1, sp, \"\");\n";
        }

        @Override
        public void addCallParameters() {
            String arg;
            Stack<String> argNamesReversed = new Stack<String>();
            while (this.argNames.size() > 0) {
                arg = this.argNames.pop();
                argNamesReversed.push(arg);
                InvokeSpecialEmitter.this.output.append(", ");
                InvokeSpecialEmitter.this.output.append(arg);
            }
            while (argNamesReversed.size() > 0) {
                arg = (String)argNamesReversed.pop();
                this.argNames.push(arg);
            }
        }

        @Override
        public void handleReturnValue() throws Exception {
            String returnValueString;
            int numReturnValues = Compiler.getNumReturnValues(this.referredMethod) & 3;
            if (numReturnValues > 0) {
                StringBuffer loadResult = new StringBuffer();
                int size = AOTCompiler.getReturntypeSize(this.referredMethod);
                String rval = "rval_" + InvokeSpecialEmitter.this.pc;
                String rvalType = AOTCompiler.getTypeCast(size);
                this.currentOutput = InvokeSpecialEmitter.this.sm.getOutput();
                InvokeSpecialEmitter.this.sm.setOutput(loadResult);
                switch (size) {
                    case 5: {
                        loadResult.append("   " + rval + " = *" + AOTCompiler.getPointerCast(size) + "sp;\n");
                        InvokeSpecialEmitter.this.sm.push(size, rval);
                        loadResult.append("   " + rval + " = *" + AOTCompiler.getPointerCast(size) + "(sp + 1);\n");
                        InvokeSpecialEmitter.this.sm.push(size, rval);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (this.calleeEntry.useCombinedReturnType()) {
                            InvokeSpecialEmitter.this.sm.push(size, this.exceptionVariable);
                            rval = null;
                            break;
                        }
                        loadResult.append("   " + rval + " = *" + AOTCompiler.getPointerCast(size) + "sp;\n");
                        InvokeSpecialEmitter.this.sm.push(size, rval);
                    }
                }
                InvokeSpecialEmitter.this.sm.setOutput(this.currentOutput);
                if (rval != null) {
                    InvokeSpecialEmitter.this.localVariables.print("   " + rvalType + " " + rval + ";\n");
                }
                returnValueString = loadResult.toString();
            } else {
                returnValueString = null;
            }
            String noExceptionCondition = String.valueOf(this.exceptionVariable) + " == -1";
            boolean negateExceptionValue = false;
            if (this.calleeEntry != null && this.calleeEntry.useCombinedReturnType()) {
                noExceptionCondition = String.valueOf(this.exceptionVariable) + " >= 0";
                negateExceptionValue = true;
            }
            InvokeSpecialEmitter.this.a_handleExceptionOccurred(InvokeSpecialEmitter.this.output, InvokeSpecialEmitter.this.localVariables, InvokeSpecialEmitter.this.pc, InvokeSpecialEmitter.this.labelsManager, returnValueString, "", this.smCopy, InvokeSpecialEmitter.this.methodDesc, this.exceptionVariable, InvokeSpecialEmitter.this.entrypoints, noExceptionCondition, negateExceptionValue);
            if (this.spAdjustment > 0) {
                InvokeSpecialEmitter.this.output.append("   sp -= " + this.spAdjustment + ";\n");
            }
        }

        @Override
        public boolean isWithArgsEmitter() {
            return true;
        }
    }

    private class WithStackEmitter
    extends Emitter {
        WithStackEmitter(MethodEntryPoints calleeEntry) {
            super(calleeEntry);
        }

        @Override
        public String callSetup() throws Exception {
            InvokeSpecialEmitter.this.sm.flush(true);
            InvokeSpecialEmitter.this.a_adjustStackAndCheckObject(InvokeSpecialEmitter.this.output, InvokeSpecialEmitter.this.localVariables, InvokeSpecialEmitter.this.pc, InvokeSpecialEmitter.this.labelsManager, this.numArgs, null, "", InvokeSpecialEmitter.this.sm);
            return null;
        }

        @Override
        public String getHandleMonitorArgs() {
            return "*sp, 1, sp + " + this.numArgs + ", \"\");\n";
        }

        @Override
        public void addCallParameters() {
            InvokeSpecialEmitter.this.requiredIncludes.print("int16 " + this.uniqueMethodIDCallee + "(int32* sp);\n");
        }

        @Override
        public void handleReturnValue() throws Exception {
            int numReturnValues = Compiler.getNumReturnValues(this.referredMethod) & 3;
            String returnValueString = numReturnValues > 0 ? "      sp += " + numReturnValues + ";\n" : null;
            String noExceptionCondition = String.valueOf(this.exceptionVariable) + " == -1";
            boolean negateExceptionValue = false;
            if (this.calleeEntry != null && this.calleeEntry.useCombinedReturnType()) {
                noExceptionCondition = String.valueOf(this.exceptionVariable) + " >= 0";
                negateExceptionValue = true;
            }
            InvokeSpecialEmitter.this.a_handleExceptionOccurred(InvokeSpecialEmitter.this.output, InvokeSpecialEmitter.this.localVariables, InvokeSpecialEmitter.this.pc, InvokeSpecialEmitter.this.labelsManager, returnValueString, "", this.smCopy, InvokeSpecialEmitter.this.methodDesc, this.exceptionVariable, InvokeSpecialEmitter.this.entrypoints, noExceptionCondition, negateExceptionValue);
        }

        @Override
        public boolean isWithArgsEmitter() {
            return false;
        }

        @Override
        public MethodOrFieldDesc getMethodDesc() {
            return InvokeSpecialEmitter.this.methodDesc;
        }
    }
}

