/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.BNode;
import icecaptools.GotoBNode;
import icecaptools.IcecapIterator;
import icecaptools.MethodEntryPoints;
import icecaptools.ReturnBNode;
import icecaptools.SwitchBNode;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.AOTToolBox;
import icecaptools.compiler.aot.LabelsManager;
import icecaptools.compiler.aot.StackManager;
import icecaptools.conversion.TargetAddressMap;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.bcel.classfile.Method;

public abstract class FlowBasedCompiler
extends AOTCompiler {
    private LinkedList<TranslationWorkItem> workItems;

    @Override
    protected boolean mayThrowExceptions(String className, String targetMethodName, String targetMethodSignature) {
        MethodEntryPoints entryPoints = this.toolBox.getDependencyExtent().getMethod(className, targetMethodName, targetMethodSignature);
        if (entryPoints != null) {
            return entryPoints.getMayThrowException();
        }
        return true;
    }

    public FlowBasedCompiler(Method javaMethod, byte[] methodCode, String uniqueMethodId, int methodNumber, NoDuplicatesMemorySegment requiredIncludes, AOTToolBox toolBox) {
        super(javaMethod, methodCode, uniqueMethodId, methodNumber, requiredIncludes, toolBox);
    }

    @Override
    protected void handleBranch(StackManager sm, byte opcode, int src, int dst, boolean doit) throws Exception {
        BNode decendant = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), dst);
        if (decendant.getStackManager() == null) {
            TranslationWorkItem targetItem = new TranslationWorkItem();
            targetItem.bnode = decendant;
            decendant.setStackManager(sm.copy());
            this.workItems.addLast(targetItem);
        } else {
            StackManager targetStack = decendant.getStackManager();
            if (!targetStack.equals(sm)) {
                StackManager temp = sm.copy();
                temp.merge(targetStack);
            }
        }
    }

    @Override
    public void compileByteCode(StackManager sm, LabelsManager labelsManager, TargetAddressMap tMap, StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, boolean compileOne, MethodEntryPoints entryPoints) throws Exception {
        this.workItems = new LinkedList();
        IcecapIterator<BNode> handlers = entryPoints.getHandlerEntryPoints();
        while (handlers.hasNext()) {
            BNode nextHandler;
            TranslationWorkItem handlerWorkItem = new TranslationWorkItem();
            handlerWorkItem.bnode = nextHandler = handlers.next();
            nextHandler.setStackManager(sm.copy());
            this.workItems.addLast(handlerWorkItem);
        }
        BNode bnode = entryPoints.getMainEntryPoint();
        TranslationWorkItem initialWorkItem = new TranslationWorkItem();
        initialWorkItem.bnode = bnode;
        bnode.setStackManager(sm.copy());
        this.workItems.addLast(initialWorkItem);
        while (this.workItems.size() != 0) {
            TranslationWorkItem next = this.workItems.removeFirst();
            if (next.bnode.getTranslation() != null) continue;
            this.handleWorkItem(next, labelsManager, tMap, localVariables, entryPoints);
        }
        ArrayList<BNode> bnodes = entryPoints.getBNodes();
        for (BNode next : bnodes) {
            StringBuffer nextTranslation = next.getTranslation();
            output.append(nextTranslation);
        }
    }

    private void handleWorkItem(TranslationWorkItem current, LabelsManager labelsManager, TargetAddressMap tMap, NoDuplicatesMemorySegment localVariables, MethodEntryPoints entryPoints) throws Exception {
        int address = current.bnode.getAddress();
        int codeLength = current.bnode.getRawBytes().length;
        byte[] code = new byte[codeLength];
        System.arraycopy(this.currentMethodCode, address, code, 0, codeLength);
        StringBuffer translation = new StringBuffer();
        current.bnode.getStackManager().setOutput(translation);
        StackManager exitStack = current.bnode.getStackManager().copy();
        super.compileByteCode(exitStack, labelsManager, tMap, translation, localVariables, address, true, entryPoints);
        current.bnode.setTranslation(translation);
        if (current.bnode instanceof ReturnBNode || current.bnode instanceof GotoBNode || current.bnode instanceof SwitchBNode) {
            return;
        }
        BNode decendant = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), address += codeLength);
        if (decendant.getStackManager() == null) {
            TranslationWorkItem childItem = new TranslationWorkItem();
            childItem.bnode = decendant;
            decendant.setStackManager(exitStack);
            this.workItems.addLast(childItem);
        } else {
            StackManager targetStack = decendant.getStackManager();
            if (!targetStack.equals(exitStack)) {
                StackManager temp = exitStack.copy();
                temp.merge(targetStack);
            }
        }
    }

    @Override
    protected void handleLabel(StackManager sm) {
    }

    private static class TranslationWorkItem {
        public BNode bnode;

        private TranslationWorkItem() {
        }
    }
}

