/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.BNode;
import icecaptools.CFuncInfo;
import icecaptools.ClassfileUtils;
import icecaptools.IcecapCFunc;
import icecaptools.InterfaceMethodCallBNode;
import icecaptools.MethodCallBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.RawByteCodes;
import icecaptools.SwitchBNode;
import icecaptools.VirtualMethodCallBNode;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.compiler.LDCConstant;
import icecaptools.compiler.NativeFileManager;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTToolBox;
import icecaptools.compiler.aot.FieldAccessEmitter;
import icecaptools.compiler.aot.InvokeEmitter;
import icecaptools.compiler.aot.InvokeSpecialEmitter;
import icecaptools.compiler.aot.LabelsManager;
import icecaptools.compiler.aot.LevelNRegisterAllocator;
import icecaptools.compiler.aot.LocalVariableManager;
import icecaptools.compiler.aot.SPManipulator;
import icecaptools.compiler.aot.StackManager;
import icecaptools.compiler.aot.StaticFieldEmitter;
import icecaptools.compiler.utils.ClassInheritanceMatrix;
import icecaptools.conversion.TargetAddressMap;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.ProducerConsumerCellInfo;
import icecaptools.stackanalyser.ProducerConsumerStack;
import icecaptools.stackanalyser.RefType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Type;

public abstract class AOTCompiler
implements SPManipulator {
    protected Method javaMethod;
    protected byte[] currentMethodCode;
    protected String uniqueMethodId;
    protected NoDuplicatesMemorySegment requiredIncludes;
    protected AOTToolBox toolBox;
    protected int methodNumber;
    private boolean spUsed;
    private CFuncInfo cfunc;
    private BNode bnode;

    public AOTCompiler(Method javaMethod, byte[] methodCode, String uniqueMethodId, int methodNumber, NoDuplicatesMemorySegment requiredIncludes, AOTToolBox toolBox) {
        this.javaMethod = javaMethod;
        this.currentMethodCode = methodCode;
        this.uniqueMethodId = uniqueMethodId;
        this.requiredIncludes = requiredIncludes;
        this.toolBox = toolBox;
        this.methodNumber = methodNumber;
        this.spUsed = false;
        this.cfunc = toolBox.getObserver().isCFunc(toolBox.getCurrentClassName(), javaMethod.getName(), javaMethod.getSignature());
    }

    public String compile() throws Exception {
        String currentClassName = this.toolBox.getCurrentClassName();
        String methodName = this.javaMethod.getName();
        String methodSignature = this.javaMethod.getSignature();
        MethodEntryPoints entrypoints = this.toolBox.getDependencyExtent().getMethod(currentClassName, methodName, methodSignature);
        StringBuffer prelude = new StringBuffer();
        prelude.append("/* " + this.javaMethod.getName() + "\n");
        prelude.append(" * param : " + NativeFileManager.getParameters(this.javaMethod) + "\n");
        prelude.append(" * return: " + this.javaMethod.getReturnType().toString() + "\n");
        prelude.append(" */\n");
        StringBuffer body = new StringBuffer();
        NoDuplicatesMemorySegment localVariables = new NoDuplicatesMemorySegment(this.toolBox.getTool().getProperties());
        LevelNRegisterAllocator sm = new LevelNRegisterAllocator(body, localVariables, this.javaMethod.getCode().getMaxStack(), this.javaMethod.getCode().getMaxLocals(), this.javaMethod.isSynthetic(), this);
        sm.getLocalVariableManager().init(body, localVariables, this.javaMethod.getCode().getMaxLocals(), this.javaMethod);
        int noLocals = this.generateSignature(prelude, entrypoints, sm.getLocalVariableManager(), this.requiredIncludes);
        prelude.append("{  \n");
        StringBuffer fullFunction = new StringBuffer();
        if (entrypoints == null) {
            fullFunction.append(prelude);
            fullFunction.append(this.generateReturnStatement("   return -1;\n"));
        } else {
            String spInitialization;
            TargetAddressMap tMap = entrypoints.getJumpTargets();
            StringBuffer exceptionSwitch = new StringBuffer();
            LabelsManager labelsManager = new LabelsManager(entrypoints, this.methodNumber, localVariables, this.requiredIncludes, this);
            this.compileByteCode(sm, labelsManager, tMap, body, localVariables, 0, false, entrypoints);
            boolean spUsed = this.spUsed;
            if (spUsed) {
                int stackOffset = Compiler.getMaxLocals(this.javaMethod.getCode());
                prelude.append("   int32* sp;\n");
                spInitialization = "   sp = &fp[" + (stackOffset + 2) + "]; /* make room for local VM state on the stack */\n";
            } else {
                spInitialization = "";
            }
            fullFunction.append(prelude);
            exceptionSwitch.append(labelsManager.getLabels());
            boolean skipLocalInitialization = false;
            if (entrypoints != null && entrypoints.canCallWithArgs()) {
                skipLocalInitialization = true;
            }
            String lvInitialization = "";
            if (!skipLocalInitialization) {
                lvInitialization = sm.getLocalVariableManager().generateLocalInitialization(localVariables, noLocals);
            } else {
                sm.getLocalVariableManager().generateLocalInitialization(localVariables, noLocals);
            }
            fullFunction.append(localVariables);
            fullFunction.append(lvInitialization);
            fullFunction.append(spInitialization);
            fullFunction.append(body);
            if (exceptionSwitch != null) {
                fullFunction.append(exceptionSwitch);
            }
        }
        fullFunction.append("}\n");
        return fullFunction.toString();
    }

    private Object generateReturnStatement(String stmt) {
        if (this.cfunc == null) {
            return stmt;
        }
        IcecapCFunc cFuncAttribute = this.cfunc.getCfunc();
        String hasReturnValue = cFuncAttribute.hasReturnValue();
        if (hasReturnValue == null || hasReturnValue.equals("false")) {
            return ";\n";
        }
        return stmt;
    }

    private int generateSignature(StringBuffer prelude, MethodEntryPoints entrypoints, LocalVariableManager localVariableManager, NoDuplicatesMemorySegment requiredIncludes) throws Exception {
        int noLocals = 0;
        StringBuffer decl = new StringBuffer();
        int returnTypeSize = 2;
        if (entrypoints != null && entrypoints.useCombinedReturnType()) {
            returnTypeSize = AOTCompiler.getReturntypeSize(entrypoints.getMethod()) + 1;
        }
        if (this.cfunc != null) {
            IcecapCFunc cFuncAttribute = this.cfunc.getCfunc();
            String signature = cFuncAttribute.signature();
            if (signature.endsWith(")")) {
                signature = signature.substring(0, signature.length() - 1);
            }
            prelude.append(signature);
            String decls = cFuncAttribute.requiredIncludes();
            if (decls != null && decls.trim().length() > 0) {
                if (!decls.endsWith("\n")) {
                    decls = String.valueOf(decls) + "\n";
                }
                requiredIncludes.print(decls);
            }
        } else {
            prelude.append(String.valueOf(AOTCompiler.getTypeCast(returnTypeSize)) + " " + this.uniqueMethodId + "(int32 *fp");
            decl.append(String.valueOf(AOTCompiler.getTypeCast(returnTypeSize)) + " " + this.uniqueMethodId + "(int32 *fp");
        }
        if (entrypoints != null && entrypoints.canCallWithArgs()) {
            NoDuplicatesMemorySegment parameters = new NoDuplicatesMemorySegment(this.toolBox.getTool().getProperties());
            if (!this.javaMethod.isStatic()) {
                ++noLocals;
            }
            if ((noLocals += ClassfileUtils.getNumArgs(this.javaMethod)) > 0) {
                prelude.append(", ");
                decl.append(", ");
                localVariableManager.generateLocalInitialization(parameters, 0, noLocals, ", ", true);
                String p = parameters.toString();
                prelude.append(p.substring(0, p.length() - 2));
                decl.append(p.substring(0, p.length() - 2));
            }
            localVariableManager.clear();
        }
        prelude.append(")\n");
        if (this.cfunc == null) {
            decl.append(");\n");
        }
        requiredIncludes.print(decl.toString());
        return noLocals;
    }

    public void compileByteCode(StackManager sm, LabelsManager labelsManager, TargetAddressMap tMap, StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, boolean compileOne, MethodEntryPoints entrypoints) throws Exception {
        while (pc < this.currentMethodCode.length) {
            this.bnode = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), pc);
            this.toolBox.getTool().getSourceCodeLinker().getSourceCode(this.toolBox.getCurrentClassName(), this.javaMethod, this.bnode.getOriginalAddress(), output);
            if (tMap.isJumpTarget(this.bnode) || AOTCompiler.isExceptionHandler(this.javaMethod, pc)) {
                this.handleLabel(sm);
                output.append("   L" + pc + ":\n");
            }
            switch (this.currentMethodCode[pc]) {
                case 1: {
                    sm.push("0");
                    ++pc;
                    break;
                }
                case -84: 
                case -82: 
                case -80: 
                case -79: {
                    int size = this.currentMethodCode[pc] != -79 ? this.normalizeProducersSize(this.bnode, this.bnode.getAinfo().entryStack.size() - 1) : 0;
                    if (AOTCompiler.synchronizedSupported(this.javaMethod)) {
                        if (entrypoints.canCallWithArgs()) {
                            NoDuplicatesMemorySegment thisName = new NoDuplicatesMemorySegment(this.toolBox.getTool().getProperties());
                            sm.getLocalVariableManager().generateLocalInitialization(thisName, 0, 1, "", true);
                            StringTokenizer tokenizer = new StringTokenizer(thisName.toString());
                            String lastToken = null;
                            while (tokenizer.hasMoreTokens()) {
                                lastToken = tokenizer.nextToken();
                            }
                            output.append("   handleMonitorEnterExit((Object*)(pointer)" + lastToken + ", 0, fp + 1, \"\");\n");
                        } else {
                            output.append("   handleMonitorEnterExit((Object*)(pointer)fp[0], 0, fp + 1, \"\");\n");
                        }
                        this.requiredIncludes.print("extern unsigned char handleMonitorEnterExit(Object* lockObj, unsigned char isEnter, int32* sp, const char* fromMethod);\n");
                    }
                    boolean returnHandled = false;
                    if (this.currentMethodCode[pc] != -79) {
                        if (this.currentMethodCode[pc] == -82) {
                            sm.pop("   *(float*)fp", size);
                        } else if (entrypoints.useCombinedReturnType()) {
                            int rsize = AOTCompiler.getReturntypeSize(this.javaMethod);
                            if (sm.isCached(0)) {
                                String top = sm.peekTop(1, rsize);
                                output.append("   return (u" + AOTCompiler.getTypeCast(rsize) + ")" + top + ";\n");
                            } else {
                                String rval = "rval_m_" + pc;
                                localVariables.print("   " + AOTCompiler.getTypeCast(entrypoints.getReturnTypeSize()) + " " + rval + ";\n");
                                sm.pop("   " + rval, AOTCompiler.getReturntypeSize(this.javaMethod));
                                output.append("   return (u" + AOTCompiler.getTypeCast(AOTCompiler.getReturntypeSize(this.javaMethod)) + ")" + rval + ";\n");
                            }
                            returnHandled = true;
                        } else {
                            String dsttype = AOTCompiler.getPointerCast(AOTCompiler.getReturntypeSize(this.javaMethod));
                            sm.pop("   *(" + dsttype + "fp)", size);
                        }
                    }
                    if (!returnHandled) {
                        output.append(this.generateReturnStatement("   return -1;\n"));
                    }
                    int n = ++pc;
                    ++pc;
                    byte extension = this.currentMethodCode[n];
                    pc += extension;
                    break;
                }
                case -83: 
                case -81: {
                    output.append("   spm1 = " + sm.peekTop(1, 3) + ";\n");
                    output.append("   spm2 = " + sm.peekTop(2, 3) + ";\n");
                    if (AOTCompiler.synchronizedSupported(this.javaMethod)) {
                        output.append("   handleMonitorEnterExit((Object*)(pointer)fp[0], 0, fp + 2, \"\");\n");
                        this.requiredIncludes.print("extern unsigned char handleMonitorEnterExit(Object* lockObj, unsigned char isEnter, int32* sp, const char* fromMethod);\n");
                    }
                    output.append("   fp[0] = spm2;\n");
                    output.append("   fp[1] = spm1;\n");
                    output.append(this.generateReturnStatement("   return -1;\n"));
                    localVariables.print("   int32 spm1;\n");
                    localVariables.print("   int32 spm2;\n");
                    int n = ++pc;
                    ++pc;
                    byte extension = this.currentMethodCode[n];
                    pc += extension;
                    break;
                }
                case 16: {
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    sm.push(valueSize, "(signed char)" + this.currentMethodCode[++pc]);
                    ++pc;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    sm.push(valueSize, "" + (this.currentMethodCode[pc] - 3));
                    ++pc;
                    break;
                }
                case -89: {
                    short branchbyte1 = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    short branchbyte2 = (short)(this.currentMethodCode[pc + 2] & 0xFF);
                    short offset = (short)(branchbyte1 << 8 | branchbyte2);
                    this.yield(output, offset);
                    this.handleBranch(sm, this.currentMethodCode[pc], pc, pc + offset, true);
                    output.append("   goto L" + (pc + offset) + ";\n");
                    pc += 3;
                    break;
                }
                case -124: {
                    byte localVarNo = this.currentMethodCode[++pc];
                    byte constVal = this.currentMethodCode[++pc];
                    int size = this.getLocalVariableSize(localVarNo, this.bnode.getOriginalAddress());
                    String cast = AOTCompiler.getTypeCast(size);
                    output.append("   " + sm.getLocal(localVarNo, this.bnode.getOriginalAddress()) + " = (" + cast + ")" + sm.getLocal(localVarNo, this.bnode.getOriginalAddress()) + " + " + constVal + ";\n");
                    ++pc;
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -58: 
                case -57: {
                    pc += this.handleOneArgBranch(sm, this.currentMethodCode, pc, output, this.bnode, localVariables);
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: {
                    pc += this.handleTwoArgBranch(sm, this.currentMethodCode, pc, output, this.bnode, localVariables);
                    break;
                }
                case -69: {
                    int classIndex = this.currentMethodCode[pc + 1] << 8 & 0xFFFF;
                    classIndex |= this.currentMethodCode[pc + 2] & 0xFF;
                    sm.flush(true);
                    output.append("   if (handleNewClassIndex(sp, " + (classIndex >>= 1) + ") == 0) {\n");
                    this.setSPUsed(true);
                    if (AOTCompiler.hasExceptionHandlers(this.javaMethod)) {
                        output.append("      pc = " + pc + ";\n");
                        labelsManager.jumpTo(sm);
                        output.append("      goto throwOutOfMemory;\n");
                        labelsManager.generateOutOfMemory();
                    } else {
                        output.append("      fp[0] = " + sm.peekTop(0, 3) + ";\n");
                        output.append("      return getClassIndex((Object*) (pointer) *sp);\n");
                    }
                    output.append("   }\n");
                    output.append("   sp++;\n");
                    pc += 3;
                    this.requiredIncludes.print("extern unsigned char handleNewClassIndex(int32* sp, unsigned short classIndex);\n");
                    this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                    break;
                }
                case 89: {
                    int dstSize = this.getConsumerSize(pc, 0);
                    if (dstSize == 0) {
                        dstSize = this.getProducersSize(pc, 0);
                    }
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int srcSize = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    sm.push(dstSize, sm.peekTop(1, srcSize));
                    ++pc;
                    break;
                }
                case -73: 
                case -72: {
                    int methodNumber = this.currentMethodCode[pc + 1] << 8;
                    MethodOrFieldDesc methodDesc = this.toolBox.getPatcher().getMethodDescriptor(methodNumber |= this.currentMethodCode[pc + 2] & 0xFF);
                    AOTInvokeSpecialEmitter emitter = new AOTInvokeSpecialEmitter(sm, output, localVariables, pc, labelsManager, this.bnode, this.currentMethodCode, this.requiredIncludes, methodDesc, this.toolBox, entrypoints);
                    InvokeEmitter worker = emitter.getEmitter();
                    worker.setup();
                    worker.callSetup();
                    worker.callSetupException();
                    worker.performCall();
                    worker.handleReturnValue();
                    this.requiredIncludes.print("RANGE extern const MethodInfo *methods;\n");
                    this.requiredIncludes.print("#include \"methods.h\"\n");
                    this.requiredIncludes.print("extern int16 enterMethodInterpreter(unsigned short methodNumber, int32* sp);\n");
                    pc += this.bnode.getRawBytes().length;
                    break;
                }
                case -74: 
                case -71: {
                    int offset = this.currentMethodCode[pc] == -71 ? 5 : 4;
                    int i = 0;
                    InvokeEmitter[] emitters = new InvokeEmitter[this.currentMethodCode[pc + offset]];
                    int count = 0;
                    while (count < this.currentMethodCode[pc + offset]) {
                        InvokeEmitter worker;
                        ++i;
                        int n = ++i;
                        int methodNumber = (this.currentMethodCode[pc + offset + 1 + n] & 0xFF) << 8;
                        int n2 = ++i;
                        ++i;
                        MethodOrFieldDesc methodDesc = this.toolBox.getPatcher().getMethodDescriptor(methodNumber |= this.currentMethodCode[pc + offset + 1 + n2] & 0xFF);
                        AOTInvokeSpecialEmitter emitter = new AOTInvokeSpecialEmitter(sm, output, localVariables, pc, labelsManager, this.bnode, this.currentMethodCode, this.requiredIncludes, methodDesc, this.toolBox, entrypoints);
                        emitters[count] = worker = emitter.getEmitter();
                        ++count;
                    }
                    boolean useDirectCall = emitters.length > 0;
                    int count2 = 0;
                    while (count2 < emitters.length) {
                        if (!emitters[count2].isWithArgsEmitter()) {
                            useDirectCall = false;
                            break;
                        }
                        ++count2;
                    }
                    localVariables.print("   unsigned short classIndex;\n");
                    localVariables.print("   unsigned short methodIndex;\n");
                    this.requiredIncludes.print("RANGE extern const ClassInfo *classes;\n");
                    this.requiredIncludes.print("#include \"classes.h\"\n");
                    if (useDirectCall) {
                        InvokeEmitter firstEmitter = emitters[0];
                        firstEmitter.setup();
                        String thisName = firstEmitter.callSetup();
                        firstEmitter.callSetupException();
                        output.append("      classIndex = getClassIndex((Object *)(pointer)" + thisName + ");\n");
                        output.append("      methodIndex = (unsigned short)-1;\n");
                        output.append("      while (methodIndex == (unsigned short)-1) {\n");
                        output.append("        switch (classIndex) {\n");
                        this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                        i = 0;
                        int count3 = 0;
                        while (count3 < this.currentMethodCode[pc + offset]) {
                            int classNumber = (this.currentMethodCode[pc + offset + 1 + i++] & 0xFF) << 8;
                            int n = i++;
                            int methodNumber = (this.currentMethodCode[pc + offset + 1 + i++] & 0xFF) << 8;
                            methodNumber |= this.currentMethodCode[pc + offset + 1 + i++] & 0xFF;
                            output.append("          case " + (classNumber |= this.currentMethodCode[pc + offset + 1 + n] & 0xFF) + ":\n");
                            InvokeEmitter emitter = emitters[count3];
                            firstEmitter.setMethodDesc(emitter.getMethodDesc());
                            firstEmitter.performCall();
                            output.append("            methodIndex = " + methodNumber + ";\n");
                            output.append("            continue;\n");
                            ++count3;
                        }
                        output.append("        }\n");
                        output.append("        classIndex = pgm_read_word(&classes[classIndex].superClass);\n");
                        output.append("      }\n");
                        firstEmitter.handleReturnValue();
                    } else {
                        short numArgs = (short)(this.currentMethodCode[pc + 3] & 0xFF);
                        localVariables.print("   unsigned char methodVtableIndex;\n");
                        String exceptionVariable = "rval_m_" + pc;
                        localVariables.print("   " + AOTCompiler.getTypeCast(entrypoints.getReturnTypeSize()) + " " + exceptionVariable + ";\n");
                        sm.flush(true);
                        this.adjustStackAndCheckObject(output, localVariables, pc, labelsManager, numArgs + 1, "      classIndex = getClassIndex(i_obj);\n", "   ", sm);
                        this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                        output.append("      methodIndex = (unsigned short)-1;\n");
                        output.append("      while (methodIndex == (unsigned short)-1) {\n");
                        output.append("        switch (classIndex) {\n");
                        i = 0;
                        int count4 = 0;
                        while (count4 < this.currentMethodCode[pc + offset]) {
                            int classNumber = (this.currentMethodCode[pc + offset + 1 + i++] & 0xFF) << 8;
                            int n = i++;
                            int methodNumber = (this.currentMethodCode[pc + offset + 1 + i++] & 0xFF) << 8;
                            int n3 = i++;
                            output.append("          case " + (classNumber |= this.currentMethodCode[pc + offset + 1 + n] & 0xFF) + ":\n");
                            output.append("            methodIndex = " + (methodNumber |= this.currentMethodCode[pc + offset + 1 + n3] & 0xFF) + ";\n");
                            output.append("            continue;\n");
                            ++count4;
                        }
                        output.append("        }\n");
                        output.append("        classIndex = pgm_read_word(&classes[classIndex].superClass);\n");
                        output.append("      }\n");
                        output.append("      " + exceptionVariable + " = dispatchInterface(methodIndex, &methodVtableIndex, sp);\n");
                        this.setSPUsed(true);
                        String returnValueString = "      sp += methodVtableIndex;\n";
                        this.handleExceptionOccurred(output, localVariables, pc, labelsManager, returnValueString, "   ", sm, null, exceptionVariable, entrypoints, String.valueOf(exceptionVariable) + " == -1", false);
                        this.requiredIncludes.print("extern signed short dispatchInterface(unsigned short methodIndex, unsigned char *vTableIndex, int32* sp);\n");
                    }
                    pc += this.bnode.getRawBytes().length;
                    break;
                }
                case -65: {
                    localVariables.print("   Object* ex_ception;\n");
                    output.append("   ex_ception = (Object*) (pointer) " + sm.peekTop(1, 3) + ";\n");
                    output.append("   excep = getClassIndex(ex_ception);\n");
                    output.append("   pc = " + pc + ";\n");
                    labelsManager.jumpTo(sm, true);
                    output.append("   goto throwIt;\n");
                    labelsManager.generateThrowIt();
                    localVariables.print("   " + AOTCompiler.getTypeCast(entrypoints.getReturnTypeSize()) + " excep;\n");
                    localVariables.print("   unsigned short pc;\n");
                    this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                    ++pc;
                    break;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    sm.load(3, this.currentMethodCode[pc] - 42, pc);
                    sm.push(3, sm.getLocal(this.currentMethodCode[pc] - 42, this.getOriginalAddress(pc)));
                    ++pc;
                    break;
                }
                case 25: {
                    short index = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    sm.load(3, index, pc);
                    sm.push(3, sm.getLocal(index, this.getOriginalAddress(pc)));
                    pc += 2;
                    break;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    String dst = this.bnode.isRedundant() ? null : "   " + sm.getLocal(this.currentMethodCode[pc] - 75, this.getOriginalAddress(pc));
                    sm.setLocal(3, this.currentMethodCode[pc] - 75, pc);
                    sm.pop(dst, 3);
                    ++pc;
                    break;
                }
                case 58: {
                    short byteVal = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    String dst = this.bnode.isRedundant() ? null : "      " + sm.getLocal(byteVal, this.getOriginalAddress(pc));
                    sm.setLocal(3, byteVal, pc);
                    sm.pop(dst, 3);
                    pc += 2;
                    break;
                }
                case 21: 
                case 23: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    int index;
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    switch (this.currentMethodCode[pc]) {
                        case 21: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            if (this.currentMethodCode[pc] == 21) {
                                index = this.currentMethodCode[pc + 1];
                                break;
                            }
                            index = this.currentMethodCode[pc] - 26;
                            break;
                        }
                        default: {
                            valueSize = 4;
                            index = this.currentMethodCode[pc] == 23 ? this.currentMethodCode[pc + 1] : this.currentMethodCode[pc] - 34;
                        }
                    }
                    int srcSize = this.getLocalVariableSize(index, this.bnode.getOriginalAddress());
                    String srcCast = AOTCompiler.getTypeCast(srcSize);
                    sm.load(srcSize, index, pc);
                    sm.push(valueSize, "(" + srcCast + ")" + sm.getLocal(index, this.bnode.getOriginalAddress()));
                    if (this.currentMethodCode[pc] == 21 || this.currentMethodCode[pc] == 23) {
                        ++pc;
                    }
                    ++pc;
                    break;
                }
                case 54: 
                case 56: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    int index;
                    int valueSize;
                    switch (this.currentMethodCode[pc]) {
                        case 54: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: {
                            valueSize = this.getIStoreSize(this.bnode, this.currentMethodCode[pc]);
                            if (this.currentMethodCode[pc] == 54) {
                                index = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                                ++pc;
                                break;
                            }
                            index = this.currentMethodCode[pc] - 59;
                            break;
                        }
                        default: {
                            valueSize = 4;
                            if (this.currentMethodCode[pc] == 56) {
                                index = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                                ++pc;
                                break;
                            }
                            index = this.currentMethodCode[pc] - 67;
                        }
                    }
                    sm.setLocal(valueSize, index, pc);
                    String dst = this.bnode.isRedundant() ? null : "   " + sm.getLocal(index, this.bnode.getOriginalAddress());
                    sm.pop(dst, valueSize);
                    ++pc;
                    break;
                }
                case -91: 
                case -90: {
                    localVariables.print("   int32 op2;\n");
                    localVariables.print("   int32 op1;\n");
                    localVariables.print("   unsigned char c_result;\n");
                    sm.pop("      op2", 3);
                    sm.pop("      op1", 3);
                    if (this.currentMethodCode[pc] == -91) {
                        output.append("      c_result = (op1 == op2);\n");
                    } else {
                        output.append("      c_result = (op1 != op2);\n");
                    }
                    output.append("      if (c_result) {\n");
                    short branchbyte1 = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    short branchbyte2 = (short)(this.currentMethodCode[pc + 2] & 0xFF);
                    short offset = (short)(branchbyte1 << 8 | branchbyte2);
                    this.handleBranch(sm, this.currentMethodCode[pc], pc, pc + offset, false);
                    output.append("         goto L" + (pc + offset) + ";\n");
                    output.append("      }\n");
                    pc += 3;
                    break;
                }
                case -64: 
                case -63: {
                    short byte1 = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    short byte2 = (short)(this.currentMethodCode[pc + 2] & 0xFF);
                    int superType = byte1 << 8 | byte2;
                    byte isInterface = (byte)(superType & 1);
                    superType >>= 1;
                    localVariables.print("   unsigned char *object;\n");
                    if (this.currentMethodCode[pc] == -63) {
                        localVariables.print("   uint8 i_res;\n");
                    }
                    sm.popRef("object");
                    if (this.currentMethodCode[pc] == -63) {
                        output.append("      excep = 1;\n");
                    } else {
                        output.append("      excep = 0;\n");
                        sm.push(3, "(int32)(pointer)object");
                    }
                    output.append("      if (object != 0) {\n");
                    if (isInterface == 0) {
                        int JAVA_LANG_OBJECT = this.toolBox.getPatcher().getClassNumber("java.lang.Object");
                        if (superType != JAVA_LANG_OBJECT) {
                            localVariables.print("   signed short subClassIndex;\n");
                            output.append("         subClassIndex = getClassIndex((Object*)object);\n");
                            output.append("         excep = !isSubClassOf(subClassIndex, " + superType + ");\n");
                            this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                        } else {
                            output.append("         excep = 0;\n");
                        }
                    } else {
                        output.append("         excep = checkImplements((Object*)object, " + superType + ");\n");
                        this.requiredIncludes.print("unsigned char checkImplements(Object* object, unsigned short interfaceIndex);\n");
                    }
                    output.append("      }\n");
                    int valueSize = 3;
                    if (this.currentMethodCode[pc] == -63 && (valueSize = this.getConsumerSize(pc, 0)) == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    output.append("      if (excep) {\n");
                    if (this.currentMethodCode[pc] == -64) {
                        output.append("         pc = " + pc + ";\n");
                        labelsManager.jumpTo(sm);
                        output.append("         goto throwClassCastException;\n");
                    } else {
                        output.append("      i_res = 0;\n");
                    }
                    output.append("      }\n");
                    if (this.currentMethodCode[pc] == -63) {
                        output.append("      else\n");
                        output.append("      {\n");
                        output.append("      i_res = 1;\n");
                        output.append("      }\n");
                        sm.push(valueSize, "i_res");
                    }
                    if (this.currentMethodCode[pc] == -64) {
                        labelsManager.generateThrowClassCast();
                        localVariables.print("   unsigned short pc;\n");
                    }
                    localVariables.print("   " + AOTCompiler.getTypeCast(entrypoints.getReturnTypeSize()) + " excep;\n");
                    this.requiredIncludes.print("extern unsigned char isSubClassOf(unsigned short subClass, unsigned short superClass);\n");
                    pc += 3;
                    break;
                }
                case 17: {
                    short byte1 = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    short byte2 = (short)(this.currentMethodCode[pc + 2] & 0xFF);
                    short value = (short)(byte1 << 8 | byte2);
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    if (valueSize == 1 && value > 255) {
                        throw new Exception("Illegal consumer size");
                    }
                    sm.push(valueSize, "" + value);
                    pc += 3;
                    break;
                }
                case -75: 
                case -52: {
                    int srcSize;
                    String type;
                    FieldInfo[] fieldOffsets = this.toolBox.getPatcher().getFieldOffsets();
                    FieldInfo finfo = fieldOffsets[pc + 4];
                    short fsize = (short)(this.currentMethodCode[pc + 3] & 0xFF);
                    short byte1 = (short)(this.currentMethodCode[pc + 4] & 0xFF);
                    short byte2 = (short)(this.currentMethodCode[pc + 5] & 0xFF);
                    int foffset = byte1 << 8 | byte2;
                    switch (fsize & 0xFC) {
                        case 16: {
                            type = "int16";
                            srcSize = 2;
                            break;
                        }
                        case 8: {
                            type = "int8";
                            srcSize = 1;
                            break;
                        }
                        case 32: {
                            if (sm.topSize() == 4) {
                                type = "float";
                                srcSize = 3;
                                break;
                            }
                        }
                        default: {
                            type = "int32";
                            srcSize = 3;
                        }
                    }
                    localVariables.print("   unsigned char* cobj;\n");
                    localVariables.print("   " + type + " lsb_" + type + ";\n");
                    if (this.currentMethodCode[pc] == -52) {
                        localVariables.print("   unsigned char* hw_address;\n");
                        localVariables.print("   struct _vm_HardwareObject_c* hwObject;\n");
                        localVariables.print("   struct _vm_Address32Bit_c* addressObj;\n");
                    }
                    int objIndex = 1;
                    if ((fsize & 0xFC) > 32) {
                        localVariables.print("   int32 msb_int32;\n");
                        objIndex = 2;
                    }
                    sm.pop("      lsb_" + type, srcSize);
                    if ((fsize & 0xFC) > 32) {
                        sm.pop("      msb_int32", 3);
                    }
                    sm.popRef("cobj");
                    AbstractStack stack = this.bnode.getStackLayout();
                    AbstractStack.StackCell cell = stack.getAt(stack.getSize() - 1 - objIndex);
                    if (((RefType)cell.content).getState() != RefType.RefState.NONNULL) {
                        AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "", sm, "cobj");
                    }
                    if (this.currentMethodCode[pc] == -75) {
                        if (finfo != null && !finfo.isFloat) {
                            output.append("      ((struct ");
                            output.append(finfo.getStructName());
                            output.append(" *)HEAP_REF(cobj, unsigned char*)) -> ");
                            output.append(finfo.getStructMemberName());
                            output.append(" = lsb_" + type + ";\n");
                            if ((fsize & 0xFC) > 32) {
                                output.append("      ((struct ");
                                output.append(finfo.getStructName());
                                output.append(" *)HEAP_REF(cobj, unsigned char*)) -> ");
                                output.append(finfo.getStructMemberLSBName());
                                output.append(" = msb_int32;\n");
                            }
                        } else {
                            output.append("      cobj = HEAP_REF(&cobj[sizeof(Object) + " + (foffset >> 3) + "], unsigned char*);\n");
                            switch (fsize & 0xFC) {
                                case 64: {
                                    output.append("      *(int32*) &cobj[4] = msb_int32;\n");
                                }
                                case 32: {
                                    output.append("      *((" + type + "*) cobj) = lsb_" + type + ";\n");
                                    break;
                                }
                                case 16: {
                                    output.append("      *((signed short*) cobj) = lsb_" + type + ";\n");
                                    break;
                                }
                                case 8: {
                                    output.append("      *((signed char*) cobj) = lsb_" + type + ";\n");
                                }
                            }
                        }
                    } else if (this.currentMethodCode[pc] == -52) {
                        int classIndex = this.currentMethodCode[pc + 1] << 8 & 0xFFFF;
                        classIndex |= this.currentMethodCode[pc + 2] & 0xFF;
                        output.append("      hwObject = (struct _vm_HardwareObject_c*)HEAP_REF(cobj, struct _vm_HardwareObject_c*);\n");
                        output.append("      addressObj = (struct _vm_Address32Bit_c*)HEAP_REF((pointer)(hwObject->address_f), struct _vm_Address32Bit_c*);\n");
                        output.append("      hw_address = (unsigned char*) (pointer) (addressObj->address_f);\n");
                        int referenceAddressIndex = this.toolBox.getPatcher().getClassNumber("reflect.HeapAccessor");
                        ClassInheritanceMatrix classMatrix = this.toolBox.getClassMatrix();
                        if (referenceAddressIndex != -1 && classMatrix.getInherits(classIndex, referenceAddressIndex)) {
                            output.append("      hw_address = HEAP_REF(hw_address, unsigned char *);\n");
                        }
                        foffset -= 32;
                        switch (fsize & 0xFC) {
                            case 64: {
                                output.append("      writeLongToIO((pointer)hw_address, " + foffset + ", msb_int32, lsb_" + type + ");\n");
                                this.requiredIncludes.print("extern void writeLongToIO(pointer address, unsigned short offset, int32 msb, int32 lsb);\n");
                                break;
                            }
                            case 32: {
                                output.append("      writeIntToIO((pointer)hw_address, " + foffset + ", lsb_" + type + ");\n");
                                this.requiredIncludes.print("extern void writeIntToIO(pointer address, unsigned short offset, int32 lsb);\n");
                                break;
                            }
                            case 16: {
                                output.append("      writeShortToIO((pointer)hw_address, " + foffset + ", lsb_" + type + " & 0xffff);\n");
                                this.requiredIncludes.print("extern void writeShortToIO(pointer address, unsigned short offset, unsigned short lsb);\n");
                                break;
                            }
                            case 8: {
                                output.append("      writeByteToIO((pointer)hw_address, " + foffset + ", lsb_" + type + " & 0xff);\n");
                                this.requiredIncludes.print("extern void writeByteToIO(pointer address, unsigned short offset, unsigned char lsb);\n");
                                break;
                            }
                            case 1: {
                                output.append("      writeBitToIO((pointer)hw_address, " + foffset + ", lsb_" + type + " & 0x1);\n");
                                this.requiredIncludes.print("extern void writeBitToIO(pointer address, unsigned short offset, unsigned char bit);\n");
                            }
                        }
                    }
                    pc += 6;
                    break;
                }
                case -76: 
                case -53: {
                    int size;
                    FieldInfo[] fieldOffsets = this.toolBox.getPatcher().getFieldOffsets();
                    FieldInfo finfo = fieldOffsets[pc + 4];
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    short fsize = (short)(this.currentMethodCode[pc + 3] & 0xFF);
                    short byte1 = (short)(this.currentMethodCode[pc + 4] & 0xFF);
                    short byte2 = (short)(this.currentMethodCode[pc + 5] & 0xFF);
                    int foffset = byte1 << 8 | byte2;
                    localVariables.print("   unsigned char* cobj;\n");
                    if (this.currentMethodCode[pc] == -53) {
                        localVariables.print("   unsigned char* hw_address;\n");
                        localVariables.print("   struct _vm_HardwareObject_c* hwObject;\n");
                        localVariables.print("   #if defined(VM_ADDRESS64BIT_INIT_)\n   Object* _addressObj_;\n#endif\n");
                        localVariables.print("   struct _vm_Address32Bit_c* addressObj32bit;\n");
                        if ((fsize & 0xFC) == 64) {
                            localVariables.print("   int32 msb_int32;\n");
                            localVariables.print("   int32 lsb_int32;\n");
                        }
                    }
                    sm.popRef("cobj");
                    AbstractStack stack = this.bnode.getStackLayout();
                    AbstractStack.StackCell cell = stack.peek();
                    if (((RefType)cell.content).getState() != RefType.RefState.NONNULL) {
                        AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "", sm, "cobj");
                    }
                    if (this.currentMethodCode[pc] == -76) {
                        if (finfo != null && !finfo.isFloat) {
                            StringBuffer buffer = new StringBuffer();
                            if ((fsize & 0xFC) > 32) {
                                buffer.append("((struct ");
                                buffer.append(finfo.getStructName());
                                buffer.append(" *)HEAP_REF(cobj, unsigned char*)) -> ");
                                buffer.append(finfo.getStructMemberLSBName());
                                sm.push(valueSize, buffer.toString());
                                buffer = new StringBuffer();
                            }
                            buffer.append("((struct ");
                            buffer.append(finfo.getStructName());
                            buffer.append(" *)HEAP_REF(cobj, unsigned char*)) -> ");
                            buffer.append(finfo.getStructMemberName());
                            sm.push(valueSize, buffer.toString());
                        } else {
                            output.append("      cobj = HEAP_REF(&cobj[sizeof(Object) + " + (foffset >> 3) + "], unsigned char*);\n");
                            switch (fsize & 0xFC) {
                                case 64: {
                                    sm.push(3, "*(int32*) &cobj[4]");
                                }
                                case 32: {
                                    ProducerConsumerCellInfo topAtExit = this.bnode.getAinfo().exitStack.peek();
                                    BNode consumer = topAtExit.getConsumer();
                                    size = this.normalizeConsumerSize(consumer, this.bnode.getAinfo().exitStack.size() - 1);
                                    String type = size == 4 ? "float" : "int32";
                                    sm.push(valueSize, "*(" + type + "*) cobj");
                                    break;
                                }
                                case 16: {
                                    sm.push(valueSize, "*(signed short*) cobj");
                                    break;
                                }
                                case 8: {
                                    sm.push(valueSize, "*(signed char*) cobj");
                                }
                            }
                        }
                    } else if (this.currentMethodCode[pc] == -53) {
                        int classIndex = this.currentMethodCode[pc + 1] << 8 & 0xFFFF;
                        classIndex |= this.currentMethodCode[pc + 2] & 0xFF;
                        output.append("      hwObject = (struct _vm_HardwareObject_c*)HEAP_REF(cobj, struct _vm_HardwareObject_c*);\n");
                        output.append("#if defined(VM_ADDRESS64BIT_INIT_)\n");
                        output.append("      _addressObj_ = (Object*)HEAP_REF((pointer)(hwObject->address_f), Object*);\n");
                        output.append("      if (*_addressObj_ == VM_ADDRESS64BIT) {\n");
                        output.append("          struct _vm_Address64Bit_c* addressObj64;\n");
                        output.append("          long address;\n");
                        output.append("          addressObj64 = (struct _vm_Address64Bit_c*)_addressObj_;\n");
                        output.append("          address = addressObj64->lsbaddress_f;\n");
                        output.append("          address = (address << 16) << 16;\n");
                        output.append("          address |= addressObj64->address_f;\n");
                        output.append("          hw_address = (unsigned char*) (pointer) address;\n");
                        output.append("      } else {\n");
                        output.append("#endif\n");
                        output.append("          addressObj32bit = (struct _vm_Address32Bit_c*) HEAP_REF((pointer )(hwObject->address_f), struct _vm_Address32Bit_c*);\n");
                        output.append("          hw_address = (unsigned char*) (pointer) (addressObj32bit->address_f);\n");
                        output.append("#if defined(VM_ADDRESS64BIT_INIT_)\n");
                        output.append("      }\n");
                        output.append("#endif\n");
                        int referenceAddressIndex = this.toolBox.getPatcher().getClassNumber("reflect.HeapAccessor");
                        ClassInheritanceMatrix classMatrix = this.toolBox.getClassMatrix();
                        if (classMatrix.getInherits(classIndex, referenceAddressIndex)) {
                            output.append("      hw_address = HEAP_REF(hw_address, unsigned char *);\n");
                        }
                        foffset -= 32;
                        switch (fsize & 0xFC) {
                            case 64: {
                                output.append("      readLongFromIO((pointer)hw_address, " + foffset + ", &msb_int32, &lsb_int32);\n");
                                sm.push(3, "msb_int32");
                                sm.push(3, "lsb_int32");
                                this.requiredIncludes.print("extern void readLongFromIO(pointer address, unsigned short offset, int32* msb, int32* lsb);\n");
                                break;
                            }
                            case 32: {
                                sm.push(valueSize, "readIntFromIO((pointer)hw_address, " + foffset + ")");
                                this.requiredIncludes.print("extern int32 readIntFromIO(pointer address, unsigned short offset);\n");
                                break;
                            }
                            case 16: {
                                sm.push(valueSize, "readShortFromIO((pointer)hw_address, " + foffset + ")");
                                this.requiredIncludes.print("extern int16 readShortFromIO(pointer address, unsigned short offset);\n");
                                break;
                            }
                            case 8: {
                                sm.push(valueSize, "readByteFromIO((pointer)hw_address, " + foffset + ")");
                                this.requiredIncludes.print("extern int8 readByteFromIO(pointer address, unsigned short offset);\n");
                                break;
                            }
                            case 1: {
                                sm.push(valueSize, "readBitFromIO((pointer)hw_address, " + foffset + ")");
                                this.requiredIncludes.print("extern int8 readBitFromIO(pointer address, unsigned short offset);\n");
                            }
                        }
                    }
                    pc += 6;
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    short byte1 = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    short byte2 = (short)(this.currentMethodCode[pc + 2] & 0xFF);
                    int index = byte1 << 8 | byte2;
                    ArrayList<LDCConstant> constants = this.toolBox.getPatcher().getConstants();
                    LDCConstant constant = constants.get(index);
                    if (constant.getType() == 2) {
                        sm.push(3, "" + constant.getInt());
                    } else if (constant.getType() == 1) {
                        localVariables.print("   const ConstantInfo* constant_;\n");
                        output.append("   constant_ = &constants[" + index + "];\n");
                        output.append("#ifndef PRE_INITIALIZE_CONSTANTS\n");
                        output.append("   initializeStringConstant(constant_, sp);\n");
                        this.setSPUsed(true);
                        output.append("#endif\n");
                        this.requiredIncludes.print("extern Object* stringConstants[];\n");
                        this.requiredIncludes.print("extern const ConstantInfo *constants;\n");
                        this.requiredIncludes.print("#ifndef PRE_INITIALIZE_CONSTANTS\nextern int16 initializeStringConstant(const ConstantInfo* constant, int32* sp);\n#endif\n");
                        sm.push(3, "(int32) (pointer) stringConstants[pgm_read_dword(&constant_->value) >> 16]");
                    } else if (constant.getType() == 6) {
                        localVariables.print("   const ConstantInfo* constant_;\n");
                        output.append("   constant_ = &constants[" + index + "];\n");
                        this.requiredIncludes.print("extern const ConstantInfo *constants;\n");
                        this.requiredIncludes.print("extern Object* getClass(unsigned short classIndex);\n");
                        sm.push(3, "(uint32)(pointer)getClass(pgm_read_dword(&constant_->value))");
                    } else if (constant.getType() == 4) {
                        localVariables.print("   int32 msi;\n");
                        localVariables.print("   int32 lsi;\n");
                        localVariables.print("   const unsigned char *data_;\n");
                        localVariables.print("   const ConstantInfo* constant_;\n");
                        output.append("   constant_ = &constants[" + index + "];\n");
                        this.requiredIncludes.print("extern const ConstantInfo *constants;\n");
                        output.append("   data_ = (const unsigned char *) pgm_read_pointer(&constant_->data, const void **);\n");
                        output.append("   msi = ((int32) pgm_read_byte(data_)) << 24;\n");
                        output.append("   msi |= ((int32) pgm_read_byte(data_ +1)) << 16;\n");
                        output.append("   msi |= pgm_read_byte(data_ + 2) << 8;\n");
                        output.append("   msi |= pgm_read_byte(data_ + 3);\n");
                        output.append("   lsi = ((int32) pgm_read_byte(data_ + 4)) << 24;\n");
                        output.append("   lsi |= ((int32) pgm_read_byte(data_ + 5)) << 16;\n");
                        output.append("   lsi |= pgm_read_byte(data_ + 6) << 8;\n");
                        output.append("   lsi |= pgm_read_byte(data_ + 7);\n");
                        sm.push(3, "msi");
                        sm.push(3, "lsi");
                    } else {
                        sm.flush(true);
                        this.setSPUsed(true);
                        localVariables.print("   unsigned char topInc;\n");
                        output.append("      topInc = handleLDCWithIndex(sp, " + index + ");\n");
                        output.append("      sp += topInc;\n");
                        this.requiredIncludes.print("unsigned char handleLDCWithIndex(int32* sp, unsigned short index);\n");
                    }
                    pc += 3;
                    break;
                }
                case 87: {
                    this.requiredIncludes.print("static uint32 dummy;\n");
                    sm.pop("dummy", 3);
                    ++pc;
                    break;
                }
                case -66: {
                    AbstractStack stack = this.bnode.getStackLayout();
                    AbstractStack.StackCell cell = stack.peek();
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    localVariables.print("   unsigned char* cobj;\n");
                    sm.popRef("      cobj");
                    if (((RefType)cell.content).getState() != RefType.RefState.NONNULL) {
                        AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "", sm, "cobj");
                    }
                    sm.push(valueSize, "*(uint16*) ((HEAP_REF(cobj, unsigned char*)) + sizeof(Object))");
                    ++pc;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = this.getProducersSize(pc, 0);
                    }
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int size = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    String type = AOTCompiler.getTypeCast(size);
                    localVariables.print("   " + type + " index_" + type + ";\n");
                    localVariables.print("   unsigned char* cobj;\n");
                    sm.pop("      index_" + type, size);
                    sm.popRef("      cobj");
                    AbstractStack stack = this.bnode.getStackLayout();
                    AbstractStack.StackCell cell = stack.getAt(stack.getSize() - 2);
                    if (((RefType)cell.content).getState() != RefType.RefState.NONNULL) {
                        AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "", sm, "cobj");
                    }
                    int elementSize = 0;
                    elementSize = this.getElementSize(pc);
                    this.adjustArrayPointer(output, elementSize, "cobj", "index_" + type);
                    output.append("      cobj = HEAP_REF(cobj, unsigned char*);\n");
                    switch (elementSize) {
                        case 1: {
                            sm.push(valueSize, "*(signed char *)cobj");
                            break;
                        }
                        case 2: {
                            sm.push(valueSize, "*((signed short *) cobj)");
                            break;
                        }
                        case 4: {
                            sm.push(valueSize, "*((uint32 *) cobj)");
                            break;
                        }
                        case 8: {
                            sm.push(3, "*((uint32 *) cobj)");
                            sm.push(3, "*((uint32 *) (cobj + 4))");
                        }
                    }
                    ++pc;
                    break;
                }
                case -68: 
                case -67: 
                case -51: {
                    int classIndex = this.currentMethodCode[pc + 1] << 8 & 0xFFFF;
                    localVariables.print("   Object* narray;\n");
                    localVariables.print("   uint16 count;\n");
                    sm.pop("      count", 2);
                    output.append("      narray = (Object*) createArray(" + (classIndex |= this.currentMethodCode[pc + 2] & 0xFF) + ", (uint16) count FLASHARG((0)));\n");
                    output.append("      if (narray == 0) {\n");
                    output.append("         pc = " + pc + ";\n");
                    labelsManager.jumpTo(sm);
                    output.append("         goto throwOutOfMemory;\n");
                    localVariables.print("   unsigned short pc;\n");
                    labelsManager.generateOutOfMemory();
                    output.append("      }\n");
                    sm.push(3, "(int32) (pointer) narray");
                    pc += 3;
                    this.requiredIncludes.print("extern unsigned char* createArray(unsigned short classIndex, uint16 count FLASHARG(uint8 flash));\n");
                    this.requiredIncludes.print("extern unsigned short getClassIndex(Object* obj);\n");
                    break;
                }
                case -59: {
                    int classIndex = this.currentMethodCode[pc + 1] << 8 & 0xFFFF;
                    int dimensions = this.currentMethodCode[pc + 3];
                    sm.flush(false);
                    localVariables.print("   Object* narray;\n");
                    output.append("      narray = (Object*) createMultiDimensionalArrays(sp, " + dimensions + ", " + (classIndex |= this.currentMethodCode[pc + 2] & 0xFF) + ");\n");
                    while (dimensions > 0) {
                        sm.pop(null, 3);
                        --dimensions;
                    }
                    sm.push(3, "(int32) (pointer) narray");
                    pc += 4;
                    this.requiredIncludes.print("extern Object* createMultiDimensionalArrays(int32* sp, unsigned char dimensions, unsigned short classIndex);\n");
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int indexStackCellIndex = this.currentMethodCode[pc] != 80 && this.currentMethodCode[pc] != 82 ? entryStack.size() - 2 : entryStack.size() - 3;
                    int indexSize = this.normalizeProducersSize(this.bnode, indexStackCellIndex);
                    String indexCast = AOTCompiler.getTypeCast(indexSize);
                    int valueSize = 3;
                    switch (this.currentMethodCode[pc]) {
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: {
                            valueSize = 3;
                            break;
                        }
                        case 84: 
                        case 85: {
                            valueSize = 1;
                            break;
                        }
                        case 86: {
                            valueSize = 2;
                        }
                    }
                    String valueCast = AOTCompiler.getTypeCast(valueSize);
                    localVariables.print("   " + valueCast + " lsb_" + valueCast + ";\n");
                    if (this.currentMethodCode[pc] == 80 || this.currentMethodCode[pc] == 82) {
                        localVariables.print("   int32 msb_int32;\n");
                    }
                    localVariables.print("   " + indexCast + " index_" + indexCast + ";\n");
                    localVariables.print("   unsigned char* cobj;\n");
                    sm.pop("      lsb_" + valueCast, valueSize);
                    if (this.currentMethodCode[pc] == 80 || this.currentMethodCode[pc] == 82) {
                        sm.pop("      msb_int32", 3);
                    }
                    sm.pop("      index_" + indexCast, indexSize);
                    sm.popRef("      cobj");
                    int indexIndex = this.currentMethodCode[pc] == 80 || this.currentMethodCode[pc] == 82 ? 4 : 3;
                    AbstractStack stack = this.bnode.getStackLayout();
                    AbstractStack.StackCell cell = stack.getAt(stack.getSize() - indexIndex);
                    if (((RefType)cell.content).getState() != RefType.RefState.NONNULL) {
                        AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "", sm, "cobj");
                    }
                    int elementSize = this.getElementSize(pc);
                    this.adjustArrayPointer(output, elementSize, "cobj", "index_" + indexCast);
                    output.append("      cobj = HEAP_REF(cobj, unsigned char*);\n");
                    switch (elementSize) {
                        case 1: {
                            output.append("      *cobj = lsb_" + valueCast + ";\n");
                            break;
                        }
                        case 2: {
                            output.append("      *((unsigned short *) cobj) = lsb_" + valueCast + ";\n");
                            break;
                        }
                        case 4: {
                            output.append("      *((uint32 *) cobj) = lsb_" + valueCast + ";\n");
                            break;
                        }
                        case 8: {
                            output.append("      *((uint32 *) cobj) = msb_int32;\n");
                            output.append("      *((uint32 *) (cobj + 4)) = lsb_" + valueCast + ";\n");
                        }
                    }
                    ++pc;
                    break;
                }
                case -105: 
                case -104: {
                    sm.flush(true);
                    localVariables.print("   double d_value1;\n");
                    localVariables.print("   double d_value2;\n");
                    localVariables.print("   int32 d_res;\n");
                    output.append("   d_res = 0;\n");
                    output.append("   sp-=2;\n");
                    output.append("   d_value1 = *(double*) sp;\n");
                    output.append("   sp-=2;\n");
                    output.append("   d_value2 = *(double*) sp;\n");
                    output.append("   if (d_value2 > d_value1) {\n");
                    output.append("      d_res = 1;\n");
                    output.append("   } else if (d_value1 > d_value2) {\n");
                    output.append("      d_res = -1;\n");
                    output.append("   }\n");
                    output.append("   *sp++ = d_res;\n");
                    ++pc;
                    break;
                }
                case -108: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    localVariables.print("   int32 l_res;\n");
                    output.append("      l_res = handleLCMP(sp);\n");
                    output.append("      sp -= 4;\n");
                    output.append("      *sp++ = l_res;\n");
                    this.requiredIncludes.print("extern int32 handleLCMP(int32* sp);\n");
                    ++pc;
                    break;
                }
                case -111: 
                case -110: {
                    ++pc;
                    break;
                }
                case -54: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    output.append("      excep = handleCloneOnArray(sp);\n");
                    output.append("      if (excep < 0) {\n");
                    output.append("         pc = " + pc + ";\n");
                    labelsManager.jumpTo(sm);
                    output.append("         goto throwNullPointer;\n");
                    output.append("      } else if (excep > 0) {\n");
                    output.append("         pc = " + pc + ";\n");
                    labelsManager.jumpTo(sm);
                    output.append("         goto throwOutOfMemory;\n");
                    output.append("      }\n");
                    labelsManager.generateOutOfMemory();
                    labelsManager.generateThrowNullPointer();
                    this.requiredIncludes.print("extern signed char handleCloneOnArray(int32* sp);\n");
                    localVariables.print("   " + AOTCompiler.getTypeCast(entrypoints.getReturnTypeSize()) + " excep;\n");
                    pc += 4;
                    break;
                }
                case 120: 
                case 122: {
                    String operation = null;
                    operation = this.currentMethodCode[pc] == 120 ? "<<" : ">>";
                    ProducerConsumerStack exitStack = this.bnode.getAinfo().exitStack;
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int src2Size = this.normalizeProducersSize(this.bnode, entryStack.size() - 2);
                    int dstSize = this.normalizeConsumerSize(exitStack.peek().getConsumer(), exitStack.size() - 1);
                    if (dstSize == 0) {
                        dstSize = 3;
                    }
                    localVariables.print("   unsigned char shiftv;\n");
                    localVariables.print("   uint32 v_alue;\n");
                    sm.pop("      shiftv", 3);
                    sm.pop("      v_alue", src2Size);
                    output.append("      v_alue = v_alue " + operation + " shiftv;\n");
                    sm.push(dstSize, "v_alue");
                    ++pc;
                    break;
                }
                case 119: {
                    sm.flush(true);
                    localVariables.print("   double d_ouble1;\n");
                    output.append("   sp -= 2;\n");
                    output.append("   d_ouble1 = *(double*) sp;\n");
                    output.append("   d_ouble1 = -d_ouble1;\n");
                    output.append("   *(double*) sp = d_ouble1;\n");
                    output.append("   sp += 2;\n");
                    ++pc;
                    break;
                }
                case 118: {
                    String srcType = AOTCompiler.getTypeCast(4);
                    localVariables.print("   " + srcType + " res_" + srcType + ";\n");
                    sm.pop("      res_" + srcType, 4);
                    output.append("      res_" + srcType + " = -res_" + srcType + ";\n");
                    sm.push(4, "res_" + srcType);
                    ++pc;
                    break;
                }
                case 116: {
                    ProducerConsumerStack exitStack = this.bnode.getAinfo().exitStack;
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int srcSize = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    int dstSize = this.normalizeConsumerSize(exitStack.peek().getConsumer(), exitStack.size() - 1);
                    if (dstSize == 0) {
                        dstSize = 3;
                    }
                    String srcType = AOTCompiler.getTypeCast(srcSize);
                    localVariables.print("   " + srcType + " res_" + srcType + ";\n");
                    sm.pop("      res_" + srcType, srcSize);
                    output.append("      res_" + srcType + " = -res_" + srcType + ";\n");
                    sm.push(dstSize, "res_" + srcType);
                    ++pc;
                    break;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: {
                    int dstSize = 4;
                    String operand = "+";
                    switch (this.currentMethodCode[pc]) {
                        case 110: {
                            operand = "/";
                            break;
                        }
                        case 106: {
                            operand = "*";
                            break;
                        }
                        case 102: {
                            operand = "-";
                        }
                    }
                    localVariables.print("   float msb_float;\n");
                    localVariables.print("   float lsb_float;\n");
                    sm.pop("      msb_float", 4);
                    sm.pop("      lsb_float", 4);
                    output.append("      lsb_float " + operand + "= msb_float;\n");
                    sm.push(dstSize, "lsb_float");
                    ++pc;
                    break;
                }
                case -128: 
                case -126: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 124: 
                case 126: {
                    ProducerConsumerStack exitStack = this.bnode.getAinfo().exitStack;
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int src1Size = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    int src2Size = this.normalizeProducersSize(this.bnode, entryStack.size() - 2);
                    int dstSize = this.normalizeConsumerSize(exitStack.peek().getConsumer(), exitStack.size() - 1);
                    if (dstSize == 0) {
                        dstSize = 3;
                    }
                    String src1Type = AOTCompiler.getTypeCast(src1Size);
                    String src2Type = AOTCompiler.getTypeCast(src2Size);
                    String operand = "";
                    switch (this.currentMethodCode[pc]) {
                        case -128: 
                        case -126: 
                        case 96: 
                        case 100: 
                        case 126: {
                            switch (this.currentMethodCode[pc]) {
                                case -128: {
                                    operand = "|";
                                    break;
                                }
                                case -126: {
                                    operand = "^";
                                    break;
                                }
                                case 126: {
                                    operand = "&";
                                    break;
                                }
                                case 100: {
                                    operand = "-";
                                    break;
                                }
                                case 96: {
                                    operand = "+";
                                }
                            }
                            localVariables.print("   " + src1Type + " msb_" + src1Type + ";\n");
                            localVariables.print("   " + src2Type + " lsb_" + src2Type + ";\n");
                            sm.pop("      msb_" + src1Type, src1Size);
                            sm.pop("      lsb_" + src2Type, src2Size);
                            output.append("      lsb_" + src2Type + " " + operand + "= msb_" + src1Type + ";\n");
                            sm.push(dstSize, "lsb_" + src2Type);
                            ++pc;
                            break;
                        }
                        case 104: {
                            String dstType = AOTCompiler.getTypeCast(dstSize);
                            localVariables.print("   " + dstType + " res_" + dstType + ";\n");
                            localVariables.print("   " + src2Type + " lsb_" + src2Type + ";\n");
                            sm.pop("      res_" + dstType, src1Size);
                            sm.pop("      lsb_" + src2Type, src2Size);
                            output.append("#if defined(GLIBC_DOES_NOT_SUPPORT_MUL)\n");
                            output.append("      res_" + dstType + " = imul(res_" + dstType + ", lsb_" + src2Type + ");\n");
                            this.requiredIncludes.print("extern int32 imul(int32 x, int32 y);\n");
                            output.append("#else\n");
                            output.append("      res_" + dstType + " = res_" + dstType + " * lsb_" + src2Type + ";\n");
                            output.append("#endif\n");
                            sm.push(dstSize, "res_" + dstType);
                            ++pc;
                            break;
                        }
                        case 108: {
                            String lsb_type = AOTCompiler.getTypeCast(src2Size);
                            String dstType = AOTCompiler.getTypeCast(dstSize);
                            localVariables.print("   " + dstType + " res_" + dstType + ";\n");
                            localVariables.print("   " + lsb_type + " lsb_" + lsb_type + ";\n");
                            sm.pop("      res_" + dstType, src1Size);
                            sm.pop("      lsb_" + lsb_type, src2Size);
                            output.append("      if (res_" + dstType + " == 0) {\n");
                            output.append("         pc = " + pc + ";\n");
                            labelsManager.jumpTo(sm);
                            output.append("         goto throwArithmeticException;\n");
                            labelsManager.generateArithmeticException();
                            output.append("      }\n");
                            output.append("      res_" + dstType + " = idiv(lsb_" + lsb_type + ", res_" + dstType + ");\n");
                            sm.push(dstSize, "res_" + dstType);
                            ++pc;
                            localVariables.print("   unsigned short pc;\n");
                            this.requiredIncludes.print("extern int32 idiv(int32 x, int32 y);\n");
                            break;
                        }
                        case 112: {
                            String lsb_type = AOTCompiler.getTypeCast(src2Size);
                            String dst_type = AOTCompiler.getTypeCast(dstSize);
                            localVariables.print("   " + dst_type + " res_" + dst_type + ";\n");
                            localVariables.print("   " + lsb_type + " lsb_" + lsb_type + ";\n");
                            sm.pop("      res_" + dst_type, src1Size);
                            sm.pop("      lsb_" + lsb_type, src2Size);
                            output.append("      if (res_" + dst_type + " == 0) {\n");
                            output.append("         pc = " + pc + ";\n");
                            labelsManager.jumpTo(sm);
                            output.append("         goto throwArithmeticException;\n");
                            labelsManager.generateArithmeticException();
                            output.append("      }\n");
                            output.append("#if defined(GLIBC_DOES_NOT_SUPPORT_MUL)\n");
                            output.append("      res_" + dst_type + " = imod(res_" + dst_type + ", lsb_" + lsb_type + ");\n");
                            output.append("#else\n");
                            output.append("      res_" + dst_type + " = lsb_" + lsb_type + " % res_" + dst_type + ";\n");
                            output.append("#endif\n");
                            sm.push(dstSize, "res_" + dst_type);
                            ++pc;
                            localVariables.print("   unsigned short pc;\n");
                            this.requiredIncludes.print("extern int32 imod(int32 a, int32 b);\n");
                            break;
                        }
                        case 124: {
                            String value1_type = AOTCompiler.getTypeCast(src2Size);
                            String dst_type = AOTCompiler.getTypeCast(dstSize);
                            localVariables.print("   unsigned char value2_uc;\n");
                            localVariables.print("   u" + value1_type + " value1_u" + value1_type + ";\n");
                            localVariables.print("   u" + dst_type + " result_u" + dst_type + ";\n");
                            sm.pop("      value2_uc", 1);
                            sm.pop("      value1_u" + value1_type, src2Size);
                            output.append("      result_u" + dst_type + " = value1_u" + value1_type + " >> value2_uc;\n");
                            sm.push(dstSize, "result_u" + dst_type);
                            ++pc;
                        }
                    }
                    break;
                }
                case -78: 
                case -77: {
                    AOTStaticFieldEmitter emitter = new AOTStaticFieldEmitter(pc, this.toolBox, this.currentMethodCode, localVariables, output, sm, this.requiredIncludes, this.bnode);
                    FieldAccessEmitter worker = emitter.getEmitter();
                    worker.performFieldAccess();
                    pc += 6;
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    int index = this.currentMethodCode[pc] - 63;
                    sm.pop("   " + sm.getLocal(index + 1, this.getOriginalAddress(pc)), 3);
                    sm.pop("   " + sm.getLocal(index, this.getOriginalAddress(pc)), 3);
                    ++pc;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    int index = this.currentMethodCode[pc] - 30;
                    sm.push(3, sm.getLocal(index, this.getOriginalAddress(pc)));
                    sm.push(3, sm.getLocal(index + 1, this.getOriginalAddress(pc)));
                    ++pc;
                    break;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: {
                    sm.flush(true);
                    localVariables.print("   double d_ouble1;\n");
                    localVariables.print("   double d_ouble2;\n");
                    output.append("   sp -= 2;\n");
                    output.append("   d_ouble1 = *(double*) sp;\n");
                    output.append("   sp -= 2;\n");
                    output.append("   d_ouble2 = *(double*) sp;\n");
                    String operator = "";
                    switch (this.currentMethodCode[pc]) {
                        case 99: {
                            operator = "+";
                            break;
                        }
                        case 103: {
                            operator = "-";
                            break;
                        }
                        case 107: {
                            operator = "*";
                            break;
                        }
                        case 111: {
                            operator = "/";
                        }
                    }
                    output.append("   d_ouble1 = d_ouble1 " + operator + " d_ouble2;\n");
                    output.append("   *(double*) sp = d_ouble1;\n");
                    output.append("   sp += 2;\n");
                    ++pc;
                    break;
                }
                case 105: 
                case 109: 
                case 113: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    localVariables.print("   unsigned char topInc;\n");
                    output.append("      topInc = handleLMULLDIVLREM(sp, " + (this.currentMethodCode[pc] & 0xFF) + ");\n");
                    output.append("      sp -= 4;\n");
                    output.append("      if (topInc == 0) {\n");
                    output.append("         pc = " + pc + ";\n");
                    labelsManager.jumpTo(sm);
                    output.append("         goto throwArithmeticException;\n");
                    labelsManager.generateArithmeticException();
                    output.append("      }\n");
                    output.append("      sp += topInc;\n");
                    ++pc;
                    this.requiredIncludes.print("extern unsigned char handleLMULLDIVLREM(int32* sp, unsigned char code);\n");
                    localVariables.print("   unsigned short pc;\n");
                    break;
                }
                case 55: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    int pcInc;
                    short byteVal;
                    if (this.currentMethodCode[pc] == 57 || this.currentMethodCode[pc] == 55) {
                        byteVal = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                        pcInc = 2;
                    } else {
                        byteVal = (short)(this.currentMethodCode[pc] - 71);
                        pcInc = 1;
                    }
                    sm.pop("   " + sm.getLocal(byteVal + 1, this.getOriginalAddress(pc)), 3);
                    sm.pop("   " + sm.getLocal(byteVal, this.getOriginalAddress(pc)), 3);
                    pc += pcInc;
                    break;
                }
                case -112: {
                    localVariables.print("   double d_ouble;\n");
                    sm.flush(true);
                    output.append("   d_ouble = *(double*) (sp - 2);\n");
                    output.append("   sp -= 2;\n");
                    output.append("   *(float*)sp = (float)d_ouble;\n");
                    output.append("   sp++;\n");
                    ++pc;
                    break;
                }
                case -113: {
                    localVariables.print("   double d_ouble;\n");
                    sm.flush(true);
                    output.append("   d_ouble = *(double*) (sp - 2);\n");
                    output.append("   sp -= 2;\n");
                    output.append("   *(int32*)sp = 0;\n");
                    output.append("   sp++;\n");
                    output.append("   *(int32*)sp = (int32)d_ouble;\n");
                    output.append("   sp++;\n");
                    ++pc;
                    break;
                }
                case 22: 
                case 24: {
                    short index = (short)(this.currentMethodCode[pc + 1] & 0xFF);
                    sm.push(3, sm.getLocal(index, this.getOriginalAddress(pc)));
                    sm.push(3, sm.getLocal(index + 1, this.getOriginalAddress(pc)));
                    pc += 2;
                    break;
                }
                case -127: 
                case -125: 
                case 97: 
                case 101: 
                case 127: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    output.append("   handleLongOperator(" + this.currentMethodCode[pc] + ", sp);\n");
                    output.append("   sp = sp - 2;\n");
                    ++pc;
                    this.requiredIncludes.print("extern void handleLongOperator(unsigned char code, int32* sp);\n");
                    break;
                }
                case 9: 
                case 10: {
                    sm.push(3, "0");
                    sm.push(3, "" + (this.currentMethodCode[pc] - 9));
                    ++pc;
                    break;
                }
                case 14: 
                case 15: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    output.append("      *(double*)sp = (double)" + (this.currentMethodCode[pc] - 14) + ";\n");
                    output.append("      sp+=2;\n");
                    ++pc;
                    break;
                }
                case 121: 
                case 123: 
                case 125: {
                    sm.flush(true);
                    this.setSPUsed(true);
                    if (this.currentMethodCode[pc] == 121) {
                        output.append("   handleLSHL(sp);\n");
                        this.requiredIncludes.print("extern void handleLSHL(int32* sp);\n");
                    } else {
                        output.append("   handleLSHR(sp);\n");
                        this.requiredIncludes.print("extern void handleLSHR(int32* sp);\n");
                    }
                    output.append("   sp--;\n");
                    ++pc;
                    break;
                }
                case -86: {
                    SwitchBNode sbnode = (SwitchBNode)this.bnode;
                    RawByteCodes.Raw_tableswitch tableSwitch = (RawByteCodes.Raw_tableswitch)sbnode.getTableSwitch();
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int srcSize = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    if (srcSize == 0) {
                        srcSize = 3;
                    }
                    String key_type = AOTCompiler.getTypeCast(srcSize);
                    int index = 0;
                    localVariables.print("   " + key_type + " key_" + key_type + ";\n");
                    sm.pop("   key_" + key_type, srcSize);
                    output.append("   switch (key_" + key_type + " - " + tableSwitch.getLow() + ") {\n");
                    long[] referenceAddressIndex = tableSwitch.offsets;
                    int dst_type = tableSwitch.offsets.length;
                    int value1_type = 0;
                    while (value1_type < dst_type) {
                        long offset = referenceAddressIndex[value1_type];
                        output.append("   case " + index + ":\n");
                        BNode target = sbnode.findTarget(offset);
                        this.handleBranch(sm, this.currentMethodCode[pc], pc, target.getAddress(), true);
                        output.append("      goto L" + target.getAddress() + ";\n");
                        ++index;
                        ++value1_type;
                    }
                    output.append("   default:\n");
                    BNode target = sbnode.findTarget(tableSwitch.defaultVal);
                    this.handleBranch(sm, this.currentMethodCode[pc], pc, target.getAddress(), true);
                    output.append("      goto L" + target.getAddress() + ";\n");
                    output.append("   }\n");
                    pc += 16 + tableSwitch.offsets.length * 4;
                    break;
                }
                case -85: {
                    SwitchBNode sbnode = (SwitchBNode)this.bnode;
                    RawByteCodes.Raw_lookupswitch lookupSwitch = (RawByteCodes.Raw_lookupswitch)sbnode.getTableSwitch();
                    ProducerConsumerStack entryStack = this.bnode.getAinfo().entryStack;
                    int srcSize = this.normalizeProducersSize(this.bnode, entryStack.size() - 1);
                    if (srcSize == 0) {
                        srcSize = 3;
                    }
                    String key_type = AOTCompiler.getTypeCast(srcSize);
                    localVariables.print("   " + key_type + " key_" + key_type + ";\n");
                    sm.pop("   key_" + key_type, srcSize);
                    output.append("   switch (key_" + key_type + ") {\n");
                    RawByteCodes.Raw_lookupswitch.Pair[] value1_type = lookupSwitch.pairs;
                    int operand = lookupSwitch.pairs.length;
                    int target = 0;
                    while (target < operand) {
                        RawByteCodes.Raw_lookupswitch.Pair pair = value1_type[target];
                        output.append("   case " + pair.match + ":\n");
                        BNode target2 = sbnode.findTarget(pair.offset);
                        this.handleBranch(sm, this.currentMethodCode[pc], pc, target2.getAddress(), true);
                        output.append("      goto L" + target2.getAddress() + ";\n");
                        ++target;
                    }
                    output.append("   default:\n");
                    BNode target3 = sbnode.findTarget(lookupSwitch.defaultVal);
                    this.handleBranch(sm, this.currentMethodCode[pc], pc, target3.getAddress(), true);
                    output.append("      goto L" + target3.getAddress() + ";\n");
                    output.append("   }\n");
                    pc += 12 + lookupSwitch.pairs.length * 8;
                    break;
                }
                case -121: {
                    sm.flush(true);
                    localVariables.print("   int32 lsb_int32;\n");
                    output.append("      lsb_int32 = *(--sp);\n");
                    output.append("      *(double*)sp = (double)lsb_int32;\n");
                    output.append("      sp+=2;\n");
                    ++pc;
                    break;
                }
                case -123: {
                    localVariables.print("   int32 lsb_int32;\n");
                    localVariables.print("   int32 msb_int32;\n");
                    sm.pop("      lsb_int32", 3);
                    output.append("      if (lsb_int32 < 0) {\n");
                    output.append("         msb_int32 = -1;\n");
                    output.append("      } else {\n");
                    output.append("         msb_int32 = 0;\n");
                    output.append("      }\n");
                    sm.push(3, "msb_int32");
                    sm.push(3, "lsb_int32");
                    ++pc;
                    break;
                }
                case -115: {
                    sm.flush(true);
                    localVariables.print("   double d_ouble;\n");
                    output.append("   d_ouble = (double) (*(float*) (sp - 1));\n");
                    output.append("   *(double*) (sp - 1) = d_ouble;\n");
                    output.append("   sp++;\n");
                    ++pc;
                    break;
                }
                case 91: {
                    localVariables.print("   int32 value1;\n");
                    localVariables.print("   int32 value2;\n");
                    localVariables.print("   int32 value3;\n");
                    sm.pop("      value1", 3);
                    sm.pop("      value2", 3);
                    sm.pop("      value3", 3);
                    sm.push(3, "value1");
                    sm.push(3, "value3");
                    sm.push(3, "value2");
                    sm.push(3, "value1");
                    ++pc;
                    break;
                }
                case 92: {
                    localVariables.print("   int32 value1;\n");
                    localVariables.print("   int32 value2;\n");
                    sm.pop("      value1", 3);
                    sm.pop("      value2", 3);
                    sm.push(3, "value2");
                    sm.push(3, "value1");
                    sm.push(3, "value2");
                    sm.push(3, "value1");
                    ++pc;
                    break;
                }
                case 90: {
                    localVariables.print("   int32 value1;\n");
                    localVariables.print("   int32 value2;\n");
                    sm.pop("      value1", 3);
                    sm.pop("      value2", 3);
                    sm.push(3, "value1");
                    sm.push(3, "value2");
                    sm.push(3, "value1");
                    ++pc;
                    break;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int index = this.currentMethodCode[pc] - 38;
                    sm.push(3, sm.getLocal(index, this.getOriginalAddress(pc)));
                    sm.push(3, sm.getLocal(index + 1, this.getOriginalAddress(pc)));
                    ++pc;
                    break;
                }
                case -109: {
                    localVariables.print("   short int sresult;\n");
                    sm.pop("      sresult", 3);
                    sm.push(3, "sresult");
                    ++pc;
                    break;
                }
                case 117: {
                    localVariables.print("   uint32 lsb_uint32;\n");
                    localVariables.print("   uint32 msb_uint32;\n");
                    sm.pop("      lsb_uint32", 3);
                    sm.pop("      msb_uint32", 3);
                    output.append("      neg(&msb_uint32, &lsb_uint32);\n");
                    sm.push(3, "msb_uint32");
                    sm.push(3, "lsb_uint32");
                    this.requiredIncludes.print("extern void neg(uint32* msb, uint32* lsb);\n");
                    ++pc;
                    break;
                }
                case -120: {
                    localVariables.print("   int32 lsi;\n");
                    sm.pop("      lsi", 3);
                    sm.pop(null, 3);
                    sm.push(3, "lsi");
                    ++pc;
                    break;
                }
                case -119: {
                    localVariables.print("   float f_lsi;\n");
                    sm.pop("      f_lsi", 4);
                    sm.pop(null, 4);
                    sm.push(4, "f_lsi");
                    ++pc;
                    break;
                }
                case -62: 
                case -61: {
                    localVariables.print("   unsigned char* cobj;\n");
                    sm.popRef("cobj");
                    AOTCompiler.checkObject(output, localVariables, pc, labelsManager, null, "   ", sm, "cobj");
                    String isEnter = this.currentMethodCode[pc] == -62 ? "1" : "0";
                    output.append("   handleMonitorEnterExit((Object*)cobj, " + isEnter + ", sp, \"\");\n");
                    ++pc;
                    this.requiredIncludes.print("extern unsigned char handleMonitorEnterExit(Object* lockObj, unsigned char isEnter, int32* sp, const char* fromMethod);\n");
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    sm.push(4, "" + (this.currentMethodCode[pc] - 11));
                    ++pc;
                    break;
                }
                case -107: 
                case -106: {
                    String left;
                    String right;
                    if (sm.isCached(0) && sm.isCached(1)) {
                        right = sm.peekTop(1, 3);
                        left = sm.peekTop(2, 3);
                        sm.pop(null, 3);
                        sm.pop(null, 3);
                    } else {
                        localVariables.print("   float lsb_float;\n");
                        localVariables.print("   float msb_float;\n");
                        sm.pop("      lsb_float", 4);
                        sm.pop("      msb_float", 4);
                        left = "msb_float";
                        right = "lsb_float";
                    }
                    output.append("    if (" + left + " > " + right + ") {\n");
                    output.append("        res = 1;\n");
                    output.append("     } else if (" + right + " > " + left + ") {\n");
                    output.append("        res = -1;\n");
                    output.append("     } else {\n");
                    output.append("        res = 0;\n");
                    output.append("     }\n");
                    int valueSize = this.getConsumerSize(pc, 0);
                    if (valueSize == 0) {
                        valueSize = 1;
                    }
                    localVariables.print("   uint8 res;\n");
                    sm.push(valueSize, "(uint8)res");
                    ++pc;
                    break;
                }
                case -122: {
                    localVariables.print("   int i_nt;\n");
                    sm.pop("      i_nt", 3);
                    sm.push(4, "i_nt");
                    ++pc;
                    break;
                }
                case -117: {
                    localVariables.print("   float f_loat;\n");
                    sm.pop("      f_loat", 4);
                    sm.push(3, "f_loat");
                    ++pc;
                    break;
                }
                case -116: {
                    localVariables.print("   float f_loat;\n");
                    sm.pop("      f_loat", 4);
                    sm.push(3, "0");
                    sm.push(3, "f_loat");
                    ++pc;
                    break;
                }
                case 95: {
                    localVariables.print("   float f_loat1;\n");
                    localVariables.print("   float f_loat2;\n");
                    sm.pop("      f_loat1", 4);
                    sm.pop("      f_loat2", 4);
                    sm.push(3, "f_loat1");
                    sm.push(3, "f_loat2");
                    ++pc;
                    break;
                }
                case -60: {
                    int size;
                    byte opcode = this.currentMethodCode[pc + 1];
                    int inx = this.currentMethodCode[pc + 2] << 8 & 0xFFFF;
                    inx |= this.currentMethodCode[pc + 3] & 0xFF;
                    switch (opcode) {
                        case -124: {
                            byte localVarNo = this.currentMethodCode[pc + 4];
                            byte constVal = this.currentMethodCode[pc + 5];
                            size = this.getLocalVariableSize(localVarNo, this.bnode.getOriginalAddress());
                            String cast = AOTCompiler.getTypeCast(size);
                            output.append("   " + sm.getLocal(localVarNo, this.bnode.getOriginalAddress()) + " = (" + cast + ")" + sm.getLocal(localVarNo, this.bnode.getOriginalAddress()) + " + " + constVal + ";\n");
                            break;
                        }
                        case 21: 
                        case 23: 
                        case 25: {
                            int valueSize = this.getConsumerSize(pc, 0);
                            if (valueSize == 0) {
                                valueSize = this.getProducersSize(pc, 0);
                            }
                            int srcSize = this.getLocalVariableSize(inx, this.bnode.getOriginalAddress());
                            String srcCast = AOTCompiler.getTypeCast(srcSize);
                            sm.load(srcSize, inx, pc);
                            sm.push(valueSize, "(" + srcCast + ")" + sm.getLocal(inx, this.bnode.getOriginalAddress()));
                            break;
                        }
                        case 22: 
                        case 24: {
                            sm.push(3, sm.getLocal(inx, this.getOriginalAddress(pc)));
                            sm.push(3, sm.getLocal(inx + 1, this.getOriginalAddress(pc)));
                            break;
                        }
                        case 54: 
                        case 56: 
                        case 58: {
                            int valueSize;
                            switch (opcode) {
                                case 54: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: {
                                    valueSize = this.getIStoreSize(this.bnode, this.currentMethodCode[pc]);
                                    break;
                                }
                                default: {
                                    valueSize = 4;
                                }
                            }
                            sm.setLocal(valueSize, inx, pc);
                            String dst = this.bnode.isRedundant() ? null : "   " + sm.getLocal(inx, this.bnode.getOriginalAddress());
                            sm.pop(dst, valueSize);
                            break;
                        }
                        case 55: 
                        case 57: {
                            sm.pop("   " + sm.getLocal(inx + 1, this.getOriginalAddress(pc)), 3);
                            sm.pop("   " + sm.getLocal(inx, this.getOriginalAddress(pc)), 3);
                            break;
                        }
                    }
                    if (opcode == -124) {
                        pc += 6;
                        break;
                    }
                    pc += 4;
                    break;
                }
                default: {
                    throw new Exception("unsupported byte code [" + Integer.toHexString(this.currentMethodCode[pc]) + "]");
                }
            }
            if (!compileOne) continue;
            return;
        }
    }

    public abstract void addUserIncludes(NoDuplicatesMemorySegment var1, String var2);

    static boolean synchronizedSupported(Method referredMethod) {
        return !referredMethod.isStatic() && !referredMethod.isNative() && referredMethod.isSynchronized();
    }

    @Override
    public void setSPUsed(boolean b) {
        this.spUsed |= b;
    }

    private int getOriginalAddress(int pc) {
        BNode bnode = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), pc);
        return bnode.getOriginalAddress();
    }

    protected void handleLabel(StackManager sm) {
        sm.flush(true);
    }

    protected void handleBranch(StackManager sm, byte opcode, int pc, int i, boolean doit) throws Exception {
        if (opcode != -85 && opcode != -86) {
            sm.flush(doit);
        }
    }

    private int getProducersSize(int pc, int index) throws Exception {
        BNode bnode = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), pc);
        ProducerConsumerStack exitStack = bnode.getAinfo().exitStack;
        int stackCellIndex = exitStack.size() - 1 - index;
        BNode consumer = exitStack.getCell(stackCellIndex).getConsumer();
        int producerSize = this.normalizeProducersSize(consumer, stackCellIndex);
        return producerSize;
    }

    private int getConsumerSize(int pc, int index) throws Exception {
        BNode bnode = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), pc);
        ProducerConsumerStack exitStack = bnode.getAinfo().exitStack;
        int stackCellIndex = exitStack.size() - 1 - index;
        BNode consumer = exitStack.getCell(stackCellIndex).getConsumer();
        int consumerSize = this.normalizeConsumerSize(consumer, stackCellIndex);
        return consumerSize;
    }

    public static String getPointerCast(int size) {
        StringBuffer type = new StringBuffer();
        type.append("(");
        type.append(AOTCompiler.getTypeCast(size));
        type.append("*)");
        return type.toString();
    }

    public static String getTypeCast(int size) {
        String type = "";
        switch (size) {
            case 1: {
                type = "int8";
                break;
            }
            case 2: {
                type = "int16";
                break;
            }
            case 3: {
                type = "int32";
                break;
            }
            case 4: {
                type = "float";
                break;
            }
            default: {
                type = "int32";
            }
        }
        return type;
    }

    public static int getReturntypeSize(Method method) throws Exception {
        Type type = method.getReturnType();
        return AOTCompiler.type2Size(type);
    }

    private static int type2Size(Type type) throws Exception {
        int size = ClassfileUtils.getSizeOfType(type);
        switch (size) {
            case 1: 
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 32: {
                return 3;
            }
            case 64: {
                return 5;
            }
        }
        return 3;
    }

    private int getArgumentSize(MethodCallBNode consumer, int stackCellIndex) throws ClassNotFoundException, Exception {
        MethodOrFieldDesc methodDesc;
        Method referredMethod = this.getCalleeMethodFromBNode(consumer);
        if (AOTCompiler.interpretMethod(referredMethod, methodDesc = this.getCalleeMethodDescriptorFromBNode(consumer), this.toolBox.getCregistry())) {
            return 3;
        }
        int top = consumer.getAinfo().entryStack.size() - 1;
        Type[] args = referredMethod.getArgumentTypes();
        if (args != null) {
            int index = args.length;
            while (index > 0) {
                Type arg = args[index - 1];
                if (AOTCompiler.type2Size(arg) == 5) {
                    if (top == stackCellIndex || top - 1 == stackCellIndex) {
                        return 3;
                    }
                    --top;
                } else if (top == stackCellIndex) {
                    return AOTCompiler.type2Size(arg);
                }
                --index;
                --top;
            }
        }
        if (consumer.getOpCode() != -72 && top == stackCellIndex) {
            return 3;
        }
        throw new Exception("Unexpected stack cell index");
    }

    private Method getCalleeMethodFromBNode(MethodCallBNode consumer) throws ClassNotFoundException, Exception {
        Method referredMethod;
        if (consumer.getOpCode() == -74) {
            referredMethod = ((VirtualMethodCallBNode)consumer).getCallee();
        } else if (consumer.getOpCode() == -71) {
            MethodOrFieldDesc methodDesc = ((InterfaceMethodCallBNode)consumer).getMethodDescriptor();
            referredMethod = ClassfileUtils.findDeclaringInterface(methodDesc.getClassName(), methodDesc.getName(), methodDesc.getSignature()).getMethod();
        } else {
            int methodNumber = this.currentMethodCode[consumer.getAddress() + 1] << 8;
            MethodOrFieldDesc methodDesc = this.toolBox.getPatcher().getMethodDescriptor(methodNumber |= this.currentMethodCode[consumer.getAddress() + 2] & 0xFF);
            referredMethod = ClassfileUtils.findMethod(methodDesc.getClassName(), methodDesc.getName(), methodDesc.getSignature()).getMethod();
        }
        return referredMethod;
    }

    private MethodOrFieldDesc getCalleeMethodDescriptorFromBNode(MethodCallBNode consumer) throws ClassNotFoundException, Exception {
        MethodOrFieldDesc methodDesc;
        if (consumer.getOpCode() == -74) {
            methodDesc = ((VirtualMethodCallBNode)consumer).getMethodDescriptor();
        } else if (consumer.getOpCode() == -71) {
            methodDesc = ((InterfaceMethodCallBNode)consumer).getMethodDescriptor();
        } else {
            int methodNumber = this.currentMethodCode[consumer.getAddress() + 1] << 8;
            methodDesc = this.toolBox.getPatcher().getMethodDescriptor(methodNumber |= this.currentMethodCode[consumer.getAddress() + 2] & 0xFF);
        }
        return methodDesc;
    }

    private int normalizeProducersSize(BNode consumer, int stackCellIndex) throws Exception {
        if (this.consumerSupported(consumer.getOpCode())) {
            ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
            ProducerConsumerCellInfo consumedCell = entryStack.getCell(stackCellIndex);
            Iterator<BNode> producers = consumedCell.getProducers().iterator();
            int size = 0;
            while (producers.hasNext()) {
                int producerSize = this.getProducerSize(producers.next(), stackCellIndex);
                if (producerSize <= size) continue;
                size = producerSize;
            }
            return size;
        }
        return 3;
    }

    private boolean consumerSupported(byte opCode) {
        switch (opCode) {
            case -111: 
            case -110: 
            case -107: 
            case -106: 
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -86: 
            case -85: 
            case -84: 
            case -82: 
            case -80: 
            case -79: 
            case -77: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -68: 
            case -66: 
            case -65: 
            case -63: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 116: 
            case 118: 
            case 120: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    private int normalizeConsumerSize(BNode consumer, int stackCellIndex) throws Exception {
        byte opCode = consumer.getOpCode();
        if (this.consumerSupported(opCode)) {
            switch (opCode) {
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 118: {
                    return 4;
                }
                case -107: 
                case -106: {
                    return 3;
                }
                case -86: 
                case -85: {
                    return 0;
                }
                case -76: {
                    return 3;
                }
                case 116: {
                    return 0;
                }
                case 120: 
                case 122: 
                case 124: {
                    ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
                    if (entryStack.size() - 1 == stackCellIndex) {
                        return 1;
                    }
                    if (entryStack.size() - 1 != stackCellIndex) break;
                    return 0;
                }
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
                    if (entryStack.size() - 1 == stackCellIndex) {
                        return 0;
                    }
                    if (entryStack.size() - 2 != stackCellIndex) break;
                    return 3;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
                    if (entryStack.size() - 1 == stackCellIndex) {
                        switch (opCode) {
                            case 79: 
                            case 81: 
                            case 83: 
                            case 85: {
                                return 3;
                            }
                            case 84: {
                                return 1;
                            }
                            case 86: {
                                return 2;
                            }
                        }
                        break;
                    }
                    if (entryStack.size() - 2 == stackCellIndex) {
                        return 0;
                    }
                    if (entryStack.size() - 3 != stackCellIndex) break;
                    return 3;
                }
                case 80: {
                    ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
                    if (entryStack.size() - 1 == stackCellIndex) {
                        return 3;
                    }
                    if (entryStack.size() - 2 == stackCellIndex) {
                        return 3;
                    }
                    if (entryStack.size() - 3 == stackCellIndex) {
                        return 0;
                    }
                    if (entryStack.size() - 4 != stackCellIndex) break;
                    return 3;
                }
                case -68: {
                    return 2;
                }
                case -66: {
                    return 3;
                }
                case -77: 
                case -75: {
                    if (stackCellIndex == consumer.getAinfo().entryStack.size() - 1) {
                        short fsize = (short)(this.currentMethodCode[consumer.getAddress() + 3] & 0xFF);
                        switch (fsize & 0xFC) {
                            case 16: {
                                return 2;
                            }
                            case 8: {
                                return 1;
                            }
                        }
                        return 3;
                    }
                    if (stackCellIndex != consumer.getAinfo().entryStack.size() - 2) break;
                    return 3;
                }
                case -82: 
                case -80: 
                case -79: {
                    return 3;
                }
                case -84: {
                    return AOTCompiler.getReturntypeSize(this.javaMethod);
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    return 0;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: {
                    return 0;
                }
                case -91: 
                case -90: {
                    return 3;
                }
                case -63: {
                    return 3;
                }
                case 56: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    return 3;
                }
                case 54: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    return this.getIStoreSize(consumer, opCode);
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    return this.getArgumentSize((MethodCallBNode)consumer, stackCellIndex);
                }
                case -65: {
                    ProducerConsumerStack entryStack = consumer.getAinfo().entryStack;
                    int top = entryStack.size() - 1;
                    while (top >= 0) {
                        if (top == stackCellIndex) {
                            return 1;
                        }
                        --top;
                    }
                    throw new Exception("Unexpected stack cell index");
                }
                case -111: 
                case -110: {
                    return 1;
                }
                case -128: 
                case -126: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 126: {
                    return 0;
                }
            }
        }
        return 3;
    }

    private int getIStoreSize(BNode consumer, byte opCode) {
        int index = opCode == 54 ? consumer.getRawBytes()[1] : opCode - 59;
        return this.getLocalVariableSize(index, consumer.getOriginalAddress() + 1);
    }

    private int getProducerSize(BNode producer, int stackCellIndex) throws Exception {
        switch (producer.getOpCode()) {
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 118: {
                return 4;
            }
            case 46: 
            case 47: 
            case 48: 
            case 50: {
                return 3;
            }
            case 51: 
            case 52: {
                return 1;
            }
            case 53: {
                return 2;
            }
            case -68: {
                return 3;
            }
            case -66: {
                return 2;
            }
            case -78: 
            case -76: {
                short fsize = (short)(this.currentMethodCode[producer.getAddress() + 3] & 0xFF);
                switch (fsize & 0xFC) {
                    case 32: 
                    case 64: {
                        return 3;
                    }
                    case 16: {
                        return 2;
                    }
                    case 8: {
                        return 1;
                    }
                }
                break;
            }
            case 17: {
                return 2;
            }
            case -63: {
                return 1;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 4;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                int index = producer.getOpCode() == 21 ? producer.getRawBytes()[1] : producer.getOpCode() - 26;
                if (producer.getAinfo().exitStack.size() != stackCellIndex + 1) break;
                return this.getLocalVariableSize(index, producer.getOriginalAddress());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                if (producer.getAinfo().exitStack.size() != stackCellIndex + 1) break;
                return 1;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                MethodCallBNode methodCall = (MethodCallBNode)producer;
                Method referredMethod = this.getCalleeMethodFromBNode(methodCall);
                int size = AOTCompiler.getReturntypeSize(referredMethod);
                if (size <= 3) {
                    if (producer.getAinfo().exitStack.size() != stackCellIndex + 1) break;
                    return size;
                }
                if (producer.getAinfo().exitStack.size() != stackCellIndex + 1 && producer.getAinfo().exitStack.size() != stackCellIndex + 2) break;
                return 3;
            }
            case -65: {
                return 3;
            }
            case -128: 
            case -126: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                ProducerConsumerStack exitStack = producer.getAinfo().exitStack;
                int dstSize = this.normalizeConsumerSize(exitStack.peek().getConsumer(), exitStack.size() - 1);
                if (dstSize == 0) {
                    dstSize = 3;
                }
                return dstSize;
            }
            case -111: 
            case -110: {
                return 1;
            }
            default: {
                return 3;
            }
        }
        return 3;
    }

    private int getLocalVariableSize(int index, int pc) {
        LocalVariableTable localVariableTable = this.javaMethod.getLocalVariableTable();
        if (localVariableTable != null) {
            LocalVariable var = localVariableTable.getLocalVariable(index, pc);
            if (var != null) {
                return AOTCompiler.getVariableSize(var);
            }
            LocalVariable[] variables = localVariableTable.getLocalVariableTable();
            int size = 0;
            int i = 0;
            while (i < variables.length) {
                int currentSize;
                var = variables[i];
                if (var.getIndex() == index && (currentSize = AOTCompiler.getVariableSize(var)) > size) {
                    size = currentSize;
                }
                ++i;
            }
            if (size == 0) {
                size = 3;
            }
            return size;
        }
        return 3;
    }

    public static int getVariableSize(LocalVariable var) {
        String sig = Utility.signatureToString((String)var.getSignature());
        if (sig.equals("byte")) {
            return 1;
        }
        if (sig.equals("short")) {
            return 2;
        }
        if (sig.equals("boolean")) {
            return 1;
        }
        if (sig.equals("float")) {
            return 4;
        }
        return 3;
    }

    private void adjustArrayPointer(StringBuffer output, int elementSize, String obj, String index) {
        switch (elementSize) {
            case 1: {
                output.append("      " + obj + " = " + obj + " + sizeof(Object) + 2 + " + index + ";\n");
                break;
            }
            case 2: {
                output.append("      " + obj + " = " + obj + " + sizeof(Object) + 2 + (" + index + " << 1);\n");
                break;
            }
            case 4: {
                output.append("      " + obj + " = " + obj + " + sizeof(Object) + 2 + (" + index + " << 2);\n");
                break;
            }
            case 8: {
                output.append("      " + obj + " = " + obj + " + sizeof(Object) + 2 + (" + index + " << 3);\n");
            }
        }
    }

    private int getElementSize(int pc) {
        int elementSize = 0;
        switch (this.currentMethodCode[pc]) {
            case 48: 
            case 81: {
                elementSize = 4;
                break;
            }
            case 50: 
            case 83: {
                elementSize = 4;
                break;
            }
            case 51: 
            case 84: {
                elementSize = 1;
                break;
            }
            case 52: 
            case 85: {
                elementSize = 4;
                break;
            }
            case 53: 
            case 86: {
                elementSize = 2;
                break;
            }
            case 47: 
            case 80: {
                elementSize = 8;
                break;
            }
            case 46: 
            case 79: {
                elementSize = 4;
            }
        }
        return elementSize;
    }

    private void handleExceptionOccurred(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, String returnValueString, String indent, StackManager sm, MethodOrFieldDesc methodDesc, String exceptionVariable, MethodEntryPoints entrypoints, String noExceptionCondition, boolean negateExceptionValue) throws Exception {
        boolean testIt = false;
        if (methodDesc != null) {
            if (this.mayThrowExceptions(methodDesc.getClassName(), methodDesc.getName(), methodDesc.getSignature())) {
                testIt = true;
            }
        } else {
            testIt = true;
        }
        if (testIt) {
            output.append(String.valueOf(indent) + "   if (" + noExceptionCondition + ") {\n");
        }
        if (returnValueString != null) {
            output.append(String.valueOf(indent) + returnValueString);
            this.setSPUsed(true);
        } else if (testIt) {
            output.append(String.valueOf(indent) + "      ;\n");
        }
        if (testIt) {
            output.append(String.valueOf(indent) + "   }\n");
            output.append(String.valueOf(indent) + "   else\n");
            output.append(String.valueOf(indent) + "   {\n");
            if (negateExceptionValue) {
                output.append(String.valueOf(indent) + "   " + exceptionVariable + " = -" + exceptionVariable + ";\n");
            }
            this.handleIt(output, localVariables, pc, labelsManager, indent, sm, exceptionVariable, entrypoints);
            output.append(String.valueOf(indent) + "   }\n");
        }
    }

    protected boolean mayThrowExceptions(String className, String targetMethodName, String targetMethodSignature) {
        return true;
    }

    private void handleIt(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, String indent, StackManager sm, String exceptionVariable, MethodEntryPoints entrypoints) throws Exception {
        this.setSPUsed(true);
        if (AOTCompiler.hasExceptionHandlers(this.javaMethod)) {
            output.append(String.valueOf(indent) + "      sp++;\n");
            output.append(String.valueOf(indent) + "      pc = " + pc + ";\n");
            labelsManager.jumpTo(sm, true);
            output.append(String.valueOf(indent) + "      excep = " + exceptionVariable + ";\n");
            output.append(String.valueOf(indent) + "      goto " + "throwIt" + ";\n");
            localVariables.print("   unsigned short pc;\n");
            labelsManager.generateThrowIt();
        } else {
            output.append(String.valueOf(indent) + "      fp[0] = *sp;\n");
            if (entrypoints.useCombinedReturnType()) {
                exceptionVariable = "-" + exceptionVariable;
            }
            output.append(this.generateReturnStatement(String.valueOf(indent) + "      return " + exceptionVariable + ";\n"));
        }
    }

    private void adjustStackAndCheckObject(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, int numArgs, String getObjectInfo, String indent, StackManager sm) throws Exception {
        output.append(String.valueOf(indent) + "   sp -= " + numArgs + ";\n");
        this.setSPUsed(true);
        if (this.currentMethodCode[pc] != -72) {
            boolean checkIt = this.nullPointerCheckRequired(pc, numArgs);
            if (checkIt) {
                output.append(String.valueOf(indent) + "   i_obj = (Object*) (pointer) *sp;\n");
                AOTCompiler.checkObject(output, localVariables, pc, labelsManager, getObjectInfo, indent, sm, "i_obj");
                localVariables.print("   Object* i_obj;\n");
            } else if (getObjectInfo != null && getObjectInfo.trim().length() > 0) {
                output.append(String.valueOf(indent) + "   i_obj = (Object*) (pointer) *sp;\n");
                output.append(String.valueOf(indent) + getObjectInfo);
                localVariables.print("   Object* i_obj;\n");
            }
        }
    }

    protected boolean nullPointerCheckRequired(int pc, int numArgs) {
        BNode bnode = this.toolBox.getDependencyExtent().getBNodeFromMethod(this.toolBox.getCurrentClassName(), this.javaMethod.getName(), this.javaMethod.getSignature(), pc);
        return AOTCompiler.nullPointerCheckRequired(numArgs, bnode);
    }

    public static boolean nullPointerCheckRequired(int numArgs, BNode bnode) {
        AbstractStack stackLayout = bnode.getStackLayout();
        AbstractStack.StackCell cell = stackLayout.getAt(stackLayout.getSize() - numArgs);
        boolean checkIt = true;
        if (cell.content instanceof RefType && ((RefType)cell.content).getState() == RefType.RefState.NONNULL) {
            checkIt = false;
        }
        return checkIt;
    }

    static void checkObject(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, String getObjectInfo, String indent, StackManager sm, String obj) throws Exception {
        output.append(String.valueOf(indent) + "      if (" + obj + " == 0) {\n");
        output.append(String.valueOf(indent) + "         pc = " + pc + ";\n");
        labelsManager.jumpTo(sm);
        output.append(String.valueOf(indent) + "         goto " + "throwNullPointer" + ";\n");
        output.append(String.valueOf(indent) + "      }\n");
        if (getObjectInfo != null) {
            output.append(String.valueOf(indent) + getObjectInfo);
        }
        labelsManager.generateThrowNullPointer();
        localVariables.print("   unsigned short pc;\n");
    }

    public static boolean interpretMethod(Method referredMethod, MethodOrFieldDesc methodDesc, ICompilationRegistry registry) {
        return referredMethod.getCode() != null && !Compiler.compileMethod(registry, referredMethod, methodDesc);
    }

    private static boolean hasExceptionHandlers(Method javaMethod) {
        Code codeAttr = javaMethod.getCode();
        return codeAttr.getExceptionTable().length > 0;
    }

    private static boolean isExceptionHandler(Method javaMethod, int pc) {
        Code codeAttr = javaMethod.getCode();
        if (codeAttr != null) {
            CodeException[] handlers;
            CodeException[] codeExceptionArray = handlers = codeAttr.getExceptionTable();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                CodeException codeException = codeExceptionArray[n2];
                if (codeException.getHandlerPC() == pc) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int handleOneArgBranch(StackManager sm, byte[] currentMethodCode, int pc, StringBuffer output, BNode bnode, NoDuplicatesMemorySegment localVariables) throws Exception {
        String left;
        short code = (short)(currentMethodCode[pc] & 0xFF);
        int size = this.normalizeProducersSize(bnode, bnode.getAinfo().entryStack.size() - 1);
        String type = AOTCompiler.getTypeCast(size);
        String comparison = null;
        String operator = "";
        if (sm.isCached(0)) {
            left = sm.peekTop(1, size);
            sm.pop(null, size);
        } else {
            localVariables.print("   " + type + " msb_" + type + ";\n");
            sm.pop("      msb_" + type, size);
            left = "msb_" + type;
        }
        switch ((byte)code) {
            case -103: 
            case -58: {
                operator = "==";
                break;
            }
            case -102: 
            case -57: {
                operator = "!=";
                break;
            }
            case -101: {
                operator = "<";
                break;
            }
            case -100: {
                operator = ">=";
                break;
            }
            case -99: {
                operator = ">";
                break;
            }
            case -98: {
                operator = "<=";
            }
        }
        comparison = "(" + left + " " + operator + " 0)";
        output.append("      if " + comparison + " {\n");
        short branchbyte1 = (short)(currentMethodCode[pc + 1] & 0xFF);
        short branchbyte2 = (short)(currentMethodCode[pc + 2] & 0xFF);
        short offset = (short)(branchbyte1 << 8 | branchbyte2);
        this.yield(output, offset);
        this.handleBranch(sm, currentMethodCode[pc], pc, pc + offset, false);
        output.append("         goto L" + (pc + offset) + ";\n");
        output.append("      }\n");
        return 3;
    }

    protected void yield(StringBuffer output, short offset) {
        if (offset <= 0 && this.toolBox.getObserver().isMethodUsed("vm.ClockInterruptHandler", "enable", "()V")) {
            String pp;
            if (this.spUsed) {
                pp = "sp";
            } else {
                int stackOffset = Compiler.getMaxLocals(this.javaMethod.getCode());
                pp = "&fp[" + (stackOffset + 2) + "]";
            }
            output.append("   yieldToScheduler(" + pp + ");\n");
            this.requiredIncludes.print("extern int16 yieldToScheduler(int32 *sp);\n");
        }
    }

    private int handleTwoArgBranch(StackManager sm, byte[] currentMethodCode, int pc, StringBuffer output, BNode bnode, NoDuplicatesMemorySegment localVariables) throws Exception {
        String left;
        String right;
        short code = (short)(currentMethodCode[pc] & 0xFF);
        String comparison = null;
        int topSize = this.normalizeProducersSize(bnode, bnode.getAinfo().entryStack.size() - 1);
        int topm1Size = this.normalizeProducersSize(bnode, bnode.getAinfo().entryStack.size() - 2);
        String lsbType = AOTCompiler.getTypeCast(topSize);
        String msbType = AOTCompiler.getTypeCast(topm1Size);
        String operator = "";
        if (sm.isCached(0) && sm.isCached(1)) {
            right = sm.peekTop(1, topSize);
            left = sm.peekTop(2, topm1Size);
            sm.pop(null, topSize);
            sm.pop(null, topSize);
        } else {
            localVariables.print("   " + lsbType + " lsb_" + lsbType + ";\n");
            localVariables.print("   " + msbType + " msb_" + msbType + ";\n");
            sm.pop("      lsb_" + lsbType, topSize);
            sm.pop("      msb_" + msbType, topm1Size);
            left = "msb_" + msbType;
            right = "lsb_" + lsbType;
        }
        switch ((byte)code) {
            case -97: {
                operator = "==";
                break;
            }
            case -96: {
                operator = "!=";
                break;
            }
            case -95: {
                operator = "<";
                break;
            }
            case -94: {
                operator = ">=";
                break;
            }
            case -93: {
                operator = ">";
                break;
            }
            case -92: {
                operator = "<=";
            }
        }
        comparison = "(" + left + " " + operator + " " + right + ")";
        output.append("      if " + comparison + " {\n");
        short branchbyte1 = (short)(currentMethodCode[pc + 1] & 0xFF);
        short branchbyte2 = (short)(currentMethodCode[pc + 2] & 0xFF);
        short offset = (short)(branchbyte1 << 8 | branchbyte2);
        this.yield(output, offset);
        this.handleBranch(sm, currentMethodCode[pc], pc, pc + offset, false);
        output.append("         goto L" + (pc + offset) + ";\n");
        output.append("      }\n");
        return 3;
    }

    @Override
    public String getCurrentMethod() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("class ");
        buffer.append(this.toolBox.getCurrentClassName());
        buffer.append(": ");
        buffer.append(this.javaMethod.getName());
        buffer.append("(");
        buffer.append(this.javaMethod.getSignature());
        buffer.append(") - ");
        buffer.append(this.bnode.toString());
        return buffer.toString();
    }

    private class AOTInvokeSpecialEmitter
    extends InvokeSpecialEmitter {
        AOTInvokeSpecialEmitter(StackManager sm, StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, BNode bnode, byte[] currentMethodCode, NoDuplicatesMemorySegment requiredIncludes, MethodOrFieldDesc methodDesc, AOTToolBox toolBox, MethodEntryPoints entrypoints) {
            super(sm, output, localVariables, pc, labelsManager, bnode, currentMethodCode, requiredIncludes, methodDesc, toolBox, entrypoints);
        }

        @Override
        protected void a_setSPUsed(boolean b) {
            AOTCompiler.this.setSPUsed(b);
        }

        @Override
        protected boolean a_mayThrowExceptions(String className, String name, String signature) {
            return AOTCompiler.this.mayThrowExceptions(className, name, signature);
        }

        @Override
        protected int a_normalizeProducersSize(BNode bnode, int i) throws Exception {
            return AOTCompiler.this.normalizeProducersSize(bnode, i);
        }

        @Override
        protected void a_adjustStackAndCheckObject(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, int numArgs, String getObjectInfo, String string, StackManager sm) throws Exception {
            AOTCompiler.this.adjustStackAndCheckObject(output, localVariables, pc, labelsManager, numArgs, getObjectInfo, string, sm);
        }

        @Override
        protected void a_handleExceptionOccurred(StringBuffer output, NoDuplicatesMemorySegment localVariables, int pc, LabelsManager labelsManager, String returnValueString, String string, StackManager smCopy, MethodOrFieldDesc methodDesc, String exceptionVariable, MethodEntryPoints entrypoints, String noExceptionCondition, boolean negateExceptionValue) throws Exception {
            AOTCompiler.this.handleExceptionOccurred(output, localVariables, pc, labelsManager, returnValueString, string, smCopy, methodDesc, exceptionVariable, entrypoints, noExceptionCondition, negateExceptionValue);
        }
    }

    private class AOTStaticFieldEmitter
    extends StaticFieldEmitter {
        public AOTStaticFieldEmitter(int pc, AOTToolBox toolBox, byte[] currentMethodCode, NoDuplicatesMemorySegment localVariables, StringBuffer output, StackManager sm, NoDuplicatesMemorySegment requiredIncludes, BNode bnode) {
            super(pc, toolBox, currentMethodCode, localVariables, output, sm, requiredIncludes, bnode);
        }

        @Override
        protected void a_addUserIncludes(NoDuplicatesMemorySegment requiredIncludes, String includes) {
            AOTCompiler.this.addUserIncludes(requiredIncludes, includes);
        }

        @Override
        protected int a_normalizeConsumerSize(BNode bnode, int i) throws Exception {
            return AOTCompiler.this.normalizeConsumerSize(bnode, i);
        }
    }
}

