/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.MethodOrFieldDesc;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class VirtualTable {
    ArrayList<MethodOrFieldDesc> methods = new ArrayList();

    public short getIndexOf(MethodOrFieldDesc nextMethod) {
        short index = (short)this.methods.indexOf(nextMethod);
        return index;
    }

    public void add(MethodOrFieldDesc nextMethod) {
        this.methods.add(nextMethod);
    }

    public String toString() {
        Iterator<MethodOrFieldDesc> iterator = this.methods.iterator();
        StringBuffer output = new StringBuffer();
        while (iterator.hasNext()) {
            MethodOrFieldDesc next = iterator.next();
            output.append(String.valueOf(next.getClassName()) + ": [" + next.getName() + next.getSignature() + "]\n");
        }
        return output.toString();
    }

    public void updateClassName(int index, String className) {
        this.methods.get(index).setClassName(className);
    }

    public int getSize() {
        return this.methods.size();
    }

    public Iterator<MethodOrFieldDesc> iterator() {
        return this.methods.iterator();
    }

    public MethodOrFieldDesc getMethod(short index) {
        return this.methods.get(index);
    }

    public static VirtualTable createVTable(String clazzName, AnalysisObserver observer) throws Exception {
        JavaClass clazz = Repository.lookupClass((String)clazzName);
        if (clazz.isInterface()) {
            throw new Exception("Unexpected interface");
        }
        JavaClass superClass = clazz.getSuperClass();
        VirtualTable vtable = superClass != null ? VirtualTable.createVTable(superClass.getClassName(), observer) : new VirtualTable();
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method current = methods[i];
            if (observer.isMethodUsed(clazzName, current.getName(), current.getSignature())) {
                MethodOrFieldDesc nextMethod = new MethodOrFieldDesc(clazz.getClassName(), current.getName(), current.getSignature());
                short index = vtable.getIndexOf(nextMethod);
                if (index == -1) {
                    vtable.add(nextMethod);
                } else {
                    vtable.updateClassName(index, clazz.getClassName());
                }
            }
            ++i;
        }
        return vtable;
    }

    public static short getVTableIndex(MethodOrFieldDesc referredMethod, AnalysisObserver observer) throws Exception {
        VirtualTable table = VirtualTable.createVTable(referredMethod.getClassName(), observer);
        short index = table.getIndexOf(referredMethod);
        return index;
    }

    public static void init() {
    }
}

