/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.FieldOffsetCalculator;
import icecaptools.JavaArrayClass;
import icecaptools.NativeFieldInfo;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.IDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;

public class StructsManager {
    private static final String STATICCLASSFIELDS = "staticClassFields";
    private FieldOffsetCalculator foCalc;
    private StringBuffer objectFieldStructs;
    private StringBuffer classFieldStructs;
    private IDGenerator idGen;
    private HashMap<String, String> classToStructMap;

    public StructsManager(FieldOffsetCalculator foCalc, IDGenerator idGen) {
        this.foCalc = foCalc;
        this.idGen = idGen;
        this.classToStructMap = new HashMap();
    }

    public StringBuffer generateObjectFieldStructs() throws Exception {
        this.objectFieldStructs = new StringBuffer();
        HashMap<JavaClass, ArrayList<FieldInfo>> classFieldsMap = this.foCalc.getObjectFields();
        for (JavaClass clazz : classFieldsMap.keySet()) {
            ArrayList<FieldInfo> fields;
            Iterator<FieldInfo> fieldIterator;
            if (this.foCalc.isHardwareObject(clazz.getClassName()) || clazz instanceof JavaArrayClass || !(fieldIterator = (fields = classFieldsMap.get(clazz)).iterator()).hasNext()) continue;
            HashSet<String> fieldsInStruct = new HashSet<String>();
            String structName = this.startStruct(clazz.getClassName(), this.objectFieldStructs, true);
            while (fieldIterator.hasNext()) {
                FieldInfo field = fieldIterator.next();
                this.addField(structName, field, fieldsInStruct, this.objectFieldStructs);
            }
            this.endStruct(clazz.getClassName(), this.objectFieldStructs);
            this.objectFieldStructs.append("\n");
        }
        return this.objectFieldStructs;
    }

    private String startStruct(String className, StringBuffer buffer, boolean addHeader) {
        String structName = "_" + this.idGen.getUniqueId(className, "c", "s");
        this.classToStructMap.put(className, structName);
        buffer.append("typedef struct PACKED ");
        buffer.append(structName);
        buffer.append(" {\n");
        if (addHeader) {
            buffer.append("    Object header;\n");
        }
        return structName;
    }

    private void endStruct(String className, StringBuffer buffer) {
        buffer.append("} ");
        buffer.append(this.idGen.getUniqueId(className, "c", "s"));
        buffer.append(";\n");
    }

    private void addField(String structName, FieldInfo field, HashSet<String> fieldsInStruct, StringBuffer buffer) throws Exception {
        int fieldSize = field.getSize() & 0xFC;
        String structMemberName = this.idGen.getUniqueId(field.getName(), "f", "s");
        field.setStructMemberName(structMemberName);
        while (fieldsInStruct.contains(structMemberName)) {
            structMemberName = this.idGen.getUniqueId(String.valueOf(structMemberName) + "_", "f", "s");
            field.setStructMemberName(structMemberName);
        }
        fieldsInStruct.add(structMemberName);
        switch (fieldSize) {
            case 8: {
                buffer.append("    uint8 ");
                break;
            }
            case 16: {
                buffer.append("    uint16 ");
                break;
            }
            case 32: {
                if (field.isFloat) {
                    buffer.append("    float ");
                    break;
                }
                buffer.append("    uint32 ");
                break;
            }
            case 64: {
                buffer.append("    uint32 ");
                buffer.append(structMemberName);
                buffer.append(";\n");
                structMemberName = "lsb" + structMemberName;
                buffer.append("    uint32 ");
                field.setStructMemberLSBName(structMemberName);
                break;
            }
            default: {
                throw new Exception("Unknown field size: " + fieldSize);
            }
        }
        buffer.append(structMemberName);
        buffer.append(";\n");
        field.setStructName(structName);
    }

    public StringBuffer generateClassFieldStructs(AnalysisObserver observer) throws Exception {
        this.classFieldStructs = new StringBuffer();
        HashMap<JavaClass, ArrayList<FieldInfo>> classFieldsMap = this.foCalc.getClassFields();
        Iterator<JavaClass> classes = classFieldsMap.keySet().iterator();
        HashSet<String> fieldsInStruct = new HashSet<String>();
        String structName = this.startStruct(STATICCLASSFIELDS, this.classFieldStructs, false);
        while (classes.hasNext()) {
            JavaClass clazz = classes.next();
            ArrayList<FieldInfo> staticFields = classFieldsMap.get(clazz);
            for (FieldInfo nextField : staticFields) {
                NativeFieldInfo nfi = observer.isNativeField(clazz.getClassName(), nextField);
                if (nfi != null) continue;
                this.addField(structName, nextField, fieldsInStruct, this.classFieldStructs);
            }
        }
        this.classFieldStructs.append("    uint8 _dummy_;\n");
        this.endStruct(STATICCLASSFIELDS, this.classFieldStructs);
        return this.classFieldStructs;
    }

    public String getStructName(String className) {
        return this.classToStructMap.get(className);
    }
}

