/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ByteCodePatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StaticInitializersManager {
    private ArrayList<MethodOrFieldDesc> initializers = new ArrayList();
    private HashMap<MethodOrFieldDesc, Integer> methodNumbers = new HashMap();
    private ByteCodePatcher patcher;
    private int numberOfClassInitializers;

    public StaticInitializersManager(ByteCodePatcher patcher) {
        this.patcher = patcher;
        this.numberOfClassInitializers = 0;
    }

    public int getNumberOfClassInitializers() {
        return this.numberOfClassInitializers;
    }

    public void registerStaticInitializer(MethodOrFieldDesc method, int methodNumber) {
        this.initializers.add(method);
        this.methodNumbers.put(method, new Integer(methodNumber));
    }

    public boolean hasClassInitializer(int classIndex) {
        for (MethodOrFieldDesc next : this.initializers) {
            String className = next.getClassName();
            int index = this.patcher.getClassNumber(className);
            if (index != classIndex) continue;
            return true;
        }
        return false;
    }

    public StringBuffer getDecleration(AnalysisObserver observer) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> usedClassInitializers = observer.getUsedClassInitializers();
        ArrayList<Integer> ciSequence = new ArrayList<Integer>();
        while (usedClassInitializers.hasNext()) {
            String nextUsedClassInitializer = usedClassInitializers.next();
            MethodOrFieldDesc desc = this.findDescriptor(nextUsedClassInitializer);
            if (desc == null) continue;
            Integer methodNumber = this.methodNumbers.get(desc);
            ciSequence.add(methodNumber);
            ++this.numberOfClassInitializers;
        }
        if (this.numberOfClassInitializers > 0) {
            buffer.append("RANGE static const short _classInitializerSequence[");
            buffer.append(String.valueOf(this.numberOfClassInitializers) + "] PROGMEM = { ");
            Iterator methods = ciSequence.iterator();
            while (methods.hasNext()) {
                Integer nextMethod = (Integer)methods.next();
                buffer.append(nextMethod);
                if (!methods.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(" };\n");
        }
        return buffer;
    }

    private MethodOrFieldDesc findDescriptor(String nextUsedClassInitializer) {
        for (MethodOrFieldDesc nextDesc : this.initializers) {
            if (!nextDesc.getClassName().equals(nextUsedClassInitializer)) continue;
            return nextDesc;
        }
        return null;
    }
}

