/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.RequiredEntryManager;
import java.util.HashMap;

public class RequiredFieldsManager
extends RequiredEntryManager {
    private HashMap<String, FieldInfo> fields;

    public RequiredFieldsManager(boolean supportLoading) {
        super(supportLoading);
        this.requiredEntries.add("java.lang.String.value");
        this.requiredEntries.add("java.lang.String.offset");
        this.requiredEntries.add("java.lang.String.count");
        this.fields = new HashMap();
    }

    public void registerEntry(String name, int fieldNumber, FieldInfo currentField) {
        super.registerEntry(name, fieldNumber);
        this.fields.put(name, currentField);
    }

    @Override
    protected String getItemName(String next) {
        return String.valueOf(next.toUpperCase().replace(".", "_").replace("[", "_")) + "_offset";
    }

    @Override
    protected StringBuffer getDeclarations(boolean includeRegistered) {
        StringBuffer buffer = new StringBuffer();
        for (String next : this.requiredEntries) {
            FieldInfo val = this.fields.containsKey(next) ? this.fields.get(next) : null;
            if (val != null && !includeRegistered || val == null) continue;
            buffer.append("#define " + next.toUpperCase().replace(".", "_").replace("[", "_") + "_offset " + val.getOffset() + "\n");
        }
        return buffer;
    }
}

