/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class RequiredEntryManager {
    protected ArrayList<String> requiredEntries = new ArrayList();
    private HashMap<String, Integer> createdEntries = new HashMap();
    private boolean supportLoading;

    public void registerEntry(String name, int number) {
        this.createdEntries.put(name, new Integer(number));
    }

    protected RequiredEntryManager(boolean supportLoading) {
        this.supportLoading = supportLoading;
    }

    protected StringBuffer getDeclarations(boolean includeRegistered) {
        StringBuffer buffer = new StringBuffer();
        for (String next : this.requiredEntries) {
            String itemName = this.getItemName(next);
            int val = this.getValue(next);
            if (val != -1 && !includeRegistered) continue;
            buffer.append("#define " + itemName + " " + val + "\n");
        }
        return buffer;
    }

    private int getValue(String next) {
        int val = this.createdEntries.containsKey(next) ? this.createdEntries.get(next) : -1;
        return val;
    }

    protected String getItemName(String next) {
        return next.toUpperCase().replace(".", "_").replace("[", "_");
    }

    public StringBuffer getDeclarations() {
        return this.getDeclarations(true);
    }

    public StringBuffer getUnregisteredDeclarations() {
        return this.getDeclarations(false);
    }

    public void getVariableDeclarations(StringBuffer declarations, StringBuffer initializations) {
        for (String next : this.requiredEntries) {
            String itemName = this.getItemName(next);
            if (this.supportLoading) {
                declarations.append("extern uint16 " + itemName + "_var;\n");
                initializations.append("RANGE uint16 " + itemName + "_var = " + itemName + ";\n");
                continue;
            }
            declarations.append("#define " + itemName + "_var " + itemName + "\n");
        }
    }
}

