/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.IcecapTool;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.compiler.IDGenerator;
import icecaptools.compiler.MemorySegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InterfaceManager {
    private HashMap<String, List<String>> interfaces = new HashMap();
    private HashMap<String, MemorySegment> interfaceMatrixDecls = new HashMap();
    private ArrayList<String> interfacesInMap;
    private HashMap<Integer, String> classInterfaces;
    private HashMap<MethodOrFieldDesc, Integer> interfaceMethodIndices = new HashMap();

    public InterfaceManager(AnalysisObserver observer) {
        this.interfacesInMap = new ArrayList();
        this.classInterfaces = new HashMap();
    }

    public void registerClass(String clazz, String _interface) {
        List<String> implementors = this.interfaces.get(_interface);
        if (implementors == null) {
            implementors = new LinkedList<String>();
            this.interfaces.put(_interface, implementors);
        }
        if (!implementors.contains(clazz)) {
            implementors.add(clazz);
        }
    }

    public void createInterfaceTableDecl(IcecapTool manager, IDGenerator idGen) throws Exception {
        for (String currentInterface : this.interfaces.keySet()) {
            int yDimension = this.getNumberOfInterfaceMethods(currentInterface) + 1;
            int methodNumber = 0;
            while (methodNumber < yDimension - 1) {
                JavaClass clazz = Repository.lookupClass((String)currentInterface);
                Method[] methods = clazz.getMethods();
                Method method = methods[methodNumber];
                MethodOrFieldDesc desc = new MethodOrFieldDesc(currentInterface, method.getName(), method.getSignature());
                this.interfaceMethodIndices.put(desc, new Integer(methodNumber));
                ++methodNumber;
            }
            this.interfaceMatrixDecls.put(currentInterface, new MemorySegment(manager.getProperties()));
            this.interfacesInMap.add(currentInterface);
        }
    }

    private int getNumberOfInterfaceMethods(String currentInterface) throws ClassNotFoundException {
        JavaClass clazz = Repository.lookupClass((String)currentInterface);
        Method[] methods = clazz.getMethods();
        if (methods != null) {
            return methods.length;
        }
        return 0;
    }

    public Iterator<String> getInterfaces() {
        return this.interfacesInMap.iterator();
    }

    public int getInterfaceIndex(String className) throws Exception {
        Iterator<String> interfaces = this.getInterfaces();
        int index = 0;
        className = className.replace("/", ".");
        while (interfaces.hasNext()) {
            String next = interfaces.next();
            if (next.equals(className)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getInterfaceMethodIndex(String className, String methodName, String methodSignature) throws Exception {
        MethodOrFieldDesc desc = new MethodOrFieldDesc(className.replace("/", "."), methodName, methodSignature);
        for (MethodOrFieldDesc next : this.interfaceMethodIndices.keySet()) {
            if (!next.equalsWithClass(className, desc)) continue;
            return this.interfaceMethodIndices.get(next);
        }
        throw new Exception("could not get index for [" + className + "]");
    }

    public int getNumberOfInterfaces() {
        return this.interfaceMatrixDecls.keySet().size();
    }

    public String generateImplementors(AnalysisObserver observer, ByteCodePatcher patcher, IcecapTool manager) throws Exception {
        HashMap<String, ArrayList<String>> classes = new HashMap<String, ArrayList<String>>();
        for (String nextInterface : this.interfaces.keySet()) {
            if (!observer.isInterfaceUsed(nextInterface)) continue;
            List<String> implementors = this.interfaces.get(nextInterface);
            for (String nextClass : implementors) {
                ArrayList<String> implementedInterfaces = (ArrayList<String>)classes.get(nextClass);
                if (implementedInterfaces == null) {
                    implementedInterfaces = new ArrayList<String>();
                    classes.put(nextClass, implementedInterfaces);
                }
                implementedInterfaces.add(nextInterface);
            }
        }
        MemorySegment buffer = new MemorySegment(manager.getProperties());
        for (String nextClass : classes.keySet()) {
            int classNumber = patcher.getClassNumber(nextClass);
            List interfaces = (List)classes.get(nextClass);
            String name = "class" + classNumber + "interfaces";
            buffer.appendCode("RANGE static const unsigned short " + name + "[" + (interfaces.size() + 1) + "] PROGMEM = { ", (interfaces.size() + 1) * 2);
            this.classInterfaces.put(new Integer(classNumber), name);
            buffer.print(String.valueOf(interfaces.size()) + ", ");
            Iterator<String> interfaceIterator = interfaces.iterator();
            while (interfaceIterator.hasNext()) {
                String nextInterface = interfaceIterator.next();
                buffer.print("" + this.getInterfaceIndex(nextInterface));
                if (!interfaceIterator.hasNext()) continue;
                buffer.print(", ");
            }
            buffer.print(" };\n");
        }
        return buffer.toString();
    }

    public String getClassInterfaceName(int classNumber) {
        return this.classInterfaces.get(new Integer(classNumber));
    }
}

