/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.BNode;
import icecaptools.ClassfileUtils;
import icecaptools.DynamicMethodCallVirtualMethodBNode;
import icecaptools.FieldOffsetCalculator;
import icecaptools.IcecapIterator;
import icecaptools.InterfaceMethodCallBNode;
import icecaptools.JavaArrayClass;
import icecaptools.MethodCallBNode;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NewArrayBNode;
import icecaptools.NewArrayMultiBNode;
import icecaptools.RawByteCodes;
import icecaptools.VirtualMethodCallBNode;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.IDGenerator;
import icecaptools.compiler.InterfaceManager;
import icecaptools.compiler.LDCConstant;
import icecaptools.compiler.RequiredMethodVTableIndexManager;
import icecaptools.compiler.VirtualTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class IcecapByteCodePatcher
implements ByteCodePatcher {
    private static final byte INVOKE_CLONE_ONARRAY = -54;
    private static final byte GETHWFIELD_OPCODE = -53;
    private static final byte PUTHWFIELD_OPCODE = -52;
    private static final byte NEWFLASHARRAY_OPCODE = -51;
    private HashMap<String, List<BNode>> registeredBytecodes;
    private HashMap<String, Integer> classNumbers;
    private HashMap<String, MethodAndNumber> methodNumbers = new HashMap();
    private HashMap<String, FieldInfo> objectFields;
    private HashMap<String, FieldInfo> classFields;
    private InterfaceManager iManager;
    private ArrayList<LDCConstant> constants;
    private int numberOfClasses;
    private RequiredMethodVTableIndexManager vtableIndexManager;
    private FieldOffsetCalculator foCalc;
    private FieldInfo[] fieldOffsets;

    public IcecapByteCodePatcher(AnalysisObserver observer, IDGenerator idGen, FieldOffsetCalculator foCalc, boolean supportLoading) {
        this.classNumbers = new HashMap();
        this.objectFields = new HashMap();
        this.classFields = new HashMap();
        this.iManager = new InterfaceManager(observer);
        this.constants = new ArrayList();
        this.numberOfClasses = 0;
        this.registeredBytecodes = new HashMap();
        this.vtableIndexManager = new RequiredMethodVTableIndexManager(idGen, supportLoading);
        this.foCalc = foCalc;
    }

    @Override
    public void patch(String className, String methodName, String methodSignature, byte[] methodCode, AnalysisObserver observer, IDGenerator idGen) throws Exception {
        String key = IcecapByteCodePatcher.createMethodID(className, methodName, methodSignature);
        this.patchNew(className, methodCode, key);
        this.patchInvokeVirtual(className, methodCode, key, observer, idGen);
        this.patchCheckcast(className, methodCode, key);
        this.patchINSTANCEOF(className, methodCode, key);
        this.patchInvokeStatic(className, methodCode, key, methodName, idGen);
        this.patchInvokeSpecial(className, methodCode, key, methodName, idGen);
        this.patchInvokeInterface(className, methodCode, key, methodName, observer, idGen);
        this.patchPutGetField(className, methodCode, key, observer);
        this.patchLDC(className, methodCode, key);
        this.patchNEWARRAYS(className, methodCode, key, methodName);
        this.patchFLASHARRAYS(className, methodCode, key, methodName, observer);
        this.patchInvokeDynamic(className, methodCode, key, methodName, observer);
    }

    private void patchInvokeDynamic(String className, byte[] methodCode, String key, String methodName, AnalysisObserver observer) {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-70});
        while (locationIterator.hasNext()) {
            BNode nextNode = locationIterator.next();
            if (!(nextNode instanceof DynamicMethodCallVirtualMethodBNode)) continue;
            DynamicMethodCallVirtualMethodBNode virtualMethodcallType = (DynamicMethodCallVirtualMethodBNode)nextNode;
            int location = nextNode.getAddress();
            String lambdaClassName = virtualMethodcallType.getLambdaClassName();
            if (!this.classNumbers.containsKey(lambdaClassName)) continue;
            int referredIndex = this.classNumbers.get(lambdaClassName);
            methodCode[location + 1] = (byte)((referredIndex <<= 1) >> 8 & 0xFF);
            methodCode[location + 2] = (byte)(referredIndex & 0xFF);
        }
    }

    private void patchNEWARRAYS(String className, byte[] methodCode, String key, String methodName) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-67, -68, -59});
        while (locationIterator.hasNext()) {
            BNode nextNode = locationIterator.next();
            int location = nextNode.getAddress();
            if (methodCode[location] == -68) {
                byte aType = methodCode[location + 1];
                this.patchBasicArrayType(methodCode, location, aType);
                continue;
            }
            if (methodCode[location] == -67) {
                this.patchReferenceArrayType(className, methodCode, location);
                continue;
            }
            if (methodCode[location] != -59) continue;
            NewArrayMultiBNode multiBNode = (NewArrayMultiBNode)nextNode;
            if (multiBNode.isBasicType()) {
                int aType = multiBNode.getBasicType();
                this.patchBasicArrayType(methodCode, location, aType);
            } else {
                this.patchReferenceArrayType(className, methodCode, location);
            }
            methodCode[location + 3] = (byte)multiBNode.getDimension();
        }
    }

    protected void patchReferenceArrayType(String className, byte[] methodCode, int location) throws Exception {
        byte indexByte1 = methodCode[location + 1];
        byte indexByte2 = methodCode[location + 2];
        String referredClassName = ClassfileUtils.getClassName(className, indexByte1 & 0xFF, indexByte2 & 0xFF);
        Integer classIndex = this.classNumbers.get("[L" + referredClassName + ";");
        if (classIndex == null) {
            StringBuffer buffer = this.classNumberNotFound(referredClassName);
            throw new Exception(buffer.toString());
        }
        int index = classIndex;
        methodCode[location + 1] = (byte)(index >> 8 & 0xFF);
        methodCode[location + 2] = (byte)(index & 0xFF);
    }

    protected void patchBasicArrayType(byte[] methodCode, int location, int aType) throws Exception {
        String basicClassName = NewArrayBNode.getBasicTypeAsString(aType);
        Integer classIndex = this.classNumbers.get(basicClassName);
        if (classIndex == null) {
            StringBuffer buffer = this.classNumberNotFound(basicClassName);
            throw new Exception(buffer.toString());
        }
        int index = classIndex;
        methodCode[location + 1] = (byte)(index >> 8 & 0xFF);
        methodCode[location + 2] = (byte)(index & 0xFF);
    }

    private void patchFLASHARRAYS(String className, byte[] methodCode, String key, String methodName, AnalysisObserver observer) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-67, -68});
        while (locationIterator.hasNext()) {
            BNode newarray = locationIterator.next();
            int location = newarray.getAddress();
            if (methodCode[location] != -68 || !((NewArrayBNode)newarray).isFlashArray()) continue;
            methodCode[location] = -51;
            observer.byteCodeUsed((byte)-51);
        }
    }

    private StringBuffer classNumberNotFound(String basicClassName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(basicClassName);
        buffer.append(" not found in list of instantiated classes:\n");
        Iterator<String> iterator = this.classNumbers.keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer;
    }

    private void patchLDC(String className, byte[] methodCode, String key) throws ClassNotFoundException {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{18, 19, 20});
        while (locationIterator.hasNext()) {
            int index;
            int location = locationIterator.next().getAddress();
            byte indexByte1 = methodCode[location + 1];
            byte indexByte2 = 0;
            if (methodCode[location] == 19 || methodCode[location] == 20) {
                indexByte2 = methodCode[location + 2];
                index = RawByteCodes.RawBytecode.bitwiseOr(RawByteCodes.RawBytecode.bitLeftShift(indexByte1 & 0xFF, 8), indexByte2 & 0xFF);
            } else {
                index = indexByte1 & 0xFF;
            }
            LDCConstant constant = ClassfileUtils.getLDCConstant(className, index);
            index = this.constants.indexOf(constant);
            if (index == -1) {
                this.constants.add(constant);
            }
            index = this.constants.indexOf(constant);
            methodCode[location + 1] = (byte)(index >> 8 & 0xFF);
            methodCode[location + 2] = (byte)(index & 0xFF);
        }
    }

    private void patchInvokeInterface(String className, byte[] methodCode, String key, String methodName, AnalysisObserver observer, IDGenerator idGen) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-71});
        while (locationIterator.hasNext()) {
            int numArgs;
            InterfaceMethodCallBNode nextLocation = (InterfaceMethodCallBNode)locationIterator.next();
            int location = nextLocation.getAddress();
            byte interfaceIndex = methodCode[location + 1];
            byte indexByte2 = methodCode[location + 2];
            MethodOrFieldDesc referredInterfaceMethod = ClassfileUtils.getMethodDesc(className, interfaceIndex & 0xFF, indexByte2 & 0xFF);
            JavaClass declaringclazz = ClassfileUtils.findDeclaringInterface(referredInterfaceMethod.getClassName(), referredInterfaceMethod.getName(), referredInterfaceMethod.getSignature()).getClazz();
            referredInterfaceMethod.setClassName(declaringclazz.getClassName());
            nextLocation.setMethodDescriptor(referredInterfaceMethod);
            interfaceIndex = (byte)this.iManager.getInterfaceIndex(referredInterfaceMethod.getClassName());
            if (interfaceIndex != -1) {
                indexByte2 = (byte)this.iManager.getInterfaceMethodIndex(referredInterfaceMethod.getClassName(), referredInterfaceMethod.getName(), referredInterfaceMethod.getSignature());
                try {
                    numArgs = ClassfileUtils.getNumArgs(referredInterfaceMethod);
                }
                catch (Exception exception) {
                    throw new Exception("Could not find method [" + referredInterfaceMethod.toString() + "]");
                }
                methodCode[location + 1] = (byte)(interfaceIndex >> 8 & 0xFF);
                methodCode[location + 2] = indexByte2;
                methodCode[location + 3] = (byte)numArgs;
                methodCode[location + 4] = (byte)(interfaceIndex & 0xFF);
                byte[] jumpTable = nextLocation.getJumpTable(referredInterfaceMethod, this, idGen);
                int i = 0;
                while (i < jumpTable.length) {
                    methodCode[location + 5 + i] = jumpTable[i];
                    ++i;
                }
                observer.reportVtableSize(jumpTable[0]);
                continue;
            }
            try {
                numArgs = ClassfileUtils.getNumArgs(referredInterfaceMethod);
            }
            catch (Exception exception) {
                throw new Exception("Could not find method [" + referredInterfaceMethod.toString() + "]");
            }
            methodCode[location + 1] = -1;
            methodCode[location + 2] = -1;
            methodCode[location + 3] = (byte)numArgs;
            methodCode[location + 4] = -1;
            System.out.println(String.valueOf(className) + ":" + methodName + ":" + location + ": Interface '" + referredInterfaceMethod.getClassName() + "' might be invoked but is never instantiated");
        }
    }

    private void patchInvokeVirtual(String className, byte[] methodCode, String key, AnalysisObserver observer, IDGenerator idGen) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-74});
        LinkedList<MethodCallBNode> convertedNodes = new LinkedList<MethodCallBNode>();
        while (locationIterator.hasNext()) {
            MethodCallBNode nextLocation = (MethodCallBNode)locationIterator.next();
            int location = nextLocation.getAddress();
            byte indexByte1 = methodCode[location + 2];
            byte indexByte2 = methodCode[location + 3];
            MethodOrFieldDesc referredMethod = ClassfileUtils.getMethodDesc(className, indexByte1 & 0xFF, indexByte2 & 0xFF);
            nextLocation.setMethodDescriptor(referredMethod);
            short methodVtableIndex = VirtualTable.getVTableIndex(referredMethod, observer);
            this.vtableIndexManager.registerEntry(idGen.getUniqueId(referredMethod.getClassName(), referredMethod.getName(), referredMethod.getSignature()), methodVtableIndex);
            if (JavaArrayClass.isArrayClass(referredMethod.getClassName()) && referredMethod.getName().equals("clone") && referredMethod.getSignature().equals("()Ljava/lang/Object;")) {
                methodCode[location] = -54;
                observer.byteCodeUsed((byte)-54);
                continue;
            }
            VirtualMethodCallBNode methodCall = (VirtualMethodCallBNode)nextLocation;
            if (methodCall.getNumberOfTargets() == 1) {
                methodCode[location] = -73;
                observer.byteCodeUsed((byte)-73);
                methodCall.getRawBytes()[0] = -73;
                referredMethod = new MethodOrFieldDesc(methodCall.getTargetClassName(), methodCall.getMethodName(), methodCall.getMethodSig());
                this.patchStaticOrSpecial(className, methodCode, methodCall.getMethodName(), location, referredMethod, idGen);
                convertedNodes.add(nextLocation);
                continue;
            }
            int numArgs = ClassfileUtils.getNumArgs(referredMethod);
            Method callee = ClassfileUtils.findMethod(referredMethod.getClassName(), referredMethod.getName(), referredMethod.getSignature()).getMethod();
            methodCall.setCallee(callee);
            if (methodVtableIndex > -1) {
                methodCode[location + 1] = (byte)(Compiler.getNumReturnValues(callee) & 3);
                methodCode[location + 2] = (byte)(methodVtableIndex & 0xFF);
                methodCode[location + 3] = (byte)numArgs;
            } else {
                methodCode[location + 1] = 0;
                methodCode[location + 2] = -1;
                methodCode[location + 3] = (byte)numArgs;
                System.out.println("Unable to patch invoke of " + referredMethod.toString());
            }
            byte[] jumpTable = methodCall.getJumpTable(referredMethod, this, idGen);
            int i = 0;
            while (i < jumpTable.length) {
                methodCode[location + 4 + i] = jumpTable[i];
                ++i;
            }
            observer.reportVtableSize(jumpTable[0]);
        }
        Iterator nodesToDelete = convertedNodes.iterator();
        while (nodesToDelete.hasNext()) {
            this.deleteRegistrant(key, (BNode)nodesToDelete.next());
        }
    }

    private void patchInvokeStaticOrSpecial(byte[] codes, String className, byte[] methodCode, String key, String methodName, IDGenerator idGen) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, codes);
        while (locationIterator.hasNext()) {
            int location = locationIterator.next().getAddress();
            byte indexByte1 = methodCode[location + 2];
            byte indexByte2 = methodCode[location + 3];
            MethodOrFieldDesc referredMethod = ClassfileUtils.getMethodDesc(className, indexByte1 & 0xFF, indexByte2 & 0xFF);
            JavaClass declaringclazz = ClassfileUtils.findMethod(referredMethod.getClassName(), referredMethod.getName(), referredMethod.getSignature()).getClazz();
            referredMethod.setClassName(declaringclazz.getClassName());
            this.patchStaticOrSpecial(className, methodCode, methodName, location, referredMethod, idGen);
        }
    }

    private void patchStaticOrSpecial(String className, byte[] methodCode, String methodName, int location, MethodOrFieldDesc referredMethod, IDGenerator idGen) throws Exception {
        int methodNumber = this.getMethodNumber(referredMethod, idGen);
        if (methodNumber != -1) {
            methodCode[location + 1] = (byte)(methodNumber >> 8 & 0xFF);
            methodCode[location + 2] = (byte)(methodNumber & 0xFF);
        } else {
            System.out.println(String.valueOf(className) + ":" + methodName + ":" + location + ": Method '" + referredMethod + "' might be invoked but class is never instantiated");
        }
    }

    private void patchInvokeStatic(String className, byte[] methodCode, String key, String methodName, IDGenerator idGen) throws Exception {
        this.patchInvokeStaticOrSpecial(new byte[]{-72}, className, methodCode, key, methodName, idGen);
    }

    private void patchInvokeSpecial(String className, byte[] methodCode, String key, String methodName, IDGenerator idGen) throws Exception {
        this.patchInvokeStaticOrSpecial(new byte[]{-73}, className, methodCode, key, methodName, idGen);
    }

    private void patchClassreference(byte[] opcodes, String className, byte[] methodCode, String key) throws Exception {
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, opcodes);
        while (locationIterator.hasNext()) {
            int location = locationIterator.next().getAddress();
            byte indexByte1 = methodCode[location + 1];
            byte indexByte2 = methodCode[location + 2];
            String referredClassName = ClassfileUtils.getClassName(className, indexByte1 & 0xFF, indexByte2 & 0xFF);
            boolean isInterface = false;
            int referredIndex = -1;
            if (referredClassName == null || JavaArrayClass.isArrayClass(referredClassName)) {
                referredClassName = "java.lang.Object";
            }
            if ((referredIndex = this.iManager.getInterfaceIndex(referredClassName)) == -1) {
                if (this.classNumbers.containsKey(referredClassName)) {
                    referredIndex = this.classNumbers.get(referredClassName);
                } else {
                    isInterface = true;
                }
            } else {
                isInterface = true;
            }
            referredIndex <<= 1;
            if (isInterface) {
                referredIndex |= 1;
            }
            methodCode[location + 1] = (byte)(referredIndex >> 8 & 0xFF);
            methodCode[location + 2] = (byte)(referredIndex & 0xFF);
        }
    }

    private void patchINSTANCEOF(String className, byte[] methodCode, String key) throws Exception {
        this.patchClassreference(new byte[]{-63}, className, methodCode, key);
    }

    private void patchCheckcast(String className, byte[] methodCode, String key) throws Exception {
        this.patchClassreference(new byte[]{-64}, className, methodCode, key);
    }

    private void patchNew(String className, byte[] methodCode, String key) throws Exception {
        this.patchClassreference(new byte[]{-69}, className, methodCode, key);
    }

    private void patchPutGetField(String className, byte[] methodCode, String key, AnalysisObserver observer) throws Exception {
        this.fieldOffsets = new FieldInfo[methodCode.length];
        IcecapIterator<BNode> locationIterator = this.getRegisteredByteCodes(key, new byte[]{-78, -77, -76, -75});
        while (locationIterator.hasNext()) {
            int location = locationIterator.next().getAddress();
            byte indexByte2 = methodCode[location + 2];
            byte indexByte3 = methodCode[location + 3];
            MethodOrFieldDesc referredField = ClassfileUtils.getMethodDesc(className, indexByte2 & 0xFF, indexByte3 & 0xFF);
            referredField = ClassfileUtils.findField(referredField.getClassName(), referredField.getName(), referredField.getSignature());
            String fieldKey = String.valueOf(referredField.getClassName()) + referredField.getName();
            HashMap<String, FieldInfo> fields = methodCode[location] == -78 || methodCode[location] == -77 ? this.classFields : this.objectFields;
            String referredClassName = referredField.getClassName();
            if (fields.containsKey(fieldKey)) {
                FieldInfo fi = fields.get(fieldKey);
                int classIndex = this.getClassNumber(referredField.getClassName());
                int fieldSize = fi.getSize();
                int fieldOffset = fi.getOffset();
                methodCode[location + 1] = (byte)(classIndex >> 8 & 0xFF);
                methodCode[location + 2] = (byte)(classIndex & 0xFF);
                methodCode[location + 3] = (byte)fieldSize;
                methodCode[location + 4] = (byte)(fieldOffset >> 8 & 0xFF);
                methodCode[location + 5] = (byte)(fieldOffset & 0xFF);
                if (!(this.foCalc.isHardwareObject(referredClassName) || methodCode[location] != -76 && methodCode[location] != -75)) {
                    this.fieldOffsets[location + 4] = fi;
                }
                if (methodCode[location] == -78 || methodCode[location] == -77) {
                    this.fieldOffsets[location + 4] = fi;
                }
            } else {
                System.out.println(String.valueOf(className) + ":" + referredField.getName() + ":" + location + ": Field in object might be invoked but class is never instantiated");
            }
            if (!this.foCalc.isHardwareObject(referredClassName)) continue;
            if (methodCode[location] == -76) {
                methodCode[location] = -53;
                observer.byteCodeUsed((byte)-53);
                continue;
            }
            if (methodCode[location] != -75) continue;
            methodCode[location] = -52;
            observer.byteCodeUsed((byte)-52);
        }
    }

    @Override
    public FieldInfo[] getFieldOffsets() {
        return this.fieldOffsets;
    }

    @Override
    public void registerClassNumber(String className, int classNumber) {
        if (this.numberOfClasses <= classNumber) {
            this.numberOfClasses = classNumber + 1;
        }
        this.classNumbers.put(className, new Integer(classNumber));
    }

    @Override
    public int getClassNumber(String className) {
        Integer num = this.classNumbers.get(className);
        if (num != null) {
            return num;
        }
        return -1;
    }

    @Override
    public String getClassName(int number) {
        for (Map.Entry<String, Integer> next : this.classNumbers.entrySet()) {
            if (next.getValue() != number) continue;
            return next.getKey();
        }
        return null;
    }

    @Override
    public void registerInterface(String clazz, String _interface) {
        this.iManager.registerClass(clazz, _interface);
    }

    @Override
    public InterfaceManager getInterfaceManager() {
        return this.iManager;
    }

    @Override
    public void registerFieldNumber(String currentClassName, FieldInfo field, int fieldNumber, boolean isStatic) {
        String fieldKey = String.valueOf(currentClassName) + field.getName();
        if (isStatic) {
            this.classFields.put(fieldKey, field);
        } else {
            this.objectFields.put(fieldKey, field);
        }
    }

    @Override
    public ArrayList<LDCConstant> getConstants() {
        return this.constants;
    }

    @Override
    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public void registerMethodNumber(MethodOrFieldDesc currentMethod, int methodNumber, IDGenerator idGen) {
        String key = idGen.getUniqueId(currentMethod.getClassName(), currentMethod.getName(), currentMethod.getSignature());
        if (!this.methodNumbers.containsKey(key)) {
            this.methodNumbers.put(key, new MethodAndNumber(currentMethod, methodNumber));
        }
    }

    @Override
    public int getMethodNumber(MethodOrFieldDesc currentMethod, IDGenerator idGen) {
        String key = idGen.getUniqueId(currentMethod.getClassName(), currentMethod.getName(), currentMethod.getSignature());
        MethodAndNumber n = this.methodNumbers.get(key);
        if (n != null) {
            return n.number;
        }
        return -1;
    }

    @Override
    public MethodOrFieldDesc getMethodDescriptor(int methodNumber) {
        for (Map.Entry<String, MethodAndNumber> next : this.methodNumbers.entrySet()) {
            MethodAndNumber nextEntry = next.getValue();
            if (nextEntry.number != methodNumber) continue;
            return nextEntry.desc;
        }
        return null;
    }

    public static String createMethodID(String className, String targetMethodName, String targetMethodSignature) {
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append(className);
        keyBuffer.append(targetMethodName);
        keyBuffer.append(targetMethodSignature);
        String key = keyBuffer.toString();
        return key;
    }

    @Override
    public void registerByteCode(String className, String targetMethodName, String targetMethodSignature, BNode node) {
        List<Object> list;
        String key = IcecapByteCodePatcher.createMethodID(className, targetMethodName, targetMethodSignature);
        if (!this.registeredBytecodes.containsKey(key)) {
            list = new LinkedList();
            this.registeredBytecodes.put(key, list);
        } else {
            list = this.registeredBytecodes.get(key);
        }
        list.add(node);
    }

    private void deleteRegistrant(String key, BNode node) throws Exception {
        List<BNode> method = this.registeredBytecodes.get(key);
        if (!method.remove(node)) {
            throw new Exception("Couldn't find it??");
        }
    }

    private IcecapIterator<BNode> getRegisteredByteCodes(String methodID, byte[] opcodes) {
        return new RegisteredCodeIterator(methodID, opcodes);
    }

    @Override
    public RequiredMethodVTableIndexManager getRequiredVTableIndices() {
        return this.vtableIndexManager;
    }

    private static class MethodAndNumber {
        public MethodOrFieldDesc desc;
        public int number;

        public MethodAndNumber(MethodOrFieldDesc desc, int number) {
            this.desc = desc;
            this.number = number;
        }
    }

    private class RegisteredCodeIterator
    implements IcecapIterator<BNode> {
        private byte[] opcodes;
        private BNode next;
        private Iterator<BNode> registrants;

        public RegisteredCodeIterator(String methodID, byte[] opcodes) {
            List registrantList = (List)IcecapByteCodePatcher.this.registeredBytecodes.get(methodID);
            this.opcodes = opcodes;
            this.next = null;
            if (registrantList != null) {
                this.registrants = registrantList.iterator();
                this.findNext();
            }
        }

        private void findNext() {
            while (this.registrants.hasNext()) {
                BNode nextRegistrant = this.registrants.next();
                boolean includeIt = false;
                int i = 0;
                while (i < this.opcodes.length) {
                    if (nextRegistrant.getOpCode() == this.opcodes[i]) {
                        includeIt = true;
                    }
                    ++i;
                }
                if (!includeIt) continue;
                this.next = nextRegistrant;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public BNode next() {
            BNode result = this.next;
            this.findNext();
            return result;
        }
    }
}

