/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.IcecapTool;
import icecaptools.compiler.ByteCodePatcher;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.LDCConstant;
import icecaptools.compiler.LabeledMemorySegment;
import icecaptools.compiler.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Iterator;

public class ConstantGenerator {
    private ByteCodePatcher patcher;
    private IcecapTool manager;
    private StringBuffer defines;
    private LabeledMemorySegment requiredIncludes;
    private boolean supportLoading;
    public static final String HEXES = "0123456789ABCDEF";

    public ConstantGenerator(ByteCodePatcher patcher, IcecapTool manager, StringBuffer defines, LabeledMemorySegment requiredIncludes, boolean supportLoading) {
        this.patcher = patcher;
        this.manager = manager;
        this.defines = defines;
        this.requiredIncludes = requiredIncludes;
        this.supportLoading = supportLoading;
    }

    public StringBuffer generateConstants() throws Exception {
        MemorySegment buffer = new MemorySegment(this.manager.getProperties());
        boolean LDC_string = false;
        boolean LDC_long = false;
        boolean LDC_float = false;
        boolean LDC_double = false;
        ArrayList<LDCConstant> constants = this.patcher.getConstants();
        if (constants.size() > 0) {
            Iterator<LDCConstant> iterator = constants.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                LDCConstant current = iterator.next();
                if (current.getType() == 1) {
                    if (!LDC_string) {
                        this.defines.append("#define LDC_STRING\n");
                        LDC_string = true;
                    }
                    String nonAscii = ConstantGenerator.filterNonAscii(current.getString(), false);
                    this.declareStringConstant(buffer, count, nonAscii, ConstantGenerator.filterNonAscii(current.getString(), true));
                } else if (current.getType() == 4) {
                    if (!LDC_long) {
                        this.defines.append("#define LDC_LONG\n");
                        LDC_long = true;
                    }
                    buffer.appendCode("RANGE static const unsigned char long_constant_" + count + "[8] PROGMEM = { ", 8);
                    long val = current.getLong();
                    buffer.print("0x" + Integer.toHexString((int)(val >> 56 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 48 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 40 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 32 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 24 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 16 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val >> 8 & 0xFFL)));
                    buffer.print(", 0x" + Integer.toHexString((int)(val & 0xFFL)));
                    buffer.print(" };\n");
                } else if (current.getType() == 3) {
                    if (!LDC_float) {
                        this.defines.append("#define LDC_FLOAT\n");
                        LDC_float = true;
                    }
                } else if (current.getType() == 5) {
                    if (!LDC_double) {
                        this.defines.append("#define LDC_DOUBLE\n");
                        LDC_double = true;
                    }
                    buffer.appendCode("RANGE static const double double_constant_" + count + " PROGMEM = ", 8);
                    buffer.print(Double.toString(current.getDouble()));
                    buffer.print(";\n");
                }
                ++count;
            }
            if (count > 0) {
                buffer.print("\n");
            }
            buffer.appendData("RANGE static const ConstantInfo _constants[" + constants.size() + "] PROGMEM = {\n", 9 * constants.size());
            iterator = constants.iterator();
            StringBuffer stringConstants = new StringBuffer();
            int stringID = 0;
            count = 0;
            while (iterator.hasNext()) {
                LDCConstant current = iterator.next();
                String type = "CONSTANT_UNKNOWN";
                switch (current.getType()) {
                    case 1: {
                        type = "CONSTANT_STRING";
                        buffer.print(" { " + type + ", " + (stringID << 16 | current.getString().length() & 0xFFFF) + ", string_constant_" + count + ", 0 }");
                        stringConstants.append("0, ");
                        ++stringID;
                        break;
                    }
                    case 2: {
                        type = "CONSTANT_INTEGER";
                        buffer.print(" { " + type + ", " + current.getInt() + ", 0, 0 }");
                        break;
                    }
                    case 3: {
                        String floatString;
                        float f = current.getFloat();
                        if (f == Float.POSITIVE_INFINITY) {
                            this.requiredIncludes.print("#include <math.h>\n");
                            floatString = "INFINITY";
                        } else if (f == Float.NEGATIVE_INFINITY) {
                            this.requiredIncludes.print("#include <math.h>\n");
                            floatString = "-INFINITY";
                        } else {
                            floatString = "" + f;
                        }
                        type = "CONSTANT_FLOAT";
                        buffer.print(" { " + type + ", 0, 0, " + floatString + " }");
                        break;
                    }
                    case 4: {
                        type = "CONSTANT_LONG";
                        buffer.print(" { " + type + ", " + 0 + ", long_constant_" + count + ", 0 }");
                        break;
                    }
                    case 5: {
                        type = "CONSTANT_DOUBLE";
                        buffer.print(" { " + type + ", " + 0 + ", &double_constant_" + count + ", 0 }");
                        break;
                    }
                    case 6: {
                        type = "CONSTANT_CLASS";
                        buffer.print(" { " + type + ", " + this.patcher.getClassNumber(current.getClassName()) + ", 0, 0 }");
                    }
                }
                if (iterator.hasNext()) {
                    buffer.print(",");
                }
                buffer.print("\n");
                ++count;
            }
            if (stringID > 0) {
                stringConstants = new StringBuffer(stringConstants.substring(0, stringConstants.length() - 2));
                stringConstants.insert(0, "Object* stringConstants[" + stringID + "] = { ");
                stringConstants.append(" };\n");
            } else {
                stringConstants.append("Object* stringConstants[1] = { 0 };\n");
            }
            buffer.print("};\n");
            buffer.appendData(stringConstants.toString(), 0);
            return buffer.getBuffer();
        }
        if (this.supportLoading) {
            buffer.print("Object* stringConstants[1] = { 0 };\n");
            return buffer.getBuffer();
        }
        return new StringBuffer();
    }

    private void declareStringConstant(MemorySegment buffer, int count, String nonAscii, String asComment) {
        byte[] bytes = nonAscii.getBytes();
        buffer.appendCode("RANGE static const unsigned char string_constant_" + count + "[" + (bytes.length + 1) + "] PROGMEM = { ", bytes.length + 1);
        if (bytes.length > 0) {
            buffer.print(ConstantGenerator.getHex(bytes, 16, null));
            buffer.print(",0x00 }; /* ");
        } else {
            buffer.print("0x00 }; /* ");
        }
        buffer.print(String.valueOf(asComment) + " */\n");
    }

    public static String getHex(byte[] raw, int lineLen, FieldInfo[] fieldOffsets) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(4 * raw.length);
        int i = 0;
        while (i < raw.length) {
            if (fieldOffsets != null && fieldOffsets[i] != null) {
                FieldInfo finfo = fieldOffsets[i];
                StringBuffer offsetof = new StringBuffer();
                if (finfo.isClassField) {
                    String structName = finfo.getStructName();
                    if (structName != null) {
                        offsetof.append("(offsetof(struct ").append(structName).append(", ");
                        offsetof.append(finfo.getStructMemberName()).append(") << 3)");
                    } else {
                        offsetof.append("0");
                    }
                } else {
                    offsetof.append("((offsetof(struct ").append(finfo.getStructName()).append(", ");
                    offsetof.append(finfo.getStructMemberName()).append(") - sizeof(Object)) << 3)");
                }
                hex.append("\n  ");
                hex.append("/* offset: ");
                hex.append(raw[i]);
                hex.append(", ");
                hex.append(raw[i + 1]);
                hex.append("*/\n");
                hex.append("(uint8)(((uint16)");
                hex.append(offsetof);
                hex.append(") >> 8)");
                hex.append(", ");
                hex.append("(uint8)(((uint16)");
                hex.append(offsetof);
                hex.append(") & 0xff)");
                hex.append(",");
                hex.append("\n  ");
                ++i;
            } else {
                byte b = raw[i];
                if (i % lineLen == 0 && i != 0) {
                    hex.append("\n  ");
                }
                hex.append("0x").append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(",");
            }
            ++i;
        }
        return hex.toString().substring(0, hex.length() - 1);
    }

    private static String filterNonAscii(String inString, boolean escape) {
        Charset charset = Charset.forName("US-ASCII");
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        String result = inString;
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(inString));
            CharBuffer cbuf = decoder.decode(bbuf);
            StringBuffer nonNullBuf = new StringBuffer();
            int length = cbuf.length();
            int i = 0;
            while (i < length) {
                char next = cbuf.charAt(i);
                if (next != '\u0000') {
                    if (escape) {
                        if (next == '\"') {
                            nonNullBuf.append('\\');
                            nonNullBuf.append(next);
                        } else if (next == '\n') {
                            nonNullBuf.append('\\');
                            nonNullBuf.append('n');
                        } else if (next == '\r') {
                            nonNullBuf.append('\\');
                            nonNullBuf.append('r');
                        } else if (next == '\\') {
                            nonNullBuf.append('\\');
                            nonNullBuf.append('\\');
                        } else {
                            nonNullBuf.append(next);
                        }
                    } else {
                        nonNullBuf.append(next);
                    }
                }
                ++i;
            }
            result = nonNullBuf.length() > 509 ? nonNullBuf.substring(0, 509) : nonNullBuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {}
        return result.replace("*/", "__").replace("/*", "__");
    }

    public int numberOfConstants() {
        return this.patcher.getConstants().size();
    }
}

