/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.RawByteCodes;
import icecaptools.conversion.TargetAddressMap;
import java.util.ArrayList;
import java.util.Iterator;

public class SwitchBNode
extends BNode {
    ArrayList<Long> targets = new ArrayList();
    private int initialAddress;
    private RawByteCodes.RawSwitch tlSwitch;

    public SwitchBNode(RawByteCodes.RawSwitch tableSwitch, int address, long defaultVal, String locationClass, String locationMethod, String locationMethodSignature) {
        super(address, locationClass, locationMethod, locationMethodSignature);
        this.initialAddress = address;
        this.addTargetAddress(defaultVal);
        this.tlSwitch = tableSwitch;
    }

    public RawByteCodes.RawSwitch getTableSwitch() {
        return this.tlSwitch;
    }

    public void addTargetAddress(long l) {
        this.targets.add(new Long(l));
    }

    public int getNumberOfTargets() {
        return this.targets.size();
    }

    @Override
    public void link(BNode[] nodes, TargetAddressMap tmap) throws Exception {
        for (Long next : this.targets) {
            BNode branchTarget = SwitchBNode.findNodeWithAddress(nodes, this.address + next.intValue());
            tmap.markJumpTarget(branchTarget);
            this.addChild(branchTarget);
        }
    }

    @Override
    public boolean requiresExtension() {
        return true;
    }

    @Override
    public void relocateForward(int address, int extension) {
        int i = 0;
        while (i < this.targets.size()) {
            Long current = this.targets.get(i);
            long branchoffset = current;
            if (branchoffset < 0L && (long)this.address + branchoffset <= (long)address) {
                this.targets.set(i, new Long(branchoffset -= (long)extension));
            }
            ++i;
        }
    }

    @Override
    public void relocateBackward(int address, int extension) {
        int i = 0;
        while (i < this.targets.size()) {
            Long current = this.targets.get(i);
            long branchoffset = current;
            if (branchoffset > 0L && (long)this.address + branchoffset > (long)address) {
                this.targets.set(i, new Long(branchoffset += (long)extension));
            }
            ++i;
        }
    }

    @Override
    public byte[] getRawBytes() {
        int padding = 3;
        int startOffset = 1 + padding + 12;
        int step = this.rawBytes[0] == -86 ? 4 : 8;
        long defaultVal = this.targets.get(0);
        byte branchbyte1 = (byte)(defaultVal >> 24 & 0xFFL);
        byte branchbyte2 = (byte)(defaultVal >> 16 & 0xFFL);
        byte branchbyte3 = (byte)(defaultVal >> 8 & 0xFFL);
        byte branchbyte4 = (byte)(defaultVal & 0xFFL);
        this.rawBytes[4] = branchbyte1;
        this.rawBytes[5] = branchbyte2;
        this.rawBytes[6] = branchbyte3;
        this.rawBytes[7] = branchbyte4;
        int i = 1;
        while (i < this.targets.size()) {
            Long offset = this.targets.get(i);
            branchbyte1 = (byte)(offset >> 24 & 0xFFL);
            branchbyte2 = (byte)(offset >> 16 & 0xFFL);
            branchbyte3 = (byte)(offset >> 8 & 0xFFL);
            branchbyte4 = (byte)(offset & 0xFFL);
            this.rawBytes[startOffset] = branchbyte1;
            this.rawBytes[startOffset + 1] = branchbyte2;
            this.rawBytes[startOffset + 2] = branchbyte3;
            this.rawBytes[startOffset + 3] = branchbyte4;
            startOffset += step;
            ++i;
        }
        return super.getRawBytes();
    }

    @Override
    public int extend() throws Exception {
        int padding = 0;
        ++this.initialAddress;
        while (this.initialAddress >> 2 << 2 != this.initialAddress) {
            ++this.initialAddress;
            ++padding;
        }
        this.initialAddress -= padding + 1;
        byte[] rawBytes = new byte[this.rawBytes.length + (3 - padding)];
        rawBytes[0] = this.rawBytes[0];
        int src = padding + 1;
        int dst = 4;
        while (src < this.rawBytes.length) {
            rawBytes[dst++] = this.rawBytes[src++];
        }
        this.rawBytes = rawBytes;
        return 3 - padding;
    }

    @Override
    protected String print() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Long> iterator = this.targets.iterator();
        buffer.append("switch ");
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public BNode findTarget(long offset) {
        Iterator<BNode> iterator = this.getChildren();
        while (iterator.hasNext()) {
            BNode next = iterator.next();
            if ((long)next.getOriginalAddress() != (long)this.getOriginalAddress() + offset) continue;
            return next;
        }
        return null;
    }
}

