/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.IcecapIterator;
import icecaptools.MethodIdentifier;
import icecaptools.compiler.utils.CallGraph;
import icecaptools.conversion.ConversionConfiguration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;

public class StackDepthAnalyser {
    private CallGraph callGraph;
    private LinkedList<MethodIdentifier> maxStack;

    public StackDepthAnalyser(CallGraph callGraph) {
        this.callGraph = callGraph;
    }

    void analyse(ConversionConfiguration config) {
        this.maxStack = this.maxDepth(null, config.getEntryPointClassName(), config.getEntryPointMethodName(), config.getEntryPointMethodSignature(), new Stack<MethodIdentifier>(), new HashMap<MethodIdentifier, LinkedList<MethodIdentifier>>());
    }

    private LinkedList<MethodIdentifier> maxDepth(MethodIdentifier current, String className, String methodName, String methodSignature, Stack<MethodIdentifier> callStack, HashMap<MethodIdentifier, LinkedList<MethodIdentifier>> previousResults) {
        if (previousResults.containsKey(current)) {
            return (LinkedList)previousResults.get(current).clone();
        }
        IcecapIterator<MethodIdentifier> callees = this.callGraph.getCallees(className, methodName, methodSignature);
        LinkedList<MethodIdentifier> maxStack = new LinkedList<MethodIdentifier>();
        while (callees.hasNext()) {
            MethodIdentifier next = callees.next();
            if (callStack.contains(next)) continue;
            callStack.push(next);
            LinkedList<MethodIdentifier> maxStackCallee = this.maxDepth(next, next.getClassName(), next.getName(), next.getSignature(), callStack, previousResults);
            if (maxStackCallee.size() > maxStack.size()) {
                maxStack = maxStackCallee;
            }
            callStack.pop();
        }
        if (current != null) {
            maxStack.addFirst(current);
            previousResults.put(current, maxStack);
        }
        return (LinkedList)maxStack.clone();
    }

    int calculateMaxDepth() {
        return this.maxStack.size();
    }

    LinkedList<MethodIdentifier> getMaxStack() {
        return this.maxStack;
    }
}

