/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.HVMLoadedProperties;
import icecaptools.HVMProperties;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyManager
implements HVMProperties {
    private HVMProperties loadedProps;
    private boolean includeJMLMethods;
    private String propertiesFilePath;

    @Override
    public String getProgmemStart() {
        return this.loadedProps.getProgmemStart();
    }

    @Override
    public String getProgmemEnd() {
        return this.loadedProps.getProgmemEnd();
    }

    @Override
    public String getNewlineSequence() {
        return this.loadedProps.getNewlineSequence();
    }

    @Override
    public boolean includeMethodAndClassNames() {
        return this.loadedProps.includeMethodAndClassNames();
    }

    public void reloadLoadedProperties(String inputSourceFileName) throws Exception {
        StringBuffer propertiesFileName = new StringBuffer();
        if (inputSourceFileName != null) {
            StringTokenizer tokenizer = new StringTokenizer(inputSourceFileName, String.valueOf(File.separatorChar));
            propertiesFileName.append(File.separatorChar);
            while (tokenizer.hasMoreTokens()) {
                String nextSegment = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                propertiesFileName.append(nextSegment);
                propertiesFileName.append(File.separatorChar);
            }
        } else {
            propertiesFileName.append(System.getProperty("user.dir"));
            propertiesFileName.append(File.separatorChar);
        }
        propertiesFileName.append("hvm.properties");
        File propertiesFile = new File(propertiesFileName.toString());
        if (propertiesFile.exists() && propertiesFile.canRead()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(propertiesFile));
                this.propertiesFilePath = propertiesFileName.toString();
                this.loadedProps = new HVMLoadedProperties(props);
                return;
            }
            catch (Exception exception) {
                throw new Exception("Unable to load from existing properties file at [" + propertiesFileName.toString() + "]");
            }
        }
        this.loadedProps = new HVMLoadedProperties(new Properties());
    }

    @Override
    public boolean isIncludeJMLMethods() {
        return this.includeJMLMethods || this.loadedProps.isIncludeJMLMethods();
    }

    @Override
    public void setIncludeJMLMethods(boolean includeJMLMethods) {
        this.includeJMLMethods = includeJMLMethods;
    }

    @Override
    public String getProperty(String key) {
        return this.loadedProps.getProperty(key);
    }

    public String getPropertiesFileName() {
        return this.propertiesFilePath;
    }
}

