/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import java.util.HashMap;
import java.util.StringTokenizer;

public class NewList {
    private String[] newList;
    private int top;
    private static HashMap<String, String> strings = new HashMap();
    private static int instanceCount = 0;

    public NewList(String news) {
        this(1);
        StringTokenizer tokenizer = new StringTokenizer(news, ";");
        while (tokenizer.hasMoreTokens()) {
            this.addElement(tokenizer.nextToken());
        }
    }

    public NewList(int initialCapacity) {
        this.newList = new String[initialCapacity];
        this.top = 0;
        ++instanceCount;
    }

    private void insertElement(String element) {
        if (this.top < this.newList.length) {
            this.newList[this.top++] = element;
        } else {
            String[] copy = new String[(this.newList.length + 1) * 2];
            int i = 0;
            while (i < this.top) {
                copy[i] = this.newList[i];
                ++i;
            }
            this.newList = copy;
            this.insertElement(element);
        }
    }

    public NewList(NewList other) {
        this(other.top);
        String[] otherEntries = other.newList;
        int i = 0;
        while (i < other.top) {
            this.newList[i] = otherEntries[i];
            ++i;
        }
        this.top = other.top;
    }

    public NewList() {
        this(1);
    }

    public void addElement(String nextElement) {
        if (nextElement != null && nextElement.trim().length() > 0) {
            if (strings.containsKey(nextElement)) {
                nextElement = strings.get(nextElement);
            } else {
                strings.put(nextElement, nextElement);
            }
            int i = 0;
            while (i < this.top) {
                if (this.newList[i] == nextElement) {
                    return;
                }
                ++i;
            }
            this.insertElement(nextElement);
            i = 0;
            while (i < this.top - 1) {
                if (this.newList[i].compareTo(this.newList[i + 1]) <= 0) {
                    ++i;
                    continue;
                }
                String temp = this.newList[i];
                this.newList[i] = this.newList[i + 1];
                this.newList[i + 1] = temp;
                if (i <= 0) continue;
                --i;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.top) {
            String current = this.newList[i];
            buffer.append(current);
            if (i + 1 < this.top) {
                buffer.append(";");
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NewList) {
            NewList other = (NewList)obj;
            if (other.top == this.top) {
                int i = 0;
                while (i < this.top) {
                    String otherNext = other.newList[i];
                    String thisNext = this.newList[i];
                    if (otherNext != thisNext) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int merge(NewList other) {
        int addedEntries = 0;
        if (other.top != 0) {
            String thisElement;
            String[] otherElements = other.newList;
            String[] thisElements = this.newList;
            String[] result = new String[other.top + this.top];
            int otherTop = 0;
            int thisTop = 0;
            int resultTop = 0;
            while (thisTop < this.top && otherTop < other.top) {
                thisElement = thisElements[thisTop];
                String otherElement = otherElements[otherTop];
                if (thisElement == otherElement) {
                    result[resultTop++] = thisElement;
                    ++thisTop;
                    ++otherTop;
                    continue;
                }
                if (thisElement.compareTo(otherElement) < 0) {
                    result[resultTop++] = thisElement;
                    ++thisTop;
                    continue;
                }
                result[resultTop++] = otherElement;
                ++otherTop;
            }
            while (otherTop < other.top) {
                String otherElement = otherElements[otherTop++];
                result[resultTop++] = otherElement;
            }
            while (thisTop < this.top) {
                thisElement = thisElements[thisTop++];
                result[resultTop++] = thisElement;
            }
            addedEntries = resultTop - this.top;
            if (addedEntries > 0) {
                this.newList = result;
            }
            this.top = resultTop;
        }
        return addedEntries;
    }

    public String[] getElementsAsArray() {
        String[] result = new String[this.top];
        int i = 0;
        while (i < this.top) {
            result[i] = this.newList[i];
            ++i;
        }
        return result;
    }

    public boolean lessThanOrEquals(NewList other) {
        if (other != null) {
            int otherTop = 0;
            String[] otherElements = other.newList;
            int i = 0;
            while (i < this.top) {
                String thisElement = this.newList[i];
                boolean found = false;
                while (otherTop < other.top) {
                    String otherElement;
                    if (thisElement != (otherElement = otherElements[otherTop++])) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int size() {
        return this.top;
    }

    public static int getInstanceCount() {
        return instanceCount;
    }
}

