/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.AnalysisObserver;
import icecaptools.AnnotationsAttribute;
import icecaptools.ClassfileUtils;
import icecaptools.IcecapCVar;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.OffsetPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FieldOffsetCalculator {
    private HashMap<JavaClass, ArrayList<FieldInfo>> objectFields = new HashMap();
    private HashMap<JavaClass, ArrayList<FieldInfo>> classFields = new HashMap();
    private HashMap<JavaClass, OffsetPair> objectSize = new HashMap();
    private ArrayList<String> additionalDependencies = new ArrayList();
    private int offset = 0;
    public static final String HWObjectClassName = "vm.HardwareObject";
    public static final String ReferenceAddressClassName = "reflect.HeapAccessor";
    public static final String Address32bitClassName = "vm.Address32Bit";
    public static final String Address64bitClassName = "vm.Address64Bit";
    private HashSet<String> nonHWObjectClasses = new HashSet();
    private LinkedList<String> maxHeirarchy = new LinkedList();

    private OffsetPair calculateOffset(JavaClass clazz, HashMap<JavaClass, ArrayList<FieldInfo>> objectFields, HashMap<JavaClass, ArrayList<FieldInfo>> classFields, boolean includeClassFields, AnalysisObserver observer, LinkedList<String> heirarchy) throws Exception {
        OffsetPair currentObjectOffset;
        int currentClassOffset = this.offset;
        ArrayList<Object> fieldsInSuperClass = null;
        heirarchy.add(clazz.getClassName());
        JavaClass superClass = clazz.getSuperClass();
        if (superClass != null) {
            currentObjectOffset = this.calculateOffset(clazz.getSuperClass(), objectFields, classFields, true, observer, heirarchy);
            fieldsInSuperClass = objectFields.get(superClass);
        } else {
            currentObjectOffset = new OffsetPair(0, 0);
            fieldsInSuperClass = new ArrayList();
            if (this.maxHeirarchy.size() < heirarchy.size()) {
                this.maxHeirarchy = (LinkedList)heirarchy.clone();
            }
        }
        if (observer.isLockingType(clazz.getClassName())) {
            currentObjectOffset.makeRoomForLock();
        }
        int fieldSize = 0;
        int fieldOffset = 0;
        ArrayList objectFieldSet = new ArrayList();
        ArrayList<FieldInfo> classFieldSet = new ArrayList<FieldInfo>();
        objectFieldSet.addAll(fieldsInSuperClass);
        Field[] fields = clazz.getFields();
        boolean isHWObject = this.isHardwareObject(clazz.getClassName());
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            Type fieldType = fields[i].getType();
            fieldSize = ClassfileUtils.getSizeOfType(fieldType);
            if (!isHWObject && fieldSize == 1) {
                fieldSize = 8;
            }
            if (!fields[i].isStatic()) {
                fieldOffset = currentObjectOffset.dheapoffset;
                currentObjectOffset.dheapoffset += fieldSize;
                objectFieldSet.add(new FieldInfo(fieldName, fieldOffset, fieldSize, fields[i].isVolatile(), fields[i].getType() instanceof ReferenceType, fieldType == Type.FLOAT, false, isHWObject));
            } else if (includeClassFields && observer.isClassFieldUsed(clazz.getClassName(), fieldName)) {
                fieldOffset = currentClassOffset;
                FieldInfo fInfo = new FieldInfo(fieldName, fieldOffset, fieldSize, false, fields[i].getType() instanceof ReferenceType, fieldType == Type.FLOAT, true, false);
                if (!this.isNativeField(observer, clazz.getClassName(), fieldOffset, fields[i], fInfo)) {
                    currentClassOffset += fieldSize;
                    this.offset += fieldSize;
                }
                classFieldSet.add(fInfo);
            }
            ++i;
        }
        objectFields.put(clazz, objectFieldSet);
        classFields.put(clazz, classFieldSet);
        this.objectSize.put(clazz, new OffsetPair(currentObjectOffset));
        if (!observer.isClassUsed(clazz.getClassName())) {
            this.additionalDependencies.add(clazz.getClassName());
        }
        return currentObjectOffset;
    }

    public boolean isHardwareObject(String className) {
        if (this.nonHWObjectClasses.contains(className)) {
            return false;
        }
        boolean isHWObject = false;
        do {
            if (!HWObjectClassName.equals(className = ClassfileUtils.getSuperClassName(className))) continue;
            isHWObject = true;
            break;
        } while (!"java.lang.Object".equals(className));
        if (!isHWObject) {
            this.nonHWObjectClasses.add(className);
        }
        return isHWObject;
    }

    private boolean isNativeField(AnalysisObserver observer, String containingClass, int fieldOffset, Field field, FieldInfo fInfo) {
        Attribute[] attributes;
        boolean isNativeField = false;
        Attribute[] attributeArray = attributes = field.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationsAttribute icecapAttribute;
            IcecapCVar cvar;
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof AnnotationsAttribute && (cvar = (IcecapCVar)(icecapAttribute = (AnnotationsAttribute)attribute).getAnnotation(IcecapCVar.class)) != null) {
                observer.registerNativeField(containingClass, fInfo, cvar);
                isNativeField = true;
            }
            if (attribute instanceof RuntimeInvisibleAnnotations && (cvar = (IcecapCVar)(icecapAttribute = AnnotationsAttribute.getAttribute((RuntimeInvisibleAnnotations)((RuntimeInvisibleAnnotations)attribute))).getAnnotation(IcecapCVar.class)) != null) {
                observer.registerNativeField(containingClass, fInfo, cvar);
                isNativeField = true;
            }
            ++n2;
        }
        return isNativeField;
    }

    public HashMap<JavaClass, ArrayList<FieldInfo>> getObjectFields() {
        return this.objectFields;
    }

    public HashMap<JavaClass, ArrayList<FieldInfo>> getClassFields() {
        return this.classFields;
    }

    public List<FieldInfo> getObjectFields(String className) {
        for (JavaClass nextClass : this.objectFields.keySet()) {
            if (!nextClass.getClassName().equals(className)) continue;
            return this.objectFields.get(nextClass);
        }
        return null;
    }

    public void calculate(Iterator<String> usedClasses, AnalysisObserver observer) throws Exception {
        while (usedClasses.hasNext()) {
            String className = usedClasses.next();
            JavaClass next = Repository.lookupClass((String)className);
            this.calculateOffset(next, this.objectFields, this.classFields, true, observer, new LinkedList<String>());
        }
        Iterator<String> additionalClasses = this.additionalDependencies.iterator();
        while (additionalClasses.hasNext()) {
            observer.classUsed(additionalClasses.next());
        }
    }

    public HashMap<JavaClass, OffsetPair> getObjectSizes() {
        return this.objectSize;
    }

    public LinkedList<String> getMaxClassHeirarchy() {
        return this.maxHeirarchy;
    }
}

