/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.Activator;
import icecaptools.CompilationSequence;
import icecaptools.IcecapEclipseProgressMonitor;
import icecaptools.RestartableMethodObserver;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.conversion.ConversionConfiguration;
import java.io.File;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;

public class ConverterJob
extends Job {
    public static CompilationSequence mostRecentSequence;
    private PrintStream out;
    private ICompilationRegistry cregistry;
    private ConversionConfiguration config;
    private RestartableMethodObserver methodObserver;

    public ConverterJob(String jobName, RestartableMethodObserver methodObserver, ConversionConfiguration config, PrintStream out, ICompilationRegistry cregistry) {
        super(jobName);
        this.methodObserver = methodObserver;
        this.out = out;
        this.cregistry = cregistry;
        this.config = config;
    }

    protected IStatus run(IProgressMonitor progressMonitor) {
        File oFile;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String outputFolder = preferenceStore.getString("ICECAP_OUTPUTFOLDER");
        if (outputFolder != null && outputFolder.length() > 0 && !(oFile = new File(outputFolder)).isDirectory()) {
            return new Status(4, "Icecaptools", 4, "Illegal output folder", (Throwable)new Exception());
        }
        CompilationSequence sequencer = new CompilationSequence();
        try {
            sequencer.startCompilation(this.out, this.methodObserver, this.config, new IcecapEclipseProgressMonitor(progressMonitor), this.cregistry, outputFolder, true);
            mostRecentSequence = sequencer;
        }
        catch (Throwable e) {
            mostRecentSequence = null;
            return new Status(4, "Icecaptools", 4, "compilation failed", e);
        }
        return Status.OK_STATUS;
    }
}

