/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.CompilationSequence;
import icecaptools.IcecapIterator;
import icecaptools.MethodAndClass;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodLocation;
import icecaptools.MethodOrFieldDesc;
import icecaptools.RawByteCodes;
import icecaptools.compiler.LDCConstant;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class ClassfileUtils {
    private ClassfileUtils() {
    }

    public static int getSizeOfType(Type t) throws Exception {
        if (t == Type.BOOLEAN) {
            return 1;
        }
        if (t == Type.BYTE) {
            return 8;
        }
        if (t == Type.SHORT) {
            return 16;
        }
        if (t == Type.CHAR || t == Type.INT || t == Type.FLOAT || t == Type.OBJECT || t.getType() == 13 || t == Type.CLASS || t == Type.STRING || t == Type.STRINGBUFFER || t == Type.THROWABLE || t.getType() == 14) {
            return 32;
        }
        if (t == Type.LONG || t == Type.DOUBLE) {
            return 64;
        }
        if (t == Type.VOID || t == Type.NULL) {
            return 0;
        }
        throw new Exception("Unhandled data type found : " + t + " / " + t.getType());
    }

    public static int getType(Type t) throws Exception {
        if (t == Type.BOOLEAN) {
            return 0;
        }
        if (t == Type.BYTE) {
            return 1;
        }
        if (t == Type.SHORT) {
            return 2;
        }
        if (t == Type.CHAR) {
            return 3;
        }
        if (t == Type.INT) {
            return 4;
        }
        if (t == Type.LONG) {
            return 5;
        }
        if (t == Type.DOUBLE) {
            return 6;
        }
        if (t == Type.FLOAT) {
            return 7;
        }
        return 8;
    }

    public static LDCConstant getLDCConstant(String className, int index) throws ClassNotFoundException {
        JavaClass clazz = Repository.lookupClass((String)className);
        Constant constant = clazz.getConstantPool().getConstant(index);
        if (constant instanceof ConstantString) {
            ConstantString str = (ConstantString)constant;
            return new LDCConstant(str.getBytes(clazz.getConstantPool()));
        }
        if (constant instanceof ConstantInteger) {
            ConstantInteger integer = (ConstantInteger)constant;
            return new LDCConstant(integer.getBytes());
        }
        if (constant instanceof ConstantFloat) {
            ConstantFloat floatVal = (ConstantFloat)constant;
            return new LDCConstant(floatVal.getBytes());
        }
        if (constant instanceof ConstantDouble) {
            ConstantDouble doubleVal = (ConstantDouble)constant;
            double val = doubleVal.getBytes();
            return new LDCConstant(val);
        }
        if (constant instanceof ConstantLong) {
            ConstantLong longVal = (ConstantLong)constant;
            long val = longVal.getBytes();
            return new LDCConstant(val);
        }
        if (constant instanceof ConstantClass) {
            ConstantClass type = (ConstantClass)constant;
            int nameIndex = type.getNameIndex();
            constant = clazz.getConstantPool().getConstant(nameIndex);
            ConstantUtf8 name = (ConstantUtf8)constant;
            return new LDCConstant(true, name.getBytes().replace("/", "."));
        }
        return null;
    }

    public static MethodOrFieldDesc findField(String className, String fieldName, String fieldSignature) throws ClassNotFoundException {
        JavaClass superClass;
        JavaClass clazz = Repository.lookupClass((String)className);
        Field[] fields = clazz.getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                Field current = fields[i];
                if (current.getName().equals(fieldName) && current.getSignature().equals(fieldSignature)) {
                    return new MethodOrFieldDesc(className, fieldName, fieldSignature);
                }
                ++i;
            }
        }
        if ((superClass = clazz.getSuperClass()) != null) {
            return ClassfileUtils.findField(superClass.getClassName(), fieldName, fieldSignature);
        }
        return null;
    }

    public static int getNumArgs(MethodOrFieldDesc referredMethod) throws ClassNotFoundException, Exception {
        JavaClass clazz = Repository.lookupClass((String)referredMethod.getClassName());
        MethodAndClass m = ClassfileUtils.findMethodInClassHierarchy(clazz, referredMethod.getName(), referredMethod.getSignature());
        if (m != null) {
            return ClassfileUtils.getNumArgs(m.getMethod());
        }
        throw new Exception("Could not find num args for [" + referredMethod.toString() + "]");
    }

    public static Method findMethodInClass(JavaClass clazz, String methodName, String methodSignature) {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method current = methods[i];
            if (current.getName().equals(methodName) && current.getSignature().equals(methodSignature)) {
                return current;
            }
            ++i;
        }
        return null;
    }

    public static Method findMethodInClass(JavaClass clazz, String methodName) {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method current = methods[i];
            if (current.getName().equals(methodName)) {
                return current;
            }
            ++i;
        }
        return null;
    }

    public static int getNumArgs(Method m) throws Exception {
        Type[] argTypes = m.getArgumentTypes();
        int nargs = 0;
        int i = 0;
        while (i < argTypes.length) {
            Type current = argTypes[i];
            nargs = current == Type.LONG || current == Type.DOUBLE ? (nargs += 2) : ++nargs;
            ++i;
        }
        return nargs;
    }

    public static int getArgSize(Method m, int argNo) throws Exception {
        int argSize = ClassfileUtils.getArgSize_(m, argNo);
        switch (argSize) {
            case 1: 
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 32: 
            case 64: {
                return 3;
            }
        }
        throw new Exception("Unexpected arg size");
    }

    private static int getArgSize_(Method m, int argNo) throws Exception {
        int index = 0;
        if (!m.isStatic() && --argNo == 0) {
            return 32;
        }
        --argNo;
        Type[] argTypes = m.getArgumentTypes();
        int i = 0;
        while (i < argTypes.length) {
            Type current = argTypes[i];
            if (index == argNo) {
                return ClassfileUtils.getSizeOfType(current);
            }
            if (current == Type.LONG || current == Type.DOUBLE) {
                if (++index == argNo) {
                    return ClassfileUtils.getSizeOfType(current);
                }
                ++index;
            } else {
                ++index;
            }
            ++i;
        }
        throw new Exception("Couldn't get size of argument");
    }

    public static MethodAndClass findMethodInClassHierarchy(JavaClass clazz, String methodName, String methodSignature) throws Exception {
        if (clazz != null) {
            Method m = ClassfileUtils.findMethodInClass(clazz, methodName, methodSignature);
            if (m != null) {
                return new MethodAndClass(m, clazz);
            }
            return ClassfileUtils.findMethodInClassHierarchy(clazz.getSuperClass(), methodName, methodSignature);
        }
        return null;
    }

    public static MethodAndClass findDeclaringInterface(String className, String name, String signature) throws ClassNotFoundException {
        JavaClass clazz = Repository.lookupClass((String)className);
        return ClassfileUtils.findDeclaringInterface(clazz, name, signature);
    }

    public static MethodAndClass findDeclaringInterface(JavaClass clazz, String targetMethodName, String targetMethodSignature) throws ClassNotFoundException {
        JavaClass[] interfaces;
        Method method = ClassfileUtils.findMethodInClass(clazz, targetMethodName, targetMethodSignature);
        if (method != null) {
            return new MethodAndClass(method, clazz);
        }
        JavaClass[] javaClassArray = interfaces = clazz.getAllInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            MethodAndClass declaring;
            JavaClass javaClass = javaClassArray[n2];
            if (javaClass != clazz && (declaring = ClassfileUtils.findDeclaringInterface(javaClass, targetMethodName, targetMethodSignature)) != null) {
                return declaring;
            }
            ++n2;
        }
        return null;
    }

    public static MethodAndClass findMethod(String className, String methodName, String methodSignature) throws Exception {
        JavaClass clazz = Repository.lookupClass((String)className);
        return ClassfileUtils.findMethodInClassHierarchy(clazz, methodName, methodSignature);
    }

    public static int getLineNumber(Method javaMethod, int pc) {
        LineNumberTable lineNumberTable = javaMethod.getLineNumberTable();
        if (lineNumberTable != null) {
            LineNumber[] lineNumbers = lineNumberTable.getLineNumberTable();
            int i = lineNumbers.length - 1;
            while (i >= 0) {
                LineNumber current = lineNumbers[i];
                if (pc >= current.getStartPC()) {
                    return current.getLineNumber();
                }
                --i;
            }
        }
        return -1;
    }

    public static String getSuperClassName(String referredClassName) {
        try {
            JavaClass clazz = Repository.lookupClass((String)referredClassName);
            return clazz.getSuperclassName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String getClassName(String className, int cpIndex) throws Exception {
        JavaClass clazz;
        try {
            clazz = Repository.lookupClass((String)className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Could not lookup class [" + className + "], check classpath for containing jar/project");
        }
        JavaClass referredClass = ClassfileUtils.getType(clazz, cpIndex);
        if (referredClass != null) {
            return referredClass.getClassName();
        }
        return null;
    }

    public static String getClassName(String className, int indexByte1, int indexByte2) throws Exception {
        int cpIndex = RawByteCodes.RawBytecode.bitwiseOr(RawByteCodes.RawBytecode.bitLeftShift(indexByte1 & 0xFF, 8), indexByte2 & 0xFF);
        return ClassfileUtils.getClassName(className, cpIndex);
    }

    public static JavaClass getType(JavaClass clazz, int cpIndex) throws Exception {
        ConstantClass referredType = (ConstantClass)clazz.getConstantPool().getConstant(cpIndex);
        if (referredType != null) {
            ConstantUtf8 className = (ConstantUtf8)clazz.getConstantPool().getConstant(referredType.getNameIndex());
            try {
                JavaClass referredClass = Repository.lookupClass((String)className.getBytes().replace("/", "."));
                return referredClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception("Could not lookup class [" + className.getBytes() + "], check classpath for containing jar/project");
            }
        }
        throw new Exception("Could not get constant [" + cpIndex + "] from class [" + clazz.getClassName() + "]");
    }

    public static MethodOrFieldDesc getMethodDesc(String className, int indexByte1, int indexByte2) throws Exception {
        try {
            int nameAndTypeIndex;
            int classIndex;
            JavaClass clazz = Repository.lookupClass((String)className);
            int cpIndex = RawByteCodes.RawBytecode.bitwiseOr(RawByteCodes.RawBytecode.bitLeftShift(indexByte1 & 0xFF, 8), indexByte2 & 0xFF);
            Constant constant = clazz.getConstantPool().getConstant(cpIndex);
            if (constant instanceof ConstantMethodref) {
                classIndex = ((ConstantMethodref)constant).getClassIndex();
                nameAndTypeIndex = ((ConstantMethodref)constant).getNameAndTypeIndex();
            } else if (constant instanceof ConstantInterfaceMethodref) {
                classIndex = ((ConstantInterfaceMethodref)constant).getClassIndex();
                nameAndTypeIndex = ((ConstantInterfaceMethodref)constant).getNameAndTypeIndex();
            } else if (constant instanceof ConstantFieldref) {
                classIndex = ((ConstantFieldref)constant).getClassIndex();
                nameAndTypeIndex = ((ConstantFieldref)constant).getNameAndTypeIndex();
            } else {
                throw new Exception("Unknow type [" + constant.getClass().toString() + "]");
            }
            ConstantClass constantClass = (ConstantClass)clazz.getConstantPool().getConstant(classIndex);
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)clazz.getConstantPool().getConstant(nameAndTypeIndex);
            ConstantUtf8 invokedClassName = (ConstantUtf8)clazz.getConstantPool().getConstant(constantClass.getNameIndex());
            ConstantUtf8 invokedMethodName = (ConstantUtf8)clazz.getConstantPool().getConstant(constantNameAndType.getNameIndex());
            ConstantUtf8 invokedMethodSignature = (ConstantUtf8)clazz.getConstantPool().getConstant(constantNameAndType.getSignatureIndex());
            return new MethodOrFieldDesc(invokedClassName.getBytes().replace("/", "."), invokedMethodName.getBytes(), invokedMethodSignature.getBytes());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Could not lookup class [" + className + "]");
        }
    }

    public static boolean hasClassInitializer(JavaClass clazz) {
        Method method = ClassfileUtils.findMethodInClass(clazz, "<clinit>", "()V");
        return method != null;
    }

    public static boolean hasDefaultConstructor(JavaClass clazz) {
        Method method = ClassfileUtils.findMethodInClass(clazz, "<init>", "()V");
        return method != null;
    }

    public static String getClassNameIdentifier(String next) {
        return next.toUpperCase().replace(".", "_").replace("[", "_").replace("$", "_");
    }

    public static MethodLocation getMethodLocation(String tName, int lineNumber, CompilationSequence sequence) throws ClassNotFoundException {
        JavaClass clazz = Repository.lookupClass((String)tName);
        if (clazz != null) {
            Method[] methods;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                LineNumberTable lineNumberTable = method.getLineNumberTable();
                if (lineNumberTable != null) {
                    LineNumber[] lnt;
                    LineNumber[] lineNumberArray = lnt = lineNumberTable.getLineNumberTable();
                    int n3 = lnt.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        LineNumber ln = lineNumberArray[n4];
                        if (ln.getLineNumber() >= lineNumber) {
                            BNode bnode;
                            int pc = ln.getStartPC();
                            MethodEntryPoints ep = sequence.getDependencyExtent().getMethod(clazz.getClassName(), method.getName(), method.getSignature());
                            if (ep != null && (bnode = ep.getBNodeFromOriginalAddress(pc)) != null) {
                                IcecapIterator<MethodOrFieldDesc> methodDescriptors = sequence.getObserver().getUsedMethods(clazz.getClassName());
                                while (methodDescriptors.hasNext()) {
                                    int methodNumber;
                                    MethodOrFieldDesc nextMethod = methodDescriptors.next();
                                    if (!nextMethod.getName().equals(method.getName()) || !nextMethod.getSignature().equals(method.getSignature()) || (methodNumber = sequence.getPatcher().getMethodNumber(nextMethod, sequence.getIDGen())) == -1) continue;
                                    MethodLocation ml = new MethodLocation(methodNumber, bnode.getAddress(), ln.getLineNumber());
                                    return ml;
                                }
                            }
                            return null;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

