/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.ByteCollector;

public class ByteCodeStream {
    private long bytecodeLength;
    private byte[] bytecode;
    private long top;
    private ByteCollector byteCollector = null;

    public int get() {
        int c = this.bytecode[(int)this.top] & 0xFF;
        ++this.top;
        if (this.byteCollector != null) {
            this.byteCollector.collect((byte)c);
        }
        return c;
    }

    public long length() {
        return this.bytecodeLength;
    }

    public long pos() {
        return this.top;
    }

    public void init(byte[] bytecode) {
        this.bytecode = bytecode;
        this.bytecodeLength = bytecode.length;
        this.top = 0L;
    }

    public boolean hasMore() {
        return this.top < this.bytecodeLength;
    }

    public void setByteCollector(ByteCollector byteCollector) {
        this.byteCollector = byteCollector;
    }

    public void seek(int address) {
        this.top = address;
    }
}

