/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.FieldAccessBNode;
import icecaptools.MethodCallBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.RefType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class BNodeUtils {
    public static void collectExceptions(MethodEntryPoints method) throws Exception {
        ArrayList<BNode> bnodes = method.getBNodes();
        LinkedList<String> exceptionsThrown = new LinkedList<String>();
        for (BNode bNode : bnodes) {
            boolean doIt = true;
            switch (bNode.getOpCode()) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    doIt = false;
                    break;
                }
                case -76: {
                    AbstractStack stackLayout = bNode.getStackLayout();
                    AbstractStack.StackCell cell = stackLayout.getAt(stackLayout.getSize() - 1);
                    if (!(cell.content instanceof RefType) || ((RefType)cell.content).getState() != RefType.RefState.NONNULL) break;
                    doIt = false;
                    break;
                }
                case -75: {
                    FieldAccessBNode fieldAccess = (FieldAccessBNode)bNode;
                    int fieldSize = fieldAccess.getSize();
                    if (fieldSize <= 0) break;
                    AbstractStack stackLayout = bNode.getStackLayout();
                    AbstractStack.StackCell cell = stackLayout.getAt(stackLayout.getSize() - 1 - fieldSize);
                    if (!(cell.content instanceof RefType) || ((RefType)cell.content).getState() != RefType.RefState.NONNULL) break;
                    doIt = false;
                    break;
                }
                case -73: {
                    MethodCallBNode methodCall = (MethodCallBNode)bNode;
                    int numArgs = methodCall.getNumArgs();
                    boolean checkIt = true;
                    if (numArgs >= 0) {
                        AbstractStack stackLayout = bNode.getStackLayout();
                        AbstractStack.StackCell cell = stackLayout.getAt(stackLayout.getSize() - 1 - numArgs);
                        if (cell.content instanceof RefType && ((RefType)cell.content).getState() == RefType.RefState.NONNULL) {
                            checkIt = false;
                        }
                    }
                    if (!checkIt) break;
                    doIt = true;
                    break;
                }
                default: {
                    doIt = true;
                }
            }
            if (!doIt || !bNode.throwsExceptions()) continue;
            Iterator<String> exceptions = bNode.getExceptionsThrown();
            while (exceptions.hasNext()) {
                String next = exceptions.next();
                if (exceptionsThrown.contains(next)) continue;
                exceptionsThrown.add(next);
            }
        }
        if (exceptionsThrown.size() > 0) {
            method.setMayThrowException();
        }
    }
}

