/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.IcecapIterator;
import icecaptools.NewList;
import icecaptools.RawByteCodes;
import icecaptools.RuntimeMethodCallBNode;
import icecaptools.compiler.aot.StackManager;
import icecaptools.compiler.utils.CallGraph;
import icecaptools.conversion.TargetAddressMap;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.ProducerConsumerNodeInfo;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class BNode {
    private ArrayList<BNode> children;
    protected int address;
    protected int originalAddress;
    private NewList newList;
    private ArrayList<String> exceptionsThrownList;
    public String locationClass;
    public String locationMethod;
    public String locationMethodSignature;
    protected byte[] rawBytes;
    private RawByteCodes.RawBytecode rawByteCode;
    private boolean redundant;
    protected ProducerConsumerNodeInfo ainfo;
    protected AbstractStack stackLayout;
    private StringBuffer translation;
    private StackManager sm;
    private String targetClassName;
    private String targetMethodName;
    private String targetMethodSignature;
    private boolean exceptionsHandled;

    public BNode(int address, String locationClass, String locationMethod, String locationMethodSignature) {
        this.address = address;
        this.originalAddress = address;
        this.locationClass = locationClass;
        this.locationMethod = locationMethod;
        this.locationMethodSignature = locationMethodSignature;
        this.redundant = false;
        this.children = new ArrayList();
        this.newList = null;
        this.exceptionsThrownList = new ArrayList();
        this.ainfo = new ProducerConsumerNodeInfo();
    }

    public ProducerConsumerNodeInfo getAinfo() {
        return this.ainfo;
    }

    public int getAddress() {
        return this.address;
    }

    public int getOriginalAddress() {
        return this.originalAddress;
    }

    public void addChild(BNode child) {
        this.children.add(child);
    }

    public Iterator<BNode> getChildren() {
        return this.children.iterator();
    }

    public void link(BNode[] nodes, TargetAddressMap tmap) throws Exception {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == this && i + 1 < nodes.length) {
                this.addChild(nodes[i + 1]);
            }
            ++i;
        }
        if (this.throwsExceptions()) {
            Iterator<String> exceptions = this.getExceptionsThrown();
            while (exceptions.hasNext()) {
                RuntimeMethodCallBNode initException = new RuntimeMethodCallBNode(this.address, exceptions.next(), "<init>", "()V", this.locationClass, this.locationMethod, this.locationMethodSignature);
                byte[] invokespecial = new byte[]{-73};
                initException.setRawBytes(invokespecial);
                this.addChild(initException);
            }
        }
    }

    protected static BNode findNodeWithAddress(BNode[] nodes, int address) throws Exception {
        int i = 0;
        while (i < nodes.length) {
            BNode current = nodes[i];
            if (current.getAddress() == address) {
                return current;
            }
            ++i;
        }
        throw new Exception("Could not find branch target");
    }

    public NewList getNewList() {
        return this.newList;
    }

    public void setNewList(NewList newList) {
        this.newList = newList;
    }

    public boolean throwsExceptions() {
        return this.exceptionsThrownList != null;
    }

    public Iterator<String> getExceptionsThrown() {
        return this.exceptionsThrownList.iterator();
    }

    public void setExceptionsThrown(IcecapIterator<String> exceptionsThrown) {
        ArrayList<String> exceptionsThrownList = new ArrayList<String>();
        while (exceptionsThrown.hasNext()) {
            exceptionsThrownList.add(exceptionsThrown.next());
        }
        if (exceptionsThrownList.size() > 0) {
            this.exceptionsThrownList = exceptionsThrownList;
        }
    }

    public void setRawBytes(byte[] rawBytes) {
        this.rawBytes = rawBytes;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public abstract boolean requiresExtension();

    public int extend() throws Exception {
        throw new Exception("Not implemented");
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public abstract void relocateForward(int var1, int var2);

    public abstract void relocateBackward(int var1, int var2);

    protected abstract String print();

    public byte getOpCode() {
        return this.rawBytes[0];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   " + this.originalAddress + ": ");
        buffer.append(this.print());
        return buffer.toString();
    }

    public void setStackLayout(AbstractStack stackLayout) {
        this.stackLayout = stackLayout;
    }

    public AbstractStack getStackLayout() {
        return this.stackLayout;
    }

    public StringBuffer getTranslation() {
        return this.translation;
    }

    public void setTranslation(StringBuffer translation) {
        this.translation = translation;
    }

    public void setStackManager(StackManager sm) {
        this.sm = sm;
    }

    public StackManager getStackManager() {
        return this.sm;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void setRedundant(boolean redundant) {
        this.redundant = redundant;
    }

    public void setRawBytecode(RawByteCodes.RawBytecode rawByteCode) {
        this.rawByteCode = rawByteCode;
    }

    public RawByteCodes.RawBytecode getRawByteCode() {
        return this.rawByteCode;
    }

    public void registerInCallGraph(CallGraph cg, String targetClassName, String targetMethodName, String targetMethodSignature) {
        if (this.targetClassName == null) {
            this.targetClassName = targetClassName;
            this.targetMethodName = targetMethodName;
            this.targetMethodSignature = targetMethodSignature;
            cg.register(this, this.locationClass, this.locationMethod, this.locationMethodSignature, targetClassName, targetMethodName, targetMethodSignature);
        } else if (this.targetMethodName != targetMethodName || this.targetMethodSignature != targetMethodSignature || this.targetClassName != targetClassName) {
            cg.register(this, this.locationClass, this.locationMethod, this.locationMethodSignature, targetClassName, targetMethodName, targetMethodSignature);
        }
    }

    public boolean exceptionsHandled() {
        return this.exceptionsHandled;
    }

    public void setExceptionsHandled() {
        this.exceptionsHandled = true;
    }
}

