/*
 * Decompiled with CFR 0.152.
 */
package vm;

import devices.Console;
import icecaptools.IcecapCVar;
import icecaptools.IcecapCompileMe;
import java.util.ArrayList;
import javax.realtime.MemoryArea;

public class Memory {
    private int base;
    private int size;
    private int free;
    private String name;
    private MemoryInfo memoryInfo;
    public static boolean memoryAreaTrackingEnabled;
    private static Memory areaToUseForTracking;
    private static ArrayList<MemoryInfo> createdMemories;
    @IcecapCVar
    private static Memory currentMemoryArea;
    @IcecapCVar
    private static Memory heapArea;
    private static int nameCount;

    @IcecapCompileMe
    private MemoryInfo addMemoryArea(Memory m) {
        MemoryInfo memory2;
        if (areaToUseForTracking == null) {
            areaToUseForTracking = m;
        }
        Memory current = Memory.switchToArea(areaToUseForTracking);
        if (createdMemories == null) {
            createdMemories = new ArrayList();
            Memory.heapArea.name = "HEAP";
            memory2 = new MemoryInfo(heapArea);
            createdMemories.add(memory2);
            Memory.heapArea.memoryInfo = memory2;
        }
        for (MemoryInfo memory2 : createdMemories) {
            if (memory2.name.compareTo(m.name) != 0) continue;
            memory2.increaseInstanceCount();
            Memory.switchToArea(current);
            return memory2;
        }
        memory2 = new MemoryInfo(m);
        createdMemories.add(memory2);
        Memory.switchToArea(current);
        return memory2;
    }

    @IcecapCompileMe
    public static void reportMemoryUsage() {
        if (memoryAreaTrackingEnabled) {
            if (createdMemories != null) {
                Memory current = Memory.switchToArea(areaToUseForTracking);
                Console.println("\nCreated " + createdMemories.size() + " memory area types:");
                for (MemoryInfo memory : createdMemories) {
                    Console.println(memory.toString());
                }
                Console.println("Max backing store usage = " + MemoryArea.getRemainingMemorySize());
                Memory.switchToArea(current);
            } else {
                Console.println("No created memories recorded");
            }
        } else {
            Console.println("Memory tracking disabled");
        }
    }

    @IcecapCompileMe
    public Memory(int base, int size, String name) {
        this.base = base;
        this.size = size;
        this.free = 0;
        String string = this.name = name == null ? "Unknown" : name;
        if (memoryAreaTrackingEnabled) {
            this.memoryInfo = this.addMemoryArea(this);
        }
    }

    private Memory(int base, int size) {
        this.base = base;
        this.size = size;
        this.free = 0;
        this.name = "BackingStore";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append(": size = ");
        buffer.append(this.size);
        buffer.append(", used = " + this.free);
        return buffer.toString();
    }

    @IcecapCompileMe
    public static Memory switchToArea(Memory newScope) {
        Memory previousMemoryArea = currentMemoryArea;
        currentMemoryArea = newScope;
        return previousMemoryArea;
    }

    @IcecapCompileMe
    public static Memory allocateInHeap(int size) {
        if (Memory.heapArea.free + size >= Memory.heapArea.size) {
            throw new OutOfMemoryError();
        }
        int startPtr = Memory.heapArea.base + Memory.heapArea.free;
        Memory.heapArea.free += size;
        Memory memory = new Memory(startPtr, size);
        return memory;
    }

    @IcecapCompileMe
    public static Memory getHeapArea() {
        return heapArea;
    }

    @IcecapCompileMe
    public static Memory getCurrentMemoryArea() {
        return currentMemoryArea;
    }

    public void reset(int newFree) {
        this.free = newFree;
    }

    public void resize(int newSize) {
        this.size = newSize;
    }

    public int consumedMemory() {
        return this.free;
    }

    public int getBase() {
        return this.base;
    }

    public int getSize() {
        return this.size;
    }

    @IcecapCompileMe
    public static void startMemoryAreaTracking() {
        Memory.updateMaxUsed(heapArea);
        memoryAreaTrackingEnabled = true;
    }

    @IcecapCompileMe
    public static void updateMaxUsed(Memory m) {
        if (m.memoryInfo != null && m.free > m.memoryInfo.maxUsed) {
            m.memoryInfo.maxUsed = m.free;
        }
    }

    @IcecapCompileMe
    public static void executeInHeap(Runnable logic) {
        Memory current = Memory.switchToArea(areaToUseForTracking);
        logic.run();
        Memory.switchToArea(current);
    }

    public String getName() {
        return this.name;
    }

    public static String getNextMemoryName(String defaultName) {
        if (memoryAreaTrackingEnabled) {
            Memory current = Memory.switchToArea(areaToUseForTracking);
            String name = String.valueOf(defaultName) + nameCount;
            ++nameCount;
            Memory.switchToArea(current);
            return name;
        }
        return defaultName;
    }

    public static void dumpLiveMemories() {
        if (memoryAreaTrackingEnabled) {
            Memory current = Memory.switchToArea(areaToUseForTracking);
            MemoryArea.printMemoryAreas();
            Memory.switchToArea(current);
        }
    }

    public static void executeInTrackingArea(Runnable logic) {
        if (memoryAreaTrackingEnabled) {
            Memory current = Memory.switchToArea(areaToUseForTracking);
            logic.run();
            Memory.switchToArea(current);
        }
    }

    private static class MemoryInfo {
        String name;
        int size;
        int maxUsed;
        private int instanceCount;

        public MemoryInfo(Memory m) {
            this.name = m.name;
            this.size = m.size;
            this.maxUsed = 0;
            this.instanceCount = 1;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.name);
            buffer.append("[" + this.instanceCount + "]");
            buffer.append(": size = ");
            buffer.append(this.size);
            buffer.append(", max used = " + this.maxUsed);
            return buffer.toString();
        }

        public void increaseInstanceCount() {
            ++this.instanceCount;
        }
    }
}

