/*
 * Decompiled with CFR 0.152.
 */
package reflect;

import java.lang.reflect.Method;
import reflect.MethodInfo;
import reflect.ObjectInfo;

public class ReflectionUtils {
    private static Method[] methodCache;
    static MethodObjectInfo objectInfo;

    public static Method getMethod(Class<?> cl, String name, Class<?> ... parameterTypes) {
        short index = ReflectionUtils.getMethodIndex(cl, name, parameterTypes);
        short numberOfMethods = MethodInfo.getNumberOfMethods();
        if (index != -1) {
            try {
                Method m = ReflectionUtils.getCachedMethod(index, numberOfMethods);
                if (m == null) {
                    m = (Method)Method.class.newInstance();
                    ReflectionUtils.writeMethodIndex(m, index);
                    ReflectionUtils.setMethodCache(m, index);
                }
                return m;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }
        return null;
    }

    public static short getMethodIndex(Class<?> cl, String name, Class<?> ... parameterTypes) {
        short numberOfMethods = MethodInfo.getNumberOfMethods();
        do {
            String className = cl.getName();
            short index = 0;
            while (index < numberOfMethods) {
                MethodInfo mInfo = MethodInfo.getMethodInfo(index);
                String currentName = mInfo.getName(index);
                if (currentName.startsWith(className) && currentName.endsWith(name) && currentName.length() == className.length() + name.length() + 1 && mInfo.numArgs == parameterTypes.length) {
                    return index;
                }
                index = (short)(index + 1);
            }
        } while ((cl = cl.getSuperclass()) != Object.class);
        return -1;
    }

    private static void writeMethodIndex(Method m, short index) {
        if (objectInfo == null) {
            objectInfo = new MethodObjectInfo();
        }
        objectInfo.setAddress(ObjectInfo.getAddress(m));
        objectInfo.setShort((short)0, index);
    }

    public static short readMethodIndex(Method m) {
        if (objectInfo == null) {
            objectInfo = new MethodObjectInfo();
        }
        objectInfo.setAddress(ObjectInfo.getAddress(m));
        return objectInfo.getShort((short)0);
    }

    private static void setMethodCache(Method m, short index) {
        ReflectionUtils.methodCache[index] = m;
    }

    private static Method getCachedMethod(short index, short numberOfMethods) {
        if (methodCache == null) {
            methodCache = new Method[numberOfMethods];
        }
        return methodCache[index];
    }

    private static class MethodObjectInfo
    extends ObjectInfo {
        private short shortValue;

        private MethodObjectInfo() {
        }

        public short getShort(short offset) {
            this.address.add(offset * 2 - 4);
            short s = this.shortValue;
            this.address.sub(offset * 2 - 4);
            return s;
        }

        public void setShort(short offset, short value) {
            this.address.add(offset * 2 - 4);
            this.shortValue = value;
            this.address.sub(offset * 2 - 4);
        }
    }
}

