/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import minicdj.util.AbstractCollection;
import minicdj.util.Collection;
import minicdj.util.ConcurrentModificationException;
import minicdj.util.Iterator;
import minicdj.util.List;
import minicdj.util.ListIterator;
import minicdj.util.NoSuchElementException;
import minicdj.util.RandomAccess;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public abstract Object get(int var1);

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        int size;
        Iterator itr = c.iterator();
        int pos = size = c.size();
        while (pos > 0) {
            this.add(index++, itr.next());
            --pos;
        }
        return size > 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int size = this.size();
        if (size != ((List)o).size()) {
            return false;
        }
        Iterator itr1 = this.iterator();
        Iterator itr2 = ((List)o).iterator();
        while (--size >= 0) {
            if (AbstractList.equals(itr1.next(), itr2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            hashCode = 31 * hashCode + AbstractList.hashCode(itr.next());
        }
        return hashCode;
    }

    @Override
    public int indexOf(Object o) {
        ListIterator itr = this.listIterator();
        int size = this.size();
        int pos = 0;
        while (pos < size) {
            if (AbstractList.equals(o, itr.next())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;
            private int size;
            private int last;
            private int knownMod;
            {
                this.size = AbstractList.this.size();
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.checkMod();
                return this.pos < this.size;
            }

            @Override
            public Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        int pos = this.size();
        ListIterator itr = this.listIterator(pos);
        while (--pos >= 0) {
            if (!AbstractList.equals(o, itr.previous())) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new ListIterator(index){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.knownMod = AbstractList.this.modCount;
                this.position = n;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.checkMod();
                return this.position < this.size;
            }

            @Override
            public boolean hasPrevious() {
                this.checkMod();
                return this.position > 0;
            }

            @Override
            public Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            @Override
            public Object previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return AbstractList.this.get(this.lastReturned);
            }

            @Override
            public int nextIndex() {
                this.checkMod();
                return this.position;
            }

            @Override
            public int previousIndex() {
                this.checkMod();
                return this.position - 1;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            @Override
            public void set(Object o) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.set(this.lastReturned, o);
            }

            @Override
            public void add(Object o) {
                this.checkMod();
                AbstractList.this.add(this.position++, o);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator itr = this.listIterator(fromIndex);
        int index = fromIndex;
        while (index < toIndex) {
            itr.next();
            itr.remove();
            ++index;
        }
    }

    @Override
    public Object set(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(String.valueOf(fromIndex) + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    private static final class RandomAccessSubList
    extends SubList
    implements RandomAccess {
        RandomAccessSubList(AbstractList backing, int fromIndex, int toIndex) {
            super(backing, fromIndex, toIndex);
        }
    }

    private static class SubList
    extends AbstractList {
        final AbstractList backingList;
        final int offset;
        int size;

        SubList(AbstractList backing, int fromIndex, int toIndex) {
            this.backingList = backing;
            this.modCount = backing.modCount;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        @Override
        public int size() {
            this.checkMod();
            return this.size;
        }

        @Override
        public Object set(int index, Object o) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.set(index + this.offset, o);
        }

        @Override
        public Object get(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            return this.backingList.get(index + this.offset);
        }

        @Override
        public void add(int index, Object o) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            this.backingList.add(index + this.offset, o);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public Object remove(int index) {
            this.checkMod();
            this.checkBoundsExclusive(index);
            Object o = this.backingList.remove(index + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return o;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkMod();
            this.backingList.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.size -= toIndex - fromIndex;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public boolean addAll(int index, Collection c) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            int csize = c.size();
            boolean result = this.backingList.addAll(this.offset + index, c);
            this.size += csize;
            this.modCount = this.backingList.modCount;
            return result;
        }

        @Override
        public boolean addAll(Collection c) {
            return this.addAll(this.size, c);
        }

        @Override
        public Iterator iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            return new ListIterator(index){
                private final ListIterator i;
                private int position;
                {
                    this.i = subList.backingList.listIterator(n + subList.offset);
                    this.position = n;
                }

                @Override
                public boolean hasNext() {
                    this.checkMod();
                    return this.position < size;
                }

                @Override
                public boolean hasPrevious() {
                    this.checkMod();
                    return this.position > 0;
                }

                @Override
                public Object next() {
                    if (this.position == size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                @Override
                public Object previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - offset;
                }

                @Override
                public void remove() {
                    this.i.remove();
                    --size;
                    this.position = this.nextIndex();
                    modCount = backingList.modCount;
                }

                @Override
                public void set(Object o) {
                    this.i.set(o);
                }

                @Override
                public void add(Object o) {
                    this.i.add(o);
                    ++size;
                    ++this.position;
                    modCount = backingList.modCount;
                }
            };
        }
    }
}

