/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.RelativeTime;
import javax.safetycritical.CyclicExecutive;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.Frame;
import javax.safetycritical.PeriodicEventHandler;
import minicdj.cdx.CollisionDetectorHandler;
import minicdj.cdx.Constants;
import minicdj.cdx.ImmortalEntry;
import minicdj.cdx.unannotated.NanoClock;
import minicdj.simulator.immortal.Simulator;

public class Level0Safelet
extends CyclicExecutive {
    public void setup() {
        Constants.PRESIMULATE = true;
        new ImmortalEntry().run();
        new Simulator().generate();
    }

    public void teardown() {
        Console.println("Level0Safelet.teardown");
        Level0Safelet.dumpResults();
    }

    @Override
    public CyclicSchedule getSchedule(PeriodicEventHandler[] handlers) {
        Frame[] frames = new Frame[1];
        CyclicSchedule schedule = new CyclicSchedule(frames);
        PeriodicEventHandler[] handlerArr = new PeriodicEventHandler[]{handlers[0]};
        frames[0] = new Frame(new RelativeTime(Constants.DETECTOR_PERIOD, 0), handlerArr);
        return schedule;
    }

    @Override
    @IcecapCompileMe
    protected void initialize() {
        try {
            ImmortalEntry.detectorThreadStart = NanoClock.now();
            AbsoluteTime releaseAt = NanoClock.roundUp(Clock.getRealtimeClock().getTime().add(Constants.DETECTOR_STARTUP_OFFSET_MILLIS, 0));
            ImmortalEntry.detectorFirstRelease = NanoClock.convert(releaseAt);
            new CollisionDetectorHandler(this).register();
            if (Constants.DEBUG_DETECTOR) {
                Console.println("Detector thread is " + Thread.currentThread());
                Console.println("Entering detector loop, detector thread priority is Unknown (NORM_PRIORITY is 5, MIN_PRIORITY is 1, MAX_PRIORITY is 10)");
            }
        }
        catch (Throwable e) {
            Console.println("e: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public long missionMemorySize() {
        return Constants.PERSISTENT_DETECTOR_SCOPE_SIZE;
    }

    public static void dumpResults() {
        String space = " ";
        String triZero = " 0 0 0 ";
        Console.println("Dumping output [ timeBefore timeAfter heapFreeBefore heapFreeAfter detectedCollisions ] for " + ImmortalEntry.recordedRuns + " recorded detector runs, in ns");
        Console.println("=====DETECTOR-STATS-START-BELOW====");
        int i = 0;
        while (i < ImmortalEntry.recordedRuns) {
            Console.print(ImmortalEntry.timesBefore[i]);
            Console.print(space);
            Console.print(ImmortalEntry.timesAfter[i]);
            Console.print(space);
            Console.print(ImmortalEntry.detectedCollisions[i]);
            Console.print(space);
            Console.print(ImmortalEntry.suspectedCollisions[i]);
            Console.print(triZero);
            Console.println(i);
            ++i;
        }
        Console.println("=====DETECTOR-STATS-END-ABOVE====");
        Console.println("Generated frames: " + Constants.MAX_FRAMES);
        Console.println("Received (and measured) frames: " + ImmortalEntry.recordedRuns);
        Console.println("Frame not ready event count (in detector): " + ImmortalEntry.frameNotReadyCount);
        Console.println("Frames dropped due to full buffer in detector: " + ImmortalEntry.droppedFrames);
        Console.println("Frames processed by detector: " + ImmortalEntry.framesProcessed);
        Console.println("Reported missed detector periods (reported by waitForNextPeriod): " + ImmortalEntry.reportedMissedPeriods);
        Console.println("Detector first release was scheduled for: " + NanoClock.asString(ImmortalEntry.detectorFirstRelease));
        Simulator.dumpStats();
        Console.println("=====DETECTOR-RELEASE-STATS-START-BELOW====");
        i = 0;
        while (i < ImmortalEntry.recordedDetectorReleaseTimes) {
            Console.print(ImmortalEntry.detectorReleaseTimes[i]);
            Console.print(space);
            Console.print((long)i * Constants.DETECTOR_PERIOD * 1000000L + ImmortalEntry.detectorReleaseTimes[0]);
            Console.print(space);
            Console.print(ImmortalEntry.detectorReportedMiss[i] ? 1 : 0);
            Console.print(space);
            Console.println(i);
            ++i;
        }
        Console.println("=====DETECTOR-RELEASE-STATS-END-ABOVE====");
    }
}

