/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.safetycritical.AffinitySet;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.Mission;
import javax.safetycritical.Monitor;
import javax.safetycritical.MultiprocessorHelpingScheduler;
import javax.safetycritical.OSProcess;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import vm.Memory;

@SCJAllowed
public class Services {
    static ServicesBehavior servicesBehavior = null;

    @SCJAllowed
    public static void captureBackTrace(Throwable association) {
    }

    @SCJAllowed
    public static ManagedSchedulable currentManagedSchedulable() {
        return servicesBehavior.currentManagedSchedulable();
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public static int getDefaultCeiling() {
        return servicesBehavior.getDefaultCeiling();
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public static void setCeiling(Object target, int ceiling) {
        servicesBehavior.setCeiling(target, ceiling);
    }

    public static AffinitySet[] getSchedulingAllocationDomains() {
        return AffinitySet.AFFINITY_SET;
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public static void nanoSpin(int nanos) {
        Clock clock = Clock.getRealtimeClock();
        AbsoluteTime time = new AbsoluteTime();
        AbsoluteTime next = new AbsoluteTime();
        clock.getTime(time);
        time.add(0L, nanos, next);
        while (time.compareTo(next) < 0) {
            clock.getTime(time);
        }
    }

    public static int getCurrentCPUID() {
        return OSProcess.getCurrentCPUID();
    }

    public static int getAvailableCPUCount() {
        return OSProcess.getAvailableCPUCount();
    }

    public static String getNameOfCurrentMemoryArea() {
        return servicesBehavior.getNameOfCurrentMemoryArea();
    }

    static final class MulticoreBehavior
    extends ServicesBehavior {
        MulticoreBehavior() {
        }

        @Override
        ManagedSchedulable currentManagedSchedulable() {
            return Mission.missionBehaviour.getManageSched(OSProcess.getThreadID());
        }

        @Override
        int getDefaultCeiling() {
            return OSProcess.getMaxPriority();
        }

        @Override
        void setCeiling(Object target, int ceiling) {
            vm.Monitor monitor = MultiprocessorHelpingScheduler.getMultiprocessorMonitor(ceiling);
            monitor.attach(target);
        }

        @Override
        String getNameOfCurrentMemoryArea() {
            return OSProcess.getCurrentMemoryArea().getName();
        }
    }

    static abstract class ServicesBehavior {
        ServicesBehavior() {
        }

        abstract ManagedSchedulable currentManagedSchedulable();

        abstract int getDefaultCeiling();

        abstract void setCeiling(Object var1, int var2);

        abstract String getNameOfCurrentMemoryArea();
    }

    static final class SinglecoreBehavior
    extends ServicesBehavior {
        SinglecoreBehavior() {
        }

        @Override
        ManagedSchedulable currentManagedSchedulable() {
            if (Launcher.level == 0) {
                return CyclicScheduler.instance().seq;
            }
            return PriorityScheduler.instance().current.getTarget();
        }

        @Override
        int getDefaultCeiling() {
            return PriorityScheduler.instance().getMaxPriority();
        }

        @Override
        void setCeiling(Object target, int ceiling) {
            Monitor monitor = new Monitor(ceiling);
            monitor.attach(target);
        }

        @Override
        String getNameOfCurrentMemoryArea() {
            return Memory.getCurrentMemoryArea().getName();
        }
    }
}

