/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedLongEventHandler;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityFrame;
import javax.safetycritical.Process;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;
import vm.Memory;
import vm.ProcessLogic;
import vm.RealtimeClock;

class ScjProcess
extends Process
implements Comparable<ScjProcess> {
    vm.Process process;
    Clock rtClock = Clock.getRealtimeClock();
    AbsoluteTime next = new AbsoluteTime(this.rtClock);
    RelativeTime start;
    RelativeTime period;
    Object monitorLock = null;
    AbsoluteTime next_temp = null;
    boolean isNotified = false;
    private ExceptionReporter exceptionReporter;
    static ScjProcess idleProcess;

    ScjProcess(ManagedSchedulable ms, int[] stack) {
        this.msObject = ms;
        this.state = 0;
        this.exceptionReporter = new ExceptionReporter();
        this.process = new vm.Process(new ProcessLogic(){

            @Override
            public void run() {
                try {
                    try {
                        ScjProcess.this.runLogic(ScjProcess.this.msObject);
                    }
                    catch (Exception e) {
                        Const.reporter.processExecutionError(e);
                        if (ScjProcess.this.msObject instanceof PeriodicEventHandler) {
                            ScjProcess.this.next.add(ScjProcess.this.period, ScjProcess.this.next);
                        }
                        ScjProcess.this.state = 5;
                    }
                }
                finally {
                    if (ScjProcess.this.msObject instanceof PeriodicEventHandler) {
                        ScjProcess.this.next.add(ScjProcess.this.period, ScjProcess.this.next);
                    }
                    ScjProcess.this.state = 5;
                }
            }

            @Override
            public void catchError(Throwable t) {
                ((ScjProcess)ScjProcess.this).exceptionReporter.t = t;
                try {
                    ManagedMemory.ImmortalMemory immortal = ManagedMemory.ImmortalMemory.instance();
                    if (immortal != null) {
                        immortal.executeInArea(ScjProcess.this.exceptionReporter);
                    } else {
                        Memory.executeInHeap(ScjProcess.this.exceptionReporter);
                    }
                }
                catch (OutOfMemoryError o) {
                    Const.reporter.processOutOfMemoryError(o);
                }
            }
        }, stack);
        this.process.initialize();
        this.rtClock.getTime(this.next);
        this.setRelease(this.msObject);
        this.setProcess(this.msObject);
    }

    private void runLogic(ManagedSchedulable ms) {
        if (ms instanceof ManagedEventHandler) {
            ((ManagedEventHandler)ms).privateMemory.enter(ms);
        } else if (ms instanceof ManagedThread) {
            ((ManagedThread)ms).privateMemory.enter(ms);
        } else {
            ((ManagedLongEventHandler)ms).privateMemory.enter(ms);
        }
    }

    private void setRelease(ManagedSchedulable ms) {
        if (ms instanceof PeriodicEventHandler) {
            this.start = ((PeriodicParameters)((PeriodicEventHandler)ms).release).getStart();
            this.period = ((PeriodicParameters)((PeriodicEventHandler)ms).release).getPeriod();
            this.next.add(this.start, this.next);
        } else if (ms instanceof OneShotEventHandler) {
            if (((OneShotEventHandler)ms).releaseTime instanceof RelativeTime) {
                RelativeTime releaseTime = (RelativeTime)((OneShotEventHandler)ms).releaseTime;
                this.next.add(releaseTime, this.next);
            } else {
                AbsoluteTime releaseTime = (AbsoluteTime)((OneShotEventHandler)ms).releaseTime;
                int compare = releaseTime.compareTo(Clock.getRealtimeClock().getTime(new AbsoluteTime(this.rtClock)));
                if (compare < 0) {
                    this.next.add(new RelativeTime(), this.next);
                } else {
                    this.next.set(releaseTime);
                }
            }
        }
    }

    public String toString() {
        return "ScjProcess:" + this.msObject + " index: " + this.index;
    }

    @Override
    public int compareTo(ScjProcess process) {
        if (this.msObject instanceof ManagedEventHandler && process.msObject instanceof ManagedEventHandler) {
            return ((ManagedEventHandler)this.msObject).priority.getPriority() - ((ManagedEventHandler)process.msObject).priority.getPriority();
        }
        if (this.msObject instanceof ManagedThread && process.msObject instanceof ManagedThread) {
            return ((ManagedThread)this.msObject).priority.getPriority() - ((ManagedThread)process.msObject).priority.getPriority();
        }
        if (this.msObject instanceof ManagedLongEventHandler && process.msObject instanceof ManagedLongEventHandler) {
            return ((ManagedLongEventHandler)this.msObject).priority.getPriority() - ((ManagedLongEventHandler)process.msObject).priority.getPriority();
        }
        return -999;
    }

    ManagedSchedulable getTarget() {
        return this.msObject;
    }

    void setIndex(int index) {
        this.index = index;
    }

    static ScjProcess createIdleProcess() {
        if (idleProcess == null) {
            PeriodicEventHandler peh = new PeriodicEventHandler(new PriorityParameters(1), new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()), Const.INFINITE_TIME), new StorageParameters(2 * Const.IDLE_BACKING_STORE, new long[]{Const.IDLE_PROCESS_STACK_SIZE}, 2 * Const.IDLE_BACKING_STORE, 0L, 0L)){

                @Override
                public void handleAsyncEvent() {
                    this.yield();
                }

                @IcecapCompileMe
                private void yield() {
                    while (true) {
                        RealtimeClock.awaitNextTick();
                    }
                }
            };
            ScjProcess process = new ScjProcess(peh, new int[Const.IDLE_PROCESS_STACK_SIZE]);
            process.rtClock.getTime(process.next);
            process.index = -1;
            idleProcess = process;
        }
        return idleProcess;
    }

    public void start() {
        this.process.initialize();
    }

    String print() {
        return "name: " + this.msObject + " \tindex: " + this.index;
    }

    protected boolean nextState(PriorityFrame pFrame) {
        return false;
    }

    protected void gotoNextState(PriorityFrame pFrame) {
    }

    void switchToPrivateMemArea() {
    }

    private static class ExceptionReporter
    implements Runnable {
        Throwable t;

        private ExceptionReporter() {
        }

        @Override
        public void run() {
            Const.reporter.processExecutionError(this.t);
        }
    }

    static interface State {
        public static final byte NEW = 0;
        public static final byte READY = 1;
        public static final byte EXECUTING = 2;
        public static final byte BLOCKED = 3;
        public static final byte SLEEPING = 4;
        public static final byte HANDLED = 5;
        public static final byte TERMINATED = 6;
        public static final byte WAITING = 7;
        public static final byte REQUIRELOCK = 8;
    }
}

