/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.Mission;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import vm.ClockInterruptHandler;

class PriorityQueueForLockAndWait {
    int[] queue;
    int tail;
    int queueSize;

    PriorityQueueForLockAndWait(int size) {
        this.queue = new int[size];
        this.tail = -1;
        this.queueSize = 0;
        this.makeEmptyQueue(this.queue);
    }

    private void makeEmptyQueue(int[] set) {
        int i = 0;
        while (i < set.length) {
            set[i] = -999;
            ++i;
        }
    }

    protected void addProcess(Object monitor, ScjProcess process) {
        ClockInterruptHandler.instance.disable();
        if (this.tail < this.queue.length - 1) {
            ++this.tail;
            int index = this.tail;
            int i = 0;
            while (i < this.tail) {
                ScjProcess temp = this.getScjProcess(this.queue[i]);
                if (temp == null) {
                    throw new IllegalArgumentException("1");
                }
                if (ManagedSchedMethods.getPriorityParameter(process.getTarget()).getPriority() > ManagedSchedMethods.getPriorityParameter(temp.getTarget()).getPriority()) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != this.tail) {
                i = this.tail;
                while (i > index) {
                    this.queue[i] = this.queue[i - 1];
                    --i;
                }
            }
            process.monitorLock = monitor;
            this.queue[index] = process.index;
            ++this.queueSize;
        } else {
            throw new IndexOutOfBoundsException("set: too small");
        }
        ClockInterruptHandler.instance.enable();
    }

    protected ScjProcess getNextProcess(Object monitor) {
        int i = 0;
        while (i <= this.tail) {
            ScjProcess process = this.getScjProcess(this.queue[i]);
            if (process.monitorLock == monitor) {
                process.monitorLock = null;
                this.reorderSet(i);
                --this.queueSize;
                return process;
            }
            ++i;
        }
        return null;
    }

    public void removeProcess(ScjProcess process) {
        int i = 0;
        while (i <= this.tail) {
            if (this.queue[i] == process.index) {
                this.reorderSet(i);
                process.monitorLock = null;
                --this.queueSize;
            }
            ++i;
        }
    }

    private void reorderSet(int index) {
        int i = index;
        while (i <= this.tail - 1) {
            this.queue[i] = this.queue[i + 1];
            ++i;
        }
        this.queue[this.tail] = -999;
        --this.tail;
    }

    private ScjProcess getScjProcess(int processIdx) {
        if (processIdx == -999) {
            return null;
        }
        if (processIdx == -2) {
            return PriorityScheduler.instance().outerMostSeqProcess;
        }
        if (processIdx == -1) {
            return ScjProcess.idleProcess;
        }
        return (ScjProcess)Mission.missionBehaviour.getProcess(processIdx);
    }

    public void print() {
        Console.println("queue size = " + (this.tail + 1));
        int i = 0;
        while (i < this.queue.length) {
            Console.print("[ " + this.queue[i] + " ] ");
            ++i;
        }
        Console.println("");
    }
}

