/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.PeriodicParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityQueue;
import javax.safetycritical.PriorityQueueForLockAndWait;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.SleepingQueue;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class PriorityFrame {
    PriorityQueue readyQueue;
    SleepingQueue sleepingQueue;
    PriorityQueueForLockAndWait waitQueue;
    PriorityQueueForLockAndWait lockQueue;

    PriorityFrame(int queueSize) {
        this.readyQueue = new PriorityQueue(queueSize);
        this.sleepingQueue = new SleepingQueue(queueSize);
        this.waitQueue = new PriorityQueueForLockAndWait(queueSize);
        this.lockQueue = new PriorityQueueForLockAndWait(queueSize);
    }

    void addProcess(ScjProcess process) {
        if (process.getTarget() instanceof PeriodicEventHandler) {
            PeriodicEventHandler pevh = (PeriodicEventHandler)process.getTarget();
            RelativeTime start = ((PeriodicParameters)pevh.release).getStart();
            if (start.getMilliseconds() == 0L && start.getNanoseconds() == 0) {
                process.state = 1;
                this.readyQueue.insert(process);
            } else {
                process.state = 4;
                this.sleepingQueue.insert(process);
            }
        } else if (process.getTarget() instanceof MissionSequencer) {
            process.state = 1;
            this.readyQueue.insert(process);
        } else if (process.getTarget() instanceof AperiodicEventHandler) {
            process.state = 3;
        } else if (process.getTarget() instanceof OneShotEventHandler) {
            process.state = 4;
            this.sleepingQueue.insert(process);
        } else if (process.getTarget() instanceof ManagedThread) {
            process.state = 1;
            this.readyQueue.insert(process);
        } else {
            throw new IllegalArgumentException("PriorityFrame.addProcess: another schedulable object ?");
        }
    }

    public void removeFromQueue(ScjProcess scjProcess) {
        this.readyQueue.remove(scjProcess);
        this.sleepingQueue.remove(scjProcess);
        this.waitQueue.removeProcess(scjProcess);
        this.lockQueue.removeProcess(scjProcess);
    }
}

