/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OSProcess;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PriorityFrame;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.Process;
import javax.safetycritical.Services;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;
import vm.ClockInterruptHandler;

@SCJAllowed
public abstract class Mission {
    MissionSequencer<?> currMissSeq;
    boolean missionTerminate = false;
    private static Mission[] missionSet = null;
    private static boolean isMissionSetInit = false;
    static MissionBehavior missionBehaviour;
    ManagedSchedulableSet msSetForMission;
    Phase phaseOfMission;
    protected int missionIndex = -1;
    boolean isMissionSetInitByThis = false;

    @SCJAllowed
    public Mission(AbsoluteTime start) {
    }

    @SCJAllowed
    public Mission() {
    }

    @SCJAllowed(value=Level.SUPPORT)
    protected boolean cleanUp() {
        return true;
    }

    @SCJAllowed
    @IcecapCompileMe
    public static Mission getMission() {
        return missionBehaviour.getMission();
    }

    @SCJAllowed
    public MissionSequencer<?> getSequencer() {
        return this.currMissSeq;
    }

    @SCJAllowed(value=Level.SUPPORT)
    protected abstract void initialize();

    void setMissionSeq(MissionSequencer<?> missSeq) {
        this.currMissSeq = missSeq;
    }

    @SCJAllowed(value=Level.SUPPORT)
    public abstract long missionMemorySize();

    @SCJAllowed
    public final boolean requestTermination() {
        return missionBehaviour.requestTermination(this);
    }

    public final boolean terminationPending() {
        return this.missionTerminate;
    }

    void runInitialize() {
        missionBehaviour.runInitialize(this);
    }

    void runExecute() {
        missionBehaviour.runExecute(this);
    }

    void runCleanup(MissionMemory missMem) {
        missionBehaviour.runCleanup(this, missMem);
    }

    boolean isRegistered(ManagedSchedulable target) {
        return ManagedSchedMethods.isRegistered(target);
    }

    boolean inMissionScope(ManagedSchedulable target) {
        return ManagedSchedMethods.isInMissionScope(target);
    }

    boolean inMissionScope(CyclicSchedule cs) {
        return true;
    }

    Phase getPhase() {
        return this.phaseOfMission;
    }

    static abstract class MissionBehavior {
        MissionBehavior() {
        }

        abstract Mission getMission();

        abstract boolean requestTermination(Mission var1);

        abstract void runInitialize(Mission var1);

        abstract void runExecute(Mission var1);

        abstract void runCleanup(Mission var1, MissionMemory var2);

        abstract Process getProcess(int var1);

        abstract ManagedSchedulable getManageSched(int var1);
    }

    static final class MulticoreBehavior
    extends MissionBehavior {
        MulticoreBehavior() {
            Services.setCeiling(this, Services.getDefaultCeiling());
        }

        @Override
        Mission getMission() {
            Object m = null;
            ManagedSchedulable ms = Services.currentManagedSchedulable();
            if (ms != null) {
                m = ms instanceof ManagedEventHandler ? (ms instanceof MissionSequencer ? ((MissionSequencer)ms).currMission : ((ManagedEventHandler)ms).mission) : ((ManagedThread)ms).mission;
            }
            return m;
        }

        @Override
        boolean requestTermination(Mission mission) {
            if (!mission.missionTerminate) {
                mission.missionTerminate = true;
                int i = 0;
                while (i < mission.msSetForMission.noOfRegistered) {
                    if (mission.msSetForMission.managedSchObjects[i] != null) {
                        if (mission.msSetForMission.managedSchObjects[i] instanceof AperiodicEventHandler) {
                            ((AperiodicEventHandler)mission.msSetForMission.managedSchObjects[i]).fireNextRelease();
                        }
                        if (mission.msSetForMission.managedSchObjects[i] instanceof OneShotEventHandler) {
                            ((OneShotEventHandler)mission.msSetForMission.managedSchObjects[i]).deschedule();
                            ((OneShotEventHandler)mission.msSetForMission.managedSchObjects[i]).fireNextRelease();
                        }
                        mission.msSetForMission.managedSchObjects[i].signalTermination();
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        synchronized int addNewMission(Mission mission) {
            if (missionSet == null || !isMissionSetInit) {
                missionSet = new Mission[Const.DEFAULT_HANDLER_NUMBER];
                isMissionSetInit = true;
                mission.isMissionSetInitByThis = true;
            }
            int i = 0;
            while (i < missionSet.length) {
                if (missionSet[i] == null) {
                    missionSet[i] = mission;
                    return i;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("Mission set: too small");
        }

        @Override
        void runInitialize(Mission mission) {
            mission.phaseOfMission = Phase.INITIALIZE;
            mission.missionIndex = this.addNewMission(mission);
            mission.msSetForMission = new ManagedSchedulableSet();
            mission.initialize();
        }

        @Override
        void runExecute(Mission mission) {
            mission.phaseOfMission = Phase.EXECUTE;
            ManagedSchedulableSet msSet = mission.msSetForMission;
            int index = mission.missionIndex * Const.DEFAULT_HANDLER_NUMBER;
            int i = 0;
            while (i < msSet.noOfRegistered) {
                ManagedSchedulable ms = msSet.managedSchObjects[i];
                OSProcess process = new OSProcess(ms);
                process.executable.id = index++;
                ++mission.msSetForMission.activeCount;
                process.executable.start();
                ++i;
            }
            mission.currMissSeq.seqWait();
            i = 0;
            while (i < mission.msSetForMission.noOfRegistered) {
                try {
                    if (mission.msSetForMission.managedSchObjects[i] instanceof ManagedThread) {
                        ((ManagedThread)mission.msSetForMission.managedSchObjects[i]).process.executable.join();
                    } else {
                        ((ManagedEventHandler)mission.msSetForMission.managedSchObjects[i]).process.executable.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }

        @Override
        void runCleanup(Mission mission, MissionMemory missMem) {
            mission.phaseOfMission = Phase.CLEANUP;
            if (mission.msSetForMission.activeCount > 0) {
                Console.println("still have SOs");
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < mission.msSetForMission.noOfRegistered) {
                mission.msSetForMission.managedSchObjects[i].cleanUp();
                mission.msSetForMission.managedSchObjects[i] = null;
                --mission.msSetForMission.msCount;
                ++i;
            }
            missionSet[mission.missionIndex] = null;
            if (mission.isMissionSetInitByThis) {
                isMissionSetInit = false;
            }
            mission.cleanUp();
            missMem.resetArea();
        }

        @Override
        Process getProcess(int index) {
            ManagedSchedulable ms = this.getManageSched(index);
            if (ms instanceof ManagedEventHandler) {
                return ((ManagedEventHandler)ms).process;
            }
            return ((ManagedThread)ms).process;
        }

        @Override
        ManagedSchedulable getManageSched(int index) {
            if (index == -99) {
                return null;
            }
            if (index == -11) {
                return MissionSequencer.outerMostSeq;
            }
            int missionIndex = index / 20;
            int managedSchdeulableIndex = index % 20;
            return missionSet[missionIndex].msSetForMission.managedSchObjects[managedSchdeulableIndex];
        }
    }

    static final class SinglecoreBehavior
    extends MissionBehavior {
        SinglecoreBehavior() {
        }

        @Override
        Mission getMission() {
            Mission mission = null;
            if (Launcher.level == 0 && CyclicScheduler.instance().seq != null) {
                mission = (Mission)CyclicScheduler.instance().seq.currMission;
            } else if (Launcher.level > 0 && PriorityScheduler.instance().getCurrentProcess() != null) {
                mission = PriorityScheduler.instance().getCurrentProcess().getTarget() instanceof MissionSequencer ? ((MissionSequencer)PriorityScheduler.instance().getCurrentProcess().getTarget()).currMission : ManagedSchedMethods.getMission(PriorityScheduler.instance().getCurrentProcess().getTarget());
            }
            return mission;
        }

        @Override
        boolean requestTermination(Mission mission) {
            if (!mission.missionTerminate) {
                int i = 0;
                while (i < mission.msSetForMission.noOfRegistered) {
                    if (mission.msSetForMission.managedSchObjects[i] != null) {
                        mission.msSetForMission.managedSchObjects[i].signalTermination();
                    }
                    ++i;
                }
                mission.missionTerminate = true;
                return false;
            }
            return true;
        }

        int addNewMission(Mission mission) {
            int i = 0;
            while (i < missionSet.length) {
                if (missionSet[i] == null) {
                    missionSet[i] = mission;
                    return i;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException("Mission set: too small");
        }

        @Override
        void runInitialize(Mission mission) {
            ClockInterruptHandler.instance.disable();
            if (missionSet == null || !isMissionSetInit) {
                missionSet = new Mission[Const.DEFAULT_HANDLER_NUMBER];
                mission.isMissionSetInitByThis = true;
                isMissionSetInit = true;
            }
            mission.missionIndex = this.addNewMission(mission);
            mission.phaseOfMission = Phase.INITIALIZE;
            mission.msSetForMission = new ManagedSchedulableSet();
            mission.initialize();
            ClockInterruptHandler.instance.enable();
        }

        @Override
        void runExecute(Mission mission) {
            ClockInterruptHandler.instance.disable();
            mission.phaseOfMission = Phase.EXECUTE;
            ManagedSchedulableSet msSet = mission.msSetForMission;
            PriorityFrame frame = PriorityScheduler.instance().pFrame;
            int index = mission.missionIndex * 20;
            int i = 0;
            while (i < msSet.noOfRegistered) {
                ManagedSchedulable ms = msSet.managedSchObjects[i];
                msSet.scjProcesses[i] = ManagedSchedMethods.createScjProcess(ms);
                msSet.scjProcesses[i].setIndex(index);
                ++index;
                frame.addProcess(msSet.scjProcesses[i]);
                ++i;
            }
            ClockInterruptHandler.instance.enable();
        }

        @Override
        void runCleanup(Mission mission, MissionMemory missMem) {
            mission.phaseOfMission = Phase.CLEANUP;
            ClockInterruptHandler.instance.disable();
            int i = 0;
            while (i < mission.msSetForMission.noOfRegistered) {
                mission.msSetForMission.scjProcesses[i] = null;
                mission.msSetForMission.managedSchObjects[i] = null;
                ++i;
            }
            missionSet[mission.missionIndex] = null;
            if (mission.isMissionSetInitByThis) {
                isMissionSetInit = false;
            }
            mission.cleanUp();
            missMem.resetArea();
            ClockInterruptHandler.instance.enable();
        }

        @Override
        Process getProcess(int index) {
            int missionIndex = index / 20;
            int scjProcessIndex = index % 20;
            return missionSet[missionIndex].msSetForMission.scjProcesses[scjProcessIndex];
        }

        @Override
        ManagedSchedulable getManageSched(int index) {
            return this.getProcess((int)index).msObject;
        }
    }
}

