/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedSchedMethods;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;

@SCJAllowed(value=Level.INFRASTRUCTURE)
class ManagedSchedulableSet {
    ManagedSchedulable[] managedSchObjects = new ManagedSchedulable[Const.DEFAULT_HANDLER_NUMBER];
    int noOfRegistered = 0;
    ScjProcess[] scjProcesses = new ScjProcess[Const.DEFAULT_HANDLER_NUMBER];
    int msCount;
    int activeCount;

    ManagedSchedulableSet() {
    }

    void addMS(ManagedSchedulable ms) {
        if (!this.contains(ms)) {
            this.managedSchObjects[this.noOfRegistered] = ms;
            ++this.noOfRegistered;
            ++this.msCount;
        }
    }

    boolean contains(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.managedSchObjects[i] == ms) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void terminateMSObjects() {
        int i = this.noOfRegistered;
        while (i > 0) {
            this.managedSchObjects[i - 1].cleanUp();
            this.managedSchObjects[i - 1] = null;
            --this.msCount;
            --i;
        }
    }

    void removeMSObject(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.managedSchObjects[i] == ms) {
                this.managedSchObjects[i].cleanUp();
                this.managedSchObjects[i] = null;
                PriorityScheduler.instance().pFrame.removeFromQueue(this.scjProcesses[i]);
                this.scjProcesses[i] = null;
                --this.msCount;
            }
            ++i;
        }
        if (this.msCount == 0) {
            ManagedSchedMethods.getMission(ms).getSequencer().seqNotify();
        }
    }

    void removeAperiodicHandlers() {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.managedSchObjects[i] instanceof AperiodicEventHandler) {
                this.managedSchObjects[i].cleanUp();
                PriorityScheduler.instance().pFrame.readyQueue.remove(this.scjProcesses[i]);
                --this.msCount;
            }
            if (this.msCount == 0) {
                ManagedSchedMethods.getMission(this.managedSchObjects[i]).getSequencer().seqNotify();
            }
            ++i;
        }
    }

    int indexOf(ManagedSchedulable ms) {
        int i = 0;
        while (i < this.noOfRegistered) {
            if (this.managedSchObjects[i] == ms) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        return "Mission: " + this.noOfRegistered + " handlers";
    }
}

