/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OSProcess;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;

public class ManagedSchedMethodsMulticore {
    static void executeManagedSchedulable(ManagedSchedulable ms) {
        if (ms instanceof ManagedThread) {
            ManagedSchedMethodsMulticore.runManagedThread((ManagedThread)ms);
        } else if (ms instanceof MissionSequencer) {
            ManagedSchedMethodsMulticore.runMissionSequencer((MissionSequencer)ms);
        } else if (ms instanceof PeriodicEventHandler) {
            ManagedSchedMethodsMulticore.runPeriodicHandler((PeriodicEventHandler)ms);
        } else if (ms instanceof AperiodicEventHandler) {
            ManagedSchedMethodsMulticore.runAperiodicEventHandler((AperiodicEventHandler)ms);
        } else if (ms instanceof OneShotEventHandler) {
            ManagedSchedMethodsMulticore.runOneShotHandler((OneShotEventHandler)ms);
        } else {
            Console.println("ManagedLongEventHandler not implemented");
        }
    }

    private static void runPeriodicHandler(PeriodicEventHandler handler) {
        handler.privateMemory.enter(handler);
        if (handler.mission.terminationPending()) {
            handler.mission.currMissSeq.seqNotify();
            OSProcess.requestTermination_c(handler.process.executable);
            OSProcess.testCancel_c();
        }
    }

    private static void runAperiodicEventHandler(AperiodicEventHandler handler) {
        if (handler.mission.terminationPending()) {
            handler.mission.currMissSeq.seqNotify();
            OSProcess.requestTermination_c(handler.process.executable);
            OSProcess.testCancel_c();
        }
        handler.waitForNextRelease();
        OSProcess.testCancel_c();
        handler.privateMemory.enter(handler);
    }

    private static void runOneShotHandler(OneShotEventHandler handler) {
        handler.state = 1;
        if (!handler.deschedulePending) {
            handler.privateMemory.enter(handler);
        }
        handler.deschedulePending = false;
        if (handler.mission.terminationPending()) {
            handler.mission.currMissSeq.seqNotify();
            OSProcess.requestTermination_c(handler.process.executable);
            OSProcess.testCancel_c();
        }
        handler.state = 2;
        handler.waitForNextRelease();
        OSProcess.testCancel_c();
        handler.state = 0;
    }

    private static void runMissionSequencer(MissionSequencer<?> ms) {
        ms.privateMemory.enter(ms);
        ms.mission.currMissSeq.seqNotify();
    }

    private static void runManagedThread(ManagedThread thread) {
        thread.privateMemory.enter(thread);
        thread.mission.currMissSeq.seqNotify();
    }
}

