/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.MemoryArea;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.InnerPrivateMemory;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedLongEventHandler;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OSProcess;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.Services;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import vm.ClockInterruptHandler;
import vm.Memory;

@SCJAllowed
public abstract class ManagedMemory
extends MemoryArea {
    static boolean flag = true;
    static MemoryBehavior memoryBehavior = null;
    private static final IllegalArgumentException exception = new IllegalArgumentException();

    static void allocateBackingStore(int size) {
        MemoryArea.overAllBackingStore = new BackingStore(Memory.allocateInHeap(size));
    }

    @IcecapCompileMe
    ManagedMemory(int size, int BackingStoreOfThisMemory, MemoryArea backingStoreProvider, String label) {
        super(size, BackingStoreOfThisMemory, backingStoreProvider, label);
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @IcecapCompileMe
    void enter(Runnable logic) throws IllegalArgumentException {
        memoryBehavior.enter(logic, this);
    }

    @SCJAllowed
    void executeInArea(Runnable logic) throws IllegalArgumentException {
        memoryBehavior.executeInArea(logic, this);
    }

    static final ManagedMemory getOuterMemory(MemoryArea mem) {
        if (mem instanceof InnerPrivateMemory) {
            return ((InnerPrivateMemory)mem).prev;
        }
        if (mem instanceof PrivateMemory) {
            return Mission.getMission().getSequencer().getMissionMemory();
        }
        if (mem instanceof MissionMemory) {
            MissionSequencer<?> missSeq = Mission.getMission().getSequencer();
            if (missSeq.outerSeq == null) {
                return ImmortalMemory.instance();
            }
            return missSeq.getOuterSeq().getMissionMemory();
        }
        return null;
    }

    @SCJAllowed
    public static void enterPrivateMemory(int size, Runnable logic) throws IllegalStateException {
        memoryBehavior.enterPrivateMemory(size, logic);
    }

    private static ManagedMemory getMemory(ManagedSchedulable ms) {
        if (ms instanceof ManagedEventHandler) {
            ManagedEventHandler mevh = (ManagedEventHandler)ms;
            return mevh.privateMemory;
        }
        if (ms instanceof ManagedThread) {
            ManagedThread mth = (ManagedThread)ms;
            return mth.privateMemory;
        }
        ManagedLongEventHandler mlevh = (ManagedLongEventHandler)ms;
        return mlevh.privateMemory;
    }

    static void cleanUpMemoryArea(ManagedSchedulable ms) {
        ManagedEventHandler handler = null;
        ManagedThread thread = null;
        if (ms instanceof ManagedEventHandler) {
            handler = (ManagedEventHandler)ms;
            handler.privateMemory.removeArea();
            if (ms instanceof MissionSequencer) {
                MissionSequencer seq = (MissionSequencer)ms;
                seq.missionMemory.removeArea();
            }
        } else {
            thread = (ManagedThread)ms;
            thread.privateMemory.removeArea();
        }
    }

    @SCJAllowed
    public static void executeInAreaOf(Object obj, Runnable logic) {
        memoryBehavior.executeInAreaOf(obj, logic);
    }

    @SCJAllowed
    public static void executeInOuterArea(Runnable logic) {
        memoryBehavior.executeInOuterArea(logic);
    }

    @SCJAllowed
    public long getRemainingBackingStore() {
        return this.memoryRemaining();
    }

    void resetArea(long newFree) {
        this.delegate.reset((int)newFree);
    }

    void resetArea() {
        this.delegate.reset(0);
    }

    void removeArea() {
        this.removeMemArea();
    }

    void resizeArea(long newSize) {
        this.resizeMemArea(newSize);
    }

    protected Memory getDelegate() {
        return this.delegate;
    }

    static MemoryArea getCurretAllocationArea() {
        return ManagedMemory.getCurrentMemoryArea();
    }

    MemoryArea getTopMostArea() {
        return null;
    }

    private static class BackingStore
    extends MemoryArea {
        public BackingStore(Memory delegate) {
            super(delegate);
        }
    }

    public static class ImmortalMemory
    extends ManagedMemory {
        ImmortalMemory(int sizeOfArea) {
            super(sizeOfArea, sizeOfArea, MemoryArea.overAllBackingStore, "Imm");
        }

        public static ImmortalMemory instance() {
            MemoryArea result = MemoryArea.getNamedMemoryArea("Imm");
            if (result != null) {
                return (ImmortalMemory)result;
            }
            return null;
        }
    }

    static abstract class MemoryBehavior {
        MemoryBehavior() {
        }

        abstract void enter(Runnable var1, ManagedMemory var2) throws IllegalArgumentException;

        abstract void executeInArea(Runnable var1, ManagedMemory var2) throws IllegalArgumentException;

        abstract void enterPrivateMemory(int var1, Runnable var2) throws IllegalStateException;

        abstract void executeInAreaOf(Object var1, Runnable var2);

        abstract void executeInOuterArea(Runnable var1);
    }

    static final class MulticoreBehavior
    extends MemoryBehavior {
        MulticoreBehavior() {
        }

        @Override
        void enter(Runnable logic, ManagedMemory memory) throws IllegalArgumentException {
            ManagedMemory outer;
            if (logic == null || !(logic instanceof ManagedSchedulable)) {
                throw new IllegalArgumentException();
            }
            ManagedSchedulable ms = (ManagedSchedulable)logic;
            if (ms instanceof ManagedEventHandler) {
                outer = ((ManagedEventHandler)ms).currentMemory;
                ((ManagedEventHandler)ms).currentMemory = memory;
            } else {
                outer = ((ManagedThread)ms).currentMemory;
                ((ManagedThread)ms).currentMemory = memory;
            }
            OSProcess.setMemoryArea(memory.delegate);
            logic.run();
            OSProcess.setMemoryArea(outer.delegate);
            memory.delegate.reset(0);
            if (ms instanceof ManagedEventHandler) {
                ((ManagedEventHandler)ms).currentMemory = outer;
            } else {
                ((ManagedThread)ms).currentMemory = outer;
            }
        }

        @Override
        void executeInArea(Runnable logic, ManagedMemory memory) throws IllegalArgumentException {
            if (logic == null) {
                throw new IllegalArgumentException("executeInArea: logic is null");
            }
            if (flag) {
                flag = false;
                Memory currentMem = Memory.getHeapArea();
                OSProcess.setMemoryArea(memory.delegate);
                logic.run();
                OSProcess.setMemoryArea(currentMem);
            } else {
                ManagedMemory outer;
                ManagedSchedulable ms = Services.currentManagedSchedulable();
                if (ms instanceof ManagedEventHandler) {
                    outer = ((ManagedEventHandler)ms).getCurrentMemory();
                    ((ManagedEventHandler)ms).setCurrentMemory(memory);
                } else {
                    outer = ((ManagedThread)ms).getCurrentMemory();
                    ((ManagedThread)ms).setCurrentMemory(memory);
                }
                OSProcess.setMemoryArea(memory.delegate);
                logic.run();
                OSProcess.setMemoryArea(outer.delegate);
                if (ms instanceof ManagedEventHandler) {
                    ((ManagedEventHandler)ms).setCurrentMemory(outer);
                } else {
                    ((ManagedThread)ms).setCurrentMemory(outer);
                }
            }
        }

        @Override
        void enterPrivateMemory(int size, Runnable logic) throws IllegalStateException {
            if (logic == null) {
                throw exception;
            }
            ManagedSchedulable ms = Services.currentManagedSchedulable();
            this.runEnterPrivateMemoryMulticore(ms, size, logic);
        }

        void runEnterPrivateMemoryMulticore(ManagedSchedulable ms, int size, Runnable logic) {
            ManagedMemory outer;
            ManagedMemory prev = ManagedMemory.getMemory(ms);
            long prevFree = prev.memoryConsumed();
            InnerPrivateMemory inner = new InnerPrivateMemory(size, prev.getRemainingBackingstoreSize(), prev, "InnerPrvMem");
            inner.prev = prev;
            if (ms instanceof ManagedEventHandler) {
                outer = ((ManagedEventHandler)ms).getCurrentMemory();
                ((ManagedEventHandler)ms).setCurrentMemory(inner);
            } else {
                outer = ((ManagedThread)ms).getCurrentMemory();
                ((ManagedThread)ms).setCurrentMemory(inner);
            }
            OSProcess.setMemoryArea(((ManagedMemory)inner).delegate);
            logic.run();
            OSProcess.setMemoryArea(outer.delegate);
            if (prev.memoryConsumed() != prevFree) {
                prev.resetArea(prevFree);
            }
            inner.removeArea();
            if (ms instanceof ManagedEventHandler) {
                ((ManagedEventHandler)ms).setCurrentMemory(outer);
            } else {
                ((ManagedThread)ms).setCurrentMemory(outer);
            }
        }

        @Override
        void executeInAreaOf(Object obj, Runnable logic) {
            ManagedMemory outer;
            if (obj == null || logic == null) {
                throw exception;
            }
            ManagedMemory memAreaOfObject = (ManagedMemory)MemoryArea.getMemoryArea(obj);
            ManagedSchedulable ms = Services.currentManagedSchedulable();
            if (ms instanceof ManagedEventHandler) {
                outer = ((ManagedEventHandler)ms).getCurrentMemory();
                ((ManagedEventHandler)ms).setCurrentMemory(memAreaOfObject);
            } else {
                outer = ((ManagedThread)ms).getCurrentMemory();
                ((ManagedThread)ms).setCurrentMemory(memAreaOfObject);
            }
            OSProcess.setMemoryArea(memAreaOfObject.delegate);
            logic.run();
            OSProcess.setMemoryArea(outer.delegate);
            if (ms instanceof ManagedEventHandler) {
                ((ManagedEventHandler)ms).setCurrentMemory(outer);
            } else {
                ((ManagedThread)ms).setCurrentMemory(outer);
            }
        }

        @Override
        void executeInOuterArea(Runnable logic) {
            ManagedMemory currentMem;
            ManagedSchedulable handler;
            if (logic == null) {
                throw exception;
            }
            ManagedSchedulable ms = Services.currentManagedSchedulable();
            if (ms instanceof ManagedEventHandler) {
                handler = (ManagedEventHandler)ms;
                currentMem = ((ManagedEventHandler)handler).getCurrentMemory();
            } else {
                handler = (ManagedThread)ms;
                currentMem = ((ManagedThread)handler).getCurrentMemory();
            }
            if (currentMem instanceof ImmortalMemory) {
                Console.println("executeInOuterArea: already in ImmortalMemory");
                throw new IllegalStateException("executeInOuterArea: already in ImmortalMemory");
            }
            ManagedMemory outerMemory = ManagedMemory.getOuterMemory(currentMem);
            if (ms instanceof ManagedEventHandler) {
                ((ManagedEventHandler)ms).setCurrentMemory(outerMemory);
            } else {
                ((ManagedThread)ms).setCurrentMemory(outerMemory);
            }
            OSProcess.setMemoryArea(outerMemory.delegate);
            logic.run();
            OSProcess.setMemoryArea(currentMem.delegate);
            if (ms instanceof ManagedEventHandler) {
                ((ManagedEventHandler)ms).setCurrentMemory(currentMem);
            } else {
                ((ManagedThread)ms).setCurrentMemory(currentMem);
            }
        }
    }

    static final class SinglecoreBehavior
    extends MemoryBehavior {
        SinglecoreBehavior() {
        }

        @Override
        void enter(Runnable logic, ManagedMemory memory) throws IllegalArgumentException {
            if (logic == null || !(logic instanceof ManagedSchedulable)) {
                throw new IllegalArgumentException();
            }
            ManagedSchedulable ms = (ManagedSchedulable)logic;
            if (ms instanceof ManagedEventHandler) {
                ManagedEventHandler mevh = (ManagedEventHandler)ms;
                Memory mem = Memory.switchToArea(mevh.privateMemory.delegate);
                logic.run();
                Memory.switchToArea(mem);
                mevh.privateMemory.delegate.reset(0);
            } else if (ms instanceof ManagedThread) {
                Console.println("ManagedMemory.enter: managedThred should work");
                ManagedThread mth = (ManagedThread)ms;
                Memory mem = Memory.switchToArea(mth.privateMemory.delegate);
                logic.run();
                Memory.switchToArea(mem);
                mth.privateMemory.delegate.reset(0);
            } else {
                Console.println("ManagedMemory.enter: UPS ManagedLongEventHandler not implemented");
            }
        }

        ScjProcess getCurrentProcess() {
            if (Launcher.level != 0) {
                return PriorityScheduler.instance().getCurrentProcess();
            }
            return CyclicScheduler.instance().getCurrentProcess();
        }

        @Override
        void executeInArea(Runnable logic, ManagedMemory memory) throws IllegalArgumentException {
            if (logic == null) {
                throw new IllegalArgumentException("executeInArea: logic is null");
            }
            if (flag) {
                flag = false;
                Memory currentMem = Memory.getHeapArea();
                Memory.switchToArea(memory.delegate);
                logic.run();
                Memory.switchToArea(currentMem);
            } else {
                ScjProcess currProcess = this.getCurrentProcess();
                if (currProcess == null) {
                    throw new IllegalArgumentException("executeInArea: process is null");
                }
                Memory mem = Memory.switchToArea(memory.delegate);
                logic.run();
                Memory.switchToArea(mem);
            }
        }

        @Override
        void enterPrivateMemory(int size, Runnable logic) throws IllegalStateException {
            if (logic == null) {
                throw exception;
            }
            ClockInterruptHandler.instance.disable();
            ManagedSchedulable ms = this.getCurrentProcess().getTarget();
            this.runEnterPrivateMemory(ms, size, logic);
            ClockInterruptHandler.instance.enable();
        }

        void runEnterPrivateMemory(ManagedSchedulable ms, int size, Runnable logic) {
            ManagedMemory prev = ManagedMemory.getMemory(ms);
            long prevFree = prev.memoryConsumed();
            InnerPrivateMemory inner = new InnerPrivateMemory(size, prev.getRemainingBackingstoreSize(), prev, "InnerPrvMem");
            inner.prev = prev;
            Memory mem = Memory.switchToArea(((ManagedMemory)inner).delegate);
            logic.run();
            Memory.switchToArea(mem);
            if (prev.memoryConsumed() != prevFree) {
                prev.resetArea(prevFree);
            }
            inner.removeArea();
        }

        @Override
        void executeInAreaOf(Object obj, Runnable logic) {
            if (obj == null || logic == null) {
                throw exception;
            }
            ClockInterruptHandler.instance.disable();
            ManagedMemory memAreaOfObject = (ManagedMemory)MemoryArea.getMemoryArea(obj);
            Memory mem = Memory.switchToArea(memAreaOfObject.getDelegate());
            logic.run();
            Memory.switchToArea(mem);
            ClockInterruptHandler.instance.enable();
        }

        @Override
        void executeInOuterArea(Runnable logic) {
            if (logic == null) {
                throw exception;
            }
            ClockInterruptHandler.instance.disable();
            MemoryArea currentMem = ManagedMemory.getCurrentMemoryArea();
            if (currentMem instanceof ImmortalMemory) {
                Console.println("executeInOuterArea: already in ImmortalMemory");
                ClockInterruptHandler.instance.enable();
                throw new IllegalStateException("executeInOuterArea: already in ImmortalMemory");
            }
            ManagedMemory outerMemory = ManagedMemory.getOuterMemory(currentMem);
            Memory mem = Memory.switchToArea(outerMemory.getDelegate());
            logic.run();
            Memory.switchToArea(mem);
            ClockInterruptHandler.instance.enable();
        }
    }
}

