/*
 * Decompiled with CFR 0.152.
 */
package test.ev3;

import com.UDPCommunication;
import devices.Console;
import devices.ev3.Motor;
import devices.ev3.MotorPort;
import devices.ev3.support.EV3Support;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.LaunchMulticore;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.Safelet;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;

public class TestEV3TCPIPFollower {
    static Motor m1;
    static Motor m2;
    static Motor[] motor;
    static EV3Support actor;
    static StorageParameters storageParameters_Sequencer;
    static StorageParameters storageParameters_Handlers2;

    static {
        motor = new Motor[2];
    }

    public static void main(String[] args) {
        storageParameters_Sequencer = new StorageParameters(Const.OUTERMOST_SEQ_BACKING_STORE, new long[]{Const.HANDLER_STACK_SIZE}, Const.PRIVATE_MEM, Const.IMMORTAL_MEM, Const.MISSION_MEM);
        storageParameters_Handlers2 = new StorageParameters(Const.PRIVATE_BACKING_STORE * 5, new long[]{Const.HANDLER_STACK_SIZE}, Const.PRIVATE_MEM * 2, 0L, 0L);
        Console.println("\n***** test multicore wait and notify main.begin *****");
        new LaunchMulticore(new MyApp(), 2);
        Console.println("***** test multicore wait and notify main.end *****");
    }

    private static class Executor
    implements Runnable {
        private Executor() {
        }

        @Override
        public void run() {
            String[] msg = UDPCommunication.receiveMsg();
            Console.println("received: " + msg[1]);
            actor.getCommand(msg[1]);
        }
    }

    private static class MyApp
    implements Safelet<Mission> {
        private MyApp() {
        }

        @Override
        public MissionSequencer<Mission> getSequencer() {
            return new MySequencer(new PriorityParameters(2), storageParameters_Sequencer);
        }

        @Override
        public long immortalMemorySize() {
            return Const.IMMORTAL_MEM;
        }

        @Override
        public void initializeApplication() {
            MotorPort port = new MotorPort(MotorPort.MotorPortID.B);
            m1 = new Motor(port);
            MotorPort port1 = new MotorPort(MotorPort.MotorPortID.C);
            TestEV3TCPIPFollower.motor[0] = m2 = new Motor(port1);
            TestEV3TCPIPFollower.motor[1] = m1;
            actor = new EV3Support(motor);
        }
    }

    private static class MyMission
    extends Mission {
        private MyMission() {
        }

        @Override
        protected void initialize() {
            MyThd myPEH1 = new MyThd(new PriorityParameters(2), null, storageParameters_Handlers2, this);
            myPEH1.register();
        }

        @Override
        public long missionMemorySize() {
            return Const.MISSION_MEM;
        }
    }

    private static class MySequencer
    extends MissionSequencer<Mission> {
        private Mission mission = new MyMission();
        private int count = 0;

        public MySequencer(PriorityParameters priority, StorageParameters storage) {
            super(priority, storage);
        }

        @Override
        protected Mission getNextMission() {
            if (this.count == 1) {
                Console.println("MySeq.count: " + this.count + "; null");
                return null;
            }
            ++this.count;
            return this.mission;
        }
    }

    private static class MyThd
    extends ManagedThread {
        Executor executor;

        public MyThd(PriorityParameters priority, PeriodicParameters release, StorageParameters storage, Mission m) {
            super(priority, storageParameters_Handlers2);
            UDPCommunication.createReceiver();
            this.executor = new Executor();
        }

        @Override
        public void run() {
            while (true) {
                ManagedMemory.enterPrivateMemory(5000, this.executor);
                actor.action();
            }
        }
    }
}

