/*
 * Decompiled with CFR 0.152.
 */
package test.ev3;

import com.UDPCommunication;
import devices.Console;
import devices.ev3.Motor;
import devices.ev3.MotorPort;
import devices.ev3.support.EV3Support;
import icecaptools.IcecapCompileMe;
import javax.realtime.Clock;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.LaunchMulticore;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.Safelet;
import javax.safetycritical.StorageParameters;
import javax.scj.util.Const;

public class TestEV3TCPIPCommander {
    static Motor m1;
    static Motor m2;
    static Motor[] motor;
    static EV3Support actor;
    static StorageParameters storageParameters_Sequencer;
    static StorageParameters storageParameters_Handlers;
    static StorageParameters storageParameters_Handlers2;

    static {
        motor = new Motor[2];
    }

    public static void main(String[] args) {
        storageParameters_Sequencer = new StorageParameters(Const.OUTERMOST_SEQ_BACKING_STORE, new long[]{Const.HANDLER_STACK_SIZE}, Const.PRIVATE_MEM, Const.IMMORTAL_MEM, Const.MISSION_MEM);
        storageParameters_Handlers = new StorageParameters(Const.PRIVATE_BACKING_STORE, new long[]{Const.HANDLER_STACK_SIZE}, Const.PRIVATE_MEM * 2, 0L, 0L);
        storageParameters_Handlers2 = new StorageParameters(Const.PRIVATE_BACKING_STORE * 5, new long[]{Const.HANDLER_STACK_SIZE}, Const.PRIVATE_MEM * 2, 0L, 0L);
        Console.println("\n***** test multicore wait and notify main.begin *****");
        new LaunchMulticore(new MyApp(), 2);
        Console.println("***** test multicore wait and notify main.end *****");
    }

    private static class Executor
    implements Runnable {
        private Executor() {
        }

        @Override
        public void run() {
            String[] msg = UDPCommunication.receiveMsg();
            Console.println("received: " + msg[1]);
            actor.getCommand(msg[1]);
        }
    }

    private static class MyApp
    implements Safelet<Mission> {
        private MyApp() {
        }

        @Override
        public MissionSequencer<Mission> getSequencer() {
            return new MySequencer(new PriorityParameters(2), storageParameters_Sequencer);
        }

        @Override
        public long immortalMemorySize() {
            return Const.IMMORTAL_MEM;
        }

        @Override
        public void initializeApplication() {
            MotorPort port = new MotorPort(MotorPort.MotorPortID.B);
            m1 = new Motor(port);
            MotorPort port1 = new MotorPort(MotorPort.MotorPortID.C);
            TestEV3TCPIPCommander.motor[0] = m2 = new Motor(port1);
            TestEV3TCPIPCommander.motor[1] = m1;
            actor = new EV3Support(motor);
        }
    }

    private static class MyMission
    extends Mission {
        private MyMission() {
        }

        @Override
        protected void initialize() {
            MyThd thd = new MyThd(new PriorityParameters(20), new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()), new RelativeTime(10L, 0, Clock.getRealtimeClock())), storageParameters_Handlers, this);
            thd.register();
            MyPEH1 myPEH1 = new MyPEH1(new PriorityParameters(2), new PeriodicParameters(new RelativeTime(Clock.getRealtimeClock()), new RelativeTime(2000L, 0, Clock.getRealtimeClock())), storageParameters_Handlers, this);
            myPEH1.register();
        }

        @Override
        public long missionMemorySize() {
            return Const.MISSION_MEM;
        }
    }

    private static class MyPEH1
    extends PeriodicEventHandler {
        int count = 1;
        boolean clockwise = false;

        public MyPEH1(PriorityParameters priority, PeriodicParameters release, StorageParameters storage, Mission m) {
            super(priority, release, storage);
            UDPCommunication.createSender("10.42.0.255");
        }

        @Override
        @IcecapCompileMe
        public void handleAsyncEvent() {
            this.giveCommand(this.count);
            this.count = !this.clockwise ? ++this.count : --this.count;
            if (this.count == 10) {
                this.clockwise = true;
                --this.count;
            }
            if (this.count == 0) {
                this.clockwise = false;
                ++this.count;
            }
        }

        private void giveCommand(int count) {
            switch (count) {
                case 1: {
                    Console.println("forward");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('F', 10, 0));
                    break;
                }
                case 2: {
                    Console.println("backward");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('B', 10, 0));
                    break;
                }
                case 3: {
                    Console.println("forward");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('F', 10, 0));
                    break;
                }
                case 4: {
                    Console.println("move faster");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('C', 20, 0));
                    break;
                }
                case 5: {
                    Console.println("park");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('P', 0));
                    break;
                }
                case 6: {
                    Console.println("start");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('S', 0));
                    break;
                }
                case 7: {
                    Console.println("move slower");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('C', 10, 0));
                    break;
                }
                case 8: {
                    Console.println("park");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('P', 0));
                    break;
                }
                case 9: {
                    Console.println("turn left");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('L', 10, 1, 0));
                    break;
                }
                case 10: {
                    Console.println("turn right");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('R', 10, 1, 0));
                    break;
                }
                case 11: {
                    Console.println("forward");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('F', 10, 0));
                    break;
                }
                case 12: {
                    Console.println("park");
                    UDPCommunication.sendBroadcastMsg(actor.generateCommand('P', 0));
                }
            }
        }
    }

    private static class MySequencer
    extends MissionSequencer<Mission> {
        private Mission mission = new MyMission();
        private int count = 0;

        public MySequencer(PriorityParameters priority, StorageParameters storage) {
            super(priority, storage);
        }

        @Override
        protected Mission getNextMission() {
            if (this.count == 1) {
                Console.println("MySeq.count: " + this.count + "; null");
                return null;
            }
            ++this.count;
            return this.mission;
        }
    }

    private static class MyThd
    extends ManagedThread {
        Executor executor;

        public MyThd(PriorityParameters priority, PeriodicParameters release, StorageParameters storage, Mission m) {
            super(priority, storageParameters_Handlers2);
            UDPCommunication.createReceiver();
            this.executor = new Executor();
        }

        @Override
        public void run() {
            while (true) {
                ManagedMemory.enterPrivateMemory(5000, this.executor);
                actor.action();
            }
        }
    }
}

