/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import minicdj.util.AbstractCollection;
import minicdj.util.AbstractMap;
import minicdj.util.AbstractSet;
import minicdj.util.Arrays;
import minicdj.util.Collection;
import minicdj.util.Collections;
import minicdj.util.ConcurrentModificationException;
import minicdj.util.Dictionary;
import minicdj.util.Enumeration;
import minicdj.util.Iterator;
import minicdj.util.Map;
import minicdj.util.NoSuchElementException;
import minicdj.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set keys;
    private transient Collection values;
    private transient Set entries;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAll(m);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Enumeration keys() {
        return new KeyEnumerator();
    }

    @Override
    public Enumeration elements() {
        return new ValueEnumerator();
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int i = this.buckets.length - 1;
        while (i >= 0) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized Object get(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized Object put(Object key, Object value) {
        idx = this.hash(key);
        e = this.buckets[idx];
        if (value != null) ** GOTO lbl10
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            if (e.key.equals(key)) {
                r = e.value;
                e.value = value;
                return r;
            }
            e = e.next;
lbl10:
            // 2 sources

            ** while (e != null)
        }
lbl11:
        // 1 sources

        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        e = new HashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        HashEntry last = null;
        while (e != null) {
            if (e.key.equals(key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry entry = (AbstractMap.BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable copy = null;
        try {
            copy = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.keys = null;
        copy.values = null;
        copy.entries = null;
        return copy;
    }

    public synchronized String toString() {
        EntryIterator entries = new EntryIterator();
        StringBuffer r = new StringBuffer("{");
        int pos = this.size;
        while (pos > 0) {
            r.append(entries.next());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    @Override
    public Set keySet() {
        if (this.keys == null) {
            AbstractSet r = new AbstractSet(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator iterator() {
                    return new KeyIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (o == null) {
                        return false;
                    }
                    return Hashtable.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return Hashtable.this.remove(o) != null;
                }
            };
            this.keys = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.keys;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            AbstractCollection r = new AbstractCollection(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection(this, r);
        }
        return this.values;
    }

    @Override
    public Set entrySet() {
        if (this.entries == null) {
            AbstractSet r = new AbstractSet(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator iterator() {
                    return new EntryIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return Hashtable.this.getEntry(o) != null;
                }

                @Override
                public boolean remove(Object o) {
                    HashEntry e = Hashtable.this.getEntry(o);
                    if (e != null) {
                        Hashtable.this.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public synchronized int hashCode() {
        EntryIterator itr = new EntryIterator();
        int hashcode = 0;
        int pos = this.size;
        while (pos > 0) {
            hashcode += itr.next().hashCode();
            --pos;
        }
        return hashcode;
    }

    private int hash(Object key) {
        int hash = key.hashCode() % this.buckets.length;
        return hash < 0 ? -hash : hash;
    }

    HashEntry getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Object key = ((Map.Entry)o).getKey();
        if (key == null) {
            return null;
        }
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (e.equals(o)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    void putAllInternal(Map m) {
        Iterator itr = m.entrySet().iterator();
        this.size = 0;
        while (itr.hasNext()) {
            ++this.size;
            Map.Entry e = (Map.Entry)itr.next();
            Object key = e.getKey();
            int idx = this.hash(key);
            HashEntry he = new HashEntry(key, e.getValue());
            he.next = this.buckets[idx];
            this.buckets[idx] = he;
        }
    }

    protected void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        int i = oldBuckets.length - 1;
        while (i >= 0) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                HashEntry next;
                int idx = this.hash(e.key);
                HashEntry dest = this.buckets[idx];
                if (dest != null) {
                    next = dest.next;
                    while (next != null) {
                        dest = next;
                        next = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                next = e.next;
                e.next = null;
                e = next;
            }
            --i;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        EntryIterator it = new EntryIterator();
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        int len = s.readInt();
        while (--len >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    private class EntryEnumerator
    implements Enumeration {
        int count;
        int idx;
        HashEntry next;

        EntryEnumerator() {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count > 0;
        }

        @Override
        public Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                if (this.idx <= 0) {
                    return null;
                }
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            return e;
        }
    }

    private class EntryIterator
    implements Iterator {
        int knownMod;
        int count;
        int idx;
        HashEntry last;
        HashEntry next;

        EntryIterator() {
            this.knownMod = Hashtable.this.modCount;
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasNext() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count > 0;
        }

        @Override
        public Object next() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                if (this.idx <= 0) {
                    return null;
                }
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            Hashtable.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object key, Object value) {
            super(key, value);
        }

        @Override
        public Object setValue(Object newVal) {
            if (newVal == null) {
                throw new NullPointerException();
            }
            return super.setValue(newVal);
        }
    }

    private final class KeyEnumerator
    extends EntryEnumerator {
        private KeyEnumerator() {
        }

        @Override
        public Object nextElement() {
            HashEntry entry = (HashEntry)super.nextElement();
            Object retVal = null;
            if (entry != null) {
                retVal = entry.key;
            }
            return retVal;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return ((HashEntry)super.next()).key;
        }
    }

    private final class ValueEnumerator
    extends EntryEnumerator {
        private ValueEnumerator() {
        }

        @Override
        public Object nextElement() {
            HashEntry entry = (HashEntry)super.nextElement();
            Object retVal = null;
            if (entry != null) {
                retVal = entry.value;
            }
            return retVal;
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            return ((HashEntry)super.next()).value;
        }
    }
}

