/*
 * Decompiled with CFR 0.152.
 */
package leadershipElection;

import com.Network;
import devices.Console;

public class LeaderShipElection {
    public static int MAX_ROBOTS = 255;
    private byte state = (byte)2;
    private int petition = 0;
    private int id = 0;
    private int time = 0;
    private Robot[] robots;
    private int[] robot_ids;

    public LeaderShipElection(String networkName, int[] ids) {
        this.petition = this.id = LeaderShipElection.generateID(Network.getIPAddress(networkName));
        Console.println("ID: " + this.id);
        this.robots = new Robot[MAX_ROBOTS];
        this.robot_ids = ids;
        int i = 0;
        while (i < this.robot_ids.length) {
            this.robots[this.robot_ids[i]] = new Robot(this.state, this.robot_ids[i], this.robot_ids[i], this.time);
            ++i;
        }
    }

    public static int generateID(String ip) {
        String lastDigit = "";
        int countDot = 0;
        int i = 0;
        while (i < ip.length()) {
            if (ip.charAt(i) == '.') {
                ++countDot;
            }
            if (countDot == 3) {
                ++i;
                break;
            }
            ++i;
        }
        int j = i;
        while (j < ip.length()) {
            lastDigit = String.valueOf(lastDigit) + ip.charAt(j);
            ++j;
        }
        return LeaderShipElection.convert(lastDigit);
    }

    public void electLeader() {
        if (this.time != 0) {
            this.printMyNeighbors();
            this.setState();
        }
        this.increaseTime();
    }

    public synchronized void reset() {
        this.state = (byte)2;
        --this.petition;
        this.time = 0;
        int i = 0;
        while (i < this.robot_ids.length) {
            this.robots[this.robot_ids[i]] = new Robot(this.state, this.robot_ids[i], this.robot_ids[i], this.time);
            ++i;
        }
    }

    public synchronized void collect(String msg) {
        int countStar = 0;
        int i = msg.length() - 1;
        while (i >= 0) {
            if (msg.charAt(i) == '*') {
                ++countStar;
            }
            --i;
        }
        if (msg.charAt(1) != '*' || countStar != 2) {
            Console.println("received: " + msg);
            int star = 0;
            int i2 = msg.length() - 1;
            while (i2 >= 0) {
                if (msg.charAt(i2) == '*' && ++star == 2) {
                    star = i2;
                    break;
                }
                --i2;
            }
            msg = msg.substring(star - 1);
            Console.println("pharsed: " + msg);
        }
        int state = msg.charAt(0) - 48;
        int id = -1;
        int petition = -1;
        int i3 = 0;
        int first_index = -1;
        int second_index = -1;
        while (i3 < msg.length()) {
            if (msg.charAt(i3) == '*') {
                first_index = i3;
                break;
            }
            ++i3;
        }
        ++i3;
        while (i3 < msg.length()) {
            if (msg.charAt(i3) == '*') {
                second_index = i3;
                break;
            }
            ++i3;
        }
        id = LeaderShipElection.convert(msg.substring(first_index + 1, second_index));
        petition = LeaderShipElection.convert(msg.substring(second_index + 1));
        this.robots[id].state = state;
        this.robots[id].id = id;
        this.robots[id].petition = petition;
        this.robots[id].time = this.time;
    }

    synchronized Robot getRobot(int index) {
        return this.robots[index];
    }

    void increaseTime() {
        ++this.time;
    }

    public String StateToNeighbors() {
        String msg = String.valueOf(this.state) + "*" + this.id + "*" + this.petition;
        return msg;
    }

    private void setState() {
        switch (this.state) {
            case 2: {
                if (this.numberOfLeaders() == 1) {
                    this.state = 1;
                    break;
                }
                if (this.numberOfLeaders() == 0 && this.hasHighestPetition() == 1) {
                    this.state = 0;
                    break;
                }
                if (this.numberOfLeaders() == 0 && this.hasHighestPetition() == 0 && this.hasHighestID()) {
                    this.state = 0;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.numberOfLeaders() == 1) break;
                if (this.numberOfLeaders() == 0 && this.hasHighestPetition() == 1) {
                    this.state = 0;
                    break;
                }
                if (this.numberOfLeaders() != 0 || this.hasHighestPetition() != 0 || !this.hasHighestID()) break;
                this.state = 0;
                break;
            }
            case 0: {
                if (this.numberOfLeaders() == 0) {
                    ++this.petition;
                    break;
                }
                this.state = (byte)2;
            }
        }
        switch (this.state) {
            case 2: {
                Console.println("undecide");
                break;
            }
            case 1: {
                Console.println("follower");
                break;
            }
            case 0: {
                Console.println("leader");
            }
        }
    }

    private int hasHighestPetition() {
        int hasHighestPetition = 0;
        int equal = -1;
        int i = 0;
        while (i < this.robot_ids.length) {
            if (this.robot_ids[i] != this.id && this.getRobot((int)this.robot_ids[i]).time >= this.time) {
                if (this.getRobot((int)this.robot_ids[i]).petition > this.petition) {
                    hasHighestPetition = -1;
                    break;
                }
                if (this.getRobot((int)this.robot_ids[i]).petition == this.petition) {
                    equal = 0;
                }
            }
            ++i;
        }
        if (hasHighestPetition == -1) {
            return -1;
        }
        if (hasHighestPetition == 0 && equal == -1) {
            return 1;
        }
        if (hasHighestPetition == 0 && equal == 0) {
            return 0;
        }
        return -1;
    }

    boolean hasHighestID() {
        boolean hasHighestID = true;
        int i = 0;
        while (i < this.robot_ids.length) {
            if (this.robot_ids[i] != this.id && this.getRobot((int)this.robot_ids[i]).time >= this.time && this.getRobot((int)this.robot_ids[i]).id > this.id) {
                hasHighestID = false;
                break;
            }
            ++i;
        }
        return hasHighestID;
    }

    int numberOfLeaders() {
        int number_of_leaders = 0;
        int i = 0;
        while (i < this.robot_ids.length) {
            int state;
            if (this.robot_ids[i] != this.id && this.getRobot((int)this.robot_ids[i]).time >= this.time && (state = this.getRobot((int)this.robot_ids[i]).state) == 0) {
                ++number_of_leaders;
            }
            ++i;
        }
        return number_of_leaders;
    }

    static int convert(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        int ret = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (i == 0 && c == '-') {
                return -1;
            }
            if (c - 48 < 0 || c - 48 > 10) {
                Console.println("wrong command: should be int here:" + s + ".");
                throw new IllegalArgumentException();
            }
            int tmp = c - 48;
            ret *= 10;
            ret += tmp;
            ++i;
        }
        return ret;
    }

    public int getState() {
        return this.state;
    }

    public void printMyNeighbors() {
        Console.println("---------------" + this.time);
        int i = 0;
        while (i < this.robot_ids.length) {
            Console.println(">" + this.getRobot(this.robot_ids[i]).toString());
            ++i;
        }
        Console.println("---------------");
    }

    public static interface Claim {
        public static final byte LEADER = 0;
        public static final byte FOLLOWER = 1;
        public static final byte UNDECIDED = 2;
    }

    class Robot {
        int state;
        int id;
        int petition;
        int time;

        public Robot(int state, int id, int petition, int time) {
            this.state = state;
            this.id = id;
            this.petition = petition;
            this.time = time;
        }

        public String toString() {
            return String.valueOf(this.state) + "*" + this.id + "*" + this.petition + "*" + this.time;
        }
    }
}

